<?php

include_once 'addon/propel/builder/SfObjectBuilder.php';

class SfOptimizedObjectBuilder extends SfObjectBuilder
{
  protected function addAttributes(&$script)
  {
  $script .= "
              protected static \$dispatcher = null;
";
    parent::addAttributes($script);
  }

  protected function addCall(&$script)
  {
  $script .= "

  public function getDispatcher()
  {
      if (null === self::\$dispatcher)
      {
          self::\$dispatcher = stEventDispatcher::getInstance();
      }

      return self::\$dispatcher;
  }
        
  public function __call(\$method, \$arguments)
  {
      \$event = \$this->getDispatcher()->notifyUntil(new sfEvent(\$this, '{$this->getStubObjectBuilder()->getClassname()}.' . \$method, array('arguments' => \$arguments, 'method' => \$method)));

      if (\$event->isProcessed())
      {
          return \$event->getReturnValue();
      }

      if (!\$callable = sfMixer::getCallable('{$this->getClassname()}:'.\$method))
      {
        throw new sfException(sprintf('Call to undefined method {$this->getClassname()}::%s', \$method));
      }

      array_unshift(\$arguments, \$this);

      return call_user_func_array(\$callable, \$arguments);
  }
";
  }

  public function build()
  {
    // Get original built code
    $objectCode = parent::build();

    // Remove useless includes
    if (!DataModelBuilder::getBuildProperty('builderAddIncludes'))
    {
      //remove all inline includes:
      //peer class include inline the mapbuilder classes
      $objectCode = preg_replace("/include_once\s*.*Base.*Peer\.php.*\s*/", "", $objectCode);
    }

    return $objectCode;
  }

  protected function addFKAccessor(&$script, ForeignKey $fk)
  {
    // Make original modifications
    parent::addFKAccessor($script, $fk);

    // With the explicit joins support, the related object returned can be hydrated with all NULL values, in this case we could simply return NULL
    if (!DataModelBuilder::getBuildProperty('builderHydrateNULLs'))
    {
      $varName = $this->getFKVarName($fk);
      $return = 'return $this->' . $varName . ';';
      $check_null_hydrated_script = '
        if (!is_null($this->' . $varName . ') && !$this->' . $varName . '->isNew() && is_null($this->' . $varName . '->getPrimaryKey())) {
          return NULL;
        }
        ' . $return;
      $script = str_replace($return, $check_null_hydrated_script, $script);
    }
  }

  /**
   * Adds setter method for "normal" columns.
   * @param      string &$script The script will be modified in this method.
   * @param      Column $col The current column.
   * @see        parent::addColumnMutators()
   */
  protected function addDefaultMutator(&$script, Column $col)
  {
    $clo = strtolower($col->getName());

    // FIXME: refactor this
    $defaultValue = null;
    if (($val = $col->getPhpDefaultValue()) !== null)
    {
      settype($val, $col->getPhpNative());
      $defaultValue = var_export($val, true);
    }

    $this->addMutatorOpen($script, $col);

    // Perform some smart checking here to handle possible type discrepancies
    // between the passed-in value and the value from the DB

    if ($col->getPhpType() != 'object' && $col->getPhpType() != 'array')
    {
      if ($col->getPhpNative() === "int")
      {
  $script .= "
        // Since the native PHP type for this column is integer,
        // we will cast the input value to an int (if it is not).
        if (\$v !== null && !is_int(\$v) && is_numeric(\$v)) {
          \$v = (int) \$v;
        }
";
      } elseif ($col->getPhpNative() === "string")
      {
  $script .= "
        // Since the native PHP type for this column is string,
        // we will cast the input to a string (if it is not).
        if (\$v !== null && !is_string(\$v)) {
          \$v = (string) \$v;
        }
";
      }
    }

    $script .= "
        if (\$this->$clo !== \$v";
    if ($defaultValue !== null)
    {
      $script .= " || \$v === $defaultValue";
    }
  $script .= ") {
          \$this->$clo = \$v;
          \$this->modifiedColumns[] = ".$this->getColumnConstant($col).";
        }
";
    $this->addMutatorClose($script, $col);
  }

    /**
     * Adds a normal (non-temporal) getter method.
     * @param      string &$script The script will be modified in this method.
     * @param      Column $col The current column.
     * @see        parent::addColumnAccessors()
     */
    protected function addGenericAccessor(&$script, $col)
    {
            $cfc=$col->getPhpName();
            $clo=strtolower($col->getName());

            $script .= "
    /**
     * Get the [$clo] column value.
     * ".$col->getDescription()."
     * @return     ".$col->getPhpNative()."
     */
    public function get$cfc(";
            if ($col->isLazyLoad()) $script .= "\$con = null";
            $script .= ")
    {
";
            if ($col->isLazyLoad()) {
                    $script .= "
            if (!\$this->".$clo."_isLoaded && \$this->$clo === null && !\$this->isNew()) {
                    \$this->load$cfc(\$con);
            }
";
            }
            if ($col->getType() == PropelTypes::DECIMAL)
            {
            $script .= "
            return null !== \$this->$clo ? (string)\$this->$clo : null;
    }
";
            }
            else
            {
            $script .= "
            return \$this->$clo;
    }
";
            }
    }

  protected function addDoSave(&$script)
  {
    $tmp = '';

    $pre_script = '';

    $post_script = '';

    foreach($this->getTable()->getColumns() as $col)
    {
      if ($col->getPhpType() != 'array' && $col->getPhpType() != 'object') continue;

      $attr = strtolower($col->getName());
      $const = $this->getColumnConstant($col);
  $pre_script .= "
              \$o_$attr = \$this->$attr;
              if (null !== \$this->$attr && \$this->isColumnModified($const)) {
                  \$this->$attr = serialize(\$this->$attr);
              }
";
  $post_script .= "
             \$this->$attr = \$o_$attr;
";
    }

    parent::addDoSave($tmp);
    // add autosave to i18n object even if the base object is not changed
    $tmp = str_replace('if ($this->isModified()) {', 'if ($this->isModified()) {'.$pre_script, $tmp);

    $tmp = str_replace('$this->resetModified();', '$this->resetModified();'.$post_script, $tmp);

    $script .= $tmp;
  }

  /**
   * Adds the save() method.
   * @param      string &$script The script will be modified in this method.
   */
  protected function addSave(&$script)
  {
    $tmp = '';

    $pre_script = "
              \$this->getDispatcher()->notify(new sfEvent(\$this, '{$this->getStubObjectBuilder()->getClassname()}.preSave', array('con' => \$con)));
";

    parent::addSave($tmp);

  $post_script .= "
              \$this->getDispatcher()->notify(new sfEvent(\$this, '{$this->getStubObjectBuilder()->getClassname()}.postSave', array('con' => \$con)));
";

    $tmp = preg_replace('/{/', '{'.$pre_script, $tmp, 1);

    $tmp = preg_replace('/(\$con\->commit\(\);)/', '$1'.$post_script, $tmp);

    $script .= $tmp;

  } // addSave()

  /**
   * Adds the hydrate() method, which sets attributes of the object based on a ResultSet.
   */
  protected function addHydrate(&$script)
  {
    $table = $this->getTable();

  $script .= "
  /**
   * Hydrates (populates) the object variables with values from the database resultset.
   *
   * An offset (1-based \"start column\") is specified so that objects can be hydrated
   * with a subset of the columns in the resultset rows.  This is needed, for example,
   * for results of JOIN queries where the resultset row includes columns from two or
   * more tables.
   *
   * @param      ResultSet \$rs The ResultSet class with cursor advanced to desired record pos.
   * @param      int \$startcol 1-based offset column which indicates which restultset column to start with.
   * @return     int next starting column
   * @throws     PropelException  - Any caught Exception will be rewrapped as a PropelException.
   */
  public function hydrate(ResultSet \$rs, \$startcol = 1)
  {
    try {
      \$this->getDispatcher()->notify(new sfEvent(\$this, '{$this->getStubObjectBuilder()->getClassname()}.preHydrate', array('resultset' => \$rs, 'startcol' => 1)));
";
    $n = 0;
    foreach($table->getColumns() as $col)
    {
      if(!$col->isLazyLoad())
      {
        $affix = CreoleTypes::getAffix(CreoleTypes::getCreoleCode($col->getType()));
        $clo = strtolower($col->getName());
        switch($col->getType())
        {

          case PropelTypes::DATE:
          case PropelTypes::TIME:
          case PropelTypes::TIMESTAMP:
  $script .= "
      \$this->$clo = \$rs->get$affix(\$startcol + $n, null);
";
            break;
          case PropelTypes::DECIMAL:
  $script .= "
      \$this->$clo = \$rs->getString(\$startcol + $n, null);
";
          default:
            if ($col->getPhpType() == 'array' || $col->getPhpType() == 'object')
            {
  $script .= "
      \$this->$clo = \$rs->get$affix(\$startcol + $n) ? unserialize(\$rs->get$affix(\$startcol + $n)) : null;
";
            }
            else
            {
  $script .= "
      \$this->$clo = \$rs->get$affix(\$startcol + $n);
";
            }
        }
        $n++;
      } // if col->isLazyLoad()
    } /* foreach */

    if ($this->getBuildProperty("addSaveMethod"))
    {
  $script .= "
      \$this->resetModified();
";
    }

  $script .= "
      \$this->setNew(false);

      \$this->getDispatcher()->notify(new sfEvent(\$this, '{$this->getStubObjectBuilder()->getClassname()}.postHydrate', array('resultset' => \$rs, 'startcol' => $n)));

      // FIXME - using NUM_COLUMNS may be clearer.
      return \$startcol + $n; // $n = ".$this->getPeerClassname()."::NUM_COLUMNS - ".$this->getPeerClassname()."::NUM_LAZY_LOAD_COLUMNS).

    } catch (Exception \$e) {
      throw new PropelException(\"Error populating ".$table->getPhpName()." object\", \$e);
    }
  }
";

  } // addHydrate()

}