<?php


abstract class BasesfAsset extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $folder_id;


	
	protected $filename;


	
	protected $description;


	
	protected $author;


	
	protected $copyright;


	
	protected $type;


	
	protected $filesize;


	
	protected $created_at;


	
	protected $updated_at;

	
	protected $asfAssetFolder;

	
	protected $collAvailabilitys;

	
	protected $lastAvailabilityCriteria = null;

	
	protected $collCategorys;

	
	protected $lastCategoryCriteria = null;

	
	protected $collProductHasSfAssets;

	
	protected $lastProductHasSfAssetCriteria = null;

	
	protected $collProductHasAttachments;

	
	protected $lastProductHasAttachmentCriteria = null;

	
	protected $collProductOptionsValues;

	
	protected $lastProductOptionsValueCriteria = null;

	
	protected $collProducers;

	
	protected $lastProducerCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getFolderId()
    {

            return $this->folder_id;
    }

    
    public function getFilename()
    {

            return $this->filename;
    }

    
    public function getDescription()
    {

            return $this->description;
    }

    
    public function getAuthor()
    {

            return $this->author;
    }

    
    public function getCopyright()
    {

            return $this->copyright;
    }

    
    public function getType()
    {

            return $this->type;
    }

    
    public function getFilesize()
    {

            return null !== $this->filesize ? (string)$this->filesize : null;
    }

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = sfAssetPeer::ID;
        }

	} 
	
	public function setFolderId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->folder_id !== $v) {
          $this->folder_id = $v;
          $this->modifiedColumns[] = sfAssetPeer::FOLDER_ID;
        }

		if ($this->asfAssetFolder !== null && $this->asfAssetFolder->getId() !== $v) {
			$this->asfAssetFolder = null;
		}

	} 
	
	public function setFilename($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->filename !== $v) {
          $this->filename = $v;
          $this->modifiedColumns[] = sfAssetPeer::FILENAME;
        }

	} 
	
	public function setDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->description !== $v) {
          $this->description = $v;
          $this->modifiedColumns[] = sfAssetPeer::DESCRIPTION;
        }

	} 
	
	public function setAuthor($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->author !== $v) {
          $this->author = $v;
          $this->modifiedColumns[] = sfAssetPeer::AUTHOR;
        }

	} 
	
	public function setCopyright($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->copyright !== $v) {
          $this->copyright = $v;
          $this->modifiedColumns[] = sfAssetPeer::COPYRIGHT;
        }

	} 
	
	public function setType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->type !== $v) {
          $this->type = $v;
          $this->modifiedColumns[] = sfAssetPeer::TYPE;
        }

	} 
	
	public function setFilesize($v)
	{

        if ($this->filesize !== $v) {
          $this->filesize = $v;
          $this->modifiedColumns[] = sfAssetPeer::FILESIZE;
        }

	} 
	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = sfAssetPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = sfAssetPeer::UPDATED_AT;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'sfAsset.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->folder_id = $rs->getInt($startcol + 1);

      $this->filename = $rs->getString($startcol + 2);

      $this->description = $rs->getString($startcol + 3);

      $this->author = $rs->getString($startcol + 4);

      $this->copyright = $rs->getString($startcol + 5);

      $this->type = $rs->getString($startcol + 6);

      $this->filesize = $rs->getString($startcol + 7, null);

      $this->filesize = $rs->getFloat($startcol + 7);

      $this->created_at = $rs->getTimestamp($startcol + 8, null);

      $this->updated_at = $rs->getTimestamp($startcol + 9, null);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'sfAsset.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating sfAsset object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BasesfAsset:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(sfAssetPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			sfAssetPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BasesfAsset:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'sfAsset.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BasesfAsset:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(sfAssetPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(sfAssetPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(sfAssetPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'sfAsset.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BasesfAsset:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfAssetFolder !== null) {
				if ($this->asfAssetFolder->isModified()) {
					$affectedRows += $this->asfAssetFolder->save($con);
				}
				$this->setsfAssetFolder($this->asfAssetFolder);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = sfAssetPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += sfAssetPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collAvailabilitys !== null) {
				foreach($this->collAvailabilitys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCategorys !== null) {
				foreach($this->collCategorys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasSfAssets !== null) {
				foreach($this->collProductHasSfAssets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasAttachments !== null) {
				foreach($this->collProductHasAttachments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductOptionsValues !== null) {
				foreach($this->collProductOptionsValues as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProducers !== null) {
				foreach($this->collProducers as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfAssetFolder !== null) {
				if (!$this->asfAssetFolder->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfAssetFolder->getValidationFailures());
				}
			}


			if (($retval = sfAssetPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collAvailabilitys !== null) {
					foreach($this->collAvailabilitys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCategorys !== null) {
					foreach($this->collCategorys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasSfAssets !== null) {
					foreach($this->collProductHasSfAssets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasAttachments !== null) {
					foreach($this->collProductHasAttachments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductOptionsValues !== null) {
					foreach($this->collProductOptionsValues as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProducers !== null) {
					foreach($this->collProducers as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = sfAssetPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getFolderId();
				break;
			case 2:
				return $this->getFilename();
				break;
			case 3:
				return $this->getDescription();
				break;
			case 4:
				return $this->getAuthor();
				break;
			case 5:
				return $this->getCopyright();
				break;
			case 6:
				return $this->getType();
				break;
			case 7:
				return $this->getFilesize();
				break;
			case 8:
				return $this->getCreatedAt();
				break;
			case 9:
				return $this->getUpdatedAt();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = sfAssetPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getFolderId(),
			$keys[2] => $this->getFilename(),
			$keys[3] => $this->getDescription(),
			$keys[4] => $this->getAuthor(),
			$keys[5] => $this->getCopyright(),
			$keys[6] => $this->getType(),
			$keys[7] => $this->getFilesize(),
			$keys[8] => $this->getCreatedAt(),
			$keys[9] => $this->getUpdatedAt(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = sfAssetPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setFolderId($value);
				break;
			case 2:
				$this->setFilename($value);
				break;
			case 3:
				$this->setDescription($value);
				break;
			case 4:
				$this->setAuthor($value);
				break;
			case 5:
				$this->setCopyright($value);
				break;
			case 6:
				$this->setType($value);
				break;
			case 7:
				$this->setFilesize($value);
				break;
			case 8:
				$this->setCreatedAt($value);
				break;
			case 9:
				$this->setUpdatedAt($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = sfAssetPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setFolderId($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setFilename($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setDescription($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setAuthor($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setCopyright($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setType($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setFilesize($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setCreatedAt($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setUpdatedAt($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(sfAssetPeer::DATABASE_NAME);

		if ($this->isColumnModified(sfAssetPeer::ID)) $criteria->add(sfAssetPeer::ID, $this->id);
		if ($this->isColumnModified(sfAssetPeer::FOLDER_ID)) $criteria->add(sfAssetPeer::FOLDER_ID, $this->folder_id);
		if ($this->isColumnModified(sfAssetPeer::FILENAME)) $criteria->add(sfAssetPeer::FILENAME, $this->filename);
		if ($this->isColumnModified(sfAssetPeer::DESCRIPTION)) $criteria->add(sfAssetPeer::DESCRIPTION, $this->description);
		if ($this->isColumnModified(sfAssetPeer::AUTHOR)) $criteria->add(sfAssetPeer::AUTHOR, $this->author);
		if ($this->isColumnModified(sfAssetPeer::COPYRIGHT)) $criteria->add(sfAssetPeer::COPYRIGHT, $this->copyright);
		if ($this->isColumnModified(sfAssetPeer::TYPE)) $criteria->add(sfAssetPeer::TYPE, $this->type);
		if ($this->isColumnModified(sfAssetPeer::FILESIZE)) $criteria->add(sfAssetPeer::FILESIZE, $this->filesize);
		if ($this->isColumnModified(sfAssetPeer::CREATED_AT)) $criteria->add(sfAssetPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(sfAssetPeer::UPDATED_AT)) $criteria->add(sfAssetPeer::UPDATED_AT, $this->updated_at);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(sfAssetPeer::DATABASE_NAME);

		$criteria->add(sfAssetPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setFolderId($this->folder_id);

		$copyObj->setFilename($this->filename);

		$copyObj->setDescription($this->description);

		$copyObj->setAuthor($this->author);

		$copyObj->setCopyright($this->copyright);

		$copyObj->setType($this->type);

		$copyObj->setFilesize($this->filesize);

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getAvailabilitys() as $relObj) {
				$copyObj->addAvailability($relObj->copy($deepCopy));
			}

			foreach($this->getCategorys() as $relObj) {
				$copyObj->addCategory($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasSfAssets() as $relObj) {
				$copyObj->addProductHasSfAsset($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasAttachments() as $relObj) {
				$copyObj->addProductHasAttachment($relObj->copy($deepCopy));
			}

			foreach($this->getProductOptionsValues() as $relObj) {
				$copyObj->addProductOptionsValue($relObj->copy($deepCopy));
			}

			foreach($this->getProducers() as $relObj) {
				$copyObj->addProducer($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new sfAssetPeer();
		}
		return self::$peer;
	}

	
	public function setsfAssetFolder($v)
	{


		if ($v === null) {
			$this->setFolderId(NULL);
		} else {
			$this->setFolderId($v->getId());
		}


		$this->asfAssetFolder = $v;
	}


	
	public function getsfAssetFolder($con = null)
	{
		if ($this->asfAssetFolder === null && ($this->folder_id !== null)) {
						$this->asfAssetFolder = sfAssetFolderPeer::retrieveByPK($this->folder_id, $con);

			
		}
		return $this->asfAssetFolder;
	}

	
	public function initAvailabilitys()
	{
		if ($this->collAvailabilitys === null) {
			$this->collAvailabilitys = array();
		}
	}

	
	public function getAvailabilitys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAvailabilitys === null) {
			if ($this->isNew()) {
			   $this->collAvailabilitys = array();
			} else {

				$criteria->add(AvailabilityPeer::SF_ASSET_ID, $this->getId());

				AvailabilityPeer::addSelectColumns($criteria);
				$this->collAvailabilitys = AvailabilityPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(AvailabilityPeer::SF_ASSET_ID, $this->getId());

				AvailabilityPeer::addSelectColumns($criteria);
				if (!isset($this->lastAvailabilityCriteria) || !$this->lastAvailabilityCriteria->equals($criteria)) {
					$this->collAvailabilitys = AvailabilityPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastAvailabilityCriteria = $criteria;
		return $this->collAvailabilitys;
	}

	
	public function countAvailabilitys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(AvailabilityPeer::SF_ASSET_ID, $this->getId());

		return AvailabilityPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addAvailability(Availability $l)
	{
		$this->collAvailabilitys[] = $l;
		$l->setsfAsset($this);
	}

	
	public function initCategorys()
	{
		if ($this->collCategorys === null) {
			$this->collCategorys = array();
		}
	}

	
	public function getCategorys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCategorys === null) {
			if ($this->isNew()) {
			   $this->collCategorys = array();
			} else {

				$criteria->add(CategoryPeer::SF_ASSET_ID, $this->getId());

				CategoryPeer::addSelectColumns($criteria);
				$this->collCategorys = CategoryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CategoryPeer::SF_ASSET_ID, $this->getId());

				CategoryPeer::addSelectColumns($criteria);
				if (!isset($this->lastCategoryCriteria) || !$this->lastCategoryCriteria->equals($criteria)) {
					$this->collCategorys = CategoryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCategoryCriteria = $criteria;
		return $this->collCategorys;
	}

	
	public function countCategorys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CategoryPeer::SF_ASSET_ID, $this->getId());

		return CategoryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCategory(Category $l)
	{
		$this->collCategorys[] = $l;
		$l->setsfAsset($this);
	}


	
	public function getCategorysJoinCategoryRelatedByParentId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCategorys === null) {
			if ($this->isNew()) {
				$this->collCategorys = array();
			} else {

				$criteria->add(CategoryPeer::SF_ASSET_ID, $this->getId());

				$this->collCategorys = CategoryPeer::doSelectJoinCategoryRelatedByParentId($criteria, $con);
			}
		} else {
									
			$criteria->add(CategoryPeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastCategoryCriteria) || !$this->lastCategoryCriteria->equals($criteria)) {
				$this->collCategorys = CategoryPeer::doSelectJoinCategoryRelatedByParentId($criteria, $con);
			}
		}
		$this->lastCategoryCriteria = $criteria;

		return $this->collCategorys;
	}

	
	public function initProductHasSfAssets()
	{
		if ($this->collProductHasSfAssets === null) {
			$this->collProductHasSfAssets = array();
		}
	}

	
	public function getProductHasSfAssets($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasSfAssets === null) {
			if ($this->isNew()) {
			   $this->collProductHasSfAssets = array();
			} else {

				$criteria->add(ProductHasSfAssetPeer::SF_ASSET_ID, $this->getId());

				ProductHasSfAssetPeer::addSelectColumns($criteria);
				$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasSfAssetPeer::SF_ASSET_ID, $this->getId());

				ProductHasSfAssetPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasSfAssetCriteria) || !$this->lastProductHasSfAssetCriteria->equals($criteria)) {
					$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasSfAssetCriteria = $criteria;
		return $this->collProductHasSfAssets;
	}

	
	public function countProductHasSfAssets($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasSfAssetPeer::SF_ASSET_ID, $this->getId());

		return ProductHasSfAssetPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasSfAsset(ProductHasSfAsset $l)
	{
		$this->collProductHasSfAssets[] = $l;
		$l->setsfAsset($this);
	}


	
	public function getProductHasSfAssetsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasSfAssets === null) {
			if ($this->isNew()) {
				$this->collProductHasSfAssets = array();
			} else {

				$criteria->add(ProductHasSfAssetPeer::SF_ASSET_ID, $this->getId());

				$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasSfAssetPeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastProductHasSfAssetCriteria) || !$this->lastProductHasSfAssetCriteria->equals($criteria)) {
				$this->collProductHasSfAssets = ProductHasSfAssetPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductHasSfAssetCriteria = $criteria;

		return $this->collProductHasSfAssets;
	}

	
	public function initProductHasAttachments()
	{
		if ($this->collProductHasAttachments === null) {
			$this->collProductHasAttachments = array();
		}
	}

	
	public function getProductHasAttachments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
			   $this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::SF_ASSET_ID, $this->getId());

				ProductHasAttachmentPeer::addSelectColumns($criteria);
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasAttachmentPeer::SF_ASSET_ID, $this->getId());

				ProductHasAttachmentPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
					$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;
		return $this->collProductHasAttachments;
	}

	
	public function countProductHasAttachments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasAttachmentPeer::SF_ASSET_ID, $this->getId());

		return ProductHasAttachmentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasAttachment(ProductHasAttachment $l)
	{
		$this->collProductHasAttachments[] = $l;
		$l->setsfAsset($this);
	}


	
	public function getProductHasAttachmentsJoinLanguage($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
				$this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::SF_ASSET_ID, $this->getId());

				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinLanguage($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttachmentPeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinLanguage($criteria, $con);
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;

		return $this->collProductHasAttachments;
	}


	
	public function getProductHasAttachmentsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttachments === null) {
			if ($this->isNew()) {
				$this->collProductHasAttachments = array();
			} else {

				$criteria->add(ProductHasAttachmentPeer::SF_ASSET_ID, $this->getId());

				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttachmentPeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastProductHasAttachmentCriteria) || !$this->lastProductHasAttachmentCriteria->equals($criteria)) {
				$this->collProductHasAttachments = ProductHasAttachmentPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductHasAttachmentCriteria = $criteria;

		return $this->collProductHasAttachments;
	}

	
	public function initProductOptionsValues()
	{
		if ($this->collProductOptionsValues === null) {
			$this->collProductOptionsValues = array();
		}
	}

	
	public function getProductOptionsValues($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
			   $this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

				ProductOptionsValuePeer::addSelectColumns($criteria);
				if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
					$this->collProductOptionsValues = ProductOptionsValuePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;
		return $this->collProductOptionsValues;
	}

	
	public function countProductOptionsValues($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

		return ProductOptionsValuePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductOptionsValue(ProductOptionsValue $l)
	{
		$this->collProductOptionsValues[] = $l;
		$l->setsfAsset($this);
	}


	
	public function getProductOptionsValuesJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsTemplate($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsTemplate($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsValueRelatedByProductOptionsValueId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsValueRelatedByProductOptionsValueId($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}


	
	public function getProductOptionsValuesJoinProductOptionsField($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductOptionsValues === null) {
			if ($this->isNew()) {
				$this->collProductOptionsValues = array();
			} else {

				$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductOptionsValuePeer::SF_ASSET_ID, $this->getId());

			if (!isset($this->lastProductOptionsValueCriteria) || !$this->lastProductOptionsValueCriteria->equals($criteria)) {
				$this->collProductOptionsValues = ProductOptionsValuePeer::doSelectJoinProductOptionsField($criteria, $con);
			}
		}
		$this->lastProductOptionsValueCriteria = $criteria;

		return $this->collProductOptionsValues;
	}

	
	public function initProducers()
	{
		if ($this->collProducers === null) {
			$this->collProducers = array();
		}
	}

	
	public function getProducers($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducers === null) {
			if ($this->isNew()) {
			   $this->collProducers = array();
			} else {

				$criteria->add(ProducerPeer::SF_ASSET_ID, $this->getId());

				ProducerPeer::addSelectColumns($criteria);
				$this->collProducers = ProducerPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProducerPeer::SF_ASSET_ID, $this->getId());

				ProducerPeer::addSelectColumns($criteria);
				if (!isset($this->lastProducerCriteria) || !$this->lastProducerCriteria->equals($criteria)) {
					$this->collProducers = ProducerPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProducerCriteria = $criteria;
		return $this->collProducers;
	}

	
	public function countProducers($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProducerPeer::SF_ASSET_ID, $this->getId());

		return ProducerPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProducer(Producer $l)
	{
		$this->collProducers[] = $l;
		$l->setsfAsset($this);
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'sfAsset.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BasesfAsset:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BasesfAsset::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 