<?php

class stAssetImageConfigurationActions extends stActions
{

   public function executeWatermark()
   {
      $i18n = $this->getContext()->getI18N();

      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $config->set('watermark', $this->getRequestParameter('watermark'));

         $this->setFlash('notice', $i18n->__('Twoje zmiany zostały zapisane', null, 'stAdminGeneratorPlugin'));

         $config->save(true);
      }
      else
      {
         $this->setFlash('notice', null);
      }

      $this->config = $config->get('watermark', array());
   }

   public function executeGallery()
   {
      $i18n = $this->getContext()->getI18N();

      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $config->set('gallery', $this->getRequestParameter('gallery'));

         $this->setFlash('notice', $i18n->__('Twoje zmiany zostały zapisane', null, 'stAdminGeneratorPlugin'));

         $config->save(true);
      }
      else
      {
         $this->setFlash('notice', null);
      }

      $this->config = $config->get('gallery', array());
   }

   public function executeProduct()
   {
      $i18n = $this->getContext()->getI18N();

      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->updateConfigFromRequest($config, 'product');

         $this->setFlash('notice', $i18n->__('Twoje zmiany zostały zapisane', null, 'stAdminGeneratorPlugin'));

         $config->save(true);
      }
      else
      {
         $this->setFlash('notice', null);
      }

      $this->config = $config->get('product', array());
   }

   public function executeCategory()
   {
      $i18n = $this->getContext()->getI18N();

      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->updateConfigFromRequest($config, 'category');

         $this->setFlash('notice', $i18n->__('Twoje zmiany zostały zapisane', null, 'stAdminGeneratorPlugin'));

         $config->save(true);
      }
      else
      {
         $this->setFlash('notice', null);
      }

      $this->config = $config->get('category', array());
   }

   public function executeProducer()
   {
      $i18n = $this->getContext()->getI18N();

      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $this->updateConfigFromRequest($config, 'producer');

         $this->setFlash('notice', $i18n->__('Twoje zmiany zostały zapisane', null, 'stAdminGeneratorPlugin'));

         $config->save(true);
      }
      else
      {
         $this->setFlash('notice', null);
      }

      $this->config = $config->get('producer', array());
   }

   public function validateCategory()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $validator1 = $this->getThumbnailValidator('szerokość');

         $validator2 = $this->getThumbnailValidator('wysokość');

         foreach ($this->getRequestParameter('category') as $thumbnail => $values)
         {
            if (!$validator1->execute($values['width'], $error))
            {
               $this->getRequest()->setError('category{'.$thumbnail.'}{width}', $error);
            }

            if (!$validator2->execute($values['height'], $error))
            {
               $this->getRequest()->setError('category{'.$thumbnail.'}{height}', $error);
            }
         }
      }

      return!$this->getRequest()->hasErrors();
   }

   public function handleErrorCategory()
   {
      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      $this->updateConfigFromRequest($config, 'category');

      $this->config = $config->get('category', array());

      return sfView::SUCCESS;
   }

   public function validateProduct()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $validator1 = $this->getThumbnailValidator('szerokość');

         $validator2 = $this->getThumbnailValidator('wysokość');

         foreach ($this->getRequestParameter('product') as $thumbnail => $values)
         {
            if (!$validator1->execute($values['width'], $error))
            {
               $this->getRequest()->setError('product{'.$thumbnail.'}{width}', $error);
            }

            if (!$validator2->execute($values['height'], $error))
            {
               $this->getRequest()->setError('product{'.$thumbnail.'}{height}', $error);
            }
         }
      }

      return!$this->getRequest()->hasErrors();
   }

   public function handleErrorProduct()
   {
      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      $this->updateConfigFromRequest($config, 'product');

      $this->config = $config->get('product', array());

      return sfView::SUCCESS;
   }

   public function validateProducer()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST)
      {
         $validator1 = $this->getThumbnailValidator('szerokość');

         $validator2 = $this->getThumbnailValidator('wysokość');

         foreach ($this->getRequestParameter('producer') as $thumbnail => $values)
         {
            if (!$validator1->execute($values['width'], $error))
            {
               $this->getRequest()->setError('producer{'.$thumbnail.'}{width}', $error);
            }

            if (!$validator2->execute($values['height'], $error))
            {
               $this->getRequest()->setError('producer{'.$thumbnail.'}{height}', $error);
            }
         }
      }

      return!$this->getRequest()->hasErrors();
   }

   public function handleErrorProducer()
   {
      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      $this->updateConfigFromRequest($config, 'producer');

      $this->config = $config->get('producer', array());

      return sfView::SUCCESS;
   }

   public function handleErrorWatermark()
   {
      $config = stConfig::getInstance(null, 'stAsset');

      $this->menu_items = $this->getMenuItems();

      $config->set('watermark', $this->getRequestParameter('watermark'));

      $this->config = $config->get('watermark', array());

      return sfView::SUCCESS;
   }

   protected function updateConfigFromRequest($config, $for)
   {
      $thumbnails = $config->get($for, array());

      foreach ($this->getRequestParameter($for) as $thumbnail => $values)
      {
         $thumbnails[$thumbnail] = $values;

         $thumbnails[$thumbnail]['watermark'] = isset($values['watermark']);
         
         $thumbnails[$thumbnail]['auto_crop'] = isset($values['auto_crop']);
      }

      $config->set($for, $thumbnails);
   }

   protected function getMenuItems()
   {
      $i18n = $this->getContext()->getI18N();

      return array(
          '@stAssetImageConfigurationDefault' => $i18n->__('Znak wodny'),
          'stAssetImageConfiguration/product' => $i18n->__('Produkty'),
          'stAssetImageConfiguration/category' => $i18n->__('Kategorie'),
          'stAssetImageConfiguration/producer' => $i18n->__('Producent'),
          'stAssetImageConfiguration/gallery' => $i18n->__('Galeria'));
   }

   protected function getThumbnailValidator($label)
   {
      $validator = new sfNumberValidator();

      $i18n = $this->getContext()->getI18N();

      $validator->initialize($this->getContext(), array(
          'min' => 16,
          'min_error' => $i18n->__('Minimalna').' '.$i18n->__($label).' '.$i18n->__('to').' 16 px',
          'type' => 'integer',
          'type_error' => $i18n->__(ucfirst($label)).' '.$i18n->__('musi być liczbą całkowitą'),
          'nan_error' => $i18n->__(ucfirst($label)).' '.$i18n->__('musi być liczbą całkowitą'),
      ));

      return $validator;
   }

}
