<?php
use_helper('stAdminGenerator', 'stJQueryTools');
?>

<?php echo st_get_admin_head(array('stAssetImageConfiguration', 'Konfiguracja zdjęć'), __('Znak wodny'), null, array('stConfigurationPlugin')) ?>
<div id="sf_admin_content">
   <?php echo st_get_component('stAdminGenerator', 'menu', array('items' => $menu_items)) ?>
   <?php if ($sf_request->hasErrors()): ?>
      <div class="form-errors">
         <h2><?php echo __('Popraw dane w formularzu.', null, 'stAdminGeneratorPlugin') ?></h2>
         <dl>
         <?php foreach ($sf_request->getErrorNames() as $name): ?>
            <dt></dt>
            <dd><?php echo $sf_request->getError($name) ?></dd>
         <?php endforeach; ?>
         </dl>
      </div>
   <?php elseif ($sf_flash->has('notice')): ?>
               <div class="save-ok">
                  <h2><?php echo $sf_flash->get('notice') ?></h2>
               </div>
   <?php endif; ?>
   <?php echo form_tag('stAssetImageConfiguration/watermark', array('id' => 'sf_admin_config_form')) ?>
   <?php echo st_get_admin_actions_head() ?>
   <?php echo st_get_admin_action('save', __('Zapisz', null, 'stAdminGeneratorPlugin'), null, array('name' => 'save')) ?>
   <?php echo st_get_admin_actions_foot() ?>
               <fieldset id="sf_fieldset-none"  style="margin-bottom: 0px; float: left; width: auto; min-width: 0px">
                  <div class="st_fieldset-content">
         <?php echo st_admin_get_form_field('watermark[text]', __('Tekst:'), $config['text'], 'input_tag', array('maxlength' => 30, 'style' => 'width: 280px')); ?>
         <?php echo st_admin_get_form_field('watermark[font]', __('Czcionka:'), sfThumbnail::getWatermarkFonts(), 'select_tag', array('selected' => $config['font'])); ?>
         <?php echo st_admin_get_form_field('watermark[color]', __('Kolor:'), $config['color'], 'st_colorpicker_input_tag'); ?>
         <?php echo st_admin_get_form_field('watermark[size]', __('Maksymalny rozmiar:'), array('' => __('Brak'), 8 => 8, 12 => 12, 16 => 16, 24 => 24, 36 => 36), 'select_tag', array('selected' => $config['size'])); ?>
         <?php echo st_admin_get_form_field('watermark[position]', __('Pozycja:'), sfThumbnail::getWatermarkPosition(), 'select_tag', array('selected' => $config['position'])); ?>
         <?php echo st_admin_get_form_field('watermark[alpha]', __('Stopień przezroczystości:'), array(0 => __('Brak'), 32 => '25%', 64 => '50%', 96 => '75%'), 'select_tag', array('selected' => $config['alpha'])); ?>
            </div>
         </fieldset>
         <div style="border: 1px solid #ccc; margin-left: -1px; width: 320px; height: 280px; float: left; text-align: center">
      <?php echo image_tag('/stThumbnailPlugin.php?i=media/shares/no_image.png&w=512&h=512&wp='.$config['position'].'&wt='.urlencode($config['text']).'&wc='.$config['color'].'&wa='.$config['alpha'].'&ws='.$config['size'].'&wf='.$config['font'], array('id' => 'watermark-preview')) ?>
            </div>
            <br style="clear: left" />
   <?php echo st_get_admin_actions_head() ?>
   <?php echo st_get_admin_action('save', __('Zapisz', null, 'stAdminGeneratorPlugin'), null, array('name' => 'save')) ?>
   <?php echo st_get_admin_actions_foot() ?>
            </form>
   

            </div>
            <br class="st_clear_all" />
<?php echo st_get_admin_foot() ?>
<script type="text/javascript">
   function reloadImagePreview()
   {
      var params = $H($('sf_admin_config_form').serialize(true));

      var image = new Image();
      
        var src = '/stThumbnailPlugin.php?i=media/shares/no_image.png&w=512&h=512&wp='+params.get('watermark[position]')+'&wt='+encodeURIComponent(params.get('watermark[text]'))+'&wc='+params.get('watermark[color]')+'&wa='+params.get('watermark[alpha]')+'&ws='+params.get('watermark[size]')+'&wf='+params.get('watermark[font]');

      image.onload = function()
      {
         $('watermark-preview').src = src;
      }

      image.src = src;
   }

   $('watermark_text').observe('change', reloadImagePreview);
 
   $('watermark_font').observe('change', reloadImagePreview);

   $('watermark_color').observe('change', reloadImagePreview);

   $('watermark_size').observe('change', reloadImagePreview);

   $('watermark_position').observe('change', reloadImagePreview);

   $('watermark_alpha').observe('change', reloadImagePreview);

   jQuery(function($) {
      $('#watermark_color').bind('onHide', reloadImagePreview);
   });
</script>
