<?php


abstract class BasesfGuardUser extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $username;


	
	protected $algorithm = 'sha1';


	
	protected $salt;


	
	protected $password;


	
	protected $created_at;


	
	protected $last_login;


	
	protected $is_active = true;


	
	protected $is_super_admin = false;


	
	protected $is_confirm = true;


	
	protected $is_admin_confirm = false;


	
	protected $hash_code;


	
	protected $language;


	
	protected $external_account;


	
	protected $wholesale;

	
	protected $collPayments;

	
	protected $lastPaymentCriteria = null;

	
	protected $collWebApiSessions;

	
	protected $lastWebApiSessionCriteria = null;

	
	protected $collNewsletterUsers;

	
	protected $lastNewsletterUserCriteria = null;

	
	protected $collBaskets;

	
	protected $lastBasketCriteria = null;

	
	protected $collUserHasDiscounts;

	
	protected $lastUserHasDiscountCriteria = null;

	
	protected $collDiscountUsers;

	
	protected $lastDiscountUserCriteria = null;

	
	protected $collDiscountCouponCodes;

	
	protected $lastDiscountCouponCodeCriteria = null;

	
	protected $collThemeLayouts;

	
	protected $lastThemeLayoutCriteria = null;

	
	protected $collOrders;

	
	protected $lastOrderCriteria = null;

	
	protected $collsfGuardUserPermissions;

	
	protected $lastsfGuardUserPermissionCriteria = null;

	
	protected $collsfGuardUserGroups;

	
	protected $lastsfGuardUserGroupCriteria = null;

	
	protected $collsfGuardRememberKeys;

	
	protected $lastsfGuardRememberKeyCriteria = null;

	
	protected $collRecommendSends;

	
	protected $lastRecommendSendCriteria = null;

	
	protected $collRecommendShopSends;

	
	protected $lastRecommendShopSendCriteria = null;

	
	protected $collReviews;

	
	protected $lastReviewCriteria = null;

	
	protected $collReviewOrders;

	
	protected $lastReviewOrderCriteria = null;

	
	protected $collPartners;

	
	protected $lastPartnerCriteria = null;

	
	protected $collGuardUserHasNavigations;

	
	protected $lastGuardUserHasNavigationCriteria = null;

	
	protected $collAdminGeneratorFilters;

	
	protected $lastAdminGeneratorFilterCriteria = null;

	
	protected $collUserDatas;

	
	protected $lastUserDataCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getUsername()
    {

            return $this->username;
    }

    
    public function getAlgorithm()
    {

            return $this->algorithm;
    }

    
    public function getSalt()
    {

            return $this->salt;
    }

    
    public function getPassword()
    {

            return $this->password;
    }

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getLastLogin($format = 'Y-m-d H:i:s')
	{

		if ($this->last_login === null || $this->last_login === '') {
			return null;
		} elseif (!is_int($this->last_login)) {
						$ts = strtotime($this->last_login);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [last_login] as date/time value: " . var_export($this->last_login, true));
			}
		} else {
			$ts = $this->last_login;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getIsActive()
    {

            return $this->is_active;
    }

    
    public function getIsSuperAdmin()
    {

            return $this->is_super_admin;
    }

    
    public function getIsConfirm()
    {

            return $this->is_confirm;
    }

    
    public function getIsAdminConfirm()
    {

            return $this->is_admin_confirm;
    }

    
    public function getHashCode()
    {

            return $this->hash_code;
    }

    
    public function getLanguage()
    {

            return $this->language;
    }

    
    public function getExternalAccount()
    {

            return $this->external_account;
    }

    
    public function getWholesale()
    {

            return $this->wholesale;
    }

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::ID;
        }

	} 
	
	public function setUsername($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->username !== $v) {
          $this->username = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::USERNAME;
        }

	} 
	
	public function setAlgorithm($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->algorithm !== $v || $v === 'sha1') {
          $this->algorithm = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::ALGORITHM;
        }

	} 
	
	public function setSalt($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->salt !== $v) {
          $this->salt = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::SALT;
        }

	} 
	
	public function setPassword($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->password !== $v) {
          $this->password = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::PASSWORD;
        }

	} 
	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = sfGuardUserPeer::CREATED_AT;
		}

	} 
	
	public function setLastLogin($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [last_login] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->last_login !== $ts) {
			$this->last_login = $ts;
			$this->modifiedColumns[] = sfGuardUserPeer::LAST_LOGIN;
		}

	} 
	
	public function setIsActive($v)
	{

        if ($this->is_active !== $v || $v === true) {
          $this->is_active = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::IS_ACTIVE;
        }

	} 
	
	public function setIsSuperAdmin($v)
	{

        if ($this->is_super_admin !== $v || $v === false) {
          $this->is_super_admin = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::IS_SUPER_ADMIN;
        }

	} 
	
	public function setIsConfirm($v)
	{

        if ($this->is_confirm !== $v || $v === true) {
          $this->is_confirm = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::IS_CONFIRM;
        }

	} 
	
	public function setIsAdminConfirm($v)
	{

        if ($this->is_admin_confirm !== $v || $v === false) {
          $this->is_admin_confirm = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::IS_ADMIN_CONFIRM;
        }

	} 
	
	public function setHashCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->hash_code !== $v) {
          $this->hash_code = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::HASH_CODE;
        }

	} 
	
	public function setLanguage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->language !== $v) {
          $this->language = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::LANGUAGE;
        }

	} 
	
	public function setExternalAccount($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->external_account !== $v) {
          $this->external_account = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::EXTERNAL_ACCOUNT;
        }

	} 
	
	public function setWholesale($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->wholesale !== $v) {
          $this->wholesale = $v;
          $this->modifiedColumns[] = sfGuardUserPeer::WHOLESALE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'sfGuardUser.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->username = $rs->getString($startcol + 1);

      $this->algorithm = $rs->getString($startcol + 2);

      $this->salt = $rs->getString($startcol + 3);

      $this->password = $rs->getString($startcol + 4);

      $this->created_at = $rs->getTimestamp($startcol + 5, null);

      $this->last_login = $rs->getTimestamp($startcol + 6, null);

      $this->is_active = $rs->getBoolean($startcol + 7);

      $this->is_super_admin = $rs->getBoolean($startcol + 8);

      $this->is_confirm = $rs->getBoolean($startcol + 9);

      $this->is_admin_confirm = $rs->getBoolean($startcol + 10);

      $this->hash_code = $rs->getString($startcol + 11);

      $this->language = $rs->getString($startcol + 12);

      $this->external_account = $rs->getString($startcol + 13);

      $this->wholesale = $rs->getString($startcol + 14);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'sfGuardUser.postHydrate', array('resultset' => $rs, 'startcol' => 15)));

            return $startcol + 15; 
    } catch (Exception $e) {
      throw new PropelException("Error populating sfGuardUser object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BasesfGuardUser:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(sfGuardUserPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			sfGuardUserPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BasesfGuardUser:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'sfGuardUser.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BasesfGuardUser:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(sfGuardUserPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(sfGuardUserPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'sfGuardUser.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BasesfGuardUser:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = sfGuardUserPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += sfGuardUserPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collPayments !== null) {
				foreach($this->collPayments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collWebApiSessions !== null) {
				foreach($this->collWebApiSessions as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collNewsletterUsers !== null) {
				foreach($this->collNewsletterUsers as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collBaskets !== null) {
				foreach($this->collBaskets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collUserHasDiscounts !== null) {
				foreach($this->collUserHasDiscounts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDiscountUsers !== null) {
				foreach($this->collDiscountUsers as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDiscountCouponCodes !== null) {
				foreach($this->collDiscountCouponCodes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collThemeLayouts !== null) {
				foreach($this->collThemeLayouts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrders !== null) {
				foreach($this->collOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collsfGuardUserPermissions !== null) {
				foreach($this->collsfGuardUserPermissions as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collsfGuardUserGroups !== null) {
				foreach($this->collsfGuardUserGroups as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collsfGuardRememberKeys !== null) {
				foreach($this->collsfGuardRememberKeys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collRecommendSends !== null) {
				foreach($this->collRecommendSends as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collRecommendShopSends !== null) {
				foreach($this->collRecommendShopSends as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collReviews !== null) {
				foreach($this->collReviews as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collReviewOrders !== null) {
				foreach($this->collReviewOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPartners !== null) {
				foreach($this->collPartners as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collGuardUserHasNavigations !== null) {
				foreach($this->collGuardUserHasNavigations as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collAdminGeneratorFilters !== null) {
				foreach($this->collAdminGeneratorFilters as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collUserDatas !== null) {
				foreach($this->collUserDatas as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = sfGuardUserPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collPayments !== null) {
					foreach($this->collPayments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collWebApiSessions !== null) {
					foreach($this->collWebApiSessions as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collNewsletterUsers !== null) {
					foreach($this->collNewsletterUsers as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collBaskets !== null) {
					foreach($this->collBaskets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collUserHasDiscounts !== null) {
					foreach($this->collUserHasDiscounts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDiscountUsers !== null) {
					foreach($this->collDiscountUsers as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDiscountCouponCodes !== null) {
					foreach($this->collDiscountCouponCodes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collThemeLayouts !== null) {
					foreach($this->collThemeLayouts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrders !== null) {
					foreach($this->collOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collsfGuardUserPermissions !== null) {
					foreach($this->collsfGuardUserPermissions as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collsfGuardUserGroups !== null) {
					foreach($this->collsfGuardUserGroups as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collsfGuardRememberKeys !== null) {
					foreach($this->collsfGuardRememberKeys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collRecommendSends !== null) {
					foreach($this->collRecommendSends as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collRecommendShopSends !== null) {
					foreach($this->collRecommendShopSends as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collReviews !== null) {
					foreach($this->collReviews as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collReviewOrders !== null) {
					foreach($this->collReviewOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPartners !== null) {
					foreach($this->collPartners as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collGuardUserHasNavigations !== null) {
					foreach($this->collGuardUserHasNavigations as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collAdminGeneratorFilters !== null) {
					foreach($this->collAdminGeneratorFilters as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collUserDatas !== null) {
					foreach($this->collUserDatas as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = sfGuardUserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getUsername();
				break;
			case 2:
				return $this->getAlgorithm();
				break;
			case 3:
				return $this->getSalt();
				break;
			case 4:
				return $this->getPassword();
				break;
			case 5:
				return $this->getCreatedAt();
				break;
			case 6:
				return $this->getLastLogin();
				break;
			case 7:
				return $this->getIsActive();
				break;
			case 8:
				return $this->getIsSuperAdmin();
				break;
			case 9:
				return $this->getIsConfirm();
				break;
			case 10:
				return $this->getIsAdminConfirm();
				break;
			case 11:
				return $this->getHashCode();
				break;
			case 12:
				return $this->getLanguage();
				break;
			case 13:
				return $this->getExternalAccount();
				break;
			case 14:
				return $this->getWholesale();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = sfGuardUserPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getUsername(),
			$keys[2] => $this->getAlgorithm(),
			$keys[3] => $this->getSalt(),
			$keys[4] => $this->getPassword(),
			$keys[5] => $this->getCreatedAt(),
			$keys[6] => $this->getLastLogin(),
			$keys[7] => $this->getIsActive(),
			$keys[8] => $this->getIsSuperAdmin(),
			$keys[9] => $this->getIsConfirm(),
			$keys[10] => $this->getIsAdminConfirm(),
			$keys[11] => $this->getHashCode(),
			$keys[12] => $this->getLanguage(),
			$keys[13] => $this->getExternalAccount(),
			$keys[14] => $this->getWholesale(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = sfGuardUserPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setUsername($value);
				break;
			case 2:
				$this->setAlgorithm($value);
				break;
			case 3:
				$this->setSalt($value);
				break;
			case 4:
				$this->setPassword($value);
				break;
			case 5:
				$this->setCreatedAt($value);
				break;
			case 6:
				$this->setLastLogin($value);
				break;
			case 7:
				$this->setIsActive($value);
				break;
			case 8:
				$this->setIsSuperAdmin($value);
				break;
			case 9:
				$this->setIsConfirm($value);
				break;
			case 10:
				$this->setIsAdminConfirm($value);
				break;
			case 11:
				$this->setHashCode($value);
				break;
			case 12:
				$this->setLanguage($value);
				break;
			case 13:
				$this->setExternalAccount($value);
				break;
			case 14:
				$this->setWholesale($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = sfGuardUserPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUsername($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setAlgorithm($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSalt($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setPassword($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setCreatedAt($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setLastLogin($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setIsActive($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setIsSuperAdmin($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setIsConfirm($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setIsAdminConfirm($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setHashCode($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setLanguage($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setExternalAccount($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setWholesale($arr[$keys[14]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);

		if ($this->isColumnModified(sfGuardUserPeer::ID)) $criteria->add(sfGuardUserPeer::ID, $this->id);
		if ($this->isColumnModified(sfGuardUserPeer::USERNAME)) $criteria->add(sfGuardUserPeer::USERNAME, $this->username);
		if ($this->isColumnModified(sfGuardUserPeer::ALGORITHM)) $criteria->add(sfGuardUserPeer::ALGORITHM, $this->algorithm);
		if ($this->isColumnModified(sfGuardUserPeer::SALT)) $criteria->add(sfGuardUserPeer::SALT, $this->salt);
		if ($this->isColumnModified(sfGuardUserPeer::PASSWORD)) $criteria->add(sfGuardUserPeer::PASSWORD, $this->password);
		if ($this->isColumnModified(sfGuardUserPeer::CREATED_AT)) $criteria->add(sfGuardUserPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(sfGuardUserPeer::LAST_LOGIN)) $criteria->add(sfGuardUserPeer::LAST_LOGIN, $this->last_login);
		if ($this->isColumnModified(sfGuardUserPeer::IS_ACTIVE)) $criteria->add(sfGuardUserPeer::IS_ACTIVE, $this->is_active);
		if ($this->isColumnModified(sfGuardUserPeer::IS_SUPER_ADMIN)) $criteria->add(sfGuardUserPeer::IS_SUPER_ADMIN, $this->is_super_admin);
		if ($this->isColumnModified(sfGuardUserPeer::IS_CONFIRM)) $criteria->add(sfGuardUserPeer::IS_CONFIRM, $this->is_confirm);
		if ($this->isColumnModified(sfGuardUserPeer::IS_ADMIN_CONFIRM)) $criteria->add(sfGuardUserPeer::IS_ADMIN_CONFIRM, $this->is_admin_confirm);
		if ($this->isColumnModified(sfGuardUserPeer::HASH_CODE)) $criteria->add(sfGuardUserPeer::HASH_CODE, $this->hash_code);
		if ($this->isColumnModified(sfGuardUserPeer::LANGUAGE)) $criteria->add(sfGuardUserPeer::LANGUAGE, $this->language);
		if ($this->isColumnModified(sfGuardUserPeer::EXTERNAL_ACCOUNT)) $criteria->add(sfGuardUserPeer::EXTERNAL_ACCOUNT, $this->external_account);
		if ($this->isColumnModified(sfGuardUserPeer::WHOLESALE)) $criteria->add(sfGuardUserPeer::WHOLESALE, $this->wholesale);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(sfGuardUserPeer::DATABASE_NAME);

		$criteria->add(sfGuardUserPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setUsername($this->username);

		$copyObj->setAlgorithm($this->algorithm);

		$copyObj->setSalt($this->salt);

		$copyObj->setPassword($this->password);

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setLastLogin($this->last_login);

		$copyObj->setIsActive($this->is_active);

		$copyObj->setIsSuperAdmin($this->is_super_admin);

		$copyObj->setIsConfirm($this->is_confirm);

		$copyObj->setIsAdminConfirm($this->is_admin_confirm);

		$copyObj->setHashCode($this->hash_code);

		$copyObj->setLanguage($this->language);

		$copyObj->setExternalAccount($this->external_account);

		$copyObj->setWholesale($this->wholesale);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getPayments() as $relObj) {
				$copyObj->addPayment($relObj->copy($deepCopy));
			}

			foreach($this->getWebApiSessions() as $relObj) {
				$copyObj->addWebApiSession($relObj->copy($deepCopy));
			}

			foreach($this->getNewsletterUsers() as $relObj) {
				$copyObj->addNewsletterUser($relObj->copy($deepCopy));
			}

			foreach($this->getBaskets() as $relObj) {
				$copyObj->addBasket($relObj->copy($deepCopy));
			}

			foreach($this->getUserHasDiscounts() as $relObj) {
				$copyObj->addUserHasDiscount($relObj->copy($deepCopy));
			}

			foreach($this->getDiscountUsers() as $relObj) {
				$copyObj->addDiscountUser($relObj->copy($deepCopy));
			}

			foreach($this->getDiscountCouponCodes() as $relObj) {
				$copyObj->addDiscountCouponCode($relObj->copy($deepCopy));
			}

			foreach($this->getThemeLayouts() as $relObj) {
				$copyObj->addThemeLayout($relObj->copy($deepCopy));
			}

			foreach($this->getOrders() as $relObj) {
				$copyObj->addOrder($relObj->copy($deepCopy));
			}

			foreach($this->getsfGuardUserPermissions() as $relObj) {
				$copyObj->addsfGuardUserPermission($relObj->copy($deepCopy));
			}

			foreach($this->getsfGuardUserGroups() as $relObj) {
				$copyObj->addsfGuardUserGroup($relObj->copy($deepCopy));
			}

			foreach($this->getsfGuardRememberKeys() as $relObj) {
				$copyObj->addsfGuardRememberKey($relObj->copy($deepCopy));
			}

			foreach($this->getRecommendSends() as $relObj) {
				$copyObj->addRecommendSend($relObj->copy($deepCopy));
			}

			foreach($this->getRecommendShopSends() as $relObj) {
				$copyObj->addRecommendShopSend($relObj->copy($deepCopy));
			}

			foreach($this->getReviews() as $relObj) {
				$copyObj->addReview($relObj->copy($deepCopy));
			}

			foreach($this->getReviewOrders() as $relObj) {
				$copyObj->addReviewOrder($relObj->copy($deepCopy));
			}

			foreach($this->getPartners() as $relObj) {
				$copyObj->addPartner($relObj->copy($deepCopy));
			}

			foreach($this->getGuardUserHasNavigations() as $relObj) {
				$copyObj->addGuardUserHasNavigation($relObj->copy($deepCopy));
			}

			foreach($this->getAdminGeneratorFilters() as $relObj) {
				$copyObj->addAdminGeneratorFilter($relObj->copy($deepCopy));
			}

			foreach($this->getUserDatas() as $relObj) {
				$copyObj->addUserData($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new sfGuardUserPeer();
		}
		return self::$peer;
	}

	
	public function initPayments()
	{
		if ($this->collPayments === null) {
			$this->collPayments = array();
		}
	}

	
	public function getPayments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
			   $this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->getId());

				PaymentPeer::addSelectColumns($criteria);
				$this->collPayments = PaymentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->getId());

				PaymentPeer::addSelectColumns($criteria);
				if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
					$this->collPayments = PaymentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPaymentCriteria = $criteria;
		return $this->collPayments;
	}

	
	public function countPayments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->getId());

		return PaymentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addPayment(Payment $l)
	{
		$this->collPayments[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getPaymentsJoinPaymentType($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collPayments = PaymentPeer::doSelectJoinPaymentType($criteria, $con);
			}
		} else {
									
			$criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinPaymentType($criteria, $con);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}


	
	public function getPaymentsJoinGiftCard($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collPayments = PaymentPeer::doSelectJoinGiftCard($criteria, $con);
			}
		} else {
									
			$criteria->add(PaymentPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinGiftCard($criteria, $con);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}

	
	public function initWebApiSessions()
	{
		if ($this->collWebApiSessions === null) {
			$this->collWebApiSessions = array();
		}
	}

	
	public function getWebApiSessions($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collWebApiSessions === null) {
			if ($this->isNew()) {
			   $this->collWebApiSessions = array();
			} else {

				$criteria->add(WebApiSessionPeer::SF_GUARD_USER_ID, $this->getId());

				WebApiSessionPeer::addSelectColumns($criteria);
				$this->collWebApiSessions = WebApiSessionPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(WebApiSessionPeer::SF_GUARD_USER_ID, $this->getId());

				WebApiSessionPeer::addSelectColumns($criteria);
				if (!isset($this->lastWebApiSessionCriteria) || !$this->lastWebApiSessionCriteria->equals($criteria)) {
					$this->collWebApiSessions = WebApiSessionPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastWebApiSessionCriteria = $criteria;
		return $this->collWebApiSessions;
	}

	
	public function countWebApiSessions($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(WebApiSessionPeer::SF_GUARD_USER_ID, $this->getId());

		return WebApiSessionPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addWebApiSession(WebApiSession $l)
	{
		$this->collWebApiSessions[] = $l;
		$l->setsfGuardUser($this);
	}

	
	public function initNewsletterUsers()
	{
		if ($this->collNewsletterUsers === null) {
			$this->collNewsletterUsers = array();
		}
	}

	
	public function getNewsletterUsers($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collNewsletterUsers === null) {
			if ($this->isNew()) {
			   $this->collNewsletterUsers = array();
			} else {

				$criteria->add(NewsletterUserPeer::SF_GUARD_USER_ID, $this->getId());

				NewsletterUserPeer::addSelectColumns($criteria);
				$this->collNewsletterUsers = NewsletterUserPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(NewsletterUserPeer::SF_GUARD_USER_ID, $this->getId());

				NewsletterUserPeer::addSelectColumns($criteria);
				if (!isset($this->lastNewsletterUserCriteria) || !$this->lastNewsletterUserCriteria->equals($criteria)) {
					$this->collNewsletterUsers = NewsletterUserPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastNewsletterUserCriteria = $criteria;
		return $this->collNewsletterUsers;
	}

	
	public function countNewsletterUsers($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(NewsletterUserPeer::SF_GUARD_USER_ID, $this->getId());

		return NewsletterUserPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addNewsletterUser(NewsletterUser $l)
	{
		$this->collNewsletterUsers[] = $l;
		$l->setsfGuardUser($this);
	}

	
	public function initBaskets()
	{
		if ($this->collBaskets === null) {
			$this->collBaskets = array();
		}
	}

	
	public function getBaskets($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBaskets === null) {
			if ($this->isNew()) {
			   $this->collBaskets = array();
			} else {

				$criteria->add(BasketPeer::SF_GUARD_USER_ID, $this->getId());

				BasketPeer::addSelectColumns($criteria);
				$this->collBaskets = BasketPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(BasketPeer::SF_GUARD_USER_ID, $this->getId());

				BasketPeer::addSelectColumns($criteria);
				if (!isset($this->lastBasketCriteria) || !$this->lastBasketCriteria->equals($criteria)) {
					$this->collBaskets = BasketPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBasketCriteria = $criteria;
		return $this->collBaskets;
	}

	
	public function countBaskets($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(BasketPeer::SF_GUARD_USER_ID, $this->getId());

		return BasketPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addBasket(Basket $l)
	{
		$this->collBaskets[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getBasketsJoinDiscountCouponCode($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBaskets === null) {
			if ($this->isNew()) {
				$this->collBaskets = array();
			} else {

				$criteria->add(BasketPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collBaskets = BasketPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		} else {
									
			$criteria->add(BasketPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastBasketCriteria) || !$this->lastBasketCriteria->equals($criteria)) {
				$this->collBaskets = BasketPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		}
		$this->lastBasketCriteria = $criteria;

		return $this->collBaskets;
	}

	
	public function initUserHasDiscounts()
	{
		if ($this->collUserHasDiscounts === null) {
			$this->collUserHasDiscounts = array();
		}
	}

	
	public function getUserHasDiscounts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserHasDiscounts === null) {
			if ($this->isNew()) {
			   $this->collUserHasDiscounts = array();
			} else {

				$criteria->add(UserHasDiscountPeer::SF_GUARD_USER_ID, $this->getId());

				UserHasDiscountPeer::addSelectColumns($criteria);
				$this->collUserHasDiscounts = UserHasDiscountPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(UserHasDiscountPeer::SF_GUARD_USER_ID, $this->getId());

				UserHasDiscountPeer::addSelectColumns($criteria);
				if (!isset($this->lastUserHasDiscountCriteria) || !$this->lastUserHasDiscountCriteria->equals($criteria)) {
					$this->collUserHasDiscounts = UserHasDiscountPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserHasDiscountCriteria = $criteria;
		return $this->collUserHasDiscounts;
	}

	
	public function countUserHasDiscounts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(UserHasDiscountPeer::SF_GUARD_USER_ID, $this->getId());

		return UserHasDiscountPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addUserHasDiscount(UserHasDiscount $l)
	{
		$this->collUserHasDiscounts[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getUserHasDiscountsJoinDiscount($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserHasDiscounts === null) {
			if ($this->isNew()) {
				$this->collUserHasDiscounts = array();
			} else {

				$criteria->add(UserHasDiscountPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collUserHasDiscounts = UserHasDiscountPeer::doSelectJoinDiscount($criteria, $con);
			}
		} else {
									
			$criteria->add(UserHasDiscountPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastUserHasDiscountCriteria) || !$this->lastUserHasDiscountCriteria->equals($criteria)) {
				$this->collUserHasDiscounts = UserHasDiscountPeer::doSelectJoinDiscount($criteria, $con);
			}
		}
		$this->lastUserHasDiscountCriteria = $criteria;

		return $this->collUserHasDiscounts;
	}

	
	public function initDiscountUsers()
	{
		if ($this->collDiscountUsers === null) {
			$this->collDiscountUsers = array();
		}
	}

	
	public function getDiscountUsers($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDiscountUsers === null) {
			if ($this->isNew()) {
			   $this->collDiscountUsers = array();
			} else {

				$criteria->add(DiscountUserPeer::SF_GUARD_USER_ID, $this->getId());

				DiscountUserPeer::addSelectColumns($criteria);
				$this->collDiscountUsers = DiscountUserPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DiscountUserPeer::SF_GUARD_USER_ID, $this->getId());

				DiscountUserPeer::addSelectColumns($criteria);
				if (!isset($this->lastDiscountUserCriteria) || !$this->lastDiscountUserCriteria->equals($criteria)) {
					$this->collDiscountUsers = DiscountUserPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDiscountUserCriteria = $criteria;
		return $this->collDiscountUsers;
	}

	
	public function countDiscountUsers($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DiscountUserPeer::SF_GUARD_USER_ID, $this->getId());

		return DiscountUserPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDiscountUser(DiscountUser $l)
	{
		$this->collDiscountUsers[] = $l;
		$l->setsfGuardUser($this);
	}

	
	public function initDiscountCouponCodes()
	{
		if ($this->collDiscountCouponCodes === null) {
			$this->collDiscountCouponCodes = array();
		}
	}

	
	public function getDiscountCouponCodes($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDiscountCouponCodes === null) {
			if ($this->isNew()) {
			   $this->collDiscountCouponCodes = array();
			} else {

				$criteria->add(DiscountCouponCodePeer::SF_GUARD_USER_ID, $this->getId());

				DiscountCouponCodePeer::addSelectColumns($criteria);
				$this->collDiscountCouponCodes = DiscountCouponCodePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DiscountCouponCodePeer::SF_GUARD_USER_ID, $this->getId());

				DiscountCouponCodePeer::addSelectColumns($criteria);
				if (!isset($this->lastDiscountCouponCodeCriteria) || !$this->lastDiscountCouponCodeCriteria->equals($criteria)) {
					$this->collDiscountCouponCodes = DiscountCouponCodePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDiscountCouponCodeCriteria = $criteria;
		return $this->collDiscountCouponCodes;
	}

	
	public function countDiscountCouponCodes($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DiscountCouponCodePeer::SF_GUARD_USER_ID, $this->getId());

		return DiscountCouponCodePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDiscountCouponCode(DiscountCouponCode $l)
	{
		$this->collDiscountCouponCodes[] = $l;
		$l->setsfGuardUser($this);
	}

	
	public function initThemeLayouts()
	{
		if ($this->collThemeLayouts === null) {
			$this->collThemeLayouts = array();
		}
	}

	
	public function getThemeLayouts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeLayouts === null) {
			if ($this->isNew()) {
			   $this->collThemeLayouts = array();
			} else {

				$criteria->add(ThemeLayoutPeer::SF_GUARD_USER_ID, $this->getId());

				ThemeLayoutPeer::addSelectColumns($criteria);
				$this->collThemeLayouts = ThemeLayoutPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ThemeLayoutPeer::SF_GUARD_USER_ID, $this->getId());

				ThemeLayoutPeer::addSelectColumns($criteria);
				if (!isset($this->lastThemeLayoutCriteria) || !$this->lastThemeLayoutCriteria->equals($criteria)) {
					$this->collThemeLayouts = ThemeLayoutPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastThemeLayoutCriteria = $criteria;
		return $this->collThemeLayouts;
	}

	
	public function countThemeLayouts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ThemeLayoutPeer::SF_GUARD_USER_ID, $this->getId());

		return ThemeLayoutPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addThemeLayout(ThemeLayout $l)
	{
		$this->collThemeLayouts[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getThemeLayoutsJoinTheme($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collThemeLayouts === null) {
			if ($this->isNew()) {
				$this->collThemeLayouts = array();
			} else {

				$criteria->add(ThemeLayoutPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collThemeLayouts = ThemeLayoutPeer::doSelectJoinTheme($criteria, $con);
			}
		} else {
									
			$criteria->add(ThemeLayoutPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastThemeLayoutCriteria) || !$this->lastThemeLayoutCriteria->equals($criteria)) {
				$this->collThemeLayouts = ThemeLayoutPeer::doSelectJoinTheme($criteria, $con);
			}
		}
		$this->lastThemeLayoutCriteria = $criteria;

		return $this->collThemeLayouts;
	}

	
	public function initOrders()
	{
		if ($this->collOrders === null) {
			$this->collOrders = array();
		}
	}

	
	public function getOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
			   $this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				$this->collOrders = OrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
					$this->collOrders = OrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderCriteria = $criteria;
		return $this->collOrders;
	}

	
	public function countOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

		return OrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrder(Order $l)
	{
		$this->collOrders[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getOrdersJoinOrderDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataBilling($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderStatus($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinDiscountCouponCode($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinDiscountCouponCode($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinPartner($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}

	
	public function initsfGuardUserPermissions()
	{
		if ($this->collsfGuardUserPermissions === null) {
			$this->collsfGuardUserPermissions = array();
		}
	}

	
	public function getsfGuardUserPermissions($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserPermissions === null) {
			if ($this->isNew()) {
			   $this->collsfGuardUserPermissions = array();
			} else {

				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->getId());

				sfGuardUserPermissionPeer::addSelectColumns($criteria);
				$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->getId());

				sfGuardUserPermissionPeer::addSelectColumns($criteria);
				if (!isset($this->lastsfGuardUserPermissionCriteria) || !$this->lastsfGuardUserPermissionCriteria->equals($criteria)) {
					$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastsfGuardUserPermissionCriteria = $criteria;
		return $this->collsfGuardUserPermissions;
	}

	
	public function countsfGuardUserPermissions($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->getId());

		return sfGuardUserPermissionPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addsfGuardUserPermission(sfGuardUserPermission $l)
	{
		$this->collsfGuardUserPermissions[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getsfGuardUserPermissionsJoinsfGuardPermission($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserPermissions === null) {
			if ($this->isNew()) {
				$this->collsfGuardUserPermissions = array();
			} else {

				$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->getId());

				$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelectJoinsfGuardPermission($criteria, $con);
			}
		} else {
									
			$criteria->add(sfGuardUserPermissionPeer::USER_ID, $this->getId());

			if (!isset($this->lastsfGuardUserPermissionCriteria) || !$this->lastsfGuardUserPermissionCriteria->equals($criteria)) {
				$this->collsfGuardUserPermissions = sfGuardUserPermissionPeer::doSelectJoinsfGuardPermission($criteria, $con);
			}
		}
		$this->lastsfGuardUserPermissionCriteria = $criteria;

		return $this->collsfGuardUserPermissions;
	}

	
	public function initsfGuardUserGroups()
	{
		if ($this->collsfGuardUserGroups === null) {
			$this->collsfGuardUserGroups = array();
		}
	}

	
	public function getsfGuardUserGroups($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserGroups === null) {
			if ($this->isNew()) {
			   $this->collsfGuardUserGroups = array();
			} else {

				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->getId());

				sfGuardUserGroupPeer::addSelectColumns($criteria);
				$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->getId());

				sfGuardUserGroupPeer::addSelectColumns($criteria);
				if (!isset($this->lastsfGuardUserGroupCriteria) || !$this->lastsfGuardUserGroupCriteria->equals($criteria)) {
					$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastsfGuardUserGroupCriteria = $criteria;
		return $this->collsfGuardUserGroups;
	}

	
	public function countsfGuardUserGroups($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->getId());

		return sfGuardUserGroupPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addsfGuardUserGroup(sfGuardUserGroup $l)
	{
		$this->collsfGuardUserGroups[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getsfGuardUserGroupsJoinsfGuardGroup($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardUserGroups === null) {
			if ($this->isNew()) {
				$this->collsfGuardUserGroups = array();
			} else {

				$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->getId());

				$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelectJoinsfGuardGroup($criteria, $con);
			}
		} else {
									
			$criteria->add(sfGuardUserGroupPeer::USER_ID, $this->getId());

			if (!isset($this->lastsfGuardUserGroupCriteria) || !$this->lastsfGuardUserGroupCriteria->equals($criteria)) {
				$this->collsfGuardUserGroups = sfGuardUserGroupPeer::doSelectJoinsfGuardGroup($criteria, $con);
			}
		}
		$this->lastsfGuardUserGroupCriteria = $criteria;

		return $this->collsfGuardUserGroups;
	}

	
	public function initsfGuardRememberKeys()
	{
		if ($this->collsfGuardRememberKeys === null) {
			$this->collsfGuardRememberKeys = array();
		}
	}

	
	public function getsfGuardRememberKeys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collsfGuardRememberKeys === null) {
			if ($this->isNew()) {
			   $this->collsfGuardRememberKeys = array();
			} else {

				$criteria->add(sfGuardRememberKeyPeer::USER_ID, $this->getId());

				sfGuardRememberKeyPeer::addSelectColumns($criteria);
				$this->collsfGuardRememberKeys = sfGuardRememberKeyPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(sfGuardRememberKeyPeer::USER_ID, $this->getId());

				sfGuardRememberKeyPeer::addSelectColumns($criteria);
				if (!isset($this->lastsfGuardRememberKeyCriteria) || !$this->lastsfGuardRememberKeyCriteria->equals($criteria)) {
					$this->collsfGuardRememberKeys = sfGuardRememberKeyPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastsfGuardRememberKeyCriteria = $criteria;
		return $this->collsfGuardRememberKeys;
	}

	
	public function countsfGuardRememberKeys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(sfGuardRememberKeyPeer::USER_ID, $this->getId());

		return sfGuardRememberKeyPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addsfGuardRememberKey(sfGuardRememberKey $l)
	{
		$this->collsfGuardRememberKeys[] = $l;
		$l->setsfGuardUser($this);
	}

	
	public function initRecommendSends()
	{
		if ($this->collRecommendSends === null) {
			$this->collRecommendSends = array();
		}
	}

	
	public function getRecommendSends($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collRecommendSends === null) {
			if ($this->isNew()) {
			   $this->collRecommendSends = array();
			} else {

				$criteria->add(RecommendSendPeer::SF_GUARD_USER_ID, $this->getId());

				RecommendSendPeer::addSelectColumns($criteria);
				$this->collRecommendSends = RecommendSendPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(RecommendSendPeer::SF_GUARD_USER_ID, $this->getId());

				RecommendSendPeer::addSelectColumns($criteria);
				if (!isset($this->lastRecommendSendCriteria) || !$this->lastRecommendSendCriteria->equals($criteria)) {
					$this->collRecommendSends = RecommendSendPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastRecommendSendCriteria = $criteria;
		return $this->collRecommendSends;
	}

	
	public function countRecommendSends($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(RecommendSendPeer::SF_GUARD_USER_ID, $this->getId());

		return RecommendSendPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addRecommendSend(RecommendSend $l)
	{
		$this->collRecommendSends[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getRecommendSendsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collRecommendSends === null) {
			if ($this->isNew()) {
				$this->collRecommendSends = array();
			} else {

				$criteria->add(RecommendSendPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collRecommendSends = RecommendSendPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(RecommendSendPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastRecommendSendCriteria) || !$this->lastRecommendSendCriteria->equals($criteria)) {
				$this->collRecommendSends = RecommendSendPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastRecommendSendCriteria = $criteria;

		return $this->collRecommendSends;
	}

	
	public function initRecommendShopSends()
	{
		if ($this->collRecommendShopSends === null) {
			$this->collRecommendShopSends = array();
		}
	}

	
	public function getRecommendShopSends($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collRecommendShopSends === null) {
			if ($this->isNew()) {
			   $this->collRecommendShopSends = array();
			} else {

				$criteria->add(RecommendShopSendPeer::SF_GUARD_USER_ID, $this->getId());

				RecommendShopSendPeer::addSelectColumns($criteria);
				$this->collRecommendShopSends = RecommendShopSendPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(RecommendShopSendPeer::SF_GUARD_USER_ID, $this->getId());

				RecommendShopSendPeer::addSelectColumns($criteria);
				if (!isset($this->lastRecommendShopSendCriteria) || !$this->lastRecommendShopSendCriteria->equals($criteria)) {
					$this->collRecommendShopSends = RecommendShopSendPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastRecommendShopSendCriteria = $criteria;
		return $this->collRecommendShopSends;
	}

	
	public function countRecommendShopSends($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(RecommendShopSendPeer::SF_GUARD_USER_ID, $this->getId());

		return RecommendShopSendPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addRecommendShopSend(RecommendShopSend $l)
	{
		$this->collRecommendShopSends[] = $l;
		$l->setsfGuardUser($this);
	}

	
	public function initReviews()
	{
		if ($this->collReviews === null) {
			$this->collReviews = array();
		}
	}

	
	public function getReviews($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
			   $this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->getId());

				ReviewPeer::addSelectColumns($criteria);
				$this->collReviews = ReviewPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->getId());

				ReviewPeer::addSelectColumns($criteria);
				if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
					$this->collReviews = ReviewPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastReviewCriteria = $criteria;
		return $this->collReviews;
	}

	
	public function countReviews($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->getId());

		return ReviewPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addReview(Review $l)
	{
		$this->collReviews[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getReviewsJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
				$this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collReviews = ReviewPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
				$this->collReviews = ReviewPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastReviewCriteria = $criteria;

		return $this->collReviews;
	}


	
	public function getReviewsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviews === null) {
			if ($this->isNew()) {
				$this->collReviews = array();
			} else {

				$criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collReviews = ReviewPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastReviewCriteria) || !$this->lastReviewCriteria->equals($criteria)) {
				$this->collReviews = ReviewPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastReviewCriteria = $criteria;

		return $this->collReviews;
	}

	
	public function initReviewOrders()
	{
		if ($this->collReviewOrders === null) {
			$this->collReviewOrders = array();
		}
	}

	
	public function getReviewOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviewOrders === null) {
			if ($this->isNew()) {
			   $this->collReviewOrders = array();
			} else {

				$criteria->add(ReviewOrderPeer::SF_GUARD_USER_ID, $this->getId());

				ReviewOrderPeer::addSelectColumns($criteria);
				$this->collReviewOrders = ReviewOrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ReviewOrderPeer::SF_GUARD_USER_ID, $this->getId());

				ReviewOrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastReviewOrderCriteria) || !$this->lastReviewOrderCriteria->equals($criteria)) {
					$this->collReviewOrders = ReviewOrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastReviewOrderCriteria = $criteria;
		return $this->collReviewOrders;
	}

	
	public function countReviewOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ReviewOrderPeer::SF_GUARD_USER_ID, $this->getId());

		return ReviewOrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addReviewOrder(ReviewOrder $l)
	{
		$this->collReviewOrders[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getReviewOrdersJoinOrder($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collReviewOrders === null) {
			if ($this->isNew()) {
				$this->collReviewOrders = array();
			} else {

				$criteria->add(ReviewOrderPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collReviewOrders = ReviewOrderPeer::doSelectJoinOrder($criteria, $con);
			}
		} else {
									
			$criteria->add(ReviewOrderPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastReviewOrderCriteria) || !$this->lastReviewOrderCriteria->equals($criteria)) {
				$this->collReviewOrders = ReviewOrderPeer::doSelectJoinOrder($criteria, $con);
			}
		}
		$this->lastReviewOrderCriteria = $criteria;

		return $this->collReviewOrders;
	}

	
	public function initPartners()
	{
		if ($this->collPartners === null) {
			$this->collPartners = array();
		}
	}

	
	public function getPartners($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPartners === null) {
			if ($this->isNew()) {
			   $this->collPartners = array();
			} else {

				$criteria->add(PartnerPeer::SF_GUARD_USER_ID, $this->getId());

				PartnerPeer::addSelectColumns($criteria);
				$this->collPartners = PartnerPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(PartnerPeer::SF_GUARD_USER_ID, $this->getId());

				PartnerPeer::addSelectColumns($criteria);
				if (!isset($this->lastPartnerCriteria) || !$this->lastPartnerCriteria->equals($criteria)) {
					$this->collPartners = PartnerPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPartnerCriteria = $criteria;
		return $this->collPartners;
	}

	
	public function countPartners($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(PartnerPeer::SF_GUARD_USER_ID, $this->getId());

		return PartnerPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addPartner(Partner $l)
	{
		$this->collPartners[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getPartnersJoinCountries($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPartners === null) {
			if ($this->isNew()) {
				$this->collPartners = array();
			} else {

				$criteria->add(PartnerPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collPartners = PartnerPeer::doSelectJoinCountries($criteria, $con);
			}
		} else {
									
			$criteria->add(PartnerPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastPartnerCriteria) || !$this->lastPartnerCriteria->equals($criteria)) {
				$this->collPartners = PartnerPeer::doSelectJoinCountries($criteria, $con);
			}
		}
		$this->lastPartnerCriteria = $criteria;

		return $this->collPartners;
	}

	
	public function initGuardUserHasNavigations()
	{
		if ($this->collGuardUserHasNavigations === null) {
			$this->collGuardUserHasNavigations = array();
		}
	}

	
	public function getGuardUserHasNavigations($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collGuardUserHasNavigations === null) {
			if ($this->isNew()) {
			   $this->collGuardUserHasNavigations = array();
			} else {

				$criteria->add(GuardUserHasNavigationPeer::SF_GUARD_USER_ID, $this->getId());

				GuardUserHasNavigationPeer::addSelectColumns($criteria);
				$this->collGuardUserHasNavigations = GuardUserHasNavigationPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(GuardUserHasNavigationPeer::SF_GUARD_USER_ID, $this->getId());

				GuardUserHasNavigationPeer::addSelectColumns($criteria);
				if (!isset($this->lastGuardUserHasNavigationCriteria) || !$this->lastGuardUserHasNavigationCriteria->equals($criteria)) {
					$this->collGuardUserHasNavigations = GuardUserHasNavigationPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastGuardUserHasNavigationCriteria = $criteria;
		return $this->collGuardUserHasNavigations;
	}

	
	public function countGuardUserHasNavigations($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(GuardUserHasNavigationPeer::SF_GUARD_USER_ID, $this->getId());

		return GuardUserHasNavigationPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addGuardUserHasNavigation(GuardUserHasNavigation $l)
	{
		$this->collGuardUserHasNavigations[] = $l;
		$l->setsfGuardUser($this);
	}

	
	public function initAdminGeneratorFilters()
	{
		if ($this->collAdminGeneratorFilters === null) {
			$this->collAdminGeneratorFilters = array();
		}
	}

	
	public function getAdminGeneratorFilters($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAdminGeneratorFilters === null) {
			if ($this->isNew()) {
			   $this->collAdminGeneratorFilters = array();
			} else {

				$criteria->add(AdminGeneratorFilterPeer::GUARD_USER_ID, $this->getId());

				AdminGeneratorFilterPeer::addSelectColumns($criteria);
				$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(AdminGeneratorFilterPeer::GUARD_USER_ID, $this->getId());

				AdminGeneratorFilterPeer::addSelectColumns($criteria);
				if (!isset($this->lastAdminGeneratorFilterCriteria) || !$this->lastAdminGeneratorFilterCriteria->equals($criteria)) {
					$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastAdminGeneratorFilterCriteria = $criteria;
		return $this->collAdminGeneratorFilters;
	}

	
	public function countAdminGeneratorFilters($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(AdminGeneratorFilterPeer::GUARD_USER_ID, $this->getId());

		return AdminGeneratorFilterPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addAdminGeneratorFilter(AdminGeneratorFilter $l)
	{
		$this->collAdminGeneratorFilters[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getAdminGeneratorFiltersJoinAdminGeneratorFilterData($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAdminGeneratorFilters === null) {
			if ($this->isNew()) {
				$this->collAdminGeneratorFilters = array();
			} else {

				$criteria->add(AdminGeneratorFilterPeer::GUARD_USER_ID, $this->getId());

				$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelectJoinAdminGeneratorFilterData($criteria, $con);
			}
		} else {
									
			$criteria->add(AdminGeneratorFilterPeer::GUARD_USER_ID, $this->getId());

			if (!isset($this->lastAdminGeneratorFilterCriteria) || !$this->lastAdminGeneratorFilterCriteria->equals($criteria)) {
				$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelectJoinAdminGeneratorFilterData($criteria, $con);
			}
		}
		$this->lastAdminGeneratorFilterCriteria = $criteria;

		return $this->collAdminGeneratorFilters;
	}

	
	public function initUserDatas()
	{
		if ($this->collUserDatas === null) {
			$this->collUserDatas = array();
		}
	}

	
	public function getUserDatas($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserDatas === null) {
			if ($this->isNew()) {
			   $this->collUserDatas = array();
			} else {

				$criteria->add(UserDataPeer::SF_GUARD_USER_ID, $this->getId());

				UserDataPeer::addSelectColumns($criteria);
				$this->collUserDatas = UserDataPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(UserDataPeer::SF_GUARD_USER_ID, $this->getId());

				UserDataPeer::addSelectColumns($criteria);
				if (!isset($this->lastUserDataCriteria) || !$this->lastUserDataCriteria->equals($criteria)) {
					$this->collUserDatas = UserDataPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserDataCriteria = $criteria;
		return $this->collUserDatas;
	}

	
	public function countUserDatas($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(UserDataPeer::SF_GUARD_USER_ID, $this->getId());

		return UserDataPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addUserData(UserData $l)
	{
		$this->collUserDatas[] = $l;
		$l->setsfGuardUser($this);
	}


	
	public function getUserDatasJoinCountries($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserDatas === null) {
			if ($this->isNew()) {
				$this->collUserDatas = array();
			} else {

				$criteria->add(UserDataPeer::SF_GUARD_USER_ID, $this->getId());

				$this->collUserDatas = UserDataPeer::doSelectJoinCountries($criteria, $con);
			}
		} else {
									
			$criteria->add(UserDataPeer::SF_GUARD_USER_ID, $this->getId());

			if (!isset($this->lastUserDataCriteria) || !$this->lastUserDataCriteria->equals($criteria)) {
				$this->collUserDatas = UserDataPeer::doSelectJoinCountries($criteria, $con);
			}
		}
		$this->lastUserDataCriteria = $criteria;

		return $this->collUserDatas;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'sfGuardUser.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BasesfGuardUser:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BasesfGuardUser::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 