<?php

/*
 * This file is part of the symfony package.
 * (c) 2004-2006 Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 *
 * @package    symfony
 * @subpackage plugin
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @author     Marek Jakubowicz <marek.jakubowicz@sote.pl> modifications
 * @version    SVN: $Id: sfSuperCacheFilter.class.php 9662 2010-12-01 09:46:34Z piotr $
 */
class sfSuperCacheFilter extends sfFilter
{
	public static $database = null;

	public function execute ($filterChain)
	{	
		$logFile = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'log'.DIRECTORY_SEPARATOR.'fastcache.log';	
	    // add helpers from Fast Cache (the same code for both modes)
	    require_once (sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'helper'.DIRECTORY_SEPARATOR.'stSymfonyFastCacheHelper.php');
        
		$filterChain->execute();               // execute next filter
		// only if cache is set for the entire page
		$cacheManager = $this->getContext()->getViewCacheManager();
		if (!is_object($cacheManager) || sfConfig::get('sf_debug') || !sfConfig::get('sf_no_script_name') || $this->getContext()->getResponse()->getStatusCode() != 200 || !class_exists('PDO'))   return;
		
		$uri = sfRouting::getInstance()->getCurrentInternalUri();
		$cache_vary = $cacheManager->getVary($uri);
		
		if (!isset($cache_vary['fastcache']) || $cache_vary['fastcache']==0) return;
		//check if there is any content
		$content = $this->getContext()->getResponse()->getContent();
		if (empty($content)) return;

		// FC parameters
		$hash_key='hash';
		$request   = $this->getContext()->getRequest();
		$pathInfo  = $request->getPathInfo();
		$hash_code = md5($pathInfo);
		$hash      = $request->getParameter($hash_key);
		$default   = $request->getParameter('default');
		$culture   = $request->getParameter('user_lang');
		
		// check our hash code, only one allowed parameter and required for caching
		// skip saving when default=1
		if ($default != 0) touch(SF_ROOT_DIR.DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'default'.DIRECTORY_SEPARATOR.$culture.DIRECTORY_SEPARATOR.'fast_cache_generate_default');
		if ($hash!=$hash_code || $default==1) return; // hash code doesn't match the key || default=1
		
		
		// set information about saving save cache, switch eg. smarty elements for fastcache mode
		sfConfig::set('fast_cache_save',1);

		// replace pathInfo $pathInfo:: '/stMixerFrontend/index/hash/123456' => $pathInfo = '/stMixerFrontend/index, remove hash
		preg_match("/".$hash_key.'\/'.$hash_code."$/",$pathInfo,$matches);
		if (! empty($matches[0]))
		{
			// code match to hash string
			$pathInfo=str_replace('/'.$hash_key.'/'.$hash_code,'',$pathInfo);
		}

		$host     = trim(($this->getParameter('with_host', true) ? '/'.$request->getHost() : ''),'/ ');
		$url      = trim(('/' == $pathInfo[strlen($pathInfo) - 1] ? $pathInfo.'index.html' : $pathInfo),'/ ');
		$int_hash = st_int_hash_number($host.'/'.$url);
		
		$language = $this->getLanguage();
		$currency = stCurrency::getInstance()->get();
		//use sqlite to store data

		$db = self::getOrCreateDb($int_hash);
		self::updateEntry($host, $url, $content, $language['lang'], $int_hash, $currency->getShortcut());
		header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0"); // HTTP/1.1
		header("Expires: Thu, 19 Nov 1981 08:52:00 GMT"); // Date in the pas
		header("Pragma:	no-cache"); // Date in the pas		
		exit;
	}

	protected function getLanguage()
	{
		$context  = sfContext::getInstance();
		$sf_user  = $context->getUser();
		$lang=$sf_user->getCulture();

		// get shortcut for current language
		// $c = new Criteria();
		// $c->add(LanguagePeer::LANGUAGE, $lang);
		// $language = LanguagePeer::doSelect($c);
		// $shortcut = $language->getShortcut();

		// return array("lang"=>$lang,"shortcut"=>$shortcut);
		return array("lang"=>$lang);
	}


    /**
     * Create SQLite DB in provided language
     *
     * @param string $int_hash create databae with provided hash number
     * @return self::database
     */
	static public function getOrCreateDb($int_hash='')
	{
		if (self::$database != null) return self::$database;
		
		$dbFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'fastcache'.DIRECTORY_SEPARATOR.'cache'.DIRECTORY_SEPARATOR.'cache.db.'.$int_hash;
		$logFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'log'.DIRECTORY_SEPARATOR.'fastcache.log';
		if (!file_exists($dbFile)) {
			try {
				self::$database = new PDO('sqlite:'. $dbFile);
			}  catch (PDOException $e) {
				file_put_contents($logFile, $e->getMessage(), FILE_APPEND);
			}
			$create_query = 'CREATE TABLE cache (host TEXT, url TEXT, content TEXT, language TEXT, modified INTEGER, currency TEXT)';
			if (self::$database->query($create_query)===false) {
				file_put_contents($logFile, implode(',',$database->errorInfo()), FILE_APPEND);
			}

			$create_query = 'CREATE INDEX host_url ON cache (host, url)';
			if (self::$database->query($create_query)===false) {
				file_put_contents($logFile, implode(',',$database->errorInfo()), FILE_APPEND);
			}
		} else {
			try {
				self::$database = new PDO('sqlite:'. $dbFile);
			}  catch (PDOException $e) {
				file_put_contents($logFile, $e->getMessage(), FILE_APPEND);
			}
		}
			
		return self::$database;
	}

	static public function hasEntry($host, $url, $int_hash)
	{
		$db = self::getOrCreateDb($int_hash);
		$sth = $db->prepare("SELECT content, language FROM cache WHERE host = ? AND url = ?");
		$sth->execute(array($host, ltrim($url,'/')));
		$data = $sth->fetch();
		if ($data===false) return false;
		return true;
	}

	public static function updateEntry($host, $url, $content, $language, $int_hash, $currency)
	{
		$logFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'log'.DIRECTORY_SEPARATOR.'fastcache.log';
		$db = self::getOrCreateDb($int_hash);
		if (self::hasEntry($host, $url, $int_hash)) {
			self::deleteEntry($host, $url, $int_hash);
		}
		$sth = $db->prepare("INSERT INTO cache VALUES (?,?,?,?,?,?)");
		if ($sth===false) {
			file_put_contents($logFile, implode(',',$database->errorInfo()), FILE_APPEND);
		}
		
		if ($sth->execute(array($host, $url, $content, $language, time(), $currency))===false)
		{
			file_put_contents($logFile, implode(',',$sth->errorInfo()), FILE_APPEND);
		}
	}

	public static function deleteEntry($host, $url, $int_hash)
	{
		$logFile = sfConfig::get('sf_root_dir').DIRECTORY_SEPARATOR.'log'.DIRECTORY_SEPARATOR.'fastcache.log';
		$db = self::getOrCreateDb($int_hash);
		$sth = $db->prepare("DELETE FROM cache WHERE host = ? AND url = ?");
		if ($sth===false) {
			file_put_contents($logFile, implode(',',$database->errorInfo()), FILE_APPEND);
		}
		if ($sth->execute(array($host, ltrim($url,'/')))===false)
		{
			file_put_contents($logFile, implode(',',$sth->errorInfo()), FILE_APPEND);
		}
	}
}
