[?php
/** 
 * SOTESHOP/stWebApiPlugin 
 * 
 * Ten plik należy do aplikacji stWebApiPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stWebApiPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stModuleWebapi.class.php 13909 2011-07-01 11:29:06Z piotr $
 * @author      Michał Prochowski <michal.prochowski@sote.pl>,
 */

<?php if(!defined("IS_WEBAPI")) :?>
<?php define( "IS_WEBAPI",  1 ); ?>

<?php global $fieldsInfo,$generator; 
    $webApiFields = $this->getParameterValue('webapi.fields'); 
    $webApiFields['_delete']['type'] = "integer";
    $webApiFields['_offset']['type'] = "integer";
    $webApiFields['_limit']['type'] = "integer";
    $webApiFields['_count']['type'] = "integer";
    $webApiFields['_update']['type'] = "integer";
    $webApiFields['created_at']['type'] = "dateTime";
    $webApiFields['updated_at']['type'] = "dateTime";
    $webApiFields['_modified_from']['type'] = "dateTime";
    $webApiFields['_modified_to']['type'] = "dateTime";
    $webApiFields['_session_hash']['type'] = "string";
    $generator = $this;
    if (is_array($this->getParameterValue('webapi.fields'))) {
        $fieldsInfo= array_merge($webApiFields,$this->getParameterValue('webapi.fields')); 
    } else {
        $fieldsInfo = $webApiFields;
    }?>

/** 
 * Definijce zwracanych błędów
 */
if (!defined("WEBAPI_INCORRECT_ID"))
{
    define( "WEBAPI_INCORRECT_ID",  "Błędny numer ID." );
    define( "WEBAPI_ADD_ERROR", "Błąd podczas dodawania danych. Informacja: %s" );
    define( "WEBAPI_UPDATE_ERROR", "Błąd podczas aktualizacji danych. Informacja: %s" );
    define( "WEBAPI_DELETE_ERROR", "Błąd podczas usuwania danych. Informacja: %s" );
    define( "WEBAPI_COUNT_ERROR", "Błąd podczas liczenia danych. Informacja: %s" );
    define( "WEBAPI_VALIDATE_ERROR", "Błąd podczas sprawdzania danych, niewłasciwa wartość pola %s ." );
    define( "WEBAPI_REQUIRE_ERROR", "Nie podano wymaganego pola: %s ." );
    define( "WEBAPI_CONFIG_ERROR", "Błąd w pliku konfiguracyjnym modułu.");
}
<?php function testRequireFields($fields) { 
        foreach ($fields as $key=>$value) :?><?php
            if ($value[0]=="="): ?>
        if (!isset($object-><?php print str_replace('=','',$value) ?>)) {throw new SoapFault( "3", sprintf( $this->__(WEBAPI_REQUIRE_ERROR), '<?php print str_replace('=','',$value) ?>' ));}
<?php endif; 
      endforeach; 
 } ?>

<?php function validateFields($fields) {
    global $fieldsInfo;
    foreach ($fields as $key=>$value) : 
     if (isset($fieldsInfo[str_replace('=','',$value)]['type'])):
      switch ($fieldsInfo[str_replace('=','',$value)]['type']) : 
                case 'int': ?>
        if (isset( $object-><?php print str_replace('=','',$value) ?>) && ! is_int( $object-><?php print str_replace('=','',$value) ?>) ) { throw new SoapFault( "3", sprintf( $this->__(WEBAPI_VALIDATE_ERROR), '<?php print str_replace('=','',$value) ?>' ) ); }
<?php break; ?>
<?php case 'double': ?>
        if (isset( $object-><?php print str_replace('=','',$value) ?>) &&! is_double( $object-><?php print str_replace('=','',$value) ?>) ) { throw new SoapFault( "3", sprintf( $this->__(WEBAPI_VALIDATE_ERROR), '<?php print str_replace('=','',$value) ?>' ) ); }
<?php break; ?>
<?php case 'string': ?>
        if (isset( $object-><?php print str_replace('=','',$value) ?>) &&! is_string( $object-><?php print str_replace('=','',$value) ?>) ) { throw new SoapFault( "3", sprintf( $this->__(WEBAPI_VALIDATE_ERROR), '<?php print str_replace('=','',$value) ?>' ) ); }
<?php break; ?>                
<?php case 'dateTime': ?>
        if (isset( $object-><?php print str_replace('=','',$value) ?>) &&! is_object(date_create( $object-><?php print str_replace('=','',$value) ?>)) ) { throw new SoapFault( "3", sprintf( $this->__(WEBAPI_VALIDATE_ERROR), '<?php print str_replace('=','',$value) ?>' ) ); }
        // zmiana daty z soap na mysql
        $fields[$key] = date_format(date_create($object-><?php print str_replace('=','',$value) ?>),"Y-m-d H:i:s");
<?php break; ?>                
<?php endswitch; ?>
<?php endif; ?>
<?php endforeach; 
} ?>


<?php function setFields($methodName, $fields, $modulename='') { ?>
    public function setFieldsFor<?php echo $methodName ?>( $object, &$item ) {    
<?php     global $fieldsInfo; ?>
    	if (method_exists($item,"setCulture" ) ) { $item->setCulture(sfContext::getInstance()->getUser()->getCulture());}
<?php foreach ($fields as $key=>$value) : ?>
<?php  if (isset($fieldsInfo[str_replace('=','',$value)]['custom'])): ?>
        if( isset( $object-><?php print str_replace('=','',$value) ?>) && is_callable('<?php echo $modulename ?>WebApi::set<?php print sfInflector::camelize(str_replace('=','',$value)) ?>')) { call_user_func('<?php echo $modulename ?>WebApi::set<?php print sfInflector::camelize(str_replace('=','',$value)) ?>', $item, $object-><?php print str_replace('=','',$value) ?>);}
<?php else: ?>
        if( isset( $object-><?php print str_replace('=','',$value) ?>) && ( method_exists( $item, "<?php print "set".sfInflector::camelize(str_replace('=','',$value))?>" ) ) ) { $item-><?php print "set".sfInflector::camelize(str_replace('=','',$value)) ?>( $object-><?php print str_replace('=','',$value) ?> ); }
<?php endif; ?>
<?php endforeach; ?>
    } 
<?php } ?>

<?php function follow($methods=array(), $key='', $step=0) { ?> 
    <?php if ($step==0): ?>
    $tmp = $item;
    <?php endif; ?>
    if (method_exists($tmp,'<?php print $methods[$step]; ?>')&&($tmp=$tmp-><?php print $methods[$step] ?>())!=null) {
        <?php if (isset($methods[$step+1])) {follow($methods, $key, $step+1);} else {?>
            $object-><?php print $key ?> = $tmp;
        <?php } ?>
    }
<?php } ?>

<?php function getFields($methodName, $fields, $modulename = '') { ?>
    public function getFieldsFor<?php echo $methodName ?>( $object, &$item ) {
<?php global $fieldsInfo, $generator; ?>
<?php if (is_array($generator->getParameterValue('webapi.methods.'.$methodName.'.custom_fields'))): 
    $webApiFields_custom = array_merge($fieldsInfo, $generator->getParameterValue('webapi.methods.'.$methodName.'.custom_fields')); ?>
<?php else: $webApiFields_custom= $fieldsInfo; endif;?>
		if (method_exists($item,"setCulture" ) ) { $item->setCulture(sfContext::getInstance()->getUser()->getCulture());}
<?php foreach ($fields as $key=>$value) : ?>
<?php  if (isset($webApiFields_custom[str_replace('=','',$value)]['custom'])): ?>
        if (is_callable('<?php echo $modulename ?>WebApi::get<?php print sfInflector::camelize(str_replace('=','',$value)) ?>')) { $object-><?php print str_replace('=','',$value) ?> = stWebApi::formatData(call_user_func('<?php echo $modulename ?>WebApi::get<?php print sfInflector::camelize(str_replace('=','',$value)) ?>', $item),"<?php print $webApiFields_custom[$value]['type']?>");}
<?php else: ?>
        if (method_exists($item,"get<?php print sfInflector::camelize(str_replace('=','',$value)) ?>" ) ) { $object-><?php print str_replace('=','',$value) ?> = stWebApi::formatData($item->get<?php print sfInflector::camelize(str_replace('=','',$value)); ?>(),"<?php print isset($webApiFields_custom[$value]['type'])?$webApiFields_custom[$value]['type']:'string'?>");} 
<?php endif; ?>
<?php endforeach; ?>

}
<?php } ?>

<?php function TestAndValidate($methodName, $inFields) { ?>

    public function TestAndValidate<?php echo $methodName ?>Fields( $object ) {
        // Sprawdzenie wymaganych parametrow, powielamy dla wszystkich parametrow z parametrem required: true
<?php if ($inFields) testRequireFields($inFields); ?>
                
        // Walidacja parametrow
<?php if ($inFields) validateFields($inFields); ?>
    }    
<?php } ?>
<?php endif ?>

/** 
 * Klasa StApiProduct
 *
 * @package     stWebApiPlugin
 * @subpackage  libs
 */
class <?php echo $this->getGeneratedModuleName() ?>WebApi
{
<?php if ($this->getParameterValue('webapi')): ?>
<?php foreach ($this->getParameterValue('webapi.methods') as $methodName => $method): ?>
      <?php $inFields =  $this->getParameterValue('webapi.methods.'.$methodName.'.fields.in'); ?>
      <?php $outFields =  $this->getParameterValue('webapi.methods.'.$methodName.'.fields.out'); ?>
<?php if (is_array($inFields)) TestAndValidate($methodName, $inFields); ?>
<?php if (is_array($inFields)) setFields($methodName, $inFields, $this->getModuleName()); ?>
<?php if (is_array($outFields)) getFields($methodName, $outFields, $this->getModuleName()); ?>
<?php if ($this->getParameterValue('webapi.methods.'.$methodName.'.peer')) {$PeerName=$this->getParameterValue('webapi.methods.'.$methodName.'.peer');}
      else  {$PeerName = $this->getParameterValue('model_class');} ?>
      <?php switch ($this->getParameterValue('webapi.methods.'.$methodName.'.type')) : 
      
      case 'add': ?>


    /** 
     * Dodawanie danych
     *
     * @param   object      $object             obiekt z parametrami
     * @return  object      okiekt z numer id dodanych danych
     * @throws WEBAPI_ADD_ERROR WEBAPI_REQUIRE_ERROR
     * @todo dodać waliadacje danych
     */
    public function <?php echo $methodName ?>( $object )
    {
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
        stWebApi::getLogin($object->_session_hash, 'webapi_write');
        <?php if ($inFields) : ?>$this->TestAndValidate<?php echo $methodName ?>Fields( $object );<?php endif;?>
		                       
        $item = new <?php print $PeerName; ?>( );
        if ( $item )
        {
            <?php if ($inFields) : ?>$this->setFieldsFor<?php echo $methodName ?>( $object, $item );<?php endif;?>
            
            //Zapisywanie danych do bazy
            try {
                $item->save( );
            } catch ( Exception $e ) {
                throw new SoapFault( "2", sprintf($this->__(WEBAPI_ADD_ERROR),$e->getMessage()));
            }
            
            // Zwracanie danych
            $object = new StdClass( );
            <?php if ($outFields) : ?>$this->getFieldsFor<?php echo $methodName ?>( $object, $item );<?php endif;?>
            return $object;

        } else {
            throw new SoapFault( "1", sprintf($this->__(WEBAPI_ADD_ERROR), "") );
        }
    }            
          <?php break; ?>
          <?php case 'update': ?>

    /** 
     * Aktualizacja danych
     *
     * @param   object      $object             obiekt z parametrami
     * @return  object      obiekt z true
     * @throws WEBAPI_INCORRECT_ID WEBAPI_UPDATE_ERROR WEBAPI_REQUIRE_ERROR
     * @todo dodać walidacje danych
     */
    public function <?php echo $methodName ?>( $object )
    {
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
        stWebApi::getLogin($object->_session_hash, 'webapi_write');
        <?php if ($inFields) : ?>$this->TestAndValidate<?php echo $methodName ?>Fields( $object );<?php endif;?>
        
        $item = <?php print $PeerName; ?>Peer::retrieveByPk( $object->id );
        if ( $item )
        {
            <?php if ($inFields) : ?>$this->setFieldsFor<?php echo $methodName ?>( $object, $item );<?php endif;?>
          
            //Zapisywanie danych do bazy
            try {
                $item->save( );
            } catch ( Exception $e ) {
                throw new SoapFault( "2", sprintf($this->__(WEBAPI_UPDATE_ERROR),$e->getMessage()) );
            }
            
            // Zwracanie danych
            $object = new StdClass( );
            $object->_update = 1;
            return $object;
            
        } else {
            throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
        }
    }
          <?php break; ?>
          <?php case 'get': ?>
    
    /** 
     * Pobieranie danych
     *
     * @param   object      $object             obiekt z parametrami
     * @return  object      okiekt z danymi
     * @throws WEBAPI_INCORRECT_ID WEBAPI_REQUIRE_ERROR
     */
    public function <?php echo $methodName ?>( $object )
    {
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
        stWebApi::getLogin($object->_session_hash, 'webapi_read');
        <?php if ($inFields) : ?>$this->TestAndValidate<?php echo $methodName ?>Fields( $object );<?php endif;?>


        $item = <?php print $PeerName; ?>Peer::retrieveByPk( $object->id );
        if ( $item )
        {
            $object = new StdClass( );
            <?php if ($outFields) : ?>$this->getFieldsFor<?php echo $methodName ?>( $object, $item );<?php endif;?>
        
            return $object;
        } else {
            throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
        }
    }
          
          <?php break; ?>
          <?php case 'delete': ?>
    
    /** 
     * Usuwanie danych
     *
     * @param   object      $object             obiekt z danymi
     * @return  object      obiekt z true
     * @throws WEBAPI_INCORRECT_ID WEBAPI_DELETE_ERROR WEBAPI_REQUIRE_ERROR
     */
    public function <?php echo $methodName ?>( $object )
    {
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
        stWebApi::getLogin($object->_session_hash, 'webapi_write');
        <?php if ($inFields) : ?>$this->TestAndValidate<?php echo $methodName ?>Fields( $object );<?php endif;?>


        $item = <?php print $PeerName; ?>Peer::retrieveByPk( $object->id );
        if ( $item )
        {
            // Zwracanie danych
          $obj = new StdClass( );
          $item->delete( );
          $obj->_delete = 1;
          return $obj;
        } else {
            throw new SoapFault( "1", $this->__(WEBAPI_INCORRECT_ID) );
        }
    }
          <?php break; ?>
          <?php case 'count': ?>
   
    /** 
     * Licznie ilości rekordów
     *
     * @return  object      okiekt z liczba rekordów 
     * @throws WEBAPI_COUNT_ERROR
     */
    public function <?php echo $methodName ?>( $object )
    {
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
        stWebApi::getLogin($object->_session_hash, 'webapi_read');
        
        try{
        $c = new Criteria( );
        
        if (isset($object->_modified_from) && isset($object->_modified_to)) {
            $criterion = $c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
            $criterion->addAnd($c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_to, Criteria::LESS_EQUAL));
            $c->add($criterion);
        } else {
            if (isset($object->_modified_from)) {
                $criterion = $c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
                $c->add($criterion);
            }
            
            if (isset($object->_modified_to)) {
                $criterion = $c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_to, Criteria::LESS_EQUAL);
                $c->add($criterion);
            }
        }
        
            //Zwracanie danych            
          $obj = new StdClass( );
            $obj->_count = <?php print $PeerName; ?>Peer::doCount($c);
            return $obj;
        } catch ( Exception $e ) {
            throw new SoapFault( "1", sprintf($this->__(WEBAPI_COUNT_ERROR),$e->getMessage()) );
        }
    }
          <?php break; ?>
          <?php case 'list': ?>
                        
    /** 
     * Pobieranie danych
     *
     * @param   object      $object             obiekt z parametrami
     * @return  object      okiekt z danymi
     * @throws WEBAPI_INCORRECT_ID WEBAPI_REQUIRE_ERROR
     */
    public function <?php echo $methodName ?>( $object )
    {
		if (isset($object->_culture)) { $this->__setCulture($object->_culture);}
        stWebApi::getLogin($object->_session_hash, 'webapi_read');
        <?php if ($inFields) : ?>$this->TestAndValidate<?php echo $methodName ?>Fields( $object );<?php endif;?>

        $c = new Criteria( );
        
        if (isset($object->_modified_from) && isset($object->_modified_to)) {
            $criterion = $c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
            $criterion->addAnd($c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_to, Criteria::LESS_EQUAL));
            $c->add($criterion);
        } else {
            if (isset($object->_modified_from)) {
                $criterion = $c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_from, Criteria::GREATER_EQUAL);
                $c->add($criterion);
            }
            
            if (isset($object->_modified_to)) {
                $criterion = $c->getNewCriterion(<?php print $PeerName; ?>Peer::UPDATED_AT, $object->_modified_to, Criteria::LESS_EQUAL);
                $c->add($criterion);
            }
        }

        if (!isset($object->_limit)) $object->_limit = 20;

        // ustawiamy kryteria wyboru
        $c->setLimit( $object->_limit );
        $c->setOffset( $object->_offset );
        
        $items = <?php print $PeerName; ?>Peer::doSelect( $c );
        
        if ( $items )
        {
          // Zwracanie wyniku, dla wszystkich pol z tablicy 'out'
            $items_array = array();
            foreach ( $items as $item )
            {
                $object = new StdClass( );
                <?php if ($outFields) : ?>$this->getFieldsFor<?php echo $methodName ?>( $object, $item );<?php endif;?>
        
                $items_array[] = $object;
            }
            return $items_array;
        } else {
            return array( );
        }
    }   
  
          <?php break; ?>
          <?php endswitch; ?>
<?php endforeach; ?>
<?php else:  ?>
  // moduł nie posiada skonfigurowanej obsługi WebApi
<?php endif ?>

	public function __($value, $args = array(), $catalogue = 'messages')
	{
		return sfContext::getInstance()->getI18n()->__($value, '', 'stWebApiBackend');
	}
	
	public function __setCulture($culture)
	{
		sfContext::getInstance()->getUser()->setCulture($culture);
	}	
};
?]
