<?php

/**
 * SOTESHOP/stAdminGeneratorPlugin 
 * 
 * Ten plik należy do aplikacji stAdminGeneratorPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stAdminGeneratorPlugin
 * @subpackage  helpers
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stAdminGeneratorHelper.php 16020 2011-11-09 11:15:40Z marcin $
 */
use_helper('Tag', 'nifty', 'Validation');

/**
 * Tworzy zewnętrzny link do modułu
 *
 * @param   string      $name               Nazwa linku
 * @param   string      $internal_uri       Wewnętrzny adres linku (np. 'stDemo/list')
 * @param   array       $options            Dodatkowe parametry linku
 * @return       string      HTML
 */
function st_external_link_to($name = '', $internal_uri = '', $options = array())
{
   $options = _parse_attributes($options);

   $options['class'] = 'st_admin_external_link';

   $options['target'] = '_blank';

   return link_to($name, $internal_uri, $options);
}

function st_replace_forward_parameters($value, $forward_parameters = array())
{
   foreach ($forward_parameters as $name => $forward_parameter)
   {
      $value = str_replace('%%forward_parameters.'.$name.'%%', $forward_parameter, $value);
   }

   return $value;
}

function st_get_admin_culture_picker($params = array())
{
   $languages = LanguagePeer::doSelectLanguages();

   $params['query_div'] = strpos($params['url'], '?') !== false ? '&' : '?';

   $content = content_tag('li', __('Wersja językowa wprowadzanych danych', array(), 'stAdminGeneratorPlugin').':', array('style' => 'display: inline; padding-right: 10px'));

   foreach ($languages as $language)
   {
      $content .= content_tag('li', _culture_picker_flag($language, $params), array('style' => 'display: inline; padding-right: 5px'));
   }

   return content_tag('fieldset', content_tag('div', content_tag('div', content_tag('ul', $content), array('class' => 'form-row')), array('class' => 'st_fieldset-content')));
}

function st_get_admin_culture_flag($culture = null)
{
   static $languages = array();

   if (!isset($languages[$culture]))
   {
      foreach (LanguagePeer::doSelectLanguages() as $language)
      {
         if ($language->getOriginalLanguage() == $culture)
         {
            $languages[$culture] = $language;

            break;
         }
      }
   }

   return _culture_picker_flag($languages[$culture], array('culture' => $culture));
}

function _culture_picker_flag(Language $language, $params)
{
   $culture = $language->getOriginalLanguage();

   if ($culture == $params['culture'])
   {
      return $language->getActiveImage() ? image_tag('/uploads/stLanguagePlugin/'.$language->getActiveImage(), array('style' => 'vertical-align: middle')) : $language->getShortcut();
   }
   else
   {
      return st_link_to($language->getInactiveImage() ? image_tag('/uploads/stLanguagePlugin/'.$language->getInactiveImage(), array('style' => 'vertical-align: middle')) : $language->getShortcut(), $params['url'].$params['query_div'].'culture='.$culture);
   }
}

/**
 * Zwraca HTML otwierający aplikację
 *
 * @param   mixed       $app_name           Nazwa aplikacji np. stOrder
 * @param   string      $title              Dodatkowy tytuł dla aplikacji
 * @param   string      $description        Opis aplikacji
 * @param   array       $applications       Lista aplikacji np. array('stOrder', 'stUser', ...)
 * @return       string      HTML
 */
function st_get_admin_head($app_name, $title = '', $description = '', $applications = array(), $link_params = array())
{
   $response = sfContext::getInstance()->getResponse();
   $routing = sfRouting::getInstance();
   $response->addJavascript(sfConfig::get('sf_prototype_web_dir').'/js/prototype');
   $response->addJavascript(sfConfig::get('sf_prototype_web_dir').'/js/builder');
   $response->addJavascript(sfConfig::get('sf_prototype_web_dir').'/js/effects');

   if (is_array($app_name) && $app_name[0] != $app_name[1])
   {
      list($route, $label) = $app_name;

      if (isset($app_name[2]))
      {
         $icon = $app_name[2];
      }
      
      if ($description)
      {
         $title = $description;
      }
   }
   else
   {
      if (is_array($app_name))
      {
         $app_name = $app_name[0];
      }
      
      if (stMenuModifier::hasHeadApplications($app_name))
      {
         $applications = stMenuModifier::getHeadApplications($app_name, $applications);
      }

      $route = $routing->hasRouteName($app_name.'Default') ? '@'.$app_name.'Default' : '@'.$app_name;

      $icon = 'backend/main/icons/'.$app_name.'.png';

      $route_info = $routing->getRouteByName($route);

      $label = sfContext::getInstance()->getI18N()->__(stApplication::getAppName($app_name), null, $route_info[4]['module']);
      
      if ($description)
      {
         $title = $description;
      }
   }

   $st_round_box_top = content_tag('div', '', array('class' => 'left')).content_tag('div', '', array('class' => 'right'));

   if (!is_file(sfConfig::get('sf_web_dir').'/images/'.$icon))
   {
      $icon = 'backend/main/icons/stDefaultApp.png';
   }

   $header = st_get_partial('stAdminGenerator/application_shortcuts', array('route' => $route, 'icon' => $icon, 'shortcuts' => $applications, 'label' => $label, 'title' => $title));

   return $header.tag('div', array('class' => 'st_round_box'), true).content_tag('div', $st_round_box_top, array('class' => 'top')).tag('div', array('class' => 'st_round_box-content', 'id' => 'sf_admin_container'), true);
}

/**
 * Zwraca HTML zamykający aplikację
 *
 * @return       string      HTML
 */
function st_get_admin_foot()
{
   $st_round_box_bottom = content_tag('div', '', array('class' => 'left')).content_tag('div', '', array('class' => 'right'));

   return '</div>'.content_tag('div', $st_round_box_bottom, array('class' => 'bottom')).'</div>';
}

function _st_head_menu_item($app_name)
{
   $routing = sfRouting::getInstance();

   $real_name = stApplication::getMenuElementName($app_name);

   $image_content = image_tag('backend/main/icons/'.$app_name.'.png', array('id' => 'app_'.$app_name, 'width' => '40px', 'height' => '40px'));

   $para_content = content_tag('p', $real_name);

   return content_tag('li', st_link_to($image_content, $routing->hasRouteName($app_name.'Default') ? '@'.$app_name.'Default' : '@'.$app_name).$para_content);
}

function _st_head_application_icon($app_name, $params)
{
   $routing = sfRouting::getInstance();
   return content_tag('div', st_link_to(image_tag('backend/main/icons/'.$app_name.'.png'), $routing->hasRouteName($app_name.'Default') ? '@'.$app_name.'Default' : '@'.$app_name.$params), 'id=st_application-head-package');
}

function st_admin_sort_st_link_to($label, $field_name)
{
   $content = '';
   $sf_user = sfContext::getInstance()->getUser();
   if ($sf_user->getAttribute('sort', null, 'sf_admin/order/sort') == $field_name)
   {
      //        $content .= st_link_to($label, 'order/list?sort=' . $field_name . '&type=' . ($sf_user->getAttribute('type', 'asc', 'sf_admin/order/sort') == 'asc' ? 'desc' : 'asc'));
      $content .= $label;
      $content .= image_tag('/images/backend/icons/'.$sf_user->getAttribute('type', 'asc', 'sf_admin/order/sort').'.png', array('align' => 'absmiddle'));
   }
   else
   {
      //        $content .= st_link_to($label, 'order/list?sort=' . $field_name . '&type=asc');
      $content .= $label;
   }

   return $content;
}

function st_admin_row_highlight()
{
   static $i;
   return!fmod(++$i, 2);
}

/**
 * Zwraca HTML otwierający nagłówek dla komponentu
 * Postać zwracanego kodu
 * <div class="st_admin-component" $html_options>
 *  <h2>$label</h2>
 *  <br class="st_clear_all" />
 *
 * @param   string      $label              Tytuł nagłówka
 * @param   mixed       $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_component_head($label, $html_options = array())
{
   $html_options = _parse_attributes($html_options);
   if (isset($html_options['class']))
   {
      $html_options['class'] = 'st_admin-component '.$html_options['class'];
   }
   else
   {
      $html_options['class'] = 'st_admin-component';
   }

   $content = tag('div', $html_options, true);
   $content .= content_tag('h2', $label);
   $content .= tag('br', array('class' => 'st_clear_all'));
   return $content;
}

/**
 * Zwraca HTML zamykający nagłówek dla komponentu
 * Postać zwracanego kodu
 * </div>
 *
 * @return   unknown
 */
function st_get_admin_component_foot()
{
   return '</div>';
}

/**
 * Zwraca HTML otwierający układ horyzontalny
 * Postać zwracanego kodu
 * <ul class="st_admin-horizontal-look" $html_options>
 *
 * @param   mixed       $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_horizontal_look_head($html_options = array())
{
   $same_height = '';

   $html_options = _parse_attributes($html_options);

   if (isset($html_options['id']))
   {
      $same_height = javascript_tag(nifty_round_elements('ul#'.$html_options['id'].' > li', 'none same-height'));
   }

   if (isset($html_options['class']))
   {
      $html_options['class'] = 'st_admin-horizontal-look '.$html_options['class'];
   }
   else
   {
      $html_options['class'] = 'st_admin-horizontal-look';
   }

   return $same_height.tag('ul', $html_options, true);
}

/**
 * Zwraca HTML otwierający element dla układu horyzontalnego
 * Postać zwracanego kodu
 * <li $html_options>
 *
 * @param   mixed       $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_horizontal_element_head($html_options = array())
{
   $html_options = _parse_attributes($html_options);
   if (isset($html_options['class']))
   {
      $html_options['class'] = 'st_admin-horizontal-look-element '.$html_options['class'];
   }
   else
   {
      $html_options['class'] = 'st_admin-horizontal-look-element';
   }

   return tag('li', $html_options, true);
}

/**
 * Zwraca HTML zamykający element dla układu horyzontalnego
 * Postać zwracanego kodu
 * </li>
 *
 * @return       string      HTML
 */
function st_get_admin_horizontal_element_foot()
{
   return '</li>';
}

/**
 * Zwraca HTML zamykający układ horyzontalny
 * Postać zwracanego kodu
 * </ul><br class="st_clear_all" />
 *
 * @return       string      HTML
 */
function st_get_admin_horizontal_look_foot()
{
   return content_tag('li', '', 'class="st_clear_all"').'</ul>';
}

/**
 * Zwraca HTML otwierający listę
 * Postać zwracanego kodu
 * <ul class="st_admin-item-list">
 *
 * @param   mixed       $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_item_list_head($html_options = array())
{
   $html_options = _parse_attributes($html_options);
   if (isset($html_options['class']))
   {
      $html_options['class'] = 'st_admin-item-list '.$html_options['class'];
   }
   else
   {
      $html_options['class'] = 'st_admin-item-list';
   }

   return tag('ul', $html_options, true);
}

/**
 * Zwraca HTML elementu listy
 * Postać zwracanego kodu:
 * <li $html_options>
 *  <span>$label</span>
 *  $value albo <strong>$value</strong> (gdy flaga is_imported jest ustawiona)
 * </li>
 *
 * @param   string      $label              Tytuł elementu
 * @param   string      $value              Wartość elementu
 * @param   bool        $is_important       Określa czy element ma być oznaczony jako ważny
 * @param   array       $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_item_list_element($label, $value, $is_important = false, $html_options = array())
{
   $label_content = content_tag('span', $label.':');

   if ($is_important)
   {
      $value_content = content_tag('strong', $value);
   }
   else
   {
      $value_content = $value;
   }

   return content_tag('li', $label_content.$value_content, $html_options);
}

/**
 * Zwraca HTML zamykający listę
 * Postać zwracanego kodu:
 * </ul><br class="st_clear_all" />
 *
 * @return       string      HTML
 */
function st_get_admin_item_list_foot()
{
   return '</ul>'.tag('br', array('class' => 'st_clear_all'));
}

/**
 * Zwraca HTML otwierający separator zawartości
 * Postać zwracanego kodu:
 * <div class="st_admin-content-separator" $html_options>
 *
 * @param   mixed       $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_content_separator_head($html_options = array())
{
   $html_options = _parse_attributes($html_options);
   if (isset($html_options['class']))
   {
      $html_options['class'] = 'st_admin-content-separator '.$html_options['class'];
   }
   else
   {
      $html_options['class'] = 'st_admin-content-separator';
   }

   return tag('div', $html_options, true);
}

/**
 * Zwraca HTML zamykający separator zawartości
 * Postać zwracanego kodu
 * </div>
 *
 * @return       string      HTML
 */
function st_get_admin_content_separator_foot()
{
   return '</div>';
}

/**
 * Zwraca HTML przycisku dla danej akcji
 *
 * @param   string      $type               Typ akcji (dostepne: save, save_and_add, save_and_list, delete, list, edit)
 * @param   string      $label              Etykieta przycisku
 * @param   string      $action             Akcja przycisku (np. category/index)
 * @param   mixed       $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_action($type, $label, $action = null, $html_options = array())
{
   $html_options = _parse_attributes($html_options);

   if ($type == 'create' || $type == 'add')
   {
      $type = 'add';
   }
   elseif ($type == 'save_and_list' || $type == 'save_and_add' || $type == 'save')
   {
      $type = 'save';
   }

   if (isset($html_options['type']))
   {
      $type = $html_options['type'];

      unset($html_options['type']);
   }

   $html_options['style'] = 'background-image: url(/images/backend/icons/'.$type.'.png)';

   if (is_null($action))
   {
      $action_content = submit_tag($label, $html_options);
   }
   else
   {
      $action_content = st_button_to($label, $action, $html_options);
   }

   return content_tag('li', content_tag('div', content_tag('div', $action_content)), array('class' => 'st_admin-action-'.$type));
}

function st_button_to($name, $internal_uri ='', $options = array())
{
   $html_options = _parse_attributes($options);
   $html_options['value'] = $name;

   if (isset($html_options['post']) && $html_options['post'])
   {
      if (isset($html_options['popup']))
      {
         throw new sfConfigurationException('You can\'t use "popup" and "post" together');
      }
      $html_options['type'] = 'submit';
      unset($html_options['post']);
      $html_options = _convert_options_to_javascript($html_options);

      return form_tag($internal_uri, array('method' => 'post', 'class' => 'button_to')).content_tag('div', tag('input', $html_options)).'</form>';
   }

   $url = $internal_uri && $internal_uri{0} == '/' ? $internal_uri : url_for($internal_uri);
   if (isset($html_options['query_string']))
   {
      $url = $url.'?'.$html_options['query_string'];
      unset($html_options['query_string']);
   }
   $url = "'".$url."'";
   $html_options['type'] = 'button';

   if (isset($html_options['popup']))
   {
      $html_options = _convert_options_to_javascript($html_options, $url);
      unset($html_options['popup']);
   }
   else
   {
      $html_options['onclick'] = "document.location.href=".$url.";";
      $html_options = _convert_options_to_javascript($html_options);
   }

   return tag('input', $html_options);
}

/**
 * Zwraca HTML otwierający definiowanie akcji
 *
 * @param   string      $html_options       opcje HTML
 * @return       string      HTML
 */
function st_get_admin_actions_head($html_options = array())
{
   $html_options = _parse_attributes($html_options);
   if (isset($html_options['class']))
   {
      $html_options['class'] = 'st_admin-actions '.$html_options['class'];
   }
   else
   {
      $html_options['class'] = 'st_admin-actions';
   }

   return tag('ul', $html_options, true);
}

/**
 * Zwraca HTML zamykający definiowanie akcji
 *
 * @return       string      HTML
 */
function st_get_admin_actions_foot()
{
   return '</ul>'.tag('br', array('class' => 'st_clear_all'));
}

function st_admin_get_filters_list($module, $action, $page)
{
   $user = sfContext::getInstance()->getUser();

   $c = new Criteria();

   $c->add(AdminGeneratorFilterPeer::MODULE_NAMESPACE, $module.'/'.$action);

   $c1 = $c->getNewCriterion(AdminGeneratorFilterPeer::GUARD_USER_ID, $user->getGuardUser()->getId());

   $c1->addOr($c->getNewCriterion(AdminGeneratorFilterPeer::IS_GLOBAL, true));

   $c->add($c1);

   $c->addAscendingOrderByColumn(AdminGeneratorFilterPeer::NAME);

   $filters = AdminGeneratorFilterPeer::doSelect($c);

   $options = array();

   foreach ($filters as $filter)
   {
      $options[$filter->getId()] = $filter->getName();
   }

   $selected = $user->getAttribute($action.'.filter', null, 'soteshop/stAdminGenerator/'.$module.'/config');

   $url = st_url_for($module.'/setFilter?for_action='.$action.'&page='.$page.'&id=');

   $js = <<<JS
<script type="text/javascript">
$('filter_control').observe('change', function() {
   window.location = '$url/' + this.options[this.selectedIndex].value;
});
</script>
JS;

   $label = label_for('filter_control', __('Aktywny filtr', null, 'stAdminGeneratorPlugin').':');

   $select = select_tag('filter_control', options_for_select($options, $selected ? $selected['id'] : null, array('include_custom' => '---')));

   return $label.$select.$js;
}

function st_admin_get_assigned_filter($filters)
{
   return select_tag('filters[assigned]', options_for_select(array(1 => __('tak', array(), 'stAdminGeneratorPlugin'), 0 => __('nie', array(), 'stAdminGeneratorPlugin')), isset($filters['assigned']) ? $filters['assigned'] : null, array(
                       'include_custom' => __("---"),
                   )));
}

function st_admin_get_current_filter($var, $module, $action)
{
   $selected = sfContext::getInstance()->getUser()->getAttribute($action.'.filter', null, 'soteshop/stAdminGenerator/'.$module.'/config');

   return isset($selected[$var]) ? $selected[$var] : null;
}

function st_admin_show_form_fields($fields, $values, $order)
{   
   foreach ($order as $name)
   {
      $attr = isset($fields[$name]['attr']) ? $fields[$name]['attr'] : array(); 
      
      $type = isset($fields[$name]['type']) ? $fields[$name]['type'] : 'input_tag';
      
      $value = isset($values[$name]) ? $values[$name] : null; 
      
      if ($type == 'select_tag')
      {
         $attr['selected'] = $value;
         
         $value = $fields[$name]['options'];
      }
      elseif ($type == 'checkbox_tag')
      {
         $attr['checked'] = $value;
         
         $value = $fields[$name]['value'];
      }
      
      echo st_admin_get_form_field($name, __($fields[$name]['label']), $value, $type, $attr); 
   }
}

function st_admin_get_form_field($name, $label, $value, $type = 'input_tag', $params = array())
{
   if (isset($params['help']))
   {
      $help = content_tag('div', $params['help'], array('class' => 'sf_admin_edit_help'));
   }
   else
   {
      $help = '';
   }

   switch ($type)
   {
      case 'checkbox_tag':
      case 'radiobutton_tag':
         if (isset($params['checked']))
         {
            $checked = $params['checked'];

            unset($params['checked']);
         }
         else
         {
            $checked = false;
         }

         $field_content = $type($name, $value, $checked, $params);
         break;
      case 'select_tag':
         if (isset($params['selected']))
         {
            $selected = $params['selected'];

            unset($params['selected']);
         }
         else
         {
            $selected = '';
         }

         $field_content = $type($name, options_for_select($value, $selected), $params);
         break;
      case 'select_number_tag':
         $field_content = $type($name, $value, $params, isset($params['html']) ? $params['html'] : array());
         break;
      case 'plain':
         $field_content = $value;
         break;
      default:
         if ($type[0] == '_')
         {
            $partial = substr($type, 1);

            $field_content = st_get_partial($partial, array('value' => $value, 'name' => $name, 'params' => $params));
         }
         else
         {
            $field_content = $type($name, $value, $params);
         }
   }

   $error_name = str_replace(array('[', ']'), array('{', '}'), $name);

   if (form_has_error($error_name))
   {
      $error_msg = content_tag('div', form_error($error_name), array('class' => 'form-error-msg'));

      return content_tag('div', label_for($name, $label).content_tag('div', $error_msg.$field_content.tag('br', array('class' => 'st_clear_all')), array('class' => 'content form-error')).$help, array('class' => 'form-row'));
   }
   else
   {
      return content_tag('div', label_for($name, $label).content_tag('div', $field_content.tag('br', array('class' => 'st_clear_all')), array('class' => 'content')).$help, array('class' => 'form-row'));
   }
}

