<?php


abstract class BaseAdminGeneratorFilter extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $guard_user_id;


	
	protected $data_id;


	
	protected $name;


	
	protected $module_namespace;


	
	protected $is_global = false;

	
	protected $asfGuardUser;

	
	protected $aAdminGeneratorFilterData;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getGuardUserId()
    {

            return $this->guard_user_id;
    }

    
    public function getDataId()
    {

            return $this->data_id;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getModuleNamespace()
    {

            return $this->module_namespace;
    }

    
    public function getIsGlobal()
    {

            return $this->is_global;
    }

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterPeer::ID;
        }

	} 
	
	public function setGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->guard_user_id !== $v) {
          $this->guard_user_id = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterPeer::GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setDataId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->data_id !== $v) {
          $this->data_id = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterPeer::DATA_ID;
        }

		if ($this->aAdminGeneratorFilterData !== null && $this->aAdminGeneratorFilterData->getId() !== $v) {
			$this->aAdminGeneratorFilterData = null;
		}

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterPeer::NAME;
        }

	} 
	
	public function setModuleNamespace($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->module_namespace !== $v) {
          $this->module_namespace = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterPeer::MODULE_NAMESPACE;
        }

	} 
	
	public function setIsGlobal($v)
	{

        if ($this->is_global !== $v || $v === false) {
          $this->is_global = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterPeer::IS_GLOBAL;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilter.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->guard_user_id = $rs->getInt($startcol + 1);

      $this->data_id = $rs->getInt($startcol + 2);

      $this->name = $rs->getString($startcol + 3);

      $this->module_namespace = $rs->getString($startcol + 4);

      $this->is_global = $rs->getBoolean($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilter.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating AdminGeneratorFilter object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseAdminGeneratorFilter:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AdminGeneratorFilterPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			AdminGeneratorFilterPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseAdminGeneratorFilter:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilter.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseAdminGeneratorFilter:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AdminGeneratorFilterPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilter.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseAdminGeneratorFilter:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}

			if ($this->aAdminGeneratorFilterData !== null) {
				if ($this->aAdminGeneratorFilterData->isModified()) {
					$affectedRows += $this->aAdminGeneratorFilterData->save($con);
				}
				$this->setAdminGeneratorFilterData($this->aAdminGeneratorFilterData);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = AdminGeneratorFilterPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += AdminGeneratorFilterPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}

			if ($this->aAdminGeneratorFilterData !== null) {
				if (!$this->aAdminGeneratorFilterData->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAdminGeneratorFilterData->getValidationFailures());
				}
			}


			if (($retval = AdminGeneratorFilterPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AdminGeneratorFilterPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getGuardUserId();
				break;
			case 2:
				return $this->getDataId();
				break;
			case 3:
				return $this->getName();
				break;
			case 4:
				return $this->getModuleNamespace();
				break;
			case 5:
				return $this->getIsGlobal();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AdminGeneratorFilterPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getGuardUserId(),
			$keys[2] => $this->getDataId(),
			$keys[3] => $this->getName(),
			$keys[4] => $this->getModuleNamespace(),
			$keys[5] => $this->getIsGlobal(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AdminGeneratorFilterPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setGuardUserId($value);
				break;
			case 2:
				$this->setDataId($value);
				break;
			case 3:
				$this->setName($value);
				break;
			case 4:
				$this->setModuleNamespace($value);
				break;
			case 5:
				$this->setIsGlobal($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AdminGeneratorFilterPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setGuardUserId($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setDataId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setModuleNamespace($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setIsGlobal($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(AdminGeneratorFilterPeer::DATABASE_NAME);

		if ($this->isColumnModified(AdminGeneratorFilterPeer::ID)) $criteria->add(AdminGeneratorFilterPeer::ID, $this->id);
		if ($this->isColumnModified(AdminGeneratorFilterPeer::GUARD_USER_ID)) $criteria->add(AdminGeneratorFilterPeer::GUARD_USER_ID, $this->guard_user_id);
		if ($this->isColumnModified(AdminGeneratorFilterPeer::DATA_ID)) $criteria->add(AdminGeneratorFilterPeer::DATA_ID, $this->data_id);
		if ($this->isColumnModified(AdminGeneratorFilterPeer::NAME)) $criteria->add(AdminGeneratorFilterPeer::NAME, $this->name);
		if ($this->isColumnModified(AdminGeneratorFilterPeer::MODULE_NAMESPACE)) $criteria->add(AdminGeneratorFilterPeer::MODULE_NAMESPACE, $this->module_namespace);
		if ($this->isColumnModified(AdminGeneratorFilterPeer::IS_GLOBAL)) $criteria->add(AdminGeneratorFilterPeer::IS_GLOBAL, $this->is_global);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(AdminGeneratorFilterPeer::DATABASE_NAME);

		$criteria->add(AdminGeneratorFilterPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setGuardUserId($this->guard_user_id);

		$copyObj->setDataId($this->data_id);

		$copyObj->setName($this->name);

		$copyObj->setModuleNamespace($this->module_namespace);

		$copyObj->setIsGlobal($this->is_global);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new AdminGeneratorFilterPeer();
		}
		return self::$peer;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setGuardUserId(NULL);
		} else {
			$this->setGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function setAdminGeneratorFilterData($v)
	{


		if ($v === null) {
			$this->setDataId(NULL);
		} else {
			$this->setDataId($v->getId());
		}


		$this->aAdminGeneratorFilterData = $v;
	}


	
	public function getAdminGeneratorFilterData($con = null)
	{
		if ($this->aAdminGeneratorFilterData === null && ($this->data_id !== null)) {
						$this->aAdminGeneratorFilterData = AdminGeneratorFilterDataPeer::retrieveByPK($this->data_id, $con);

			
		}
		return $this->aAdminGeneratorFilterData;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'AdminGeneratorFilter.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseAdminGeneratorFilter:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseAdminGeneratorFilter::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 