<?php


abstract class BaseAdminGeneratorFilterData extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $data;

	
	protected $collAdminGeneratorFilters;

	
	protected $lastAdminGeneratorFilterCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getData()
    {

            return $this->data;
    }

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterDataPeer::ID;
        }

	} 
	
	public function setData($v)
	{

        if ($this->data !== $v) {
          $this->data = $v;
          $this->modifiedColumns[] = AdminGeneratorFilterDataPeer::DATA;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilterData.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->data = $rs->getString($startcol + 1) ? unserialize($rs->getString($startcol + 1)) : null;

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilterData.postHydrate', array('resultset' => $rs, 'startcol' => 2)));

            return $startcol + 2; 
    } catch (Exception $e) {
      throw new PropelException("Error populating AdminGeneratorFilterData object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseAdminGeneratorFilterData:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AdminGeneratorFilterDataPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			AdminGeneratorFilterDataPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseAdminGeneratorFilterData:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilterData.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseAdminGeneratorFilterData:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AdminGeneratorFilterDataPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'AdminGeneratorFilterData.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseAdminGeneratorFilterData:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
              $o_data = $this->data;
              if (null !== $this->data && $this->isColumnModified(AdminGeneratorFilterDataPeer::DATA)) {
                  $this->data = serialize($this->data);
              }

				if ($this->isNew()) {
					$pk = AdminGeneratorFilterDataPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += AdminGeneratorFilterDataPeer::doUpdate($this, $con);
				}
				$this->resetModified();
             $this->data = $o_data;
 			}

			if ($this->collAdminGeneratorFilters !== null) {
				foreach($this->collAdminGeneratorFilters as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = AdminGeneratorFilterDataPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collAdminGeneratorFilters !== null) {
					foreach($this->collAdminGeneratorFilters as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AdminGeneratorFilterDataPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getData();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AdminGeneratorFilterDataPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getData(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AdminGeneratorFilterDataPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setData($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AdminGeneratorFilterDataPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setData($arr[$keys[1]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(AdminGeneratorFilterDataPeer::DATABASE_NAME);

		if ($this->isColumnModified(AdminGeneratorFilterDataPeer::ID)) $criteria->add(AdminGeneratorFilterDataPeer::ID, $this->id);
		if ($this->isColumnModified(AdminGeneratorFilterDataPeer::DATA)) $criteria->add(AdminGeneratorFilterDataPeer::DATA, $this->data);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(AdminGeneratorFilterDataPeer::DATABASE_NAME);

		$criteria->add(AdminGeneratorFilterDataPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setData($this->data);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getAdminGeneratorFilters() as $relObj) {
				$copyObj->addAdminGeneratorFilter($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new AdminGeneratorFilterDataPeer();
		}
		return self::$peer;
	}

	
	public function initAdminGeneratorFilters()
	{
		if ($this->collAdminGeneratorFilters === null) {
			$this->collAdminGeneratorFilters = array();
		}
	}

	
	public function getAdminGeneratorFilters($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAdminGeneratorFilters === null) {
			if ($this->isNew()) {
			   $this->collAdminGeneratorFilters = array();
			} else {

				$criteria->add(AdminGeneratorFilterPeer::DATA_ID, $this->getId());

				AdminGeneratorFilterPeer::addSelectColumns($criteria);
				$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(AdminGeneratorFilterPeer::DATA_ID, $this->getId());

				AdminGeneratorFilterPeer::addSelectColumns($criteria);
				if (!isset($this->lastAdminGeneratorFilterCriteria) || !$this->lastAdminGeneratorFilterCriteria->equals($criteria)) {
					$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastAdminGeneratorFilterCriteria = $criteria;
		return $this->collAdminGeneratorFilters;
	}

	
	public function countAdminGeneratorFilters($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(AdminGeneratorFilterPeer::DATA_ID, $this->getId());

		return AdminGeneratorFilterPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addAdminGeneratorFilter(AdminGeneratorFilter $l)
	{
		$this->collAdminGeneratorFilters[] = $l;
		$l->setAdminGeneratorFilterData($this);
	}


	
	public function getAdminGeneratorFiltersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAdminGeneratorFilters === null) {
			if ($this->isNew()) {
				$this->collAdminGeneratorFilters = array();
			} else {

				$criteria->add(AdminGeneratorFilterPeer::DATA_ID, $this->getId());

				$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(AdminGeneratorFilterPeer::DATA_ID, $this->getId());

			if (!isset($this->lastAdminGeneratorFilterCriteria) || !$this->lastAdminGeneratorFilterCriteria->equals($criteria)) {
				$this->collAdminGeneratorFilters = AdminGeneratorFilterPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastAdminGeneratorFilterCriteria = $criteria;

		return $this->collAdminGeneratorFilters;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'AdminGeneratorFilterData.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseAdminGeneratorFilterData:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseAdminGeneratorFilterData::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 