<?php $routing = sfRouting::getInstance(); ?> 
<div class="st_application-header">
    <div style="float:left">
      <h1>
        <span><?php echo st_link_to(image_tag($icon, array('alt' => $label)), $route) ?></span>
        <?php echo st_link_to($label, $route) ?>
      </h1>
      <p class="description"><?php echo $title ? $title : '&nbsp;' ?></p>       
    </div>
    <?php if ($shortcuts): ?>
        <div class="st_round_box" id="shortcut-box">
            <div class="top">
                <div class="left"></div>
                <div class="right"></div>
            </div>
            <div class="st_round_box-content">
                <ul class="shortcuts">
                    <?php foreach ($shortcuts as $shortcut): ?>
                        <?php
                        $label = stApplication::getMenuElementName($shortcut);
                        $route_name = '@' . $shortcut;
                        $routeName = $routing->hasRouteName($shortcut . 'Default') ? $route_name . 'Default' : $route_name;
                        $routeInfo = $routing->getRouteByName($routeName);
                        $module = $routeInfo[4]['module'];
                        ?>
                        <li class="shortcut">
                            <?php echo st_link_to(image_tag('backend/main/icons/' . $shortcut . '.png', stLicenseTypeHelper::addImageStyle($module, array('id' => 'app_' . $shortcut))), $routeName) ?>
                            <p><?php echo st_link_to(__($label, null, $module), $routeName) ?></p>
                        </li>
                    <?php endforeach; ?>
                </ul>
                <br style="clear: right" />
            </div>
            <div class="bottom">
                <div class="left"></div>
                <div class="right"></div>
            </div>
        </div>
        <br style="clear: right" />
    <?php endif; ?> 
</div>
