<?php


abstract class BaseAttributeField extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $attribute_template_id;


	
	protected $name;


	
	protected $rank;

	
	protected $aAttributeTemplate;

	
	protected $collDeliverySectionss;

	
	protected $lastDeliverySectionsCriteria = null;

	
	protected $collProductHasAttributeFields;

	
	protected $lastProductHasAttributeFieldCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getAttributeTemplateId()
    {

            return $this->attribute_template_id;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getRank()
    {

            return $this->rank;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = AttributeFieldPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = AttributeFieldPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = AttributeFieldPeer::ID;
        }

	} 
	
	public function setAttributeTemplateId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->attribute_template_id !== $v) {
          $this->attribute_template_id = $v;
          $this->modifiedColumns[] = AttributeFieldPeer::ATTRIBUTE_TEMPLATE_ID;
        }

		if ($this->aAttributeTemplate !== null && $this->aAttributeTemplate->getId() !== $v) {
			$this->aAttributeTemplate = null;
		}

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = AttributeFieldPeer::NAME;
        }

	} 
	
	public function setRank($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->rank !== $v) {
          $this->rank = $v;
          $this->modifiedColumns[] = AttributeFieldPeer::RANK;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'AttributeField.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->attribute_template_id = $rs->getInt($startcol + 3);

      $this->name = $rs->getString($startcol + 4);

      $this->rank = $rs->getInt($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'AttributeField.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating AttributeField object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseAttributeField:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AttributeFieldPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			AttributeFieldPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseAttributeField:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'AttributeField.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseAttributeField:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(AttributeFieldPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(AttributeFieldPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AttributeFieldPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'AttributeField.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseAttributeField:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aAttributeTemplate !== null) {
				if ($this->aAttributeTemplate->isModified()) {
					$affectedRows += $this->aAttributeTemplate->save($con);
				}
				$this->setAttributeTemplate($this->aAttributeTemplate);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = AttributeFieldPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += AttributeFieldPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collDeliverySectionss !== null) {
				foreach($this->collDeliverySectionss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProductHasAttributeFields !== null) {
				foreach($this->collProductHasAttributeFields as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aAttributeTemplate !== null) {
				if (!$this->aAttributeTemplate->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAttributeTemplate->getValidationFailures());
				}
			}


			if (($retval = AttributeFieldPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collDeliverySectionss !== null) {
					foreach($this->collDeliverySectionss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProductHasAttributeFields !== null) {
					foreach($this->collProductHasAttributeFields as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AttributeFieldPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getAttributeTemplateId();
				break;
			case 4:
				return $this->getName();
				break;
			case 5:
				return $this->getRank();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AttributeFieldPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getAttributeTemplateId(),
			$keys[4] => $this->getName(),
			$keys[5] => $this->getRank(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AttributeFieldPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setAttributeTemplateId($value);
				break;
			case 4:
				$this->setName($value);
				break;
			case 5:
				$this->setRank($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AttributeFieldPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setAttributeTemplateId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setName($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setRank($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(AttributeFieldPeer::DATABASE_NAME);

		if ($this->isColumnModified(AttributeFieldPeer::CREATED_AT)) $criteria->add(AttributeFieldPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(AttributeFieldPeer::UPDATED_AT)) $criteria->add(AttributeFieldPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(AttributeFieldPeer::ID)) $criteria->add(AttributeFieldPeer::ID, $this->id);
		if ($this->isColumnModified(AttributeFieldPeer::ATTRIBUTE_TEMPLATE_ID)) $criteria->add(AttributeFieldPeer::ATTRIBUTE_TEMPLATE_ID, $this->attribute_template_id);
		if ($this->isColumnModified(AttributeFieldPeer::NAME)) $criteria->add(AttributeFieldPeer::NAME, $this->name);
		if ($this->isColumnModified(AttributeFieldPeer::RANK)) $criteria->add(AttributeFieldPeer::RANK, $this->rank);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(AttributeFieldPeer::DATABASE_NAME);

		$criteria->add(AttributeFieldPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setAttributeTemplateId($this->attribute_template_id);

		$copyObj->setName($this->name);

		$copyObj->setRank($this->rank);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getDeliverySectionss() as $relObj) {
				$copyObj->addDeliverySections($relObj->copy($deepCopy));
			}

			foreach($this->getProductHasAttributeFields() as $relObj) {
				$copyObj->addProductHasAttributeField($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new AttributeFieldPeer();
		}
		return self::$peer;
	}

	
	public function setAttributeTemplate($v)
	{


		if ($v === null) {
			$this->setAttributeTemplateId(NULL);
		} else {
			$this->setAttributeTemplateId($v->getId());
		}


		$this->aAttributeTemplate = $v;
	}


	
	public function getAttributeTemplate($con = null)
	{
		if ($this->aAttributeTemplate === null && ($this->attribute_template_id !== null)) {
						$this->aAttributeTemplate = AttributeTemplatePeer::retrieveByPK($this->attribute_template_id, $con);

			
		}
		return $this->aAttributeTemplate;
	}

	
	public function initDeliverySectionss()
	{
		if ($this->collDeliverySectionss === null) {
			$this->collDeliverySectionss = array();
		}
	}

	
	public function getDeliverySectionss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverySectionss === null) {
			if ($this->isNew()) {
			   $this->collDeliverySectionss = array();
			} else {

				$criteria->add(DeliverySectionsPeer::ATTRIBUTE_FIELD_ID, $this->getId());

				DeliverySectionsPeer::addSelectColumns($criteria);
				$this->collDeliverySectionss = DeliverySectionsPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DeliverySectionsPeer::ATTRIBUTE_FIELD_ID, $this->getId());

				DeliverySectionsPeer::addSelectColumns($criteria);
				if (!isset($this->lastDeliverySectionsCriteria) || !$this->lastDeliverySectionsCriteria->equals($criteria)) {
					$this->collDeliverySectionss = DeliverySectionsPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDeliverySectionsCriteria = $criteria;
		return $this->collDeliverySectionss;
	}

	
	public function countDeliverySectionss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DeliverySectionsPeer::ATTRIBUTE_FIELD_ID, $this->getId());

		return DeliverySectionsPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDeliverySections(DeliverySections $l)
	{
		$this->collDeliverySectionss[] = $l;
		$l->setAttributeField($this);
	}


	
	public function getDeliverySectionssJoinDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverySectionss === null) {
			if ($this->isNew()) {
				$this->collDeliverySectionss = array();
			} else {

				$criteria->add(DeliverySectionsPeer::ATTRIBUTE_FIELD_ID, $this->getId());

				$this->collDeliverySectionss = DeliverySectionsPeer::doSelectJoinDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(DeliverySectionsPeer::ATTRIBUTE_FIELD_ID, $this->getId());

			if (!isset($this->lastDeliverySectionsCriteria) || !$this->lastDeliverySectionsCriteria->equals($criteria)) {
				$this->collDeliverySectionss = DeliverySectionsPeer::doSelectJoinDelivery($criteria, $con);
			}
		}
		$this->lastDeliverySectionsCriteria = $criteria;

		return $this->collDeliverySectionss;
	}

	
	public function initProductHasAttributeFields()
	{
		if ($this->collProductHasAttributeFields === null) {
			$this->collProductHasAttributeFields = array();
		}
	}

	
	public function getProductHasAttributeFields($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttributeFields === null) {
			if ($this->isNew()) {
			   $this->collProductHasAttributeFields = array();
			} else {

				$criteria->add(ProductHasAttributeFieldPeer::ATTRIBUTE_FIELD_ID, $this->getId());

				ProductHasAttributeFieldPeer::addSelectColumns($criteria);
				$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductHasAttributeFieldPeer::ATTRIBUTE_FIELD_ID, $this->getId());

				ProductHasAttributeFieldPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductHasAttributeFieldCriteria) || !$this->lastProductHasAttributeFieldCriteria->equals($criteria)) {
					$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductHasAttributeFieldCriteria = $criteria;
		return $this->collProductHasAttributeFields;
	}

	
	public function countProductHasAttributeFields($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductHasAttributeFieldPeer::ATTRIBUTE_FIELD_ID, $this->getId());

		return ProductHasAttributeFieldPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProductHasAttributeField(ProductHasAttributeField $l)
	{
		$this->collProductHasAttributeFields[] = $l;
		$l->setAttributeField($this);
	}


	
	public function getProductHasAttributeFieldsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProductHasAttributeFields === null) {
			if ($this->isNew()) {
				$this->collProductHasAttributeFields = array();
			} else {

				$criteria->add(ProductHasAttributeFieldPeer::ATTRIBUTE_FIELD_ID, $this->getId());

				$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductHasAttributeFieldPeer::ATTRIBUTE_FIELD_ID, $this->getId());

			if (!isset($this->lastProductHasAttributeFieldCriteria) || !$this->lastProductHasAttributeFieldCriteria->equals($criteria)) {
				$this->collProductHasAttributeFields = ProductHasAttributeFieldPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastProductHasAttributeFieldCriteria = $criteria;

		return $this->collProductHasAttributeFields;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'AttributeField.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseAttributeField:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseAttributeField::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 