<?php
/**
 * SOTESHOP/stAvailabilityPlugin
 *
 * Ten plik należy do aplikacji stAvailabilityPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stAvailabilityPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: AvailabilityPeer.php 617 2009-04-09 13:02:31Z michal $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl> 
 */

/**
 * Klasa AvailabilityPeer
 *
 * @package     stAvailabilityPlugin
 * @subpackage  libs
 */
class AvailabilityPeer extends BaseAvailabilityPeer
{
	public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
	{
		if ($culture === null)
		{
			$culture = stLanguage::getHydrateCulture();
		}

		if ($c->getDbName() == Propel::getDefaultDB())
		{
			$c->setDbName(self::DATABASE_NAME);
		}

		AvailabilityPeer::addSelectColumns($c);

		$startcol = (AvailabilityPeer::NUM_COLUMNS - AvailabilityPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		AvailabilityI18nPeer::addSelectColumns($c);

		$c->addJoin(AvailabilityPeer::ID, sprintf("%s AND %s = '%s'", AvailabilityI18nPeer::ID, AvailabilityI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);

		$results = array();

		while($rs->next())
		{

			$omClass = AvailabilityPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
			$obj1->setCulture($culture);

			$omClass = AvailabilityI18nPeer::getOMClass($rs, $startcol);

			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol);

			$obj1->setAvailabilityI18nForCulture($obj2, $culture);
			$obj2->setAvailability($obj1);

			$results[] = $obj1;
		}
		return $results;
	}

	public static function doCountWithI18n(Criteria $c, $con = null)
	{
		$c->addJoin(AvailabilityI18nPeer::ID, AvailabilityPeer::ID);

		$c->add(AvailabilityI18nPeer::CULTURE, stLanguage::getHydrateCulture());

		return self::doCount($c, $con);
	}
	
	public static function getProductAvailability($product)
	{
		$avail = $product->getAvailability();
		if (is_object($avail)) return $avail->getOptAvailabilityName();
		return '';
	}
	
	public static function setProductAvailability($product, $value)
	{
		$value = trim($value);
		if (!empty($value))
		{
			$c = new Criteria();
			$c->add(AvailabilityPeer::OPT_AVAILABILITY_NAME, $value);
			$avail = AvailabilityPeer::doSelectOne($c);
			
			if (is_object($avail)) $product->setAvailabilityId($avail->getId());
		}
	}	
}