<?php


abstract class BaseAvailability extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_asset_id;


	
	protected $stock_from;


	
	protected $is_system_default;


	
	protected $opt_availability_name;


	
	protected $color;


	
	protected $image;

	
	protected $asfAsset;

	
	protected $collAvailabilityI18ns;

	
	protected $lastAvailabilityI18nCriteria = null;

	
	protected $collProducts;

	
	protected $lastProductCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfAssetId()
    {

            return $this->sf_asset_id;
    }

    
    public function getStockFrom()
    {

            return null !== $this->stock_from ? (string)$this->stock_from : null;
    }

    
    public function getIsSystemDefault()
    {

            return $this->is_system_default;
    }

    
    public function getOptAvailabilityName()
    {

            return $this->opt_availability_name;
    }

    
    public function getColor()
    {

            return $this->color;
    }

    
    public function getImage()
    {

            return $this->image;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = AvailabilityPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = AvailabilityPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = AvailabilityPeer::ID;
        }

	} 
	
	public function setSfAssetId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_asset_id !== $v) {
          $this->sf_asset_id = $v;
          $this->modifiedColumns[] = AvailabilityPeer::SF_ASSET_ID;
        }

		if ($this->asfAsset !== null && $this->asfAsset->getId() !== $v) {
			$this->asfAsset = null;
		}

	} 
	
	public function setStockFrom($v)
	{

        if ($this->stock_from !== $v) {
          $this->stock_from = $v;
          $this->modifiedColumns[] = AvailabilityPeer::STOCK_FROM;
        }

	} 
	
	public function setIsSystemDefault($v)
	{

        if ($this->is_system_default !== $v) {
          $this->is_system_default = $v;
          $this->modifiedColumns[] = AvailabilityPeer::IS_SYSTEM_DEFAULT;
        }

	} 
	
	public function setOptAvailabilityName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_availability_name !== $v) {
          $this->opt_availability_name = $v;
          $this->modifiedColumns[] = AvailabilityPeer::OPT_AVAILABILITY_NAME;
        }

	} 
	
	public function setColor($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->color !== $v) {
          $this->color = $v;
          $this->modifiedColumns[] = AvailabilityPeer::COLOR;
        }

	} 
	
	public function setImage($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->image !== $v) {
          $this->image = $v;
          $this->modifiedColumns[] = AvailabilityPeer::IMAGE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Availability.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_asset_id = $rs->getInt($startcol + 3);

      $this->stock_from = $rs->getString($startcol + 4, null);

      $this->stock_from = $rs->getFloat($startcol + 4);

      $this->is_system_default = $rs->getBoolean($startcol + 5);

      $this->opt_availability_name = $rs->getString($startcol + 6);

      $this->color = $rs->getString($startcol + 7);

      $this->image = $rs->getString($startcol + 8);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Availability.postHydrate', array('resultset' => $rs, 'startcol' => 9)));

            return $startcol + 9; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Availability object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseAvailability:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AvailabilityPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			AvailabilityPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseAvailability:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Availability.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseAvailability:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(AvailabilityPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(AvailabilityPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(AvailabilityPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Availability.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseAvailability:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfAsset !== null) {
				if ($this->asfAsset->isModified()) {
					$affectedRows += $this->asfAsset->save($con);
				}
				$this->setsfAsset($this->asfAsset);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = AvailabilityPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += AvailabilityPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collAvailabilityI18ns !== null) {
				foreach($this->collAvailabilityI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProducts !== null) {
				foreach($this->collProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfAsset !== null) {
				if (!$this->asfAsset->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfAsset->getValidationFailures());
				}
			}


			if (($retval = AvailabilityPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collAvailabilityI18ns !== null) {
					foreach($this->collAvailabilityI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProducts !== null) {
					foreach($this->collProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AvailabilityPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfAssetId();
				break;
			case 4:
				return $this->getStockFrom();
				break;
			case 5:
				return $this->getIsSystemDefault();
				break;
			case 6:
				return $this->getOptAvailabilityName();
				break;
			case 7:
				return $this->getColor();
				break;
			case 8:
				return $this->getImage();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AvailabilityPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfAssetId(),
			$keys[4] => $this->getStockFrom(),
			$keys[5] => $this->getIsSystemDefault(),
			$keys[6] => $this->getOptAvailabilityName(),
			$keys[7] => $this->getColor(),
			$keys[8] => $this->getImage(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = AvailabilityPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfAssetId($value);
				break;
			case 4:
				$this->setStockFrom($value);
				break;
			case 5:
				$this->setIsSystemDefault($value);
				break;
			case 6:
				$this->setOptAvailabilityName($value);
				break;
			case 7:
				$this->setColor($value);
				break;
			case 8:
				$this->setImage($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = AvailabilityPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfAssetId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setStockFrom($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setIsSystemDefault($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptAvailabilityName($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setColor($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setImage($arr[$keys[8]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(AvailabilityPeer::DATABASE_NAME);

		if ($this->isColumnModified(AvailabilityPeer::CREATED_AT)) $criteria->add(AvailabilityPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(AvailabilityPeer::UPDATED_AT)) $criteria->add(AvailabilityPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(AvailabilityPeer::ID)) $criteria->add(AvailabilityPeer::ID, $this->id);
		if ($this->isColumnModified(AvailabilityPeer::SF_ASSET_ID)) $criteria->add(AvailabilityPeer::SF_ASSET_ID, $this->sf_asset_id);
		if ($this->isColumnModified(AvailabilityPeer::STOCK_FROM)) $criteria->add(AvailabilityPeer::STOCK_FROM, $this->stock_from);
		if ($this->isColumnModified(AvailabilityPeer::IS_SYSTEM_DEFAULT)) $criteria->add(AvailabilityPeer::IS_SYSTEM_DEFAULT, $this->is_system_default);
		if ($this->isColumnModified(AvailabilityPeer::OPT_AVAILABILITY_NAME)) $criteria->add(AvailabilityPeer::OPT_AVAILABILITY_NAME, $this->opt_availability_name);
		if ($this->isColumnModified(AvailabilityPeer::COLOR)) $criteria->add(AvailabilityPeer::COLOR, $this->color);
		if ($this->isColumnModified(AvailabilityPeer::IMAGE)) $criteria->add(AvailabilityPeer::IMAGE, $this->image);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(AvailabilityPeer::DATABASE_NAME);

		$criteria->add(AvailabilityPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfAssetId($this->sf_asset_id);

		$copyObj->setStockFrom($this->stock_from);

		$copyObj->setIsSystemDefault($this->is_system_default);

		$copyObj->setOptAvailabilityName($this->opt_availability_name);

		$copyObj->setColor($this->color);

		$copyObj->setImage($this->image);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getAvailabilityI18ns() as $relObj) {
				$copyObj->addAvailabilityI18n($relObj->copy($deepCopy));
			}

			foreach($this->getProducts() as $relObj) {
				$copyObj->addProduct($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new AvailabilityPeer();
		}
		return self::$peer;
	}

	
	public function setsfAsset($v)
	{


		if ($v === null) {
			$this->setSfAssetId(NULL);
		} else {
			$this->setSfAssetId($v->getId());
		}


		$this->asfAsset = $v;
	}


	
	public function getsfAsset($con = null)
	{
		if ($this->asfAsset === null && ($this->sf_asset_id !== null)) {
						$this->asfAsset = sfAssetPeer::retrieveByPK($this->sf_asset_id, $con);

			
		}
		return $this->asfAsset;
	}

	
	public function initAvailabilityI18ns()
	{
		if ($this->collAvailabilityI18ns === null) {
			$this->collAvailabilityI18ns = array();
		}
	}

	
	public function getAvailabilityI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collAvailabilityI18ns === null) {
			if ($this->isNew()) {
			   $this->collAvailabilityI18ns = array();
			} else {

				$criteria->add(AvailabilityI18nPeer::ID, $this->getId());

				AvailabilityI18nPeer::addSelectColumns($criteria);
				$this->collAvailabilityI18ns = AvailabilityI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(AvailabilityI18nPeer::ID, $this->getId());

				AvailabilityI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastAvailabilityI18nCriteria) || !$this->lastAvailabilityI18nCriteria->equals($criteria)) {
					$this->collAvailabilityI18ns = AvailabilityI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastAvailabilityI18nCriteria = $criteria;
		return $this->collAvailabilityI18ns;
	}

	
	public function countAvailabilityI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(AvailabilityI18nPeer::ID, $this->getId());

		return AvailabilityI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addAvailabilityI18n(AvailabilityI18n $l)
	{
		$this->collAvailabilityI18ns[] = $l;
		$l->setAvailability($this);
	}

	
	public function initProducts()
	{
		if ($this->collProducts === null) {
			$this->collProducts = array();
		}
	}

	
	public function getProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
			   $this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				$this->collProducts = ProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
					$this->collProducts = ProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductCriteria = $criteria;
		return $this->collProducts;
	}

	
	public function countProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

		return ProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProduct(Product $l)
	{
		$this->collProducts[] = $l;
		$l->setAvailability($this);
	}


	
	public function getProductsJoinProductRelatedByParentId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinCurrency($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinProducer($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::AVAILABILITY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getAvailabilityName()
  {
    $obj = $this->getCurrentAvailabilityI18n();

    return ($obj ? $obj->getAvailabilityName() : null);
  }

  public function setAvailabilityName($value)
  {
    $this->getCurrentAvailabilityI18n()->setAvailabilityName($value);
  }

  protected $current_i18n = array();

  public function getCurrentAvailabilityI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = AvailabilityI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setAvailabilityI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setAvailabilityI18nForCulture(new AvailabilityI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setAvailabilityI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addAvailabilityI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Availability.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseAvailability:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseAvailability::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 