<?php

/**
 * Subclass for performing query and update operations on the 'st_box' table.
 *
 * 
 *
 * @package plugins.stBoxPlugin.lib.model
 */ 
class BoxPeer extends BaseBoxPeer
{
     /**
     * Przeciążenie metody pobierającej strony www w odpowiedniej wersji jezykowej
     *
     * @param Criteria $c Kryteria
     * @param mixed $culture Wersja językowa
     * @param CreoleConnection $con Połączenie z bazą danych
     * @return array Produkty
     */
    public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
    {
        if ($culture === null)
        {
            $culture = stLanguage::getHydrateCulture();
        }

        if ($c->getDbName() == Propel::getDefaultDB())
        {
            $c->setDbName(self::DATABASE_NAME);
        }

        BoxPeer::addSelectColumns($c);

        $startcol = (BoxPeer::NUM_COLUMNS - BoxPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

        BoxI18nPeer::addSelectColumns($c);

        $c->addJoin(BoxPeer::ID, sprintf("%s AND %s = '%s'", BoxI18nPeer::ID, BoxI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

        $rs = BasePeer::doSelect($c, $con);

        $results = array();

        while($rs->next())
        {

            $omClass = BoxPeer::getOMClass();

            $cls = Propel::import($omClass);
            $obj1 = new $cls();
            $obj1->hydrate($rs);
            $obj1->setCulture($culture);

            $omClass = BoxI18nPeer::getOMClass($rs, $startcol);

            $cls = Propel::import($omClass);
            $obj2 = new $cls();
            $obj2->hydrate($rs, $startcol);

            $obj1->setBoxI18nForCulture($obj2, $culture);
            $obj2->setBox($obj1);

            $results[] = $obj1;
        }
        return $results;
    }


    public static function doCountWithI18n(Criteria $c, $con = null)
    {
        $c->addJoin(BoxI18nPeer::ID, BoxPeer::ID);

        $c->add(BoxI18nPeer::CULTURE, stLanguage::getHydrateCulture());

        return self::doCount($c, $con);
    }
}
