<?php


abstract class BaseBox extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $box_group_id;


	
	protected $active;


	
	protected $opt_name;


	
	protected $opt_content;


	
	protected $show_title;


	
	protected $webmaster_id;

	
	protected $aBoxGroup;

	
	protected $collBoxI18ns;

	
	protected $lastBoxI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getBoxGroupId()
    {

            return $this->box_group_id;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptContent()
    {

            return $this->opt_content;
    }

    
    public function getShowTitle()
    {

            return $this->show_title;
    }

    
    public function getWebmasterId()
    {

            return $this->webmaster_id;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = BoxPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = BoxPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = BoxPeer::ID;
        }

	} 
	
	public function setBoxGroupId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->box_group_id !== $v) {
          $this->box_group_id = $v;
          $this->modifiedColumns[] = BoxPeer::BOX_GROUP_ID;
        }

		if ($this->aBoxGroup !== null && $this->aBoxGroup->getId() !== $v) {
			$this->aBoxGroup = null;
		}

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v) {
          $this->active = $v;
          $this->modifiedColumns[] = BoxPeer::ACTIVE;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = BoxPeer::OPT_NAME;
        }

	} 
	
	public function setOptContent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_content !== $v) {
          $this->opt_content = $v;
          $this->modifiedColumns[] = BoxPeer::OPT_CONTENT;
        }

	} 
	
	public function setShowTitle($v)
	{

        if ($this->show_title !== $v) {
          $this->show_title = $v;
          $this->modifiedColumns[] = BoxPeer::SHOW_TITLE;
        }

	} 
	
	public function setWebmasterId($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->webmaster_id !== $v) {
          $this->webmaster_id = $v;
          $this->modifiedColumns[] = BoxPeer::WEBMASTER_ID;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Box.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->box_group_id = $rs->getInt($startcol + 3);

      $this->active = $rs->getBoolean($startcol + 4);

      $this->opt_name = $rs->getString($startcol + 5);

      $this->opt_content = $rs->getString($startcol + 6);

      $this->show_title = $rs->getBoolean($startcol + 7);

      $this->webmaster_id = $rs->getString($startcol + 8);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Box.postHydrate', array('resultset' => $rs, 'startcol' => 9)));

            return $startcol + 9; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Box object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseBox:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BoxPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			BoxPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseBox:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Box.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseBox:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(BoxPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(BoxPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BoxPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Box.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseBox:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aBoxGroup !== null) {
				if ($this->aBoxGroup->isModified() || $this->aBoxGroup->getCurrentBoxGroupI18n()->isModified()) {
					$affectedRows += $this->aBoxGroup->save($con);
				}
				$this->setBoxGroup($this->aBoxGroup);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = BoxPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += BoxPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collBoxI18ns !== null) {
				foreach($this->collBoxI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aBoxGroup !== null) {
				if (!$this->aBoxGroup->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aBoxGroup->getValidationFailures());
				}
			}


			if (($retval = BoxPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collBoxI18ns !== null) {
					foreach($this->collBoxI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BoxPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getBoxGroupId();
				break;
			case 4:
				return $this->getActive();
				break;
			case 5:
				return $this->getOptName();
				break;
			case 6:
				return $this->getOptContent();
				break;
			case 7:
				return $this->getShowTitle();
				break;
			case 8:
				return $this->getWebmasterId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BoxPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getBoxGroupId(),
			$keys[4] => $this->getActive(),
			$keys[5] => $this->getOptName(),
			$keys[6] => $this->getOptContent(),
			$keys[7] => $this->getShowTitle(),
			$keys[8] => $this->getWebmasterId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BoxPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setBoxGroupId($value);
				break;
			case 4:
				$this->setActive($value);
				break;
			case 5:
				$this->setOptName($value);
				break;
			case 6:
				$this->setOptContent($value);
				break;
			case 7:
				$this->setShowTitle($value);
				break;
			case 8:
				$this->setWebmasterId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BoxPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setBoxGroupId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setActive($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setOptName($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setOptContent($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setShowTitle($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setWebmasterId($arr[$keys[8]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(BoxPeer::DATABASE_NAME);

		if ($this->isColumnModified(BoxPeer::CREATED_AT)) $criteria->add(BoxPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(BoxPeer::UPDATED_AT)) $criteria->add(BoxPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(BoxPeer::ID)) $criteria->add(BoxPeer::ID, $this->id);
		if ($this->isColumnModified(BoxPeer::BOX_GROUP_ID)) $criteria->add(BoxPeer::BOX_GROUP_ID, $this->box_group_id);
		if ($this->isColumnModified(BoxPeer::ACTIVE)) $criteria->add(BoxPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(BoxPeer::OPT_NAME)) $criteria->add(BoxPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(BoxPeer::OPT_CONTENT)) $criteria->add(BoxPeer::OPT_CONTENT, $this->opt_content);
		if ($this->isColumnModified(BoxPeer::SHOW_TITLE)) $criteria->add(BoxPeer::SHOW_TITLE, $this->show_title);
		if ($this->isColumnModified(BoxPeer::WEBMASTER_ID)) $criteria->add(BoxPeer::WEBMASTER_ID, $this->webmaster_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(BoxPeer::DATABASE_NAME);

		$criteria->add(BoxPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setBoxGroupId($this->box_group_id);

		$copyObj->setActive($this->active);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptContent($this->opt_content);

		$copyObj->setShowTitle($this->show_title);

		$copyObj->setWebmasterId($this->webmaster_id);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getBoxI18ns() as $relObj) {
				$copyObj->addBoxI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new BoxPeer();
		}
		return self::$peer;
	}

	
	public function setBoxGroup($v)
	{


		if ($v === null) {
			$this->setBoxGroupId(NULL);
		} else {
			$this->setBoxGroupId($v->getId());
		}


		$this->aBoxGroup = $v;
	}


	
	public function getBoxGroup($con = null)
	{
		if ($this->aBoxGroup === null && ($this->box_group_id !== null)) {
						$this->aBoxGroup = BoxGroupPeer::retrieveByPK($this->box_group_id, $con);

			
		}
		return $this->aBoxGroup;
	}

	
	public function initBoxI18ns()
	{
		if ($this->collBoxI18ns === null) {
			$this->collBoxI18ns = array();
		}
	}

	
	public function getBoxI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBoxI18ns === null) {
			if ($this->isNew()) {
			   $this->collBoxI18ns = array();
			} else {

				$criteria->add(BoxI18nPeer::ID, $this->getId());

				BoxI18nPeer::addSelectColumns($criteria);
				$this->collBoxI18ns = BoxI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(BoxI18nPeer::ID, $this->getId());

				BoxI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastBoxI18nCriteria) || !$this->lastBoxI18nCriteria->equals($criteria)) {
					$this->collBoxI18ns = BoxI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBoxI18nCriteria = $criteria;
		return $this->collBoxI18ns;
	}

	
	public function countBoxI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(BoxI18nPeer::ID, $this->getId());

		return BoxI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addBoxI18n(BoxI18n $l)
	{
		$this->collBoxI18ns[] = $l;
		$l->setBox($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentBoxI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentBoxI18n()->setName($value);
  }

  public function getContent()
  {
    $obj = $this->getCurrentBoxI18n();

    return ($obj ? $obj->getContent() : null);
  }

  public function setContent($value)
  {
    $this->getCurrentBoxI18n()->setContent($value);
  }

  protected $current_i18n = array();

  public function getCurrentBoxI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = BoxI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setBoxI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setBoxI18nForCulture(new BoxI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setBoxI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addBoxI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Box.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseBox:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseBox::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 