<?php


abstract class BaseBoxGroup extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $opt_name;


	
	protected $box_group;

	
	protected $collBoxs;

	
	protected $lastBoxCriteria = null;

	
	protected $collBoxGroupI18ns;

	
	protected $lastBoxGroupI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getBoxGroup()
    {

            return $this->box_group;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = BoxGroupPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = BoxGroupPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = BoxGroupPeer::ID;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = BoxGroupPeer::OPT_NAME;
        }

	} 
	
	public function setBoxGroup($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->box_group !== $v) {
          $this->box_group = $v;
          $this->modifiedColumns[] = BoxGroupPeer::BOX_GROUP;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'BoxGroup.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->opt_name = $rs->getString($startcol + 3);

      $this->box_group = $rs->getString($startcol + 4);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'BoxGroup.postHydrate', array('resultset' => $rs, 'startcol' => 5)));

            return $startcol + 5; 
    } catch (Exception $e) {
      throw new PropelException("Error populating BoxGroup object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseBoxGroup:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BoxGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			BoxGroupPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseBoxGroup:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'BoxGroup.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseBoxGroup:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(BoxGroupPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(BoxGroupPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(BoxGroupPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'BoxGroup.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseBoxGroup:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = BoxGroupPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += BoxGroupPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collBoxs !== null) {
				foreach($this->collBoxs as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collBoxGroupI18ns !== null) {
				foreach($this->collBoxGroupI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = BoxGroupPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collBoxs !== null) {
					foreach($this->collBoxs as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collBoxGroupI18ns !== null) {
					foreach($this->collBoxGroupI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BoxGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getOptName();
				break;
			case 4:
				return $this->getBoxGroup();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BoxGroupPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getOptName(),
			$keys[4] => $this->getBoxGroup(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = BoxGroupPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setOptName($value);
				break;
			case 4:
				$this->setBoxGroup($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = BoxGroupPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setOptName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setBoxGroup($arr[$keys[4]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(BoxGroupPeer::DATABASE_NAME);

		if ($this->isColumnModified(BoxGroupPeer::CREATED_AT)) $criteria->add(BoxGroupPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(BoxGroupPeer::UPDATED_AT)) $criteria->add(BoxGroupPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(BoxGroupPeer::ID)) $criteria->add(BoxGroupPeer::ID, $this->id);
		if ($this->isColumnModified(BoxGroupPeer::OPT_NAME)) $criteria->add(BoxGroupPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(BoxGroupPeer::BOX_GROUP)) $criteria->add(BoxGroupPeer::BOX_GROUP, $this->box_group);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(BoxGroupPeer::DATABASE_NAME);

		$criteria->add(BoxGroupPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setBoxGroup($this->box_group);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getBoxs() as $relObj) {
				$copyObj->addBox($relObj->copy($deepCopy));
			}

			foreach($this->getBoxGroupI18ns() as $relObj) {
				$copyObj->addBoxGroupI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new BoxGroupPeer();
		}
		return self::$peer;
	}

	
	public function initBoxs()
	{
		if ($this->collBoxs === null) {
			$this->collBoxs = array();
		}
	}

	
	public function getBoxs($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBoxs === null) {
			if ($this->isNew()) {
			   $this->collBoxs = array();
			} else {

				$criteria->add(BoxPeer::BOX_GROUP_ID, $this->getId());

				BoxPeer::addSelectColumns($criteria);
				$this->collBoxs = BoxPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(BoxPeer::BOX_GROUP_ID, $this->getId());

				BoxPeer::addSelectColumns($criteria);
				if (!isset($this->lastBoxCriteria) || !$this->lastBoxCriteria->equals($criteria)) {
					$this->collBoxs = BoxPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBoxCriteria = $criteria;
		return $this->collBoxs;
	}

	
	public function countBoxs($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(BoxPeer::BOX_GROUP_ID, $this->getId());

		return BoxPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addBox(Box $l)
	{
		$this->collBoxs[] = $l;
		$l->setBoxGroup($this);
	}

	
	public function initBoxGroupI18ns()
	{
		if ($this->collBoxGroupI18ns === null) {
			$this->collBoxGroupI18ns = array();
		}
	}

	
	public function getBoxGroupI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBoxGroupI18ns === null) {
			if ($this->isNew()) {
			   $this->collBoxGroupI18ns = array();
			} else {

				$criteria->add(BoxGroupI18nPeer::ID, $this->getId());

				BoxGroupI18nPeer::addSelectColumns($criteria);
				$this->collBoxGroupI18ns = BoxGroupI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(BoxGroupI18nPeer::ID, $this->getId());

				BoxGroupI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastBoxGroupI18nCriteria) || !$this->lastBoxGroupI18nCriteria->equals($criteria)) {
					$this->collBoxGroupI18ns = BoxGroupI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBoxGroupI18nCriteria = $criteria;
		return $this->collBoxGroupI18ns;
	}

	
	public function countBoxGroupI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(BoxGroupI18nPeer::ID, $this->getId());

		return BoxGroupI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addBoxGroupI18n(BoxGroupI18n $l)
	{
		$this->collBoxGroupI18ns[] = $l;
		$l->setBoxGroup($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentBoxGroupI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentBoxGroupI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentBoxGroupI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = BoxGroupI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setBoxGroupI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setBoxGroupI18nForCulture(new BoxGroupI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setBoxGroupI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addBoxGroupI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'BoxGroup.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseBoxGroup:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseBoxGroup::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 