<?php

class stCategoryTreeComponents extends sfComponents
{

   public function __toString()
   {
      return get_class($this);
   }

   public function executeShow()
   {
      $this->smarty = new stSmarty('stCategoryTree');

      $this->config = stConfig::getInstance($this->getContext(), 'stCategory');

      if ($this->getUser()->hasParameter('selected', 'soteshop/stCategory'))
      {
         $selected = $this->getUser()->getParameter('selected', null, 'soteshop/stCategory');

         CategoryPeer::setHydrateMethod(array($this, 'hydrateSelected'));

         $path = $selected->getPath();

         $path[$selected->getId()] = $selected->getId();
         
         $this->expanded = $path;
      }
      else
      {
         $this->expanded = array();
      }

      $c = new Criteria();

      $c->addAsColumn('ID', CategoryPeer::ID);

      $c->addAscendingOrderByColumn(CategoryPeer::SCOPE);

      CategoryPeer::setHydrateMethod(array($this, 'hydrateCategories'));

      $fc = new stFunctionCache('stCategoryTree');

      $this->roots = $fc->cacheCall(array($this, 'getCategories'), array(array('producer_id' => stProducer::getSelectedProducerId()), $this->getUser()->getCulture()));

      CategoryPeer::setHydrateMethod(null);

      if (!$this->roots)
      {
         return sfView::NONE;
      }
   }

   public function executeTree()
   {
      $producer_id = stProducer::getSelectedProducerId();

      $config = stConfig::getInstance($this->getContext(), 'stCategory');

      $fc = new stFunctionCache('stCategoryTree');

      $categories = $fc->cacheCall(array($this, 'getCategories'), array(array('scope' => $this->parent['scope'], 'producer_id' => $producer_id), $this->getUser()->getCulture()));

      $this->categories = new stCategoryTreeIterator($categories, $this->expanded);

      $this->show_product_count = $config->get('show_product_count');
   }

   public function executeHorizontalTree()
   {
      sfLoader::loadHelpers(array('Helper', 'Url', 'stUrl'));

      $c = new Criteria();

      $c->add(CategoryPeer::PARENT_ID, null, Criteria::ISNULL);

      $roots = CategoryPeer::doSelect($c);

      if (!$roots)
      {
         return sfView::NONE;
      }

      $results = array();

      foreach ($roots as $root)
      {
         $c = new Criteria();

         $c->add(CategoryPeer::PARENT_ID, $root->getId());

         $categories = array();

         $children = ProductHasCategoryPeer::doSelectCategories($c);

         if ($children)
         {
            foreach ($children as $child)
            {
               $categories[] = array('name' => $child->getName(), 'url' => st_url_for('stProduct/list?url=' . $child->getFriendlyUrl()), 'instance' => $child);
            }

            $results[] = array('name' => $root->getName(), 'categories' => $categories, 'instance' => $root);
         }
      }

      $this->results = $results;

      $this->smarty = new stSmarty('stCategoryTree');
   }

   public function executeAjaxTree()
   {
      $config = stConfig::getInstance(sfContext::getInstance(), 'stCategory');

      $expand_always = !$this->expanded && $config->get('expand_root') != -1 || $this->expanded && $config->get('expand_always');

      $this->smarty = new stSmarty('stCategoryTree');

      $this->smarty->register_function('render_ajax_categories', array($this, 'smartyRenderAjaxCategories'));

      $this->smarty->register_function('jquery_tree_init', array($this, 'smartyJQueryTreeInit'));

      $this->smarty->assign('roots', $this->roots);
      
      if ($this->getUser()->hasParameter('selected', 'soteshop/stCategory'))
      {
         $this->smarty->assign('selected', $this->expanded ? end($this->expanded) : null);
      }      

      $this->smarty->assign('expand_always', $expand_always);

      $this->smarty->assign('expanded', $this->expanded);

      $this->smarty->assign('show_roots', !$config->get('hide_root'));

      $this->smarty->assign('show_product_count', $config->get('show_product_count'));
   }

   public function executeAjaxCategories()
   {
      $producer_id = stProducer::getSelectedProducerId();

      $config = stConfig::getInstance(sfContext::getInstance(), 'stCategory');

      $fc = new stFunctionCache('stCategoryTree');

      $categories = $fc->cacheCall(array($this, 'getCategories'), array(array('scope' => $this->parent['scope'], 'parent_id' => $this->parent['id'], 'producer_id' => $producer_id), $this->getUser()->getCulture()));

      if (!$categories)
      {
         return sfView::NONE;
      }

      $this->smarty = new stSmarty('stCategoryTree');

      $this->smarty->assign('categories', $categories);

      if ($this->getUser()->hasParameter('selected', 'soteshop/stCategory'))
      {
         $this->smarty->assign('selected', $this->expanded ? end($this->expanded) : null);
      }

      $this->smarty->assign('unique_id', !$this->parent['is_root'] || $config->get('hide_root') ? $this->parent['id'] : null);

      $this->smarty->assign('expanded', $this->expanded);

      $this->smarty->assign('show_product_count', $config->get('show_product_count'));

      $this->smarty->assign('include_root_class', $config->get('hide_root') && $this->parent['is_root']);

      $this->smarty->register_function('render_ajax_categories', array($this, 'smartyRenderAjaxCategories'));
   }

   public function smartyRenderAjaxCategories($params)
   {
      return st_get_component('stCategoryTree', 'ajaxCategories', array('parent' => $params['for'], 'expanded' => $this->expanded));
   }

   public function smartyJQueryTreeInit($params)
   {
      sfLoader::loadHelpers(array('stJQueryTree'), 'stCategoryTree');

      return st_jquery_tree_init($params['for']['id'], array('url' => array('module' => 'stCategoryTree', 'action' => 'ajaxCategories')));
   }

   public function getCategories($params = array())
   {
      $product_config = stConfig::getInstance(null, 'stProduct');
      
      $c = new Criteria();

      $c->addAlias('node', CategoryPeer::TABLE_NAME);

      $where = '';

      if (isset($params['producer_id']))
      {
         $where .= ' AND p.PRODUCER_ID = ' . $params['producer_id'];
      }

      if ($product_config->get('show_without_price'))
      {
         $where .= ' AND p.PRICE > 0';
      }
      
      $c->addAsColumn('cnt', sprintf('SUM((SELECT count(p.id) FROM %s p, %s phc WHERE phc.CATEGORY_ID = node.id AND phc.PRODUCT_ID = p.id AND p.ACTIVE = 1' . $where . '))', ProductPeer::TABLE_NAME, ProductHasCategoryPeer::TABLE_NAME));

      $c->addAsColumn('category_count', 'COUNT(node.id)');

      $c->addJoin(CategoryPeer::LFT, sprintf('%s BETWEEN %s AND %s AND %s = %s AND node.IS_ACTIVE = 1', CategoryPeer::alias('node', CategoryPeer::LFT), CategoryPeer::LFT, CategoryPeer::RGT, CategoryPeer::alias('node', CategoryPeer::SCOPE), isset($params['scope']) ? $params['scope'] : CategoryPeer::SCOPE), Criteria::CUSTOM | Criteria::STRAIGHT_JOIN);

      $c->add(CategoryPeer::IS_ACTIVE, true);
      
      $c->add(CategoryPeer::IS_HIDDEN, false);

      $c->addGroupByColumn(CategoryPeer::ID);

      if (isset($params['parent_id']))
      {
         $c->add(CategoryPeer::PARENT_ID, $params['parent_id']);

         $c->addAscendingOrderByColumn(CategoryPeer::LFT);
      }
      elseif (isset($params['scope']))
      {
         $c->add(CategoryPeer::SCOPE, $params['scope']);

         $c->addAscendingOrderByColumn(CategoryPeer::LFT);
      }
      else
      {
         $c->add(CategoryPeer::PARENT_ID, null, Criteria::ISNULL);

         $c->addAscendingOrderByColumn(CategoryPeer::ROOT_POSITION);
      }

      $c->addAsColumn('ID', CategoryPeer::ID);

      $c->addHaving('cnt > 0');

      CategoryPeer::setHydrateMethod(array($this, 'hydrateCategories'));

      $ret = CategoryPeer::doSelectWithI18n($c);

      CategoryPeer::setHydrateMethod(null);

      return $ret;
   }

   public function hydrateSelected(ResultSet $rs)
   {
      $results = array();

      $rs->setFetchmode(ResultSet::FETCHMODE_ASSOC);

      while ($rs->next())
      {
         $row = $rs->getRow();

         $results[$row['ID']] = $row['ID'];
      }

      return $results;
   }

   public function hydrateCategories(ResultSet $rs)
   {
      $results = array();

      $rs->setFetchmode(ResultSet::FETCHMODE_ASSOC);

      sfLoader::loadHelpers(array('Helper', 'stUrl'));

      while ($rs->next())
      {
         $row = $rs->getRow();

         $has_i18n = $row['CULTURE'];

         $results[] = array(
             'id' => $row['ID'],
             'scope' => $row['SCOPE'],
             'name' => $row['NAME'] ? $row['NAME'] : $row['OPT_NAME'],
             'url' => st_url_for(array('module' => 'stProduct', 'action' => 'list', 'url' => $row['URL'] ? $row['URL'] : $row['OPT_URL'])),
             'image' => $row['OPT_IMAGE'],
             'lft' => $row['LFT'],
             'rgt' => $row['RGT'],
             'depth' => $row['DEPTH'],
             'is_root' => $row['PARENT_ID'] === null,
             'depth' => $row['DEPTH'],
             'has_children' => $row['RGT'] - $row['LFT'] > 1 && $row['category_count'] > 1,
             'product_count' => isset($row['cnt']) ? $row['cnt'] : null);
      }

      return $results;
   }

}
