<?php

/**
 * SOTESHOP/stCountriesPlugin
 *
 * Ten plik należy do aplikacji stCountriesPlugin opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stCountriesPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: CountriesPeer.php 10420 2011-01-21 13:20:27Z michal $
 * @author      Marcin Olejniczak <marcin.olejniczak@sote.pl>
 */

/**
 * Klasa CountriesPeer
 *
 * @package     stCountriesPlugin
 * @subpackage  libs
 */
class CountriesPeer extends BaseCountriesPeer
{

	/**
	 *
	 * Zwraca listę aktywnych krajów
	 *
	 * @param Criteria $c Kryteria
	 * @param CreoleConnection $con Połączenie propel
	 * @return array Of Countries
	 */
	public static function doSelectActive(Criteria $c, $con = null)
	{
		$criteria = clone $c;

		$culture = sfContext::getInstance()->getUser()->getCulture();

		$criteria->addAscendingOrderByColumn('IFNULL('.CountriesI18nPeer::NAME.','.CountriesPeer::OPT_NAME.') COLLATE utf8_unicode_ci');

		$criteria->add(CountriesPeer::IS_ACTIVE, true);

		return self::doSelectWithI18n($criteria, $culture, $con);
	}

	public static function doSelectDefault(Criteria $c, $con = null)
	{
		$criteria = clone $c;

		$criteria->add(self::IS_DEFAULT, true);

		return self::doSelectOne($criteria, $con);
	}

	/**
	 *
	 * Zwraca listę aktywnych krajów
	 *
	 * @param Criteria $c Kryteria
	 * @param CreoleConnection $con Połączenie propel
	 * @return array Of Countries
	 */
	public static function doSelectActiveBackend(Criteria $c, $con = null)
	{
		$criteria = clone $c;

		$criteria->add(CountriesPeer::IS_ACTIVE, true);

		$criteria->addAscendingOrderByColumn(self::OPT_NAME . ' COLLATE utf8_unicode_ci');

		return self::doSelect($criteria, $con);
	}

	public static function doCountActive(Criteria $c, $con = null)
	{
		$criteria = clone $c;

		$criteria->add(CountriesPeer::IS_ACTIVE, true);

		return self::doCount($criteria, false, $con);
	}

	/**
	 * Przeciążenie metody pobierającej kraje w odpowiedniej wersji jezykowej
	 *
	 * @param Criteria $c Kryteria
	 * @param mixed $culture Wersja językowa
	 * @param CreoleConnection $con Połączenie z bazą danych
	 * @return array Produkty
	 */
	public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
	{
		if ($culture === null)
		{
			$culture = stLanguage::getHydrateCulture();
		}

		if ($c->getDbName() == Propel::getDefaultDB())
		{
			$c->setDbName(self::DATABASE_NAME);
		}

		CountriesPeer::addSelectColumns($c);
		$startcol = (CountriesPeer::NUM_COLUMNS - CountriesPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CountriesI18nPeer::addSelectColumns($c);

		$c->addJoin(CountriesPeer::ID, CountriesI18nPeer::ID . ' AND ' . CountriesI18nPeer::CULTURE . ' = \'' . $culture . '\'', Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);

		$results = array();

		while ($rs->next())
		{

			$omClass = CountriesPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
			$obj1->setCulture($culture);

			$omClass = CountriesI18nPeer::getOMClass($rs, $startcol);

			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol);

			$obj1->setCountriesI18nForCulture($obj2, $culture);
			$obj2->setCountries($obj1);

			$results[] = $obj1;
		}

		return $results;
	}

	public static function doCountWithI18n(Criteria $c, $con = null)
	{
		$c->addJoin(CountriesI18nPeer::ID, CountriesPeer::ID);

		$c->add(CountriesI18nPeer::CULTURE, stLanguage::getHydrateCulture());

		return self::doCount($c, $con);
	}
}