<?php


abstract class BaseCountries extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $iso_a2;


	
	protected $iso_a3;


	
	protected $continent;


	
	protected $number;


	
	protected $opt_name;


	
	protected $is_active = false;


	
	protected $is_default = false;

	
	protected $collCountriesAreaHasCountriess;

	
	protected $lastCountriesAreaHasCountriesCriteria = null;

	
	protected $collCountriesI18ns;

	
	protected $lastCountriesI18nCriteria = null;

	
	protected $collOrderUserDataBillings;

	
	protected $lastOrderUserDataBillingCriteria = null;

	
	protected $collOrderUserDataDeliverys;

	
	protected $lastOrderUserDataDeliveryCriteria = null;

	
	protected $collPartners;

	
	protected $lastPartnerCriteria = null;

	
	protected $collUserDatas;

	
	protected $lastUserDataCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getIsoA2()
    {

            return $this->iso_a2;
    }

    
    public function getIsoA3()
    {

            return $this->iso_a3;
    }

    
    public function getContinent()
    {

            return $this->continent;
    }

    
    public function getNumber()
    {

            return $this->number;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getIsActive()
    {

            return $this->is_active;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = CountriesPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = CountriesPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = CountriesPeer::ID;
        }

	} 
	
	public function setIsoA2($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->iso_a2 !== $v) {
          $this->iso_a2 = $v;
          $this->modifiedColumns[] = CountriesPeer::ISO_A2;
        }

	} 
	
	public function setIsoA3($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->iso_a3 !== $v) {
          $this->iso_a3 = $v;
          $this->modifiedColumns[] = CountriesPeer::ISO_A3;
        }

	} 
	
	public function setContinent($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->continent !== $v) {
          $this->continent = $v;
          $this->modifiedColumns[] = CountriesPeer::CONTINENT;
        }

	} 
	
	public function setNumber($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->number !== $v) {
          $this->number = $v;
          $this->modifiedColumns[] = CountriesPeer::NUMBER;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = CountriesPeer::OPT_NAME;
        }

	} 
	
	public function setIsActive($v)
	{

        if ($this->is_active !== $v || $v === false) {
          $this->is_active = $v;
          $this->modifiedColumns[] = CountriesPeer::IS_ACTIVE;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = CountriesPeer::IS_DEFAULT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Countries.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->iso_a2 = $rs->getString($startcol + 3);

      $this->iso_a3 = $rs->getString($startcol + 4);

      $this->continent = $rs->getString($startcol + 5);

      $this->number = $rs->getString($startcol + 6);

      $this->opt_name = $rs->getString($startcol + 7);

      $this->is_active = $rs->getBoolean($startcol + 8);

      $this->is_default = $rs->getBoolean($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Countries.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Countries object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseCountries:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CountriesPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			CountriesPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseCountries:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Countries.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseCountries:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(CountriesPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(CountriesPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CountriesPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Countries.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseCountries:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CountriesPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += CountriesPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collCountriesAreaHasCountriess !== null) {
				foreach($this->collCountriesAreaHasCountriess as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCountriesI18ns !== null) {
				foreach($this->collCountriesI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderUserDataBillings !== null) {
				foreach($this->collOrderUserDataBillings as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderUserDataDeliverys !== null) {
				foreach($this->collOrderUserDataDeliverys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collPartners !== null) {
				foreach($this->collPartners as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collUserDatas !== null) {
				foreach($this->collUserDatas as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = CountriesPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collCountriesAreaHasCountriess !== null) {
					foreach($this->collCountriesAreaHasCountriess as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCountriesI18ns !== null) {
					foreach($this->collCountriesI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderUserDataBillings !== null) {
					foreach($this->collOrderUserDataBillings as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderUserDataDeliverys !== null) {
					foreach($this->collOrderUserDataDeliverys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collPartners !== null) {
					foreach($this->collPartners as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collUserDatas !== null) {
					foreach($this->collUserDatas as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CountriesPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getIsoA2();
				break;
			case 4:
				return $this->getIsoA3();
				break;
			case 5:
				return $this->getContinent();
				break;
			case 6:
				return $this->getNumber();
				break;
			case 7:
				return $this->getOptName();
				break;
			case 8:
				return $this->getIsActive();
				break;
			case 9:
				return $this->getIsDefault();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CountriesPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getIsoA2(),
			$keys[4] => $this->getIsoA3(),
			$keys[5] => $this->getContinent(),
			$keys[6] => $this->getNumber(),
			$keys[7] => $this->getOptName(),
			$keys[8] => $this->getIsActive(),
			$keys[9] => $this->getIsDefault(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CountriesPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setIsoA2($value);
				break;
			case 4:
				$this->setIsoA3($value);
				break;
			case 5:
				$this->setContinent($value);
				break;
			case 6:
				$this->setNumber($value);
				break;
			case 7:
				$this->setOptName($value);
				break;
			case 8:
				$this->setIsActive($value);
				break;
			case 9:
				$this->setIsDefault($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CountriesPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setIsoA2($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setIsoA3($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setContinent($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setNumber($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setOptName($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setIsActive($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setIsDefault($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(CountriesPeer::DATABASE_NAME);

		if ($this->isColumnModified(CountriesPeer::CREATED_AT)) $criteria->add(CountriesPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(CountriesPeer::UPDATED_AT)) $criteria->add(CountriesPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(CountriesPeer::ID)) $criteria->add(CountriesPeer::ID, $this->id);
		if ($this->isColumnModified(CountriesPeer::ISO_A2)) $criteria->add(CountriesPeer::ISO_A2, $this->iso_a2);
		if ($this->isColumnModified(CountriesPeer::ISO_A3)) $criteria->add(CountriesPeer::ISO_A3, $this->iso_a3);
		if ($this->isColumnModified(CountriesPeer::CONTINENT)) $criteria->add(CountriesPeer::CONTINENT, $this->continent);
		if ($this->isColumnModified(CountriesPeer::NUMBER)) $criteria->add(CountriesPeer::NUMBER, $this->number);
		if ($this->isColumnModified(CountriesPeer::OPT_NAME)) $criteria->add(CountriesPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(CountriesPeer::IS_ACTIVE)) $criteria->add(CountriesPeer::IS_ACTIVE, $this->is_active);
		if ($this->isColumnModified(CountriesPeer::IS_DEFAULT)) $criteria->add(CountriesPeer::IS_DEFAULT, $this->is_default);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CountriesPeer::DATABASE_NAME);

		$criteria->add(CountriesPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setIsoA2($this->iso_a2);

		$copyObj->setIsoA3($this->iso_a3);

		$copyObj->setContinent($this->continent);

		$copyObj->setNumber($this->number);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setIsActive($this->is_active);

		$copyObj->setIsDefault($this->is_default);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getCountriesAreaHasCountriess() as $relObj) {
				$copyObj->addCountriesAreaHasCountries($relObj->copy($deepCopy));
			}

			foreach($this->getCountriesI18ns() as $relObj) {
				$copyObj->addCountriesI18n($relObj->copy($deepCopy));
			}

			foreach($this->getOrderUserDataBillings() as $relObj) {
				$copyObj->addOrderUserDataBilling($relObj->copy($deepCopy));
			}

			foreach($this->getOrderUserDataDeliverys() as $relObj) {
				$copyObj->addOrderUserDataDelivery($relObj->copy($deepCopy));
			}

			foreach($this->getPartners() as $relObj) {
				$copyObj->addPartner($relObj->copy($deepCopy));
			}

			foreach($this->getUserDatas() as $relObj) {
				$copyObj->addUserData($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CountriesPeer();
		}
		return self::$peer;
	}

	
	public function initCountriesAreaHasCountriess()
	{
		if ($this->collCountriesAreaHasCountriess === null) {
			$this->collCountriesAreaHasCountriess = array();
		}
	}

	
	public function getCountriesAreaHasCountriess($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCountriesAreaHasCountriess === null) {
			if ($this->isNew()) {
			   $this->collCountriesAreaHasCountriess = array();
			} else {

				$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_ID, $this->getId());

				CountriesAreaHasCountriesPeer::addSelectColumns($criteria);
				$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_ID, $this->getId());

				CountriesAreaHasCountriesPeer::addSelectColumns($criteria);
				if (!isset($this->lastCountriesAreaHasCountriesCriteria) || !$this->lastCountriesAreaHasCountriesCriteria->equals($criteria)) {
					$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCountriesAreaHasCountriesCriteria = $criteria;
		return $this->collCountriesAreaHasCountriess;
	}

	
	public function countCountriesAreaHasCountriess($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_ID, $this->getId());

		return CountriesAreaHasCountriesPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCountriesAreaHasCountries(CountriesAreaHasCountries $l)
	{
		$this->collCountriesAreaHasCountriess[] = $l;
		$l->setCountries($this);
	}


	
	public function getCountriesAreaHasCountriessJoinCountriesArea($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCountriesAreaHasCountriess === null) {
			if ($this->isNew()) {
				$this->collCountriesAreaHasCountriess = array();
			} else {

				$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_ID, $this->getId());

				$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelectJoinCountriesArea($criteria, $con);
			}
		} else {
									
			$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_ID, $this->getId());

			if (!isset($this->lastCountriesAreaHasCountriesCriteria) || !$this->lastCountriesAreaHasCountriesCriteria->equals($criteria)) {
				$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelectJoinCountriesArea($criteria, $con);
			}
		}
		$this->lastCountriesAreaHasCountriesCriteria = $criteria;

		return $this->collCountriesAreaHasCountriess;
	}

	
	public function initCountriesI18ns()
	{
		if ($this->collCountriesI18ns === null) {
			$this->collCountriesI18ns = array();
		}
	}

	
	public function getCountriesI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCountriesI18ns === null) {
			if ($this->isNew()) {
			   $this->collCountriesI18ns = array();
			} else {

				$criteria->add(CountriesI18nPeer::ID, $this->getId());

				CountriesI18nPeer::addSelectColumns($criteria);
				$this->collCountriesI18ns = CountriesI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CountriesI18nPeer::ID, $this->getId());

				CountriesI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastCountriesI18nCriteria) || !$this->lastCountriesI18nCriteria->equals($criteria)) {
					$this->collCountriesI18ns = CountriesI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCountriesI18nCriteria = $criteria;
		return $this->collCountriesI18ns;
	}

	
	public function countCountriesI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CountriesI18nPeer::ID, $this->getId());

		return CountriesI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCountriesI18n(CountriesI18n $l)
	{
		$this->collCountriesI18ns[] = $l;
		$l->setCountries($this);
	}

	
	public function initOrderUserDataBillings()
	{
		if ($this->collOrderUserDataBillings === null) {
			$this->collOrderUserDataBillings = array();
		}
	}

	
	public function getOrderUserDataBillings($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderUserDataBillings === null) {
			if ($this->isNew()) {
			   $this->collOrderUserDataBillings = array();
			} else {

				$criteria->add(OrderUserDataBillingPeer::COUNTRIES_ID, $this->getId());

				OrderUserDataBillingPeer::addSelectColumns($criteria);
				$this->collOrderUserDataBillings = OrderUserDataBillingPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderUserDataBillingPeer::COUNTRIES_ID, $this->getId());

				OrderUserDataBillingPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderUserDataBillingCriteria) || !$this->lastOrderUserDataBillingCriteria->equals($criteria)) {
					$this->collOrderUserDataBillings = OrderUserDataBillingPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderUserDataBillingCriteria = $criteria;
		return $this->collOrderUserDataBillings;
	}

	
	public function countOrderUserDataBillings($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderUserDataBillingPeer::COUNTRIES_ID, $this->getId());

		return OrderUserDataBillingPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderUserDataBilling(OrderUserDataBilling $l)
	{
		$this->collOrderUserDataBillings[] = $l;
		$l->setCountries($this);
	}

	
	public function initOrderUserDataDeliverys()
	{
		if ($this->collOrderUserDataDeliverys === null) {
			$this->collOrderUserDataDeliverys = array();
		}
	}

	
	public function getOrderUserDataDeliverys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderUserDataDeliverys === null) {
			if ($this->isNew()) {
			   $this->collOrderUserDataDeliverys = array();
			} else {

				$criteria->add(OrderUserDataDeliveryPeer::COUNTRIES_ID, $this->getId());

				OrderUserDataDeliveryPeer::addSelectColumns($criteria);
				$this->collOrderUserDataDeliverys = OrderUserDataDeliveryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderUserDataDeliveryPeer::COUNTRIES_ID, $this->getId());

				OrderUserDataDeliveryPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderUserDataDeliveryCriteria) || !$this->lastOrderUserDataDeliveryCriteria->equals($criteria)) {
					$this->collOrderUserDataDeliverys = OrderUserDataDeliveryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderUserDataDeliveryCriteria = $criteria;
		return $this->collOrderUserDataDeliverys;
	}

	
	public function countOrderUserDataDeliverys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderUserDataDeliveryPeer::COUNTRIES_ID, $this->getId());

		return OrderUserDataDeliveryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderUserDataDelivery(OrderUserDataDelivery $l)
	{
		$this->collOrderUserDataDeliverys[] = $l;
		$l->setCountries($this);
	}

	
	public function initPartners()
	{
		if ($this->collPartners === null) {
			$this->collPartners = array();
		}
	}

	
	public function getPartners($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPartners === null) {
			if ($this->isNew()) {
			   $this->collPartners = array();
			} else {

				$criteria->add(PartnerPeer::COUNTRIES_ID, $this->getId());

				PartnerPeer::addSelectColumns($criteria);
				$this->collPartners = PartnerPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(PartnerPeer::COUNTRIES_ID, $this->getId());

				PartnerPeer::addSelectColumns($criteria);
				if (!isset($this->lastPartnerCriteria) || !$this->lastPartnerCriteria->equals($criteria)) {
					$this->collPartners = PartnerPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPartnerCriteria = $criteria;
		return $this->collPartners;
	}

	
	public function countPartners($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(PartnerPeer::COUNTRIES_ID, $this->getId());

		return PartnerPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addPartner(Partner $l)
	{
		$this->collPartners[] = $l;
		$l->setCountries($this);
	}


	
	public function getPartnersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPartners === null) {
			if ($this->isNew()) {
				$this->collPartners = array();
			} else {

				$criteria->add(PartnerPeer::COUNTRIES_ID, $this->getId());

				$this->collPartners = PartnerPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(PartnerPeer::COUNTRIES_ID, $this->getId());

			if (!isset($this->lastPartnerCriteria) || !$this->lastPartnerCriteria->equals($criteria)) {
				$this->collPartners = PartnerPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastPartnerCriteria = $criteria;

		return $this->collPartners;
	}

	
	public function initUserDatas()
	{
		if ($this->collUserDatas === null) {
			$this->collUserDatas = array();
		}
	}

	
	public function getUserDatas($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserDatas === null) {
			if ($this->isNew()) {
			   $this->collUserDatas = array();
			} else {

				$criteria->add(UserDataPeer::COUNTRIES_ID, $this->getId());

				UserDataPeer::addSelectColumns($criteria);
				$this->collUserDatas = UserDataPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(UserDataPeer::COUNTRIES_ID, $this->getId());

				UserDataPeer::addSelectColumns($criteria);
				if (!isset($this->lastUserDataCriteria) || !$this->lastUserDataCriteria->equals($criteria)) {
					$this->collUserDatas = UserDataPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserDataCriteria = $criteria;
		return $this->collUserDatas;
	}

	
	public function countUserDatas($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(UserDataPeer::COUNTRIES_ID, $this->getId());

		return UserDataPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addUserData(UserData $l)
	{
		$this->collUserDatas[] = $l;
		$l->setCountries($this);
	}


	
	public function getUserDatasJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserDatas === null) {
			if ($this->isNew()) {
				$this->collUserDatas = array();
			} else {

				$criteria->add(UserDataPeer::COUNTRIES_ID, $this->getId());

				$this->collUserDatas = UserDataPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(UserDataPeer::COUNTRIES_ID, $this->getId());

			if (!isset($this->lastUserDataCriteria) || !$this->lastUserDataCriteria->equals($criteria)) {
				$this->collUserDatas = UserDataPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastUserDataCriteria = $criteria;

		return $this->collUserDatas;
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentCountriesI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentCountriesI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentCountriesI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = CountriesI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setCountriesI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setCountriesI18nForCulture(new CountriesI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setCountriesI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addCountriesI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Countries.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseCountries:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseCountries::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 