<?php


abstract class BaseCountriesArea extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $name;


	
	protected $is_active = false;

	
	protected $collDeliverys;

	
	protected $lastDeliveryCriteria = null;

	
	protected $collCountriesAreaHasCountriess;

	
	protected $lastCountriesAreaHasCountriesCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getIsActive()
    {

            return $this->is_active;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = CountriesAreaPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = CountriesAreaPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = CountriesAreaPeer::ID;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = CountriesAreaPeer::NAME;
        }

	} 
	
	public function setIsActive($v)
	{

        if ($this->is_active !== $v || $v === false) {
          $this->is_active = $v;
          $this->modifiedColumns[] = CountriesAreaPeer::IS_ACTIVE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'CountriesArea.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->name = $rs->getString($startcol + 3);

      $this->is_active = $rs->getBoolean($startcol + 4);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'CountriesArea.postHydrate', array('resultset' => $rs, 'startcol' => 5)));

            return $startcol + 5; 
    } catch (Exception $e) {
      throw new PropelException("Error populating CountriesArea object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseCountriesArea:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CountriesAreaPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			CountriesAreaPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseCountriesArea:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'CountriesArea.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseCountriesArea:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(CountriesAreaPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(CountriesAreaPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CountriesAreaPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'CountriesArea.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseCountriesArea:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CountriesAreaPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += CountriesAreaPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collDeliverys !== null) {
				foreach($this->collDeliverys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCountriesAreaHasCountriess !== null) {
				foreach($this->collCountriesAreaHasCountriess as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = CountriesAreaPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collDeliverys !== null) {
					foreach($this->collDeliverys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCountriesAreaHasCountriess !== null) {
					foreach($this->collCountriesAreaHasCountriess as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CountriesAreaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getName();
				break;
			case 4:
				return $this->getIsActive();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CountriesAreaPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getName(),
			$keys[4] => $this->getIsActive(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CountriesAreaPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setName($value);
				break;
			case 4:
				$this->setIsActive($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CountriesAreaPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setIsActive($arr[$keys[4]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(CountriesAreaPeer::DATABASE_NAME);

		if ($this->isColumnModified(CountriesAreaPeer::CREATED_AT)) $criteria->add(CountriesAreaPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(CountriesAreaPeer::UPDATED_AT)) $criteria->add(CountriesAreaPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(CountriesAreaPeer::ID)) $criteria->add(CountriesAreaPeer::ID, $this->id);
		if ($this->isColumnModified(CountriesAreaPeer::NAME)) $criteria->add(CountriesAreaPeer::NAME, $this->name);
		if ($this->isColumnModified(CountriesAreaPeer::IS_ACTIVE)) $criteria->add(CountriesAreaPeer::IS_ACTIVE, $this->is_active);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CountriesAreaPeer::DATABASE_NAME);

		$criteria->add(CountriesAreaPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setName($this->name);

		$copyObj->setIsActive($this->is_active);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getDeliverys() as $relObj) {
				$copyObj->addDelivery($relObj->copy($deepCopy));
			}

			foreach($this->getCountriesAreaHasCountriess() as $relObj) {
				$copyObj->addCountriesAreaHasCountries($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CountriesAreaPeer();
		}
		return self::$peer;
	}

	
	public function initDeliverys()
	{
		if ($this->collDeliverys === null) {
			$this->collDeliverys = array();
		}
	}

	
	public function getDeliverys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverys === null) {
			if ($this->isNew()) {
			   $this->collDeliverys = array();
			} else {

				$criteria->add(DeliveryPeer::COUNTRIES_AREA_ID, $this->getId());

				DeliveryPeer::addSelectColumns($criteria);
				$this->collDeliverys = DeliveryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DeliveryPeer::COUNTRIES_AREA_ID, $this->getId());

				DeliveryPeer::addSelectColumns($criteria);
				if (!isset($this->lastDeliveryCriteria) || !$this->lastDeliveryCriteria->equals($criteria)) {
					$this->collDeliverys = DeliveryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDeliveryCriteria = $criteria;
		return $this->collDeliverys;
	}

	
	public function countDeliverys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DeliveryPeer::COUNTRIES_AREA_ID, $this->getId());

		return DeliveryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDelivery(Delivery $l)
	{
		$this->collDeliverys[] = $l;
		$l->setCountriesArea($this);
	}


	
	public function getDeliverysJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverys === null) {
			if ($this->isNew()) {
				$this->collDeliverys = array();
			} else {

				$criteria->add(DeliveryPeer::COUNTRIES_AREA_ID, $this->getId());

				$this->collDeliverys = DeliveryPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(DeliveryPeer::COUNTRIES_AREA_ID, $this->getId());

			if (!isset($this->lastDeliveryCriteria) || !$this->lastDeliveryCriteria->equals($criteria)) {
				$this->collDeliverys = DeliveryPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastDeliveryCriteria = $criteria;

		return $this->collDeliverys;
	}

	
	public function initCountriesAreaHasCountriess()
	{
		if ($this->collCountriesAreaHasCountriess === null) {
			$this->collCountriesAreaHasCountriess = array();
		}
	}

	
	public function getCountriesAreaHasCountriess($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCountriesAreaHasCountriess === null) {
			if ($this->isNew()) {
			   $this->collCountriesAreaHasCountriess = array();
			} else {

				$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_AREA_ID, $this->getId());

				CountriesAreaHasCountriesPeer::addSelectColumns($criteria);
				$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_AREA_ID, $this->getId());

				CountriesAreaHasCountriesPeer::addSelectColumns($criteria);
				if (!isset($this->lastCountriesAreaHasCountriesCriteria) || !$this->lastCountriesAreaHasCountriesCriteria->equals($criteria)) {
					$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCountriesAreaHasCountriesCriteria = $criteria;
		return $this->collCountriesAreaHasCountriess;
	}

	
	public function countCountriesAreaHasCountriess($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_AREA_ID, $this->getId());

		return CountriesAreaHasCountriesPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCountriesAreaHasCountries(CountriesAreaHasCountries $l)
	{
		$this->collCountriesAreaHasCountriess[] = $l;
		$l->setCountriesArea($this);
	}


	
	public function getCountriesAreaHasCountriessJoinCountries($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCountriesAreaHasCountriess === null) {
			if ($this->isNew()) {
				$this->collCountriesAreaHasCountriess = array();
			} else {

				$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_AREA_ID, $this->getId());

				$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelectJoinCountries($criteria, $con);
			}
		} else {
									
			$criteria->add(CountriesAreaHasCountriesPeer::COUNTRIES_AREA_ID, $this->getId());

			if (!isset($this->lastCountriesAreaHasCountriesCriteria) || !$this->lastCountriesAreaHasCountriesCriteria->equals($criteria)) {
				$this->collCountriesAreaHasCountriess = CountriesAreaHasCountriesPeer::doSelectJoinCountries($criteria, $con);
			}
		}
		$this->lastCountriesAreaHasCountriesCriteria = $criteria;

		return $this->collCountriesAreaHasCountriess;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'CountriesArea.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseCountriesArea:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseCountriesArea::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 