<?php


abstract class BaseCountriesPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_countries';

	
	const CLASS_DEFAULT = 'plugins.stCountriesPlugin.lib.model.Countries';

	
	const NUM_COLUMNS = 10;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_countries.CREATED_AT';

	
	const UPDATED_AT = 'st_countries.UPDATED_AT';

	
	const ID = 'st_countries.ID';

	
	const ISO_A2 = 'st_countries.ISO_A2';

	
	const ISO_A3 = 'st_countries.ISO_A3';

	
	const CONTINENT = 'st_countries.CONTINENT';

	
	const NUMBER = 'st_countries.NUMBER';

	
	const OPT_NAME = 'st_countries.OPT_NAME';

	
	const IS_ACTIVE = 'st_countries.IS_ACTIVE';

	
	const IS_DEFAULT = 'st_countries.IS_DEFAULT';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'IsoA2', 'IsoA3', 'Continent', 'Number', 'OptName', 'IsActive', 'IsDefault', ),
		BasePeer::TYPE_COLNAME => array (CountriesPeer::CREATED_AT, CountriesPeer::UPDATED_AT, CountriesPeer::ID, CountriesPeer::ISO_A2, CountriesPeer::ISO_A3, CountriesPeer::CONTINENT, CountriesPeer::NUMBER, CountriesPeer::OPT_NAME, CountriesPeer::IS_ACTIVE, CountriesPeer::IS_DEFAULT, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'iso_a2', 'iso_a3', 'continent', 'number', 'opt_name', 'is_active', 'is_default', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'IsoA2' => 3, 'IsoA3' => 4, 'Continent' => 5, 'Number' => 6, 'OptName' => 7, 'IsActive' => 8, 'IsDefault' => 9, ),
		BasePeer::TYPE_COLNAME => array (CountriesPeer::CREATED_AT => 0, CountriesPeer::UPDATED_AT => 1, CountriesPeer::ID => 2, CountriesPeer::ISO_A2 => 3, CountriesPeer::ISO_A3 => 4, CountriesPeer::CONTINENT => 5, CountriesPeer::NUMBER => 6, CountriesPeer::OPT_NAME => 7, CountriesPeer::IS_ACTIVE => 8, CountriesPeer::IS_DEFAULT => 9, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'iso_a2' => 3, 'iso_a3' => 4, 'continent' => 5, 'number' => 6, 'opt_name' => 7, 'is_active' => 8, 'is_default' => 9, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('plugins.stCountriesPlugin.lib.model.map.CountriesMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = CountriesPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(CountriesPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(CountriesPeer::CREATED_AT);

		$criteria->addSelectColumn(CountriesPeer::UPDATED_AT);

		$criteria->addSelectColumn(CountriesPeer::ID);

		$criteria->addSelectColumn(CountriesPeer::ISO_A2);

		$criteria->addSelectColumn(CountriesPeer::ISO_A3);

		$criteria->addSelectColumn(CountriesPeer::CONTINENT);

		$criteria->addSelectColumn(CountriesPeer::NUMBER);

		$criteria->addSelectColumn(CountriesPeer::OPT_NAME);

		$criteria->addSelectColumn(CountriesPeer::IS_ACTIVE);

		$criteria->addSelectColumn(CountriesPeer::IS_DEFAULT);

	}

	const COUNT = 'COUNT(st_countries.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_countries.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(CountriesPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(CountriesPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = CountriesPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = CountriesPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return CountriesPeer::populateObjects(CountriesPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseCountriesPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseCountriesPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			CountriesPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = CountriesPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

     
     public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
     {
       if ($culture === null)
       {
         $culture = sfContext::getInstance()->getUser()->getCulture();
       }

              if ($c->getDbName() == Propel::getDefaultDB())
       {
         $c->setDbName(self::DATABASE_NAME);
       }

      CountriesPeer::addSelectColumns($c);
      $startcol = (CountriesPeer::NUM_COLUMNS - CountriesPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

      CountriesI18nPeer::addSelectColumns($c);

      $c->addJoin(CountriesPeer::ID, sprintf('%s AND %s = \'%s\'', CountriesI18nPeer::ID, CountriesI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

      $rs = BasePeer::doSelect($c, $con);

      if (self::$hydrateMethod)
      {
         return call_user_func(self::$hydrateMethod, $rs);
      }

      $results = array();

      while($rs->next()) {

         $omClass = CountriesPeer::getOMClass();

         $cls = Propel::import($omClass);
         $obj1 = new $cls();
         $obj1->hydrate($rs);
         $obj1->setCulture($culture);

         $omClass = CountriesI18nPeer::getOMClass($rs, $startcol);

         $cls = Propel::import($omClass);
         $obj2 = new $cls();
         $obj2->hydrate($rs, $startcol);

         $obj1->setCountriesI18nForCulture($obj2, $culture);
         $obj2->setCountries($obj1);

         $results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
       }
       return $results;
     }

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return CountriesPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseCountriesPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseCountriesPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(CountriesPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseCountriesPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseCountriesPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseCountriesPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseCountriesPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(CountriesPeer::ID);
			$selectCriteria->add(CountriesPeer::ID, $criteria->remove(CountriesPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseCountriesPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseCountriesPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += CountriesPeer::doOnDeleteCascade(new Criteria(), $con);
			CountriesPeer::doOnDeleteSetNull(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(CountriesPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(CountriesPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof Countries) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(CountriesPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += CountriesPeer::doOnDeleteCascade($criteria, $con);CountriesPeer::doOnDeleteSetNull($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = CountriesPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(CountriesAreaHasCountriesPeer::COUNTRIES_ID, $obj->getId());
			$affectedRows += CountriesAreaHasCountriesPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(CountriesI18nPeer::ID, $obj->getId());
			$affectedRows += CountriesI18nPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	protected static function doOnDeleteSetNull(Criteria $criteria, Connection $con)
	{

				$objects = CountriesPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {

						$selectCriteria = new Criteria(CountriesPeer::DATABASE_NAME);
			$updateValues = new Criteria(CountriesPeer::DATABASE_NAME);
			$selectCriteria->add(OrderUserDataBillingPeer::COUNTRIES_ID, $obj->getId());
			$updateValues->add(OrderUserDataBillingPeer::COUNTRIES_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
						$selectCriteria = new Criteria(CountriesPeer::DATABASE_NAME);
			$updateValues = new Criteria(CountriesPeer::DATABASE_NAME);
			$selectCriteria->add(OrderUserDataDeliveryPeer::COUNTRIES_ID, $obj->getId());
			$updateValues->add(OrderUserDataDeliveryPeer::COUNTRIES_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
		}
	}

	
	public static function doValidate(Countries $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(CountriesPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(CountriesPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(CountriesPeer::DATABASE_NAME, CountriesPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = CountriesPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(CountriesPeer::DATABASE_NAME);

		$criteria->add(CountriesPeer::ID, $pk);


		$v = CountriesPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(CountriesPeer::ID, $pks, Criteria::IN);
			$objs = CountriesPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseCountriesPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('plugins.stCountriesPlugin.lib.model.map.CountriesMapBuilder');
}
