<?php


abstract class BaseCrosselling extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $first_product_id;


	
	protected $secound_product_id;


	
	protected $sum;

	
	protected $aProductRelatedByFirstProductId;

	
	protected $aProductRelatedBySecoundProductId;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getFirstProductId()
    {

            return $this->first_product_id;
    }

    
    public function getSecoundProductId()
    {

            return $this->secound_product_id;
    }

    
    public function getSum()
    {

            return $this->sum;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = CrossellingPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = CrossellingPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = CrossellingPeer::ID;
        }

	} 
	
	public function setFirstProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->first_product_id !== $v) {
          $this->first_product_id = $v;
          $this->modifiedColumns[] = CrossellingPeer::FIRST_PRODUCT_ID;
        }

		if ($this->aProductRelatedByFirstProductId !== null && $this->aProductRelatedByFirstProductId->getId() !== $v) {
			$this->aProductRelatedByFirstProductId = null;
		}

	} 
	
	public function setSecoundProductId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->secound_product_id !== $v) {
          $this->secound_product_id = $v;
          $this->modifiedColumns[] = CrossellingPeer::SECOUND_PRODUCT_ID;
        }

		if ($this->aProductRelatedBySecoundProductId !== null && $this->aProductRelatedBySecoundProductId->getId() !== $v) {
			$this->aProductRelatedBySecoundProductId = null;
		}

	} 
	
	public function setSum($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sum !== $v) {
          $this->sum = $v;
          $this->modifiedColumns[] = CrossellingPeer::SUM;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Crosselling.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->first_product_id = $rs->getInt($startcol + 3);

      $this->secound_product_id = $rs->getInt($startcol + 4);

      $this->sum = $rs->getInt($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Crosselling.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Crosselling object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseCrosselling:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CrossellingPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			CrossellingPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseCrosselling:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Crosselling.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseCrosselling:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(CrossellingPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(CrossellingPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CrossellingPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Crosselling.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseCrosselling:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aProductRelatedByFirstProductId !== null) {
				if ($this->aProductRelatedByFirstProductId->isModified() || $this->aProductRelatedByFirstProductId->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProductRelatedByFirstProductId->save($con);
				}
				$this->setProductRelatedByFirstProductId($this->aProductRelatedByFirstProductId);
			}

			if ($this->aProductRelatedBySecoundProductId !== null) {
				if ($this->aProductRelatedBySecoundProductId->isModified() || $this->aProductRelatedBySecoundProductId->getCurrentProductI18n()->isModified()) {
					$affectedRows += $this->aProductRelatedBySecoundProductId->save($con);
				}
				$this->setProductRelatedBySecoundProductId($this->aProductRelatedBySecoundProductId);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CrossellingPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += CrossellingPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aProductRelatedByFirstProductId !== null) {
				if (!$this->aProductRelatedByFirstProductId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductRelatedByFirstProductId->getValidationFailures());
				}
			}

			if ($this->aProductRelatedBySecoundProductId !== null) {
				if (!$this->aProductRelatedBySecoundProductId->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aProductRelatedBySecoundProductId->getValidationFailures());
				}
			}


			if (($retval = CrossellingPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CrossellingPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getFirstProductId();
				break;
			case 4:
				return $this->getSecoundProductId();
				break;
			case 5:
				return $this->getSum();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CrossellingPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getFirstProductId(),
			$keys[4] => $this->getSecoundProductId(),
			$keys[5] => $this->getSum(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CrossellingPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setFirstProductId($value);
				break;
			case 4:
				$this->setSecoundProductId($value);
				break;
			case 5:
				$this->setSum($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CrossellingPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setFirstProductId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setSecoundProductId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setSum($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(CrossellingPeer::DATABASE_NAME);

		if ($this->isColumnModified(CrossellingPeer::CREATED_AT)) $criteria->add(CrossellingPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(CrossellingPeer::UPDATED_AT)) $criteria->add(CrossellingPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(CrossellingPeer::ID)) $criteria->add(CrossellingPeer::ID, $this->id);
		if ($this->isColumnModified(CrossellingPeer::FIRST_PRODUCT_ID)) $criteria->add(CrossellingPeer::FIRST_PRODUCT_ID, $this->first_product_id);
		if ($this->isColumnModified(CrossellingPeer::SECOUND_PRODUCT_ID)) $criteria->add(CrossellingPeer::SECOUND_PRODUCT_ID, $this->secound_product_id);
		if ($this->isColumnModified(CrossellingPeer::SUM)) $criteria->add(CrossellingPeer::SUM, $this->sum);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CrossellingPeer::DATABASE_NAME);

		$criteria->add(CrossellingPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setFirstProductId($this->first_product_id);

		$copyObj->setSecoundProductId($this->secound_product_id);

		$copyObj->setSum($this->sum);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CrossellingPeer();
		}
		return self::$peer;
	}

	
	public function setProductRelatedByFirstProductId($v)
	{


		if ($v === null) {
			$this->setFirstProductId(NULL);
		} else {
			$this->setFirstProductId($v->getId());
		}


		$this->aProductRelatedByFirstProductId = $v;
	}


	
	public function getProductRelatedByFirstProductId($con = null)
	{
		if ($this->aProductRelatedByFirstProductId === null && ($this->first_product_id !== null)) {
						$this->aProductRelatedByFirstProductId = ProductPeer::retrieveByPK($this->first_product_id, $con);

			
		}
		return $this->aProductRelatedByFirstProductId;
	}

	
	public function setProductRelatedBySecoundProductId($v)
	{


		if ($v === null) {
			$this->setSecoundProductId(NULL);
		} else {
			$this->setSecoundProductId($v->getId());
		}


		$this->aProductRelatedBySecoundProductId = $v;
	}


	
	public function getProductRelatedBySecoundProductId($con = null)
	{
		if ($this->aProductRelatedBySecoundProductId === null && ($this->secound_product_id !== null)) {
						$this->aProductRelatedBySecoundProductId = ProductPeer::retrieveByPK($this->secound_product_id, $con);

			
		}
		return $this->aProductRelatedBySecoundProductId;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Crosselling.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseCrosselling:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseCrosselling::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 