<?php
/**
 * SOTESHOP/stCurrencyPlugin
 *
 * Ten plik należy do aplikacji stCurrencyPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE.
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stCurrencyPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: CurrencyPeer.php 10414 2011-01-21 11:49:57Z michal $
 * @author      Marcin Olejnczak <marcin.olejniczak@sote.pl>
 */

/**
 * Klasa CurrencyPeer
 *
 * @package     stCurrencyPlugin
 * @subpackage  libs
 */
class CurrencyPeer extends BaseCurrencyPeer
{
	/**
	 * pobieranie z dodatkowym cachem
	 *
	 * @param       integer     $pk
	 * @param        object      $con
	 * @return   object
	 */
	public static function retrieveByPK($pk, $con = null)
	{
		$stCache = new stFunctionCache('stCurrency');
		return $stCache->add('retrieve_'.$pk,"BaseCurrencyPeer::retrieveByPK",$pk, $con);
	}

	public static function doSelectActive(Criteria $c, $con = null)
	{
		$c = clone $c;

		$c->add(CurrencyPeer::ACTIVE, true);

		$stCache = new stFunctionCache('stCurrency');
		return $stCache->add('doSelectActive_'.md5(serialize($c)), 'CurrencyPeer::doSelect', $c);

		return self::doSelect($c);
	}

	/**
	 * Wybór aktywnej waluty
	 *
	 * @param      Criteria    $c
	 * @param     $con
	 * @return   object
	 */
	public static function doSelectActiveOne(Criteria $c, $con = null)
	{
		$c = clone $c;
		$c->setLimit(1);

		$currency = self::doSelectActive($c, $con);

		return $currency ? $currency[0] : null;
	}

	public static function doSelectSystemDefault(Criteria $c, $con = null)
	{
		$c = clone $c;

		$config = stConfig::getInstance(null, 'stCurrencyPlugin');

		$c->add(self::SHORTCUT, $config->get('default_currency'));

		return self::doSelectOne($c);
	}

	public static function retrieveByIso($iso)
	{
		static $currencies = null;

		if (null === $currencies)
		{
			$currencies = self::doSelect(new Criteria());
		}

		foreach ($currencies as $currency)
		{
			if ($currency->getShortcut() == $iso)
			{
				return $currency;
			}
		}

		return null;
	}

	public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
	{
		if ($culture === null)
		{
			$culture = stLanguage::getHydrateCulture();
		}

		if ($c->getDbName() == Propel::getDefaultDB())
		{
			$c->setDbName(self::DATABASE_NAME);
		}

		CurrencyPeer::addSelectColumns($c);

		$startcol = (CurrencyPeer::NUM_COLUMNS - CurrencyPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CurrencyI18nPeer::addSelectColumns($c);

		$c->addJoin(CurrencyPeer::ID, sprintf("%s AND %s = '%s'", CurrencyI18nPeer::ID, CurrencyI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);

		$results = array();

		while($rs->next())
		{

			$omClass = CurrencyPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
			$obj1->setCulture($culture);

			$omClass = CurrencyI18nPeer::getOMClass($rs, $startcol);

			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol);

			$obj1->setCurrencyI18nForCulture($obj2, $culture);
			$obj2->setCurrency($obj1);

			$results[] = $obj1;
		}
		return $results;
	}

	public static function doCountWithI18n(Criteria $c, $con = null)
	{
		$c->addJoin(CurrencyI18nPeer::ID, CurrencyPeer::ID);

		$c->add(CurrencyI18nPeer::CULTURE, stLanguage::getHydrateCulture());

		return self::doCount($c, $con);
	}
}
