<?php


abstract class BaseCurrency extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $currency_standard_id;


	
	protected $shortcut;


	
	protected $exchange;


	
	protected $active;


	
	protected $main;


	
	protected $front_symbol;


	
	protected $back_symbol;


	
	protected $nbp_exchange;


	
	protected $system;


	
	protected $opt_name;

	
	protected $aCurrencyStandard;

	
	protected $collLanguages;

	
	protected $lastLanguageCriteria = null;

	
	protected $collProducts;

	
	protected $lastProductCriteria = null;

	
	protected $collGiftCards;

	
	protected $lastGiftCardCriteria = null;

	
	protected $collCurrencyI18ns;

	
	protected $lastCurrencyI18nCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCurrencyStandardId()
    {

            return $this->currency_standard_id;
    }

    
    public function getShortcut()
    {

            return $this->shortcut;
    }

    
    public function getExchange()
    {

            return null !== $this->exchange ? (string)$this->exchange : null;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getMain()
    {

            return $this->main;
    }

    
    public function getFrontSymbol()
    {

            return $this->front_symbol;
    }

    
    public function getBackSymbol()
    {

            return $this->back_symbol;
    }

    
    public function getNbpExchange()
    {

            return $this->nbp_exchange;
    }

    
    public function getSystem()
    {

            return $this->system;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = CurrencyPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = CurrencyPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = CurrencyPeer::ID;
        }

	} 
	
	public function setCurrencyStandardId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->currency_standard_id !== $v) {
          $this->currency_standard_id = $v;
          $this->modifiedColumns[] = CurrencyPeer::CURRENCY_STANDARD_ID;
        }

		if ($this->aCurrencyStandard !== null && $this->aCurrencyStandard->getId() !== $v) {
			$this->aCurrencyStandard = null;
		}

	} 
	
	public function setShortcut($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->shortcut !== $v) {
          $this->shortcut = $v;
          $this->modifiedColumns[] = CurrencyPeer::SHORTCUT;
        }

	} 
	
	public function setExchange($v)
	{

        if ($this->exchange !== $v) {
          $this->exchange = $v;
          $this->modifiedColumns[] = CurrencyPeer::EXCHANGE;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v) {
          $this->active = $v;
          $this->modifiedColumns[] = CurrencyPeer::ACTIVE;
        }

	} 
	
	public function setMain($v)
	{

        if ($this->main !== $v) {
          $this->main = $v;
          $this->modifiedColumns[] = CurrencyPeer::MAIN;
        }

	} 
	
	public function setFrontSymbol($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->front_symbol !== $v) {
          $this->front_symbol = $v;
          $this->modifiedColumns[] = CurrencyPeer::FRONT_SYMBOL;
        }

	} 
	
	public function setBackSymbol($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->back_symbol !== $v) {
          $this->back_symbol = $v;
          $this->modifiedColumns[] = CurrencyPeer::BACK_SYMBOL;
        }

	} 
	
	public function setNbpExchange($v)
	{

        if ($this->nbp_exchange !== $v) {
          $this->nbp_exchange = $v;
          $this->modifiedColumns[] = CurrencyPeer::NBP_EXCHANGE;
        }

	} 
	
	public function setSystem($v)
	{

        if ($this->system !== $v) {
          $this->system = $v;
          $this->modifiedColumns[] = CurrencyPeer::SYSTEM;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = CurrencyPeer::OPT_NAME;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Currency.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->currency_standard_id = $rs->getInt($startcol + 3);

      $this->shortcut = $rs->getString($startcol + 4);

      $this->exchange = $rs->getString($startcol + 5, null);

      $this->exchange = $rs->getFloat($startcol + 5);

      $this->active = $rs->getBoolean($startcol + 6);

      $this->main = $rs->getBoolean($startcol + 7);

      $this->front_symbol = $rs->getString($startcol + 8);

      $this->back_symbol = $rs->getString($startcol + 9);

      $this->nbp_exchange = $rs->getFloat($startcol + 10);

      $this->system = $rs->getBoolean($startcol + 11);

      $this->opt_name = $rs->getString($startcol + 12);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Currency.postHydrate', array('resultset' => $rs, 'startcol' => 13)));

            return $startcol + 13; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Currency object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseCurrency:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CurrencyPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			CurrencyPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseCurrency:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Currency.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseCurrency:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(CurrencyPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(CurrencyPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(CurrencyPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Currency.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseCurrency:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aCurrencyStandard !== null) {
				if ($this->aCurrencyStandard->isModified()) {
					$affectedRows += $this->aCurrencyStandard->save($con);
				}
				$this->setCurrencyStandard($this->aCurrencyStandard);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = CurrencyPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += CurrencyPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collLanguages !== null) {
				foreach($this->collLanguages as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collProducts !== null) {
				foreach($this->collProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collGiftCards !== null) {
				foreach($this->collGiftCards as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collCurrencyI18ns !== null) {
				foreach($this->collCurrencyI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aCurrencyStandard !== null) {
				if (!$this->aCurrencyStandard->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCurrencyStandard->getValidationFailures());
				}
			}


			if (($retval = CurrencyPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collLanguages !== null) {
					foreach($this->collLanguages as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collProducts !== null) {
					foreach($this->collProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collGiftCards !== null) {
					foreach($this->collGiftCards as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collCurrencyI18ns !== null) {
					foreach($this->collCurrencyI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CurrencyPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCurrencyStandardId();
				break;
			case 4:
				return $this->getShortcut();
				break;
			case 5:
				return $this->getExchange();
				break;
			case 6:
				return $this->getActive();
				break;
			case 7:
				return $this->getMain();
				break;
			case 8:
				return $this->getFrontSymbol();
				break;
			case 9:
				return $this->getBackSymbol();
				break;
			case 10:
				return $this->getNbpExchange();
				break;
			case 11:
				return $this->getSystem();
				break;
			case 12:
				return $this->getOptName();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CurrencyPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCurrencyStandardId(),
			$keys[4] => $this->getShortcut(),
			$keys[5] => $this->getExchange(),
			$keys[6] => $this->getActive(),
			$keys[7] => $this->getMain(),
			$keys[8] => $this->getFrontSymbol(),
			$keys[9] => $this->getBackSymbol(),
			$keys[10] => $this->getNbpExchange(),
			$keys[11] => $this->getSystem(),
			$keys[12] => $this->getOptName(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = CurrencyPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCurrencyStandardId($value);
				break;
			case 4:
				$this->setShortcut($value);
				break;
			case 5:
				$this->setExchange($value);
				break;
			case 6:
				$this->setActive($value);
				break;
			case 7:
				$this->setMain($value);
				break;
			case 8:
				$this->setFrontSymbol($value);
				break;
			case 9:
				$this->setBackSymbol($value);
				break;
			case 10:
				$this->setNbpExchange($value);
				break;
			case 11:
				$this->setSystem($value);
				break;
			case 12:
				$this->setOptName($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = CurrencyPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCurrencyStandardId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setShortcut($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setExchange($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setActive($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setMain($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setFrontSymbol($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setBackSymbol($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setNbpExchange($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setSystem($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setOptName($arr[$keys[12]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(CurrencyPeer::DATABASE_NAME);

		if ($this->isColumnModified(CurrencyPeer::CREATED_AT)) $criteria->add(CurrencyPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(CurrencyPeer::UPDATED_AT)) $criteria->add(CurrencyPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(CurrencyPeer::ID)) $criteria->add(CurrencyPeer::ID, $this->id);
		if ($this->isColumnModified(CurrencyPeer::CURRENCY_STANDARD_ID)) $criteria->add(CurrencyPeer::CURRENCY_STANDARD_ID, $this->currency_standard_id);
		if ($this->isColumnModified(CurrencyPeer::SHORTCUT)) $criteria->add(CurrencyPeer::SHORTCUT, $this->shortcut);
		if ($this->isColumnModified(CurrencyPeer::EXCHANGE)) $criteria->add(CurrencyPeer::EXCHANGE, $this->exchange);
		if ($this->isColumnModified(CurrencyPeer::ACTIVE)) $criteria->add(CurrencyPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(CurrencyPeer::MAIN)) $criteria->add(CurrencyPeer::MAIN, $this->main);
		if ($this->isColumnModified(CurrencyPeer::FRONT_SYMBOL)) $criteria->add(CurrencyPeer::FRONT_SYMBOL, $this->front_symbol);
		if ($this->isColumnModified(CurrencyPeer::BACK_SYMBOL)) $criteria->add(CurrencyPeer::BACK_SYMBOL, $this->back_symbol);
		if ($this->isColumnModified(CurrencyPeer::NBP_EXCHANGE)) $criteria->add(CurrencyPeer::NBP_EXCHANGE, $this->nbp_exchange);
		if ($this->isColumnModified(CurrencyPeer::SYSTEM)) $criteria->add(CurrencyPeer::SYSTEM, $this->system);
		if ($this->isColumnModified(CurrencyPeer::OPT_NAME)) $criteria->add(CurrencyPeer::OPT_NAME, $this->opt_name);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(CurrencyPeer::DATABASE_NAME);

		$criteria->add(CurrencyPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCurrencyStandardId($this->currency_standard_id);

		$copyObj->setShortcut($this->shortcut);

		$copyObj->setExchange($this->exchange);

		$copyObj->setActive($this->active);

		$copyObj->setMain($this->main);

		$copyObj->setFrontSymbol($this->front_symbol);

		$copyObj->setBackSymbol($this->back_symbol);

		$copyObj->setNbpExchange($this->nbp_exchange);

		$copyObj->setSystem($this->system);

		$copyObj->setOptName($this->opt_name);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getLanguages() as $relObj) {
				$copyObj->addLanguage($relObj->copy($deepCopy));
			}

			foreach($this->getProducts() as $relObj) {
				$copyObj->addProduct($relObj->copy($deepCopy));
			}

			foreach($this->getGiftCards() as $relObj) {
				$copyObj->addGiftCard($relObj->copy($deepCopy));
			}

			foreach($this->getCurrencyI18ns() as $relObj) {
				$copyObj->addCurrencyI18n($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new CurrencyPeer();
		}
		return self::$peer;
	}

	
	public function setCurrencyStandard($v)
	{


		if ($v === null) {
			$this->setCurrencyStandardId(NULL);
		} else {
			$this->setCurrencyStandardId($v->getId());
		}


		$this->aCurrencyStandard = $v;
	}


	
	public function getCurrencyStandard($con = null)
	{
		if ($this->aCurrencyStandard === null && ($this->currency_standard_id !== null)) {
						$this->aCurrencyStandard = CurrencyStandardPeer::retrieveByPK($this->currency_standard_id, $con);

			
		}
		return $this->aCurrencyStandard;
	}

	
	public function initLanguages()
	{
		if ($this->collLanguages === null) {
			$this->collLanguages = array();
		}
	}

	
	public function getLanguages($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collLanguages === null) {
			if ($this->isNew()) {
			   $this->collLanguages = array();
			} else {

				$criteria->add(LanguagePeer::CURRENCY_ID, $this->getId());

				LanguagePeer::addSelectColumns($criteria);
				$this->collLanguages = LanguagePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(LanguagePeer::CURRENCY_ID, $this->getId());

				LanguagePeer::addSelectColumns($criteria);
				if (!isset($this->lastLanguageCriteria) || !$this->lastLanguageCriteria->equals($criteria)) {
					$this->collLanguages = LanguagePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastLanguageCriteria = $criteria;
		return $this->collLanguages;
	}

	
	public function countLanguages($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(LanguagePeer::CURRENCY_ID, $this->getId());

		return LanguagePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addLanguage(Language $l)
	{
		$this->collLanguages[] = $l;
		$l->setCurrency($this);
	}

	
	public function initProducts()
	{
		if ($this->collProducts === null) {
			$this->collProducts = array();
		}
	}

	
	public function getProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
			   $this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				$this->collProducts = ProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

				ProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
					$this->collProducts = ProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastProductCriteria = $criteria;
		return $this->collProducts;
	}

	
	public function countProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

		return ProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addProduct(Product $l)
	{
		$this->collProducts[] = $l;
		$l->setCurrency($this);
	}


	
	public function getProductsJoinProductRelatedByParentId($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinProductRelatedByParentId($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinProducer($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinProducer($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinAvailability($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinAvailability($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}


	
	public function getProductsJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collProducts === null) {
			if ($this->isNew()) {
				$this->collProducts = array();
			} else {

				$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

				$this->collProducts = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(ProductPeer::CURRENCY_ID, $this->getId());

			if (!isset($this->lastProductCriteria) || !$this->lastProductCriteria->equals($criteria)) {
				$this->collProducts = ProductPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastProductCriteria = $criteria;

		return $this->collProducts;
	}

	
	public function initGiftCards()
	{
		if ($this->collGiftCards === null) {
			$this->collGiftCards = array();
		}
	}

	
	public function getGiftCards($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collGiftCards === null) {
			if ($this->isNew()) {
			   $this->collGiftCards = array();
			} else {

				$criteria->add(GiftCardPeer::CURRENCY_ID, $this->getId());

				GiftCardPeer::addSelectColumns($criteria);
				$this->collGiftCards = GiftCardPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(GiftCardPeer::CURRENCY_ID, $this->getId());

				GiftCardPeer::addSelectColumns($criteria);
				if (!isset($this->lastGiftCardCriteria) || !$this->lastGiftCardCriteria->equals($criteria)) {
					$this->collGiftCards = GiftCardPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastGiftCardCriteria = $criteria;
		return $this->collGiftCards;
	}

	
	public function countGiftCards($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(GiftCardPeer::CURRENCY_ID, $this->getId());

		return GiftCardPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addGiftCard(GiftCard $l)
	{
		$this->collGiftCards[] = $l;
		$l->setCurrency($this);
	}

	
	public function initCurrencyI18ns()
	{
		if ($this->collCurrencyI18ns === null) {
			$this->collCurrencyI18ns = array();
		}
	}

	
	public function getCurrencyI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collCurrencyI18ns === null) {
			if ($this->isNew()) {
			   $this->collCurrencyI18ns = array();
			} else {

				$criteria->add(CurrencyI18nPeer::ID, $this->getId());

				CurrencyI18nPeer::addSelectColumns($criteria);
				$this->collCurrencyI18ns = CurrencyI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(CurrencyI18nPeer::ID, $this->getId());

				CurrencyI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastCurrencyI18nCriteria) || !$this->lastCurrencyI18nCriteria->equals($criteria)) {
					$this->collCurrencyI18ns = CurrencyI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastCurrencyI18nCriteria = $criteria;
		return $this->collCurrencyI18ns;
	}

	
	public function countCurrencyI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(CurrencyI18nPeer::ID, $this->getId());

		return CurrencyI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addCurrencyI18n(CurrencyI18n $l)
	{
		$this->collCurrencyI18ns[] = $l;
		$l->setCurrency($this);
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentCurrencyI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentCurrencyI18n()->setName($value);
  }

  protected $current_i18n = array();

  public function getCurrentCurrencyI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = CurrencyI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setCurrencyI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setCurrencyI18nForCulture(new CurrencyI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setCurrencyI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addCurrencyI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Currency.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseCurrency:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseCurrency::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 