<?php
/** 
 * SOTESHOP/stCurrencyPlugin 
 * 
 * Ten plik należy do aplikacji stCurrencyPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stCurrencyPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stExchangeNBP.class.php 97 2009-08-26 08:04:10Z marcin $
 * @author      Marcin Olejniczak <marcin.olejniczak@sote.pl>
 */

/** 
 * Klasa do obsługi plików xml z kursami walut udostępnianych przez NBP 
 *
 * @package     stCurrencyPlugin
 * @subpackage  libs
 */
class ExchangeNBP
{
    /** 
     * Tablica z wszystkimi kursami zczytanymi z XML
     * @var array
     */
    private $arrCoinage = array();

    /** 
     * Przechowuje nazwą aktualnego pliku XML 
     */
    public $todayXMLFile = null;

    /** 
     * Zmienna zawierająca datę aktualizacji kursów 
     * @var string
     */
    private $strData;

    /** 
     * Pobieranie dzisiejszego XMLa
     *
     * @return   $todayXMLFile
     */
    public function getTodayXML()
    {
        $remoteDirInfo = @file_get_contents('http://nbp.pl/kursy/xml/dir.txt');

        if ($remoteDirInfo === false)
        {
            echo 'Błąd podczas otwierania zdalnego pliku z informacją o katalogu! System przerwał pracę.';
            return false;
        };

        $remoteDirInfo = explode("\r\n", $remoteDirInfo);

        //usunięcie ostatniego pustego elementu tablicy, jeżli tego nie błdzie, pojawi się
        //"Notice:  Uninitialized string offset:  0"
        array_pop($remoteDirInfo);

        //wyszukiwanie elementów z 'c' ("Tabela kursów średnich walut obcych")
        $todayXMLFile = array_filter($remoteDirInfo, array($this, 'searchB'));
        $todayXMLFile = array_pop($todayXMLFile);
        return $todayXMLFile;

    }

    /** 
     * funkcja zwrotna wywoływana przez array_filter w $this->getTodayXML() 
     * wyszukuje wszystkie elementy, w których pierwsza litera to "b" (oznaczenie NBP dla 
     * plików XML zawierających "Tabelę kursów średnich walut obcych" 
     *
     * @param           str         $data
     * @return   str
     */
    private function searchB($data)
    {
        if ($data{0} == 'a')
        {
            return $data;
        };
    }
    
    /** 
     * Konstruktor parsuje xml'a do tablicy
     *
     * @param        string      $strEncoding
     * @param        string      $strUrlXml
     */
    public function __construct($strEncoding='UTF-8',$strUrlXml='http://www.nbp.pl/Kursy/xml/'){
        $strUrlXml=$strUrlXml.$this->getTodayXML() . '.xml';
        $objXml = new XMLReader();
        if(function_exists('curl_init')){
            $objXml->XML($this->ccurl_fopen($strUrlXml));
        }
        else
        {
            $objXml->open($strUrlXml);
        }
        $j=0;
        while($objXml->read())
        {
            if($objXml->name === 'data_publikacji' && $objXml->nodeType==1)
            {
                $objXml->read();
                $this->strData=$objXml->value;
            }
            if($objXml->depth==3)
            {
                if($j==4)
                {
                    $j=0;
                    $this -> arrCoinage[$arrCurrency[2]]=$arrCurrency;
                    $arrCurrency=array();
                }
                if($strEncoding!='ISO-8859-2')
                {
                    $arrCurrency[$j]=iconv('UTF-8',$strEncoding,$objXml->value);
                }
                else
                {
                    $arrCurrency[$j]=$objXml->value;
                }
                $j++;
            }
        }
    }

    /** 
     * Otwieranie pliku
     * Metoda otwiera plik i zwraca jego zawartość
     *
     * @param        string      $strUrl
     * @return   mixed
     */
    private function ccurl_fopen ($strUrl)
    {
        $strUser_agent = "Mozilla/8.0 (Windows 2008 SP32 + 3patch)";
        $resCh = curl_init();
        curl_setopt ($resCh, CURLOPT_URL, $strUrl);
        curl_setopt ($resCh, CURLOPT_USERAGENT, $strUser_agent);
        curl_setopt ($resCh, CURLOPT_COOKIEJAR, "cookie.txt");
        curl_setopt ($resCh, CURLOPT_HEADER, 0);
        curl_setopt ($resCh, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($resCh, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt ($resCh, CURLOPT_TIMEOUT, 120);
        $mixResult = curl_exec ($resCh);
        curl_close($resCh);
        return $mixResult;
    }

    /** 
     * Aktualna nazwa pliku XML z danymi
     *
     * @param        string      $strTable
     * @return   string
     */
    private function current_xml($strTable='a')
    {
        $resConnection = fsockopen ( "www.nbp.pl", 80 );
        $strHeaders  = 'GET /Kursy/xml/dir.txt HTTP/1.0' . "rn";
        $strHeaders .= 'Host: www.nbp.pl' . "rn";
        $strHeaders .= 'User-Agent: Mozilla/8.0 (Windows; U; Windows NT 5.1; pl-PL; rv:1.7.10) Gecko/20050717 Firefox/1.0.6' . "rnrn";

        fputs ( $resConnection, $strHeaders );
        while ( ! feof ( $resConnection ) )
        {
            $arrFilesXML[] = fgets ( $resConnection, 128 );
        }
        fclose ( $resConnection );

        $arrFilesXML = array_reverse ($arrFilesXML);
        for($i=0; $i<=3; $i++)
        {
            $strName=trim($arrFilesXML[$i]);
            $strTodayXML=trim($arrFilesXML[$i]);
        }
        return $strTodayXML;
    }

    /** 
     * Zwraca wybrane waluty
     * Metoda zwraca informacje o podanych w parametrze walutach
     *
     * @param         mixed       $mixCurrency
     * @return   array
     */
    public function return_currency($mixCurrency=array())
    {
        if(is_array($mixCurrency) && count($mixCurrency)==0)
        {
            return $this->arrCoinage;
        }
        elseif(!is_array($mixCurrency))
        {
            if(array_key_exists($mixCurrency,$this->arrCoinage))
            return $this->arrCoinage[$mixCurrency];
            return FALSE;
        }
        else
        {
            foreach($this->arrCoinage AS $strKey => $arrWartosc)
            {
                if(in_array($strKey,$mixCurrency))
                $arrResult[$strKey]=$this->arrCoinage[$strKey];
            }
            if(count($arrResult)>0)
            return $arrResult;
            return FALSE;
        }
        return FALSE;
    }

    /** 
     * Data aktualizacji kursów 
     *
     * @return   string
     */
    public function getData(){
        return $this->strData;
    }

}
