<?php
/** 
 * SOTESHOP/stCurrencyPlugin 
 * 
 * Ten plik należy do aplikacji stCurrencyPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stCurrencyPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stPluginCurrencyBackendActions.class.php 4902 2010-05-12 09:22:13Z marcin $
 * @author      Marcin Olejniczak <marcin.olejniczak@sote.pl>
 */

/** 
 * stCurrencyBackend actions.
 *
 * @package     stCurrencyPlugin
 * @subpackage  libs
 */
class stPluginCurrencyBackendActions extends autostCurrencyBackendActions
{
    /** 
     * Zapisywanie $currency z warunkami
     *
     * @param     $currency
     */
//    public function saveCurrency($currency)
//    {
//        $this->getRequest()->getMethod() == sfRequest::POST;
//
//        $current = $this->getRequestParameter('currency');
//
//        $id_currency = $this->getRequestParameter('id');
//
//        $currencyy = CurrencyPeer::retrieveByPK($id_currency);
//
//        //jesli zapisywana waluta jest walutą główną to ustawia zmienna main
//        if ($currencyy)
//        {
//            $main = $currencyy->getMain();
//        }
//        else
//        {
//            $main = 0;
//        }
//
//        if ((!isset($current['active'])) and $main)
//        {
//            $this->setFlash('notice', 'Waluta główna nie może być odznaczona.');
//            $this->redirect('stCurrencyBackend/edit?id=' . $id_currency);
//        }
//        // jesli zapisywana waluta jest walutą główną to nie można jej odznaczyc
//        if (($main == 1) and (!isset($current['main'])))
//        {
//            $this->setFlash('notice', 'Waluta główna nie może być odznaczona.');
//            $this->redirect('stCurrencyBackend/edit?id=' . $id_currency);
//        }
//        else
//        {
//            // sprawdza czy podany kurs jest większy niz 0.00001
//            if (! $current['exchange'] <= 0.00001)
//            {
//                // jesli jest zaznaczona jako waluta głowna to odznacza obecna
//                if (isset($current['main']))
//                {
//                    $c = new Criteria();
//                    $c->add(CurrencyPeer::MAIN, '1');
//                    $currency_main = CurrencyPeer::doSelectOne($c);
//                    if ($currency_main)
//                    {
//                        $currency_main = CurrencyPeer::retrieveByPK($currency_main->getId());
//                        $currency_main->setMain('0');
//                        $currency_main->save();
//                    }
//                }
//            }
//        }
//
////        die(print_r($currency, true));
//
//        parent::saveCurrency($currency);
//    }

    /** 
     * Synchronizacja z NBP
     */
    public function executeSynchronizeNbp()
    {
        $c = new Criteria();
        $criterion = $c->getOrderByColumns('id');
        $currencies = CurrencyPeer::doSelect($c);

        foreach ($currencies as $currency)
        {
            if ($currency->getMain())
            {
                $currency->setNbpExchange(1);
            }
            else
            {
                $shortcut = $currency->getShortcut();
                $rate = new ExchangeNBP();
                $coinage = $rate->return_currency($shortcut);
                $coinage = preg_replace('/,/', '.', $coinage[3]);
                $currency->setNbpExchange($coinage);
            }
            $currency->save();
        }
        $this->redirect('currency');
    }

    /** 
     * Zapisywanie kursów NBP do bazy
     */
    public function executeSaveNbp()
    {
        $c = new Criteria();
        $criterion = $c->getOrderByColumns('id');
        $currencies = CurrencyPeer::doSelect($c);

        foreach ($currencies as $currency)
        {
            $nbp = $currency->getNbpExchange();
            $current = CurrencyPeer::retrieveByPK($currency->getId());
            if ($currency->getNbpExchange() == '')
            {
                $current->setExchange(1);
            } else
            {
                $current->setExchange($currency->getNbpExchange());
            }
            $current->save();
        }
        $this->redirect('currency');
    }

    /** 
     * Zapisywanie pojedyńczych kursów NBP do bazy
     */
    public function executeSaveOneNbp()
    {
        $id_currency = $this->getRequestParameter('id');
        $current = CurrencyPeer::retrieveByPK($id_currency);
        if ($current->getNbpExchange() == '')
        {
            $current->setExchange(1);
        }
        else
        {
            $current->setExchange($current->getNbpExchange());
        }
        $current->save();
        $this->redirect('currency');
    }
    
    /** 
     * Usuwanie $currency z warunkami
     *
     * @param       integer     $id
     * @return  true        or false
     */
    protected function processDelete($id)
    {
        $config = stConfig::getInstance(sfContext::getInstance(), array('main_currency' => stConfig::STRING ), 'stCurrencyPlugin');
        $config->load();
        $config_main = $config->get('main_currency'); 
        $this->currency = CurrencyPeer::retrieveByPk($id);
        $this->forward404Unless($this->currency);
        if ($this->currency->getId()==$config_main)
        {
            $this->getRequest()->setError('delete', 'Nie można usunąć waluty głównej.');
            $this->forward('stCurrencyBackend', 'list');
            return false;
        }
        if ($this->currency->getMain()==1)
        {
            $this->getRequest()->setError('delete', 'Nie można usunąć waluty domyślnej.');
            $this->forward('stCurrencyBackend', 'list');
            return false;
        }
        
        try
        {
          $this->deleteCurrency($this->currency);
        }
        catch (PropelException $e)
        {
          $this->getRequest()->setError('delete', 'Could not delete the selected Currency. Make sure it does not have any associated items.');
          $this->redirect('stCurrencyBackend', 'edit');
          return false;
        }

  
    return true;
  }
}
