<?php
/** 
 * SOTESHOP/stCurrencyPlugin 
 * 
 * Ten plik należy do aplikacji stCurrencyPlugin opartej na licencji (Open License SOTE) Otwarta Licencja SOTE. 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stCurrencyPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/open (Open License SOTE) Otwarta Licencja SOTE
 * @version     $Id: stPluginCurrencyFrontendActions.class.php 6088 2010-07-06 14:43:52Z marek $
 * @author      Marcin Olejniczak <marcin.olejniczak@sote.pl>
 */

/** 
 * Akcje modułu stCurrencyFrontend
 *
 * @package     stCurrencyPlugin
 * @subpackage  libs
 */
class stPluginCurrencyFrontendActions extends stActions
{
    /** 
     * Funkcja zapisujaca wybrana walute
     */
    public function executeAddCurrency()
    {
        $referer = $this->getRequest()->getReferer();
        $currency = stCurrency::getInstance($this->getContext());
        $currency->set($this->getRequestParameter('currency'));
        stCacheManager::remove('sf_cache_partial/stCurrencyFrontend/_pickCurrency/*');
        
        // disable Fast Cache for this session if currency is different that default
        stFastCacheController::disable();
        
        $this->redirect($referer);
    }
}
