<?php
/**
 * SOTESHOP/stDelivery
 *
 * Ten plik należy do aplikacji stDelivery opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stDelivery
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: Delivery.php 10244 2011-01-13 14:26:05Z michal $
 * @author      Marcin Olejniczak <marcin.olejniczak@sote.pl>
 */

/**
 * Subclass for representing a row from the 'st_delivery' table.
 *
 * @package     stDelivery
 * @subpackage  libs
 */
class Delivery extends BaseDelivery
{
    protected static $currency = null;

    public function  __construct()
    {
        if (null === self::$currency && SF_APP == 'frontend')
        {
            self::$currency = stCurrency::getInstance(sfContext::getInstance())->get();
        }
    }

    public function __toString()
    {
        return $this->getName();
    }

    public function getMaxOrderWeight()
    {
        return $this->format(parent::getMaxOrderWeight());
    }

    public function getMaxOrderAmount()
    {
        return $this->format(parent::getMaxOrderAmount());
    }

    public function getMinOrderWeight()
    {
        return $this->format(parent::getMinOrderWeight());
    }

    public function getMinOrderAmount()
    {
        return $this->format(parent::getMinOrderAmount());
    }

    public function getDefaultCost()
    {
        return $this->format(parent::getDefaultCost());
    }

    public function getCostNetto($with_currency = false)
    {
        $v = $this->getDefaultCost();

        if ($with_currency)
        {
            $v = self::$currency->exchange($v);
        }

        return $v;
    }

    public function setCostNetto($v)
    {
        $this->setDefaultCost($v);
    }

    public function getCostBrutto($with_currency = false)
    {
        $v =  $this->getDefaultCostBrutto();

        if (null === $v)
        {
            $v = stPrice::calculate($this->getCostNetto(), $this->getTax()->getVat());

            $this->setCostBrutto($v);
        }

        if ($with_currency)
        {
            $v = self::$currency->exchange($v);
        }

        return $this->format($v);
    }

    public function setCostBrutto($v)
    {
        $this->setDefaultCostBrutto($v);
    }

    public function getFreeFrom()
    {
        return $this->format($this->getFreeDelivery());
    }

    public function setFreeFrom($v)
    {
        $this->setFreeDelivery($v);
    }

    public function getSectionCostTypeDesc()
    {
        $tmp = DeliverySectionsPeer::getAdditionalSectionCosts();

        return $this->getSectionCostType() ? $tmp[$this->getSectionCostType()] : null;
    }

    /**
     *
     * Dodana na potrzeby admin generator
     *
     * @param int $v Id vat
     */
    public function setEditTax($v)
    {
        $this->setTaxId($v);
    }

    public function getTax($con = null)
    {
        $this->aTax = parent::getTax($con);

        if (null === $this->aTax)
        {
            $this->aTax = TaxPeer::doSelectDefaultOne(new Criteria());
        }

        return $this->aTax;
    }


    /**
     * Przeciążenie hydrate
     *
     * @param ResultSet $rs
     * @param int $startcol
     * @return object
     */
    public function hydrate(ResultSet $rs, $startcol = 1)
    {
        $this->setCulture(stLanguage::getHydrateCulture());

        return parent::hydrate($rs, $startcol);
    }

    /**
     * Przeciążenie getName
     *
     * @return string
     */
    public function getName()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);
        }

        $v = parent::getName();

        if (is_null($v))
        {
            $v = stLanguage::getDefaultValue($this, __METHOD__);
        }

        return $v;
    }

    /**
     * Przeciążenie setName
     *
     * @param string $v Nazwa producenta
     */
    public function setName($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }

        parent::setName($v);
    }

    /**
     * Przeciążenie getDescription
     *
     * @return string
     */
    public function getDescription()
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            return stLanguage::getDefaultValue($this, __METHOD__);
        }

        $v = parent::getDescription();

        if (is_null($v))
        {
            $v = stLanguage::getDefaultValue($this, __METHOD__);
        }

        return $v;
    }

    /**
     * Przeciążenie setDescription
     *
     * @param string $v Nazwa producenta
     */
    public function setDescription($v)
    {
        if ($this->getCulture() == stLanguage::getOptLanguage())
        {
            stLanguage::setDefaultValue($this, __METHOD__, $v);
        }

        parent::setDescription($v);
    }

    public function save($con = null)
    {
        if ($this->getIsDefault() && $this->isColumnModified(DeliveryPeer::IS_DEFAULT))
        {
            $c = new Criteria();

            $c->add(DeliveryPeer::COUNTRIES_AREA_ID, $this->getCountriesAreaId());

            $delivery = DeliveryPeer::doSelectDefault($c);

            if ($delivery)
            {
                $delivery->setIsDefault(false);

                $delivery->save($con);
            }
        }

        parent::save($con);
    }

    protected function format($v)
    {
        $v = $v ? $v : 0.00;

        if (is_numeric($v))
        {
            return stPrice::round($v);
        }

        return $v;
    }
}