<?php

/**
 * Subclass for performing query and update operations on the 'st_delivery' table.
 *
 *
 *
 * @package plugins.stDeliveryPlugin.lib.model
 */
class DeliveryPeer extends BaseDeliveryPeer
{
    public static function doSelectPaymentsWithDeliveryHasPaymentsByPK($pk, $con = null)
    {
        $c = new Criteria();

        $c->addJoin(PaymentTypePeer::ID, sprintf("%s AND %s = %d", DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID, DeliveryHasPaymentTypePeer::DELIVERY_ID, $pk), Criteria::LEFT_JOIN);

        $c->add(PaymentTypePeer::ACTIVE, true);

        $c->addDescendingOrderByColumn(DeliveryHasPaymentTypePeer::IS_ACTIVE);

        $c->addAscendingOrderByColumn(DeliveryHasPaymentTypePeer::ID);

        $joinHelper = new sfPropelCustomJoinHelper('PaymentType');

        $joinHelper->addSelectTables('DeliveryHasPaymentType');

        return $joinHelper->doSelect($c, $con);
    }

    public static function doSelectCountryAreaWithDeliveryHasCountryAreaByPK($pk, $con = null)
    {
        $c = new Criteria();

        $c->addJoin(CountriesAreaPeer::ID, sprintf("%s AND %s = %d", DeliveryHasCountriesAreaPeer::COUNTRIES_AREA_ID, DeliveryHasCountriesAreaPeer::DELIVERY_ID, $pk), Criteria::LEFT_JOIN);

        $c->addAscendingOrderByColumn(DeliveryHasCountriesAreaPeer::ID);

        $joinHelper = new sfPropelCustomJoinHelper('CountriesArea');

        $joinHelper->addSelectTables('DeliveryHasCountriesArea');

        return $joinHelper->doSelect($c, $con);
    }

    public static function doSelectDefault(Criteria $c, $con = null)
    {
        $criteria = clone $c;

        $criteria->add(self::IS_DEFAULT, true);

        return self::doSelectOne($criteria, $con);
    }
}
