<?php



class DeliveryMapBuilder {

	
	const CLASS_NAME = 'plugins.stDeliveryPlugin.lib.model.map.DeliveryMapBuilder';

	
	private $dbMap;

	
	public function isBuilt()
	{
		return ($this->dbMap !== null);
	}

	
	public function getDatabaseMap()
	{
		return $this->dbMap;
	}

	
	public function doBuild()
	{
		$this->dbMap = Propel::getDatabaseMap('propel');

		$tMap = $this->dbMap->addTable('st_delivery');
		$tMap->setPhpName('Delivery');

		$tMap->setUseIdGenerator(true);

		$tMap->addColumn('CREATED_AT', 'CreatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addColumn('UPDATED_AT', 'UpdatedAt', 'int', CreoleTypes::TIMESTAMP, false, null);

		$tMap->addPrimaryKey('ID', 'Id', 'int', CreoleTypes::INTEGER, true, null);

		$tMap->addForeignKey('COUNTRIES_AREA_ID', 'CountriesAreaId', 'int', CreoleTypes::INTEGER, 'st_countries_area', 'ID', false, null);

		$tMap->addForeignKey('TAX_ID', 'TaxId', 'int', CreoleTypes::INTEGER, 'st_tax', 'ID', false, null);

		$tMap->addColumn('FREE_DELIVERY', 'FreeDelivery', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('ACTIVE', 'Active', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('DEFAULT_COST', 'DefaultCost', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('DEFAULT_COST_BRUTTO', 'DefaultCostBrutto', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('IS_SYSTEM_DEFAULT', 'IsSystemDefault', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('OPT_NAME', 'OptName', 'string', CreoleTypes::VARCHAR, false, 255);

		$tMap->addColumn('OPT_DESCRIPTION', 'OptDescription', 'string', CreoleTypes::LONGVARCHAR, false, null);

		$tMap->addColumn('IS_DEFAULT', 'IsDefault', 'boolean', CreoleTypes::BOOLEAN, false, null);

		$tMap->addColumn('SECTION_COST_TYPE', 'SectionCostType', 'string', CreoleTypes::VARCHAR, false, 32);

		$tMap->addColumn('MAX_ORDER_WEIGHT', 'MaxOrderWeight', 'double', CreoleTypes::DECIMAL, false, 6);

		$tMap->addColumn('MAX_ORDER_AMOUNT', 'MaxOrderAmount', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('MAX_ORDER_QUANTITY', 'MaxOrderQuantity', 'int', CreoleTypes::INTEGER, false, null);

		$tMap->addColumn('MIN_ORDER_WEIGHT', 'MinOrderWeight', 'double', CreoleTypes::DECIMAL, false, 6);

		$tMap->addColumn('MIN_ORDER_AMOUNT', 'MinOrderAmount', 'double', CreoleTypes::DECIMAL, false, 10);

		$tMap->addColumn('MIN_ORDER_QUANTITY', 'MinOrderQuantity', 'int', CreoleTypes::INTEGER, false, null);

	} 
} 