<?php


abstract class BaseDelivery extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $countries_area_id;


	
	protected $tax_id;


	
	protected $free_delivery = 0;


	
	protected $active;


	
	protected $default_cost = 0;


	
	protected $default_cost_brutto;


	
	protected $is_system_default = false;


	
	protected $opt_name;


	
	protected $opt_description;


	
	protected $is_default = false;


	
	protected $section_cost_type;


	
	protected $max_order_weight = 0;


	
	protected $max_order_amount = 0;


	
	protected $max_order_quantity = 0;


	
	protected $min_order_weight = 0;


	
	protected $min_order_amount = 0;


	
	protected $min_order_quantity = 0;

	
	protected $aCountriesArea;

	
	protected $aTax;

	
	protected $collDeliverySectionss;

	
	protected $lastDeliverySectionsCriteria = null;

	
	protected $collDeliveryHasPaymentTypes;

	
	protected $lastDeliveryHasPaymentTypeCriteria = null;

	
	protected $collDeliveryI18ns;

	
	protected $lastDeliveryI18nCriteria = null;

	
	protected $collOrderDeliverys;

	
	protected $lastOrderDeliveryCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

  
  protected $culture;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getCountriesAreaId()
    {

            return $this->countries_area_id;
    }

    
    public function getTaxId()
    {

            return $this->tax_id;
    }

    
    public function getFreeDelivery()
    {

            return null !== $this->free_delivery ? (string)$this->free_delivery : null;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getDefaultCost()
    {

            return null !== $this->default_cost ? (string)$this->default_cost : null;
    }

    
    public function getDefaultCostBrutto()
    {

            return null !== $this->default_cost_brutto ? (string)$this->default_cost_brutto : null;
    }

    
    public function getIsSystemDefault()
    {

            return $this->is_system_default;
    }

    
    public function getOptName()
    {

            return $this->opt_name;
    }

    
    public function getOptDescription()
    {

            return $this->opt_description;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getSectionCostType()
    {

            return $this->section_cost_type;
    }

    
    public function getMaxOrderWeight()
    {

            return null !== $this->max_order_weight ? (string)$this->max_order_weight : null;
    }

    
    public function getMaxOrderAmount()
    {

            return null !== $this->max_order_amount ? (string)$this->max_order_amount : null;
    }

    
    public function getMaxOrderQuantity()
    {

            return $this->max_order_quantity;
    }

    
    public function getMinOrderWeight()
    {

            return null !== $this->min_order_weight ? (string)$this->min_order_weight : null;
    }

    
    public function getMinOrderAmount()
    {

            return null !== $this->min_order_amount ? (string)$this->min_order_amount : null;
    }

    
    public function getMinOrderQuantity()
    {

            return $this->min_order_quantity;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = DeliveryPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = DeliveryPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = DeliveryPeer::ID;
        }

	} 
	
	public function setCountriesAreaId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->countries_area_id !== $v) {
          $this->countries_area_id = $v;
          $this->modifiedColumns[] = DeliveryPeer::COUNTRIES_AREA_ID;
        }

		if ($this->aCountriesArea !== null && $this->aCountriesArea->getId() !== $v) {
			$this->aCountriesArea = null;
		}

	} 
	
	public function setTaxId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->tax_id !== $v) {
          $this->tax_id = $v;
          $this->modifiedColumns[] = DeliveryPeer::TAX_ID;
        }

		if ($this->aTax !== null && $this->aTax->getId() !== $v) {
			$this->aTax = null;
		}

	} 
	
	public function setFreeDelivery($v)
	{

        if ($this->free_delivery !== $v || $v === 0) {
          $this->free_delivery = $v;
          $this->modifiedColumns[] = DeliveryPeer::FREE_DELIVERY;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v) {
          $this->active = $v;
          $this->modifiedColumns[] = DeliveryPeer::ACTIVE;
        }

	} 
	
	public function setDefaultCost($v)
	{

        if ($this->default_cost !== $v || $v === 0) {
          $this->default_cost = $v;
          $this->modifiedColumns[] = DeliveryPeer::DEFAULT_COST;
        }

	} 
	
	public function setDefaultCostBrutto($v)
	{

        if ($this->default_cost_brutto !== $v) {
          $this->default_cost_brutto = $v;
          $this->modifiedColumns[] = DeliveryPeer::DEFAULT_COST_BRUTTO;
        }

	} 
	
	public function setIsSystemDefault($v)
	{

        if ($this->is_system_default !== $v || $v === false) {
          $this->is_system_default = $v;
          $this->modifiedColumns[] = DeliveryPeer::IS_SYSTEM_DEFAULT;
        }

	} 
	
	public function setOptName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_name !== $v) {
          $this->opt_name = $v;
          $this->modifiedColumns[] = DeliveryPeer::OPT_NAME;
        }

	} 
	
	public function setOptDescription($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->opt_description !== $v) {
          $this->opt_description = $v;
          $this->modifiedColumns[] = DeliveryPeer::OPT_DESCRIPTION;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = DeliveryPeer::IS_DEFAULT;
        }

	} 
	
	public function setSectionCostType($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->section_cost_type !== $v) {
          $this->section_cost_type = $v;
          $this->modifiedColumns[] = DeliveryPeer::SECTION_COST_TYPE;
        }

	} 
	
	public function setMaxOrderWeight($v)
	{

        if ($this->max_order_weight !== $v || $v === 0) {
          $this->max_order_weight = $v;
          $this->modifiedColumns[] = DeliveryPeer::MAX_ORDER_WEIGHT;
        }

	} 
	
	public function setMaxOrderAmount($v)
	{

        if ($this->max_order_amount !== $v || $v === 0) {
          $this->max_order_amount = $v;
          $this->modifiedColumns[] = DeliveryPeer::MAX_ORDER_AMOUNT;
        }

	} 
	
	public function setMaxOrderQuantity($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->max_order_quantity !== $v || $v === 0) {
          $this->max_order_quantity = $v;
          $this->modifiedColumns[] = DeliveryPeer::MAX_ORDER_QUANTITY;
        }

	} 
	
	public function setMinOrderWeight($v)
	{

        if ($this->min_order_weight !== $v || $v === 0) {
          $this->min_order_weight = $v;
          $this->modifiedColumns[] = DeliveryPeer::MIN_ORDER_WEIGHT;
        }

	} 
	
	public function setMinOrderAmount($v)
	{

        if ($this->min_order_amount !== $v || $v === 0) {
          $this->min_order_amount = $v;
          $this->modifiedColumns[] = DeliveryPeer::MIN_ORDER_AMOUNT;
        }

	} 
	
	public function setMinOrderQuantity($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->min_order_quantity !== $v || $v === 0) {
          $this->min_order_quantity = $v;
          $this->modifiedColumns[] = DeliveryPeer::MIN_ORDER_QUANTITY;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Delivery.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->countries_area_id = $rs->getInt($startcol + 3);

      $this->tax_id = $rs->getInt($startcol + 4);

      $this->free_delivery = $rs->getString($startcol + 5, null);

      $this->free_delivery = $rs->getFloat($startcol + 5);

      $this->active = $rs->getBoolean($startcol + 6);

      $this->default_cost = $rs->getString($startcol + 7, null);

      $this->default_cost = $rs->getFloat($startcol + 7);

      $this->default_cost_brutto = $rs->getString($startcol + 8, null);

      $this->default_cost_brutto = $rs->getFloat($startcol + 8);

      $this->is_system_default = $rs->getBoolean($startcol + 9);

      $this->opt_name = $rs->getString($startcol + 10);

      $this->opt_description = $rs->getString($startcol + 11);

      $this->is_default = $rs->getBoolean($startcol + 12);

      $this->section_cost_type = $rs->getString($startcol + 13);

      $this->max_order_weight = $rs->getString($startcol + 14, null);

      $this->max_order_weight = $rs->getFloat($startcol + 14);

      $this->max_order_amount = $rs->getString($startcol + 15, null);

      $this->max_order_amount = $rs->getFloat($startcol + 15);

      $this->max_order_quantity = $rs->getInt($startcol + 16);

      $this->min_order_weight = $rs->getString($startcol + 17, null);

      $this->min_order_weight = $rs->getFloat($startcol + 17);

      $this->min_order_amount = $rs->getString($startcol + 18, null);

      $this->min_order_amount = $rs->getFloat($startcol + 18);

      $this->min_order_quantity = $rs->getInt($startcol + 19);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Delivery.postHydrate', array('resultset' => $rs, 'startcol' => 20)));

            return $startcol + 20; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Delivery object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseDelivery:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DeliveryPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			DeliveryPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseDelivery:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Delivery.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseDelivery:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(DeliveryPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(DeliveryPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DeliveryPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Delivery.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseDelivery:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aCountriesArea !== null) {
				if ($this->aCountriesArea->isModified()) {
					$affectedRows += $this->aCountriesArea->save($con);
				}
				$this->setCountriesArea($this->aCountriesArea);
			}

			if ($this->aTax !== null) {
				if ($this->aTax->isModified()) {
					$affectedRows += $this->aTax->save($con);
				}
				$this->setTax($this->aTax);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = DeliveryPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += DeliveryPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collDeliverySectionss !== null) {
				foreach($this->collDeliverySectionss as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDeliveryHasPaymentTypes !== null) {
				foreach($this->collDeliveryHasPaymentTypes as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDeliveryI18ns !== null) {
				foreach($this->collDeliveryI18ns as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrderDeliverys !== null) {
				foreach($this->collOrderDeliverys as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aCountriesArea !== null) {
				if (!$this->aCountriesArea->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCountriesArea->getValidationFailures());
				}
			}

			if ($this->aTax !== null) {
				if (!$this->aTax->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aTax->getValidationFailures());
				}
			}


			if (($retval = DeliveryPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collDeliverySectionss !== null) {
					foreach($this->collDeliverySectionss as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDeliveryHasPaymentTypes !== null) {
					foreach($this->collDeliveryHasPaymentTypes as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDeliveryI18ns !== null) {
					foreach($this->collDeliveryI18ns as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrderDeliverys !== null) {
					foreach($this->collOrderDeliverys as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DeliveryPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getCountriesAreaId();
				break;
			case 4:
				return $this->getTaxId();
				break;
			case 5:
				return $this->getFreeDelivery();
				break;
			case 6:
				return $this->getActive();
				break;
			case 7:
				return $this->getDefaultCost();
				break;
			case 8:
				return $this->getDefaultCostBrutto();
				break;
			case 9:
				return $this->getIsSystemDefault();
				break;
			case 10:
				return $this->getOptName();
				break;
			case 11:
				return $this->getOptDescription();
				break;
			case 12:
				return $this->getIsDefault();
				break;
			case 13:
				return $this->getSectionCostType();
				break;
			case 14:
				return $this->getMaxOrderWeight();
				break;
			case 15:
				return $this->getMaxOrderAmount();
				break;
			case 16:
				return $this->getMaxOrderQuantity();
				break;
			case 17:
				return $this->getMinOrderWeight();
				break;
			case 18:
				return $this->getMinOrderAmount();
				break;
			case 19:
				return $this->getMinOrderQuantity();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DeliveryPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getCountriesAreaId(),
			$keys[4] => $this->getTaxId(),
			$keys[5] => $this->getFreeDelivery(),
			$keys[6] => $this->getActive(),
			$keys[7] => $this->getDefaultCost(),
			$keys[8] => $this->getDefaultCostBrutto(),
			$keys[9] => $this->getIsSystemDefault(),
			$keys[10] => $this->getOptName(),
			$keys[11] => $this->getOptDescription(),
			$keys[12] => $this->getIsDefault(),
			$keys[13] => $this->getSectionCostType(),
			$keys[14] => $this->getMaxOrderWeight(),
			$keys[15] => $this->getMaxOrderAmount(),
			$keys[16] => $this->getMaxOrderQuantity(),
			$keys[17] => $this->getMinOrderWeight(),
			$keys[18] => $this->getMinOrderAmount(),
			$keys[19] => $this->getMinOrderQuantity(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DeliveryPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setCountriesAreaId($value);
				break;
			case 4:
				$this->setTaxId($value);
				break;
			case 5:
				$this->setFreeDelivery($value);
				break;
			case 6:
				$this->setActive($value);
				break;
			case 7:
				$this->setDefaultCost($value);
				break;
			case 8:
				$this->setDefaultCostBrutto($value);
				break;
			case 9:
				$this->setIsSystemDefault($value);
				break;
			case 10:
				$this->setOptName($value);
				break;
			case 11:
				$this->setOptDescription($value);
				break;
			case 12:
				$this->setIsDefault($value);
				break;
			case 13:
				$this->setSectionCostType($value);
				break;
			case 14:
				$this->setMaxOrderWeight($value);
				break;
			case 15:
				$this->setMaxOrderAmount($value);
				break;
			case 16:
				$this->setMaxOrderQuantity($value);
				break;
			case 17:
				$this->setMinOrderWeight($value);
				break;
			case 18:
				$this->setMinOrderAmount($value);
				break;
			case 19:
				$this->setMinOrderQuantity($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DeliveryPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCountriesAreaId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setTaxId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setFreeDelivery($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setActive($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setDefaultCost($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setDefaultCostBrutto($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setIsSystemDefault($arr[$keys[9]]);
		if (array_key_exists($keys[10], $arr)) $this->setOptName($arr[$keys[10]]);
		if (array_key_exists($keys[11], $arr)) $this->setOptDescription($arr[$keys[11]]);
		if (array_key_exists($keys[12], $arr)) $this->setIsDefault($arr[$keys[12]]);
		if (array_key_exists($keys[13], $arr)) $this->setSectionCostType($arr[$keys[13]]);
		if (array_key_exists($keys[14], $arr)) $this->setMaxOrderWeight($arr[$keys[14]]);
		if (array_key_exists($keys[15], $arr)) $this->setMaxOrderAmount($arr[$keys[15]]);
		if (array_key_exists($keys[16], $arr)) $this->setMaxOrderQuantity($arr[$keys[16]]);
		if (array_key_exists($keys[17], $arr)) $this->setMinOrderWeight($arr[$keys[17]]);
		if (array_key_exists($keys[18], $arr)) $this->setMinOrderAmount($arr[$keys[18]]);
		if (array_key_exists($keys[19], $arr)) $this->setMinOrderQuantity($arr[$keys[19]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(DeliveryPeer::DATABASE_NAME);

		if ($this->isColumnModified(DeliveryPeer::CREATED_AT)) $criteria->add(DeliveryPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(DeliveryPeer::UPDATED_AT)) $criteria->add(DeliveryPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(DeliveryPeer::ID)) $criteria->add(DeliveryPeer::ID, $this->id);
		if ($this->isColumnModified(DeliveryPeer::COUNTRIES_AREA_ID)) $criteria->add(DeliveryPeer::COUNTRIES_AREA_ID, $this->countries_area_id);
		if ($this->isColumnModified(DeliveryPeer::TAX_ID)) $criteria->add(DeliveryPeer::TAX_ID, $this->tax_id);
		if ($this->isColumnModified(DeliveryPeer::FREE_DELIVERY)) $criteria->add(DeliveryPeer::FREE_DELIVERY, $this->free_delivery);
		if ($this->isColumnModified(DeliveryPeer::ACTIVE)) $criteria->add(DeliveryPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(DeliveryPeer::DEFAULT_COST)) $criteria->add(DeliveryPeer::DEFAULT_COST, $this->default_cost);
		if ($this->isColumnModified(DeliveryPeer::DEFAULT_COST_BRUTTO)) $criteria->add(DeliveryPeer::DEFAULT_COST_BRUTTO, $this->default_cost_brutto);
		if ($this->isColumnModified(DeliveryPeer::IS_SYSTEM_DEFAULT)) $criteria->add(DeliveryPeer::IS_SYSTEM_DEFAULT, $this->is_system_default);
		if ($this->isColumnModified(DeliveryPeer::OPT_NAME)) $criteria->add(DeliveryPeer::OPT_NAME, $this->opt_name);
		if ($this->isColumnModified(DeliveryPeer::OPT_DESCRIPTION)) $criteria->add(DeliveryPeer::OPT_DESCRIPTION, $this->opt_description);
		if ($this->isColumnModified(DeliveryPeer::IS_DEFAULT)) $criteria->add(DeliveryPeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(DeliveryPeer::SECTION_COST_TYPE)) $criteria->add(DeliveryPeer::SECTION_COST_TYPE, $this->section_cost_type);
		if ($this->isColumnModified(DeliveryPeer::MAX_ORDER_WEIGHT)) $criteria->add(DeliveryPeer::MAX_ORDER_WEIGHT, $this->max_order_weight);
		if ($this->isColumnModified(DeliveryPeer::MAX_ORDER_AMOUNT)) $criteria->add(DeliveryPeer::MAX_ORDER_AMOUNT, $this->max_order_amount);
		if ($this->isColumnModified(DeliveryPeer::MAX_ORDER_QUANTITY)) $criteria->add(DeliveryPeer::MAX_ORDER_QUANTITY, $this->max_order_quantity);
		if ($this->isColumnModified(DeliveryPeer::MIN_ORDER_WEIGHT)) $criteria->add(DeliveryPeer::MIN_ORDER_WEIGHT, $this->min_order_weight);
		if ($this->isColumnModified(DeliveryPeer::MIN_ORDER_AMOUNT)) $criteria->add(DeliveryPeer::MIN_ORDER_AMOUNT, $this->min_order_amount);
		if ($this->isColumnModified(DeliveryPeer::MIN_ORDER_QUANTITY)) $criteria->add(DeliveryPeer::MIN_ORDER_QUANTITY, $this->min_order_quantity);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(DeliveryPeer::DATABASE_NAME);

		$criteria->add(DeliveryPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setCountriesAreaId($this->countries_area_id);

		$copyObj->setTaxId($this->tax_id);

		$copyObj->setFreeDelivery($this->free_delivery);

		$copyObj->setActive($this->active);

		$copyObj->setDefaultCost($this->default_cost);

		$copyObj->setDefaultCostBrutto($this->default_cost_brutto);

		$copyObj->setIsSystemDefault($this->is_system_default);

		$copyObj->setOptName($this->opt_name);

		$copyObj->setOptDescription($this->opt_description);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setSectionCostType($this->section_cost_type);

		$copyObj->setMaxOrderWeight($this->max_order_weight);

		$copyObj->setMaxOrderAmount($this->max_order_amount);

		$copyObj->setMaxOrderQuantity($this->max_order_quantity);

		$copyObj->setMinOrderWeight($this->min_order_weight);

		$copyObj->setMinOrderAmount($this->min_order_amount);

		$copyObj->setMinOrderQuantity($this->min_order_quantity);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getDeliverySectionss() as $relObj) {
				$copyObj->addDeliverySections($relObj->copy($deepCopy));
			}

			foreach($this->getDeliveryHasPaymentTypes() as $relObj) {
				$copyObj->addDeliveryHasPaymentType($relObj->copy($deepCopy));
			}

			foreach($this->getDeliveryI18ns() as $relObj) {
				$copyObj->addDeliveryI18n($relObj->copy($deepCopy));
			}

			foreach($this->getOrderDeliverys() as $relObj) {
				$copyObj->addOrderDelivery($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new DeliveryPeer();
		}
		return self::$peer;
	}

	
	public function setCountriesArea($v)
	{


		if ($v === null) {
			$this->setCountriesAreaId(NULL);
		} else {
			$this->setCountriesAreaId($v->getId());
		}


		$this->aCountriesArea = $v;
	}


	
	public function getCountriesArea($con = null)
	{
		if ($this->aCountriesArea === null && ($this->countries_area_id !== null)) {
						$this->aCountriesArea = CountriesAreaPeer::retrieveByPK($this->countries_area_id, $con);

			
		}
		return $this->aCountriesArea;
	}

	
	public function setTax($v)
	{


		if ($v === null) {
			$this->setTaxId(NULL);
		} else {
			$this->setTaxId($v->getId());
		}


		$this->aTax = $v;
	}


	
	public function getTax($con = null)
	{
		if ($this->aTax === null && ($this->tax_id !== null)) {
						$this->aTax = TaxPeer::retrieveByPK($this->tax_id, $con);

			
		}
		return $this->aTax;
	}

	
	public function initDeliverySectionss()
	{
		if ($this->collDeliverySectionss === null) {
			$this->collDeliverySectionss = array();
		}
	}

	
	public function getDeliverySectionss($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverySectionss === null) {
			if ($this->isNew()) {
			   $this->collDeliverySectionss = array();
			} else {

				$criteria->add(DeliverySectionsPeer::DELIVERY_ID, $this->getId());

				DeliverySectionsPeer::addSelectColumns($criteria);
				$this->collDeliverySectionss = DeliverySectionsPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DeliverySectionsPeer::DELIVERY_ID, $this->getId());

				DeliverySectionsPeer::addSelectColumns($criteria);
				if (!isset($this->lastDeliverySectionsCriteria) || !$this->lastDeliverySectionsCriteria->equals($criteria)) {
					$this->collDeliverySectionss = DeliverySectionsPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDeliverySectionsCriteria = $criteria;
		return $this->collDeliverySectionss;
	}

	
	public function countDeliverySectionss($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DeliverySectionsPeer::DELIVERY_ID, $this->getId());

		return DeliverySectionsPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDeliverySections(DeliverySections $l)
	{
		$this->collDeliverySectionss[] = $l;
		$l->setDelivery($this);
	}


	
	public function getDeliverySectionssJoinAttributeField($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliverySectionss === null) {
			if ($this->isNew()) {
				$this->collDeliverySectionss = array();
			} else {

				$criteria->add(DeliverySectionsPeer::DELIVERY_ID, $this->getId());

				$this->collDeliverySectionss = DeliverySectionsPeer::doSelectJoinAttributeField($criteria, $con);
			}
		} else {
									
			$criteria->add(DeliverySectionsPeer::DELIVERY_ID, $this->getId());

			if (!isset($this->lastDeliverySectionsCriteria) || !$this->lastDeliverySectionsCriteria->equals($criteria)) {
				$this->collDeliverySectionss = DeliverySectionsPeer::doSelectJoinAttributeField($criteria, $con);
			}
		}
		$this->lastDeliverySectionsCriteria = $criteria;

		return $this->collDeliverySectionss;
	}

	
	public function initDeliveryHasPaymentTypes()
	{
		if ($this->collDeliveryHasPaymentTypes === null) {
			$this->collDeliveryHasPaymentTypes = array();
		}
	}

	
	public function getDeliveryHasPaymentTypes($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliveryHasPaymentTypes === null) {
			if ($this->isNew()) {
			   $this->collDeliveryHasPaymentTypes = array();
			} else {

				$criteria->add(DeliveryHasPaymentTypePeer::DELIVERY_ID, $this->getId());

				DeliveryHasPaymentTypePeer::addSelectColumns($criteria);
				$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DeliveryHasPaymentTypePeer::DELIVERY_ID, $this->getId());

				DeliveryHasPaymentTypePeer::addSelectColumns($criteria);
				if (!isset($this->lastDeliveryHasPaymentTypeCriteria) || !$this->lastDeliveryHasPaymentTypeCriteria->equals($criteria)) {
					$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDeliveryHasPaymentTypeCriteria = $criteria;
		return $this->collDeliveryHasPaymentTypes;
	}

	
	public function countDeliveryHasPaymentTypes($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DeliveryHasPaymentTypePeer::DELIVERY_ID, $this->getId());

		return DeliveryHasPaymentTypePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDeliveryHasPaymentType(DeliveryHasPaymentType $l)
	{
		$this->collDeliveryHasPaymentTypes[] = $l;
		$l->setDelivery($this);
	}


	
	public function getDeliveryHasPaymentTypesJoinPaymentType($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliveryHasPaymentTypes === null) {
			if ($this->isNew()) {
				$this->collDeliveryHasPaymentTypes = array();
			} else {

				$criteria->add(DeliveryHasPaymentTypePeer::DELIVERY_ID, $this->getId());

				$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelectJoinPaymentType($criteria, $con);
			}
		} else {
									
			$criteria->add(DeliveryHasPaymentTypePeer::DELIVERY_ID, $this->getId());

			if (!isset($this->lastDeliveryHasPaymentTypeCriteria) || !$this->lastDeliveryHasPaymentTypeCriteria->equals($criteria)) {
				$this->collDeliveryHasPaymentTypes = DeliveryHasPaymentTypePeer::doSelectJoinPaymentType($criteria, $con);
			}
		}
		$this->lastDeliveryHasPaymentTypeCriteria = $criteria;

		return $this->collDeliveryHasPaymentTypes;
	}

	
	public function initDeliveryI18ns()
	{
		if ($this->collDeliveryI18ns === null) {
			$this->collDeliveryI18ns = array();
		}
	}

	
	public function getDeliveryI18ns($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDeliveryI18ns === null) {
			if ($this->isNew()) {
			   $this->collDeliveryI18ns = array();
			} else {

				$criteria->add(DeliveryI18nPeer::ID, $this->getId());

				DeliveryI18nPeer::addSelectColumns($criteria);
				$this->collDeliveryI18ns = DeliveryI18nPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DeliveryI18nPeer::ID, $this->getId());

				DeliveryI18nPeer::addSelectColumns($criteria);
				if (!isset($this->lastDeliveryI18nCriteria) || !$this->lastDeliveryI18nCriteria->equals($criteria)) {
					$this->collDeliveryI18ns = DeliveryI18nPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDeliveryI18nCriteria = $criteria;
		return $this->collDeliveryI18ns;
	}

	
	public function countDeliveryI18ns($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DeliveryI18nPeer::ID, $this->getId());

		return DeliveryI18nPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDeliveryI18n(DeliveryI18n $l)
	{
		$this->collDeliveryI18ns[] = $l;
		$l->setDelivery($this);
	}

	
	public function initOrderDeliverys()
	{
		if ($this->collOrderDeliverys === null) {
			$this->collOrderDeliverys = array();
		}
	}

	
	public function getOrderDeliverys($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderDeliverys === null) {
			if ($this->isNew()) {
			   $this->collOrderDeliverys = array();
			} else {

				$criteria->add(OrderDeliveryPeer::DELIVERY_ID, $this->getId());

				OrderDeliveryPeer::addSelectColumns($criteria);
				$this->collOrderDeliverys = OrderDeliveryPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderDeliveryPeer::DELIVERY_ID, $this->getId());

				OrderDeliveryPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderDeliveryCriteria) || !$this->lastOrderDeliveryCriteria->equals($criteria)) {
					$this->collOrderDeliverys = OrderDeliveryPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderDeliveryCriteria = $criteria;
		return $this->collOrderDeliverys;
	}

	
	public function countOrderDeliverys($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderDeliveryPeer::DELIVERY_ID, $this->getId());

		return OrderDeliveryPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrderDelivery(OrderDelivery $l)
	{
		$this->collOrderDeliverys[] = $l;
		$l->setDelivery($this);
	}


	
	public function getOrderDeliverysJoinTax($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrderDeliverys === null) {
			if ($this->isNew()) {
				$this->collOrderDeliverys = array();
			} else {

				$criteria->add(OrderDeliveryPeer::DELIVERY_ID, $this->getId());

				$this->collOrderDeliverys = OrderDeliveryPeer::doSelectJoinTax($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderDeliveryPeer::DELIVERY_ID, $this->getId());

			if (!isset($this->lastOrderDeliveryCriteria) || !$this->lastOrderDeliveryCriteria->equals($criteria)) {
				$this->collOrderDeliverys = OrderDeliveryPeer::doSelectJoinTax($criteria, $con);
			}
		}
		$this->lastOrderDeliveryCriteria = $criteria;

		return $this->collOrderDeliverys;
	}

  public function getCulture()
  {
    return $this->culture;
  }

  public function setCulture($culture)
  {
    $this->culture = $culture;
  }

  public function getName()
  {
    $obj = $this->getCurrentDeliveryI18n();

    return ($obj ? $obj->getName() : null);
  }

  public function setName($value)
  {
    $this->getCurrentDeliveryI18n()->setName($value);
  }

  public function getDescription()
  {
    $obj = $this->getCurrentDeliveryI18n();

    return ($obj ? $obj->getDescription() : null);
  }

  public function setDescription($value)
  {
    $this->getCurrentDeliveryI18n()->setDescription($value);
  }

  protected $current_i18n = array();

  public function getCurrentDeliveryI18n()
  {
    if (!isset($this->current_i18n[$this->culture]))
    {
      $obj = DeliveryI18nPeer::retrieveByPK($this->getId(), $this->culture);
      if ($obj)
      {
        $this->setDeliveryI18nForCulture($obj, $this->culture);
      }
      else
      {
        $this->setDeliveryI18nForCulture(new DeliveryI18n(), $this->culture);
        $this->current_i18n[$this->culture]->setCulture($this->culture);
      }
    }

    return $this->current_i18n[$this->culture];
  }

  public function setDeliveryI18nForCulture($object, $culture)
  {
    $this->current_i18n[$culture] = $object;
    $this->addDeliveryI18n($object);
  }


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Delivery.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseDelivery:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseDelivery::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 