<?php


abstract class BaseDeliveryHasPaymentType extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $payment_type_id;


	
	protected $delivery_id;


	
	protected $is_active = false;


	
	protected $is_default = false;


	
	protected $cost = 0;


	
	protected $cost_brutto;


	
	protected $free_from = 0;

	
	protected $aPaymentType;

	
	protected $aDelivery;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getPaymentTypeId()
    {

            return $this->payment_type_id;
    }

    
    public function getDeliveryId()
    {

            return $this->delivery_id;
    }

    
    public function getIsActive()
    {

            return $this->is_active;
    }

    
    public function getIsDefault()
    {

            return $this->is_default;
    }

    
    public function getCost()
    {

            return null !== $this->cost ? (string)$this->cost : null;
    }

    
    public function getCostBrutto()
    {

            return null !== $this->cost_brutto ? (string)$this->cost_brutto : null;
    }

    
    public function getFreeFrom()
    {

            return null !== $this->free_from ? (string)$this->free_from : null;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = DeliveryHasPaymentTypePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = DeliveryHasPaymentTypePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::ID;
        }

	} 
	
	public function setPaymentTypeId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->payment_type_id !== $v) {
          $this->payment_type_id = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID;
        }

		if ($this->aPaymentType !== null && $this->aPaymentType->getId() !== $v) {
			$this->aPaymentType = null;
		}

	} 
	
	public function setDeliveryId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->delivery_id !== $v) {
          $this->delivery_id = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::DELIVERY_ID;
        }

		if ($this->aDelivery !== null && $this->aDelivery->getId() !== $v) {
			$this->aDelivery = null;
		}

	} 
	
	public function setIsActive($v)
	{

        if ($this->is_active !== $v || $v === false) {
          $this->is_active = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::IS_ACTIVE;
        }

	} 
	
	public function setIsDefault($v)
	{

        if ($this->is_default !== $v || $v === false) {
          $this->is_default = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::IS_DEFAULT;
        }

	} 
	
	public function setCost($v)
	{

        if ($this->cost !== $v || $v === 0) {
          $this->cost = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::COST;
        }

	} 
	
	public function setCostBrutto($v)
	{

        if ($this->cost_brutto !== $v) {
          $this->cost_brutto = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::COST_BRUTTO;
        }

	} 
	
	public function setFreeFrom($v)
	{

        if ($this->free_from !== $v || $v === 0) {
          $this->free_from = $v;
          $this->modifiedColumns[] = DeliveryHasPaymentTypePeer::FREE_FROM;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'DeliveryHasPaymentType.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->payment_type_id = $rs->getInt($startcol + 3);

      $this->delivery_id = $rs->getInt($startcol + 4);

      $this->is_active = $rs->getBoolean($startcol + 5);

      $this->is_default = $rs->getBoolean($startcol + 6);

      $this->cost = $rs->getString($startcol + 7, null);

      $this->cost = $rs->getFloat($startcol + 7);

      $this->cost_brutto = $rs->getString($startcol + 8, null);

      $this->cost_brutto = $rs->getFloat($startcol + 8);

      $this->free_from = $rs->getString($startcol + 9, null);

      $this->free_from = $rs->getFloat($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'DeliveryHasPaymentType.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating DeliveryHasPaymentType object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseDeliveryHasPaymentType:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DeliveryHasPaymentTypePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			DeliveryHasPaymentTypePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseDeliveryHasPaymentType:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'DeliveryHasPaymentType.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseDeliveryHasPaymentType:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(DeliveryHasPaymentTypePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(DeliveryHasPaymentTypePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DeliveryHasPaymentTypePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'DeliveryHasPaymentType.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseDeliveryHasPaymentType:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aPaymentType !== null) {
				if ($this->aPaymentType->isModified() || $this->aPaymentType->getCurrentPaymentTypeI18n()->isModified()) {
					$affectedRows += $this->aPaymentType->save($con);
				}
				$this->setPaymentType($this->aPaymentType);
			}

			if ($this->aDelivery !== null) {
				if ($this->aDelivery->isModified() || $this->aDelivery->getCurrentDeliveryI18n()->isModified()) {
					$affectedRows += $this->aDelivery->save($con);
				}
				$this->setDelivery($this->aDelivery);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = DeliveryHasPaymentTypePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += DeliveryHasPaymentTypePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aPaymentType !== null) {
				if (!$this->aPaymentType->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aPaymentType->getValidationFailures());
				}
			}

			if ($this->aDelivery !== null) {
				if (!$this->aDelivery->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aDelivery->getValidationFailures());
				}
			}


			if (($retval = DeliveryHasPaymentTypePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DeliveryHasPaymentTypePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getPaymentTypeId();
				break;
			case 4:
				return $this->getDeliveryId();
				break;
			case 5:
				return $this->getIsActive();
				break;
			case 6:
				return $this->getIsDefault();
				break;
			case 7:
				return $this->getCost();
				break;
			case 8:
				return $this->getCostBrutto();
				break;
			case 9:
				return $this->getFreeFrom();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DeliveryHasPaymentTypePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getPaymentTypeId(),
			$keys[4] => $this->getDeliveryId(),
			$keys[5] => $this->getIsActive(),
			$keys[6] => $this->getIsDefault(),
			$keys[7] => $this->getCost(),
			$keys[8] => $this->getCostBrutto(),
			$keys[9] => $this->getFreeFrom(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DeliveryHasPaymentTypePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setPaymentTypeId($value);
				break;
			case 4:
				$this->setDeliveryId($value);
				break;
			case 5:
				$this->setIsActive($value);
				break;
			case 6:
				$this->setIsDefault($value);
				break;
			case 7:
				$this->setCost($value);
				break;
			case 8:
				$this->setCostBrutto($value);
				break;
			case 9:
				$this->setFreeFrom($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DeliveryHasPaymentTypePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setPaymentTypeId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setDeliveryId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setIsActive($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setIsDefault($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setCost($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setCostBrutto($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setFreeFrom($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(DeliveryHasPaymentTypePeer::DATABASE_NAME);

		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::CREATED_AT)) $criteria->add(DeliveryHasPaymentTypePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::UPDATED_AT)) $criteria->add(DeliveryHasPaymentTypePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::ID)) $criteria->add(DeliveryHasPaymentTypePeer::ID, $this->id);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID)) $criteria->add(DeliveryHasPaymentTypePeer::PAYMENT_TYPE_ID, $this->payment_type_id);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::DELIVERY_ID)) $criteria->add(DeliveryHasPaymentTypePeer::DELIVERY_ID, $this->delivery_id);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::IS_ACTIVE)) $criteria->add(DeliveryHasPaymentTypePeer::IS_ACTIVE, $this->is_active);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::IS_DEFAULT)) $criteria->add(DeliveryHasPaymentTypePeer::IS_DEFAULT, $this->is_default);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::COST)) $criteria->add(DeliveryHasPaymentTypePeer::COST, $this->cost);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::COST_BRUTTO)) $criteria->add(DeliveryHasPaymentTypePeer::COST_BRUTTO, $this->cost_brutto);
		if ($this->isColumnModified(DeliveryHasPaymentTypePeer::FREE_FROM)) $criteria->add(DeliveryHasPaymentTypePeer::FREE_FROM, $this->free_from);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(DeliveryHasPaymentTypePeer::DATABASE_NAME);

		$criteria->add(DeliveryHasPaymentTypePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setPaymentTypeId($this->payment_type_id);

		$copyObj->setDeliveryId($this->delivery_id);

		$copyObj->setIsActive($this->is_active);

		$copyObj->setIsDefault($this->is_default);

		$copyObj->setCost($this->cost);

		$copyObj->setCostBrutto($this->cost_brutto);

		$copyObj->setFreeFrom($this->free_from);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new DeliveryHasPaymentTypePeer();
		}
		return self::$peer;
	}

	
	public function setPaymentType($v)
	{


		if ($v === null) {
			$this->setPaymentTypeId(NULL);
		} else {
			$this->setPaymentTypeId($v->getId());
		}


		$this->aPaymentType = $v;
	}


	
	public function getPaymentType($con = null)
	{
		if ($this->aPaymentType === null && ($this->payment_type_id !== null)) {
						$this->aPaymentType = PaymentTypePeer::retrieveByPK($this->payment_type_id, $con);

			
		}
		return $this->aPaymentType;
	}

	
	public function setDelivery($v)
	{


		if ($v === null) {
			$this->setDeliveryId(NULL);
		} else {
			$this->setDeliveryId($v->getId());
		}


		$this->aDelivery = $v;
	}


	
	public function getDelivery($con = null)
	{
		if ($this->aDelivery === null && ($this->delivery_id !== null)) {
						$this->aDelivery = DeliveryPeer::retrieveByPK($this->delivery_id, $con);

			
		}
		return $this->aDelivery;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'DeliveryHasPaymentType.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseDeliveryHasPaymentType:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseDeliveryHasPaymentType::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 