<?php


abstract class BaseDeliveryPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_delivery';

	
	const CLASS_DEFAULT = 'plugins.stDeliveryPlugin.lib.model.Delivery';

	
	const NUM_COLUMNS = 20;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const CREATED_AT = 'st_delivery.CREATED_AT';

	
	const UPDATED_AT = 'st_delivery.UPDATED_AT';

	
	const ID = 'st_delivery.ID';

	
	const COUNTRIES_AREA_ID = 'st_delivery.COUNTRIES_AREA_ID';

	
	const TAX_ID = 'st_delivery.TAX_ID';

	
	const FREE_DELIVERY = 'st_delivery.FREE_DELIVERY';

	
	const ACTIVE = 'st_delivery.ACTIVE';

	
	const DEFAULT_COST = 'st_delivery.DEFAULT_COST';

	
	const DEFAULT_COST_BRUTTO = 'st_delivery.DEFAULT_COST_BRUTTO';

	
	const IS_SYSTEM_DEFAULT = 'st_delivery.IS_SYSTEM_DEFAULT';

	
	const OPT_NAME = 'st_delivery.OPT_NAME';

	
	const OPT_DESCRIPTION = 'st_delivery.OPT_DESCRIPTION';

	
	const IS_DEFAULT = 'st_delivery.IS_DEFAULT';

	
	const SECTION_COST_TYPE = 'st_delivery.SECTION_COST_TYPE';

	
	const MAX_ORDER_WEIGHT = 'st_delivery.MAX_ORDER_WEIGHT';

	
	const MAX_ORDER_AMOUNT = 'st_delivery.MAX_ORDER_AMOUNT';

	
	const MAX_ORDER_QUANTITY = 'st_delivery.MAX_ORDER_QUANTITY';

	
	const MIN_ORDER_WEIGHT = 'st_delivery.MIN_ORDER_WEIGHT';

	
	const MIN_ORDER_AMOUNT = 'st_delivery.MIN_ORDER_AMOUNT';

	
	const MIN_ORDER_QUANTITY = 'st_delivery.MIN_ORDER_QUANTITY';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt', 'UpdatedAt', 'Id', 'CountriesAreaId', 'TaxId', 'FreeDelivery', 'Active', 'DefaultCost', 'DefaultCostBrutto', 'IsSystemDefault', 'OptName', 'OptDescription', 'IsDefault', 'SectionCostType', 'MaxOrderWeight', 'MaxOrderAmount', 'MaxOrderQuantity', 'MinOrderWeight', 'MinOrderAmount', 'MinOrderQuantity', ),
		BasePeer::TYPE_COLNAME => array (DeliveryPeer::CREATED_AT, DeliveryPeer::UPDATED_AT, DeliveryPeer::ID, DeliveryPeer::COUNTRIES_AREA_ID, DeliveryPeer::TAX_ID, DeliveryPeer::FREE_DELIVERY, DeliveryPeer::ACTIVE, DeliveryPeer::DEFAULT_COST, DeliveryPeer::DEFAULT_COST_BRUTTO, DeliveryPeer::IS_SYSTEM_DEFAULT, DeliveryPeer::OPT_NAME, DeliveryPeer::OPT_DESCRIPTION, DeliveryPeer::IS_DEFAULT, DeliveryPeer::SECTION_COST_TYPE, DeliveryPeer::MAX_ORDER_WEIGHT, DeliveryPeer::MAX_ORDER_AMOUNT, DeliveryPeer::MAX_ORDER_QUANTITY, DeliveryPeer::MIN_ORDER_WEIGHT, DeliveryPeer::MIN_ORDER_AMOUNT, DeliveryPeer::MIN_ORDER_QUANTITY, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at', 'updated_at', 'id', 'countries_area_id', 'tax_id', 'free_delivery', 'active', 'default_cost', 'default_cost_brutto', 'is_system_default', 'opt_name', 'opt_description', 'is_default', 'section_cost_type', 'max_order_weight', 'max_order_amount', 'max_order_quantity', 'min_order_weight', 'min_order_amount', 'min_order_quantity', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('CreatedAt' => 0, 'UpdatedAt' => 1, 'Id' => 2, 'CountriesAreaId' => 3, 'TaxId' => 4, 'FreeDelivery' => 5, 'Active' => 6, 'DefaultCost' => 7, 'DefaultCostBrutto' => 8, 'IsSystemDefault' => 9, 'OptName' => 10, 'OptDescription' => 11, 'IsDefault' => 12, 'SectionCostType' => 13, 'MaxOrderWeight' => 14, 'MaxOrderAmount' => 15, 'MaxOrderQuantity' => 16, 'MinOrderWeight' => 17, 'MinOrderAmount' => 18, 'MinOrderQuantity' => 19, ),
		BasePeer::TYPE_COLNAME => array (DeliveryPeer::CREATED_AT => 0, DeliveryPeer::UPDATED_AT => 1, DeliveryPeer::ID => 2, DeliveryPeer::COUNTRIES_AREA_ID => 3, DeliveryPeer::TAX_ID => 4, DeliveryPeer::FREE_DELIVERY => 5, DeliveryPeer::ACTIVE => 6, DeliveryPeer::DEFAULT_COST => 7, DeliveryPeer::DEFAULT_COST_BRUTTO => 8, DeliveryPeer::IS_SYSTEM_DEFAULT => 9, DeliveryPeer::OPT_NAME => 10, DeliveryPeer::OPT_DESCRIPTION => 11, DeliveryPeer::IS_DEFAULT => 12, DeliveryPeer::SECTION_COST_TYPE => 13, DeliveryPeer::MAX_ORDER_WEIGHT => 14, DeliveryPeer::MAX_ORDER_AMOUNT => 15, DeliveryPeer::MAX_ORDER_QUANTITY => 16, DeliveryPeer::MIN_ORDER_WEIGHT => 17, DeliveryPeer::MIN_ORDER_AMOUNT => 18, DeliveryPeer::MIN_ORDER_QUANTITY => 19, ),
		BasePeer::TYPE_FIELDNAME => array ('created_at' => 0, 'updated_at' => 1, 'id' => 2, 'countries_area_id' => 3, 'tax_id' => 4, 'free_delivery' => 5, 'active' => 6, 'default_cost' => 7, 'default_cost_brutto' => 8, 'is_system_default' => 9, 'opt_name' => 10, 'opt_description' => 11, 'is_default' => 12, 'section_cost_type' => 13, 'max_order_weight' => 14, 'max_order_amount' => 15, 'max_order_quantity' => 16, 'min_order_weight' => 17, 'min_order_amount' => 18, 'min_order_quantity' => 19, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('plugins.stDeliveryPlugin.lib.model.map.DeliveryMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = DeliveryPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(DeliveryPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(DeliveryPeer::CREATED_AT);

		$criteria->addSelectColumn(DeliveryPeer::UPDATED_AT);

		$criteria->addSelectColumn(DeliveryPeer::ID);

		$criteria->addSelectColumn(DeliveryPeer::COUNTRIES_AREA_ID);

		$criteria->addSelectColumn(DeliveryPeer::TAX_ID);

		$criteria->addSelectColumn(DeliveryPeer::FREE_DELIVERY);

		$criteria->addSelectColumn(DeliveryPeer::ACTIVE);

		$criteria->addSelectColumn(DeliveryPeer::DEFAULT_COST);

		$criteria->addSelectColumn(DeliveryPeer::DEFAULT_COST_BRUTTO);

		$criteria->addSelectColumn(DeliveryPeer::IS_SYSTEM_DEFAULT);

		$criteria->addSelectColumn(DeliveryPeer::OPT_NAME);

		$criteria->addSelectColumn(DeliveryPeer::OPT_DESCRIPTION);

		$criteria->addSelectColumn(DeliveryPeer::IS_DEFAULT);

		$criteria->addSelectColumn(DeliveryPeer::SECTION_COST_TYPE);

		$criteria->addSelectColumn(DeliveryPeer::MAX_ORDER_WEIGHT);

		$criteria->addSelectColumn(DeliveryPeer::MAX_ORDER_AMOUNT);

		$criteria->addSelectColumn(DeliveryPeer::MAX_ORDER_QUANTITY);

		$criteria->addSelectColumn(DeliveryPeer::MIN_ORDER_WEIGHT);

		$criteria->addSelectColumn(DeliveryPeer::MIN_ORDER_AMOUNT);

		$criteria->addSelectColumn(DeliveryPeer::MIN_ORDER_QUANTITY);

	}

	const COUNT = 'COUNT(st_delivery.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_delivery.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(DeliveryPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(DeliveryPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = DeliveryPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = DeliveryPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return DeliveryPeer::populateObjects(DeliveryPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseDeliveryPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseDeliveryPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			DeliveryPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = DeliveryPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinCountriesArea(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(DeliveryPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(DeliveryPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(DeliveryPeer::COUNTRIES_AREA_ID, CountriesAreaPeer::ID, Criteria::LEFT_JOIN);

		$rs = DeliveryPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinTax(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(DeliveryPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(DeliveryPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(DeliveryPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = DeliveryPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinCountriesArea(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		DeliveryPeer::addSelectColumns($c);
		$startcol = (DeliveryPeer::NUM_COLUMNS - DeliveryPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		CountriesAreaPeer::addSelectColumns($c);

		$c->addJoin(DeliveryPeer::COUNTRIES_AREA_ID, CountriesAreaPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = DeliveryPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getCountriesAreaId())
                        {

			   $omClass = CountriesAreaPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addDelivery($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doSelectJoinTax(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		DeliveryPeer::addSelectColumns($c);
		$startcol = (DeliveryPeer::NUM_COLUMNS - DeliveryPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		TaxPeer::addSelectColumns($c);

		$c->addJoin(DeliveryPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = DeliveryPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getTaxId())
                        {

			   $omClass = TaxPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addDelivery($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(DeliveryPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(DeliveryPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(DeliveryPeer::COUNTRIES_AREA_ID, CountriesAreaPeer::ID, Criteria::LEFT_JOIN);

		$criteria->addJoin(DeliveryPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = DeliveryPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		DeliveryPeer::addSelectColumns($c);
		$startcol2 = (DeliveryPeer::NUM_COLUMNS - DeliveryPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CountriesAreaPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CountriesAreaPeer::NUM_COLUMNS;

		TaxPeer::addSelectColumns($c);
		$startcol4 = $startcol3 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(DeliveryPeer::COUNTRIES_AREA_ID, CountriesAreaPeer::ID, Criteria::LEFT_JOIN);

		$c->addJoin(DeliveryPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = DeliveryPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = CountriesAreaPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCountriesArea(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addDelivery($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initDeliverys();
				$obj2->addDelivery($obj1);
			}


					
			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj3 = new $cls();
			$obj3->hydrate($rs, $startcol3);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj3 = $temp_obj1->getTax(); 				if ($temp_obj3->getPrimaryKey() === $obj3->getPrimaryKey()) {
					$newObject = false;
					$temp_obj3->addDelivery($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj3->initDeliverys();
				$obj3->addDelivery($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doCountJoinAllExceptCountriesArea(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(DeliveryPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(DeliveryPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(DeliveryPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);

		$rs = DeliveryPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doCountJoinAllExceptTax(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(DeliveryPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(DeliveryPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(DeliveryPeer::COUNTRIES_AREA_ID, CountriesAreaPeer::ID, Criteria::LEFT_JOIN);

		$rs = DeliveryPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAllExceptCountriesArea(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		DeliveryPeer::addSelectColumns($c);
		$startcol2 = (DeliveryPeer::NUM_COLUMNS - DeliveryPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		TaxPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + TaxPeer::NUM_COLUMNS;

		$c->addJoin(DeliveryPeer::TAX_ID, TaxPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = DeliveryPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = TaxPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getTax(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addDelivery($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initDeliverys();
				$obj2->addDelivery($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


	
	public static function doSelectJoinAllExceptTax(Criteria $c, $con = null)
	{
		$c = clone $c;

								if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		DeliveryPeer::addSelectColumns($c);
		$startcol2 = (DeliveryPeer::NUM_COLUMNS - DeliveryPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CountriesAreaPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CountriesAreaPeer::NUM_COLUMNS;

		$c->addJoin(DeliveryPeer::COUNTRIES_AREA_ID, CountriesAreaPeer::ID, Criteria::LEFT_JOIN);


		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = DeliveryPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);

			$omClass = CountriesAreaPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2  = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCountriesArea(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addDelivery($obj1);
					break;
				}
			}

			if ($newObject) {
				$obj2->initDeliverys();
				$obj2->addDelivery($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}


     
     public static function doSelectWithI18n(Criteria $c, $culture = null, $con = null)
     {
       if ($culture === null)
       {
         $culture = sfContext::getInstance()->getUser()->getCulture();
       }

              if ($c->getDbName() == Propel::getDefaultDB())
       {
         $c->setDbName(self::DATABASE_NAME);
       }

      DeliveryPeer::addSelectColumns($c);
      $startcol = (DeliveryPeer::NUM_COLUMNS - DeliveryPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

      DeliveryI18nPeer::addSelectColumns($c);

      $c->addJoin(DeliveryPeer::ID, sprintf('%s AND %s = \'%s\'', DeliveryI18nPeer::ID, DeliveryI18nPeer::CULTURE, $culture), Criteria::LEFT_JOIN);

      $rs = BasePeer::doSelect($c, $con);

      if (self::$hydrateMethod)
      {
         return call_user_func(self::$hydrateMethod, $rs);
      }

      $results = array();

      while($rs->next()) {

         $omClass = DeliveryPeer::getOMClass();

         $cls = Propel::import($omClass);
         $obj1 = new $cls();
         $obj1->hydrate($rs);
         $obj1->setCulture($culture);

         $omClass = DeliveryI18nPeer::getOMClass($rs, $startcol);

         $cls = Propel::import($omClass);
         $obj2 = new $cls();
         $obj2->hydrate($rs, $startcol);

         $obj1->setDeliveryI18nForCulture($obj2, $culture);
         $obj2->setDelivery($obj1);

         $results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
       }
       return $results;
     }

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return DeliveryPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseDeliveryPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseDeliveryPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(DeliveryPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseDeliveryPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseDeliveryPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseDeliveryPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseDeliveryPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(DeliveryPeer::ID);
			$selectCriteria->add(DeliveryPeer::ID, $criteria->remove(DeliveryPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseDeliveryPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseDeliveryPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			$affectedRows += DeliveryPeer::doOnDeleteCascade(new Criteria(), $con);
			DeliveryPeer::doOnDeleteSetNull(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(DeliveryPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(DeliveryPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof Delivery) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(DeliveryPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			$affectedRows += DeliveryPeer::doOnDeleteCascade($criteria, $con);DeliveryPeer::doOnDeleteSetNull($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteCascade(Criteria $criteria, Connection $con)
	{
				$affectedRows = 0;

				$objects = DeliveryPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {


			$c = new Criteria();
			
			$c->add(DeliverySectionsPeer::DELIVERY_ID, $obj->getId());
			$affectedRows += DeliverySectionsPeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(DeliveryHasPaymentTypePeer::DELIVERY_ID, $obj->getId());
			$affectedRows += DeliveryHasPaymentTypePeer::doDelete($c, $con);

			$c = new Criteria();
			
			$c->add(DeliveryI18nPeer::ID, $obj->getId());
			$affectedRows += DeliveryI18nPeer::doDelete($c, $con);
		}
		return $affectedRows;
	}

	
	protected static function doOnDeleteSetNull(Criteria $criteria, Connection $con)
	{

				$objects = DeliveryPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {

						$selectCriteria = new Criteria(DeliveryPeer::DATABASE_NAME);
			$updateValues = new Criteria(DeliveryPeer::DATABASE_NAME);
			$selectCriteria->add(OrderDeliveryPeer::DELIVERY_ID, $obj->getId());
			$updateValues->add(OrderDeliveryPeer::DELIVERY_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
		}
	}

	
	public static function doValidate(Delivery $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(DeliveryPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(DeliveryPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(DeliveryPeer::DATABASE_NAME, DeliveryPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = DeliveryPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(DeliveryPeer::DATABASE_NAME);

		$criteria->add(DeliveryPeer::ID, $pk);


		$v = DeliveryPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(DeliveryPeer::ID, $pks, Criteria::IN);
			$objs = DeliveryPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseDeliveryPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('plugins.stDeliveryPlugin.lib.model.map.DeliveryMapBuilder');
}
