<?php


abstract class BaseDeliverySections extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $attribute_field_id;


	
	protected $delivery_id;


	
	protected $value_from = 0;


	
	protected $amount = 0;


	
	protected $amount_brutto;

	
	protected $aAttributeField;

	
	protected $aDelivery;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getAttributeFieldId()
    {

            return $this->attribute_field_id;
    }

    
    public function getDeliveryId()
    {

            return $this->delivery_id;
    }

    
    public function getValueFrom()
    {

            return null !== $this->value_from ? (string)$this->value_from : null;
    }

    
    public function getAmount()
    {

            return null !== $this->amount ? (string)$this->amount : null;
    }

    
    public function getAmountBrutto()
    {

            return null !== $this->amount_brutto ? (string)$this->amount_brutto : null;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = DeliverySectionsPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = DeliverySectionsPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = DeliverySectionsPeer::ID;
        }

	} 
	
	public function setAttributeFieldId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->attribute_field_id !== $v) {
          $this->attribute_field_id = $v;
          $this->modifiedColumns[] = DeliverySectionsPeer::ATTRIBUTE_FIELD_ID;
        }

		if ($this->aAttributeField !== null && $this->aAttributeField->getId() !== $v) {
			$this->aAttributeField = null;
		}

	} 
	
	public function setDeliveryId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->delivery_id !== $v) {
          $this->delivery_id = $v;
          $this->modifiedColumns[] = DeliverySectionsPeer::DELIVERY_ID;
        }

		if ($this->aDelivery !== null && $this->aDelivery->getId() !== $v) {
			$this->aDelivery = null;
		}

	} 
	
	public function setValueFrom($v)
	{

        if ($this->value_from !== $v || $v === 0) {
          $this->value_from = $v;
          $this->modifiedColumns[] = DeliverySectionsPeer::VALUE_FROM;
        }

	} 
	
	public function setAmount($v)
	{

        if ($this->amount !== $v || $v === 0) {
          $this->amount = $v;
          $this->modifiedColumns[] = DeliverySectionsPeer::AMOUNT;
        }

	} 
	
	public function setAmountBrutto($v)
	{

        if ($this->amount_brutto !== $v) {
          $this->amount_brutto = $v;
          $this->modifiedColumns[] = DeliverySectionsPeer::AMOUNT_BRUTTO;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'DeliverySections.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->attribute_field_id = $rs->getInt($startcol + 3);

      $this->delivery_id = $rs->getInt($startcol + 4);

      $this->value_from = $rs->getString($startcol + 5, null);

      $this->value_from = $rs->getFloat($startcol + 5);

      $this->amount = $rs->getString($startcol + 6, null);

      $this->amount = $rs->getFloat($startcol + 6);

      $this->amount_brutto = $rs->getString($startcol + 7, null);

      $this->amount_brutto = $rs->getFloat($startcol + 7);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'DeliverySections.postHydrate', array('resultset' => $rs, 'startcol' => 8)));

            return $startcol + 8; 
    } catch (Exception $e) {
      throw new PropelException("Error populating DeliverySections object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseDeliverySections:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DeliverySectionsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			DeliverySectionsPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseDeliverySections:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'DeliverySections.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseDeliverySections:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(DeliverySectionsPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(DeliverySectionsPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DeliverySectionsPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'DeliverySections.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseDeliverySections:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aAttributeField !== null) {
				if ($this->aAttributeField->isModified()) {
					$affectedRows += $this->aAttributeField->save($con);
				}
				$this->setAttributeField($this->aAttributeField);
			}

			if ($this->aDelivery !== null) {
				if ($this->aDelivery->isModified() || $this->aDelivery->getCurrentDeliveryI18n()->isModified()) {
					$affectedRows += $this->aDelivery->save($con);
				}
				$this->setDelivery($this->aDelivery);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = DeliverySectionsPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += DeliverySectionsPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aAttributeField !== null) {
				if (!$this->aAttributeField->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aAttributeField->getValidationFailures());
				}
			}

			if ($this->aDelivery !== null) {
				if (!$this->aDelivery->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aDelivery->getValidationFailures());
				}
			}


			if (($retval = DeliverySectionsPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}



			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DeliverySectionsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getAttributeFieldId();
				break;
			case 4:
				return $this->getDeliveryId();
				break;
			case 5:
				return $this->getValueFrom();
				break;
			case 6:
				return $this->getAmount();
				break;
			case 7:
				return $this->getAmountBrutto();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DeliverySectionsPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getAttributeFieldId(),
			$keys[4] => $this->getDeliveryId(),
			$keys[5] => $this->getValueFrom(),
			$keys[6] => $this->getAmount(),
			$keys[7] => $this->getAmountBrutto(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DeliverySectionsPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setAttributeFieldId($value);
				break;
			case 4:
				$this->setDeliveryId($value);
				break;
			case 5:
				$this->setValueFrom($value);
				break;
			case 6:
				$this->setAmount($value);
				break;
			case 7:
				$this->setAmountBrutto($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DeliverySectionsPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setAttributeFieldId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setDeliveryId($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setValueFrom($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setAmount($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setAmountBrutto($arr[$keys[7]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(DeliverySectionsPeer::DATABASE_NAME);

		if ($this->isColumnModified(DeliverySectionsPeer::CREATED_AT)) $criteria->add(DeliverySectionsPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(DeliverySectionsPeer::UPDATED_AT)) $criteria->add(DeliverySectionsPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(DeliverySectionsPeer::ID)) $criteria->add(DeliverySectionsPeer::ID, $this->id);
		if ($this->isColumnModified(DeliverySectionsPeer::ATTRIBUTE_FIELD_ID)) $criteria->add(DeliverySectionsPeer::ATTRIBUTE_FIELD_ID, $this->attribute_field_id);
		if ($this->isColumnModified(DeliverySectionsPeer::DELIVERY_ID)) $criteria->add(DeliverySectionsPeer::DELIVERY_ID, $this->delivery_id);
		if ($this->isColumnModified(DeliverySectionsPeer::VALUE_FROM)) $criteria->add(DeliverySectionsPeer::VALUE_FROM, $this->value_from);
		if ($this->isColumnModified(DeliverySectionsPeer::AMOUNT)) $criteria->add(DeliverySectionsPeer::AMOUNT, $this->amount);
		if ($this->isColumnModified(DeliverySectionsPeer::AMOUNT_BRUTTO)) $criteria->add(DeliverySectionsPeer::AMOUNT_BRUTTO, $this->amount_brutto);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(DeliverySectionsPeer::DATABASE_NAME);

		$criteria->add(DeliverySectionsPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setAttributeFieldId($this->attribute_field_id);

		$copyObj->setDeliveryId($this->delivery_id);

		$copyObj->setValueFrom($this->value_from);

		$copyObj->setAmount($this->amount);

		$copyObj->setAmountBrutto($this->amount_brutto);


		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new DeliverySectionsPeer();
		}
		return self::$peer;
	}

	
	public function setAttributeField($v)
	{


		if ($v === null) {
			$this->setAttributeFieldId(NULL);
		} else {
			$this->setAttributeFieldId($v->getId());
		}


		$this->aAttributeField = $v;
	}


	
	public function getAttributeField($con = null)
	{
		if ($this->aAttributeField === null && ($this->attribute_field_id !== null)) {
						$this->aAttributeField = AttributeFieldPeer::retrieveByPK($this->attribute_field_id, $con);

			
		}
		return $this->aAttributeField;
	}

	
	public function setDelivery($v)
	{


		if ($v === null) {
			$this->setDeliveryId(NULL);
		} else {
			$this->setDeliveryId($v->getId());
		}


		$this->aDelivery = $v;
	}


	
	public function getDelivery($con = null)
	{
		if ($this->aDelivery === null && ($this->delivery_id !== null)) {
						$this->aDelivery = DeliveryPeer::retrieveByPK($this->delivery_id, $con);

			
		}
		return $this->aDelivery;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'DeliverySections.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseDeliverySections:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseDeliverySections::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 