<script type="text/javascript">
    function st_insert(element, sibling, insert_type, which_sibling)
    {
        var e = $(element);

        if (which_sibling == 'prev')
        {
            s = e.previous(sibling);
        }
        else
        {
            s = e.next(sibling);
        }

        if (s)
        {
            if (insert_type == 'after')
            {
                s.insert({ after: e });
            }
            else
            {
                s.insert({ before: e });
            }

            new Effect.Highlight(e, { startcolor: '#ffff99', endcolor: '#ffffff', restorecolor: 'transparent', duration: 0.6, queue: {scope: 'st_insert'}});
        }

        return s;
    };

document.observe("dom:loaded", function()
{
    $A($$('.st_delivery-payment-form-active')).each(function(e) {
        e.observe('change', function(event) {
            if (this.checked)
            {
                $('st_delivery-payment-row-'+this.value+'-control').show();

                $('st_delivery-payment-row-'+this.value).addClassName('st_delivery-payment-row-enabled');

                $('st_delivery-payment-row-'+this.value).removeClassName('st_delivery-payment-row-disabled');

                Form.Element.enable('delivery_is_default_payment_' + this.value);

                Form.Element.enable('delivery_payments_'+this.value+'_cost_netto');

                Form.Element.enable('delivery_payments_'+this.value+'_cost_brutto');

                Form.Element.enable('delivery_payments_'+this.value+'_free_from');

                if (!st_insert('st_delivery-payment-row-'+this.value, 'tr.st_delivery-payment-row-enabled', 'after', 'prev'))
                {
                    $('st_delivery-payment-body').insert({top: $('st_delivery-payment-row-'+this.value)});
                }
            }
            else
            {
                $('st_delivery-payment-row-'+this.value).addClassName('st_delivery-payment-row-disabled');

                $('st_delivery-payment-row-'+this.value).removeClassName('st_delivery-payment-row-enabled');

                $('st_delivery-payment-row-'+this.value+'-control').hide();

                Form.Element.disable('delivery_is_default_payment_' + this.value);

                Form.Element.disable('delivery_payments_'+this.value+'_cost_netto');

                Form.Element.disable('delivery_payments_'+this.value+'_cost_brutto');

                Form.Element.disable('delivery_payments_'+this.value+'_free_from');

                if (!st_insert('st_delivery-payment-row-'+this.value, 'tr.st_delivery-payment-row-disabled', 'before', 'next'))
                {
                    $('st_delivery-payment-body').insert({bottom: $('st_delivery-payment-row-'+this.value)});
                }
            }
        });
});
});
</script>
<?php echo form_error('delivery{payments}', array('style' => 'color: #FF3333')) ?>
<?php if (empty($payments)): ?>
<?php echo st_external_link_to(__('Brak aktywnego typu płatności, przejdź do konfiguracji typów płatności'), '@stPaymentType') ?>
<?php else: ?>
<table class="st_record_list" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th rowspan="2"><?php echo __('Aktywna') ?></th>
            <th rowspan="2"><?php echo __('Domyślna') ?></th>
            <th rowspan="2" style="width: 150px"><?php echo __('Nazwa') ?></th>
            <th colspan="2"><?php echo __('Koszt') ?></th>
            <th rowspan="2"><?php echo __('Darmowa od (brutto)') ?></th>
            <th rowspan="2"><?php echo __('Kolejność') ?></th>
        </tr>
        <tr>
            <th><?php echo __('Netto') ?></th>
            <th><?php echo __('Brutto') ?></th>
        </tr>
    </thead>
    <tbody id="st_delivery-payment-body">

<?php foreach ($payments as $index => $payment): ?>
<?php
$dhp = $payment->getDeliveryHasPaymentType();
$active = $dhp ? $dhp->getIsActive() : false;
$pid = $payment->getId();

$error_cost = form_has_error('delivery{payments}{'.$pid.'}{cost_netto}');
$error_cost_brutto = form_has_error('delivery{payments}{'.$pid.'}{cost_brutto}');
$error_free_from = form_has_error('delivery{payments}{'.$pid.'}{free_from}');
      st_price_tax_manager_add_price_field(array(
          'price' => 'delivery_payments_'.$pid.'_cost_netto',
          'priceWithTax' => 'delivery_payments_'.$pid.'_cost_brutto'));
?>
<?php if ($error_cost): ?>
        <tr><td colspan="7"><?php echo form_error('delivery{payments}{'.$pid.'}{cost_netto}', array('style' => 'color: #FF3333')) ?></td></tr>
<?php endif; ?>
<?php if ($error_cost_brutto): ?>
        <tr><td colspan="7"><?php echo form_error('delivery{payments}{'.$pid.'}{cost_brutto}', array('style' => 'color: #FF3333')) ?></td></tr>
<?php endif; ?>
<?php if ($error_free_from): ?>
        <tr><td colspan="7"><?php echo form_error('delivery{payments}{'.$pid.'}{free_from}', array('style' => 'color: #FF3333')) ?></td></tr>
<?php endif; ?>
        <tr id="st_delivery-payment-row-<?php echo $pid ?>" class="st_delivery-payment-row-<?php echo $active ? 'enabled' : 'disabled' ?>">
            <td><?php echo checkbox_tag('delivery[payments]['.$pid.'][is_active]', $pid, $active, array('class' => 'st_delivery-payment-form-active')) ?></td>
            <td><?php echo radiobutton_tag('delivery[is_default_payment]', $pid, $dhp ? $dhp->getIsDefault() : false, array('id' => 'delivery_is_default_payment_' . $pid, 'disabled' => !$active)) ?></td>
            <td style="text-align: left">
                <?php echo st_external_link_to($payment->getName(), 'stPaymentType/edit?id=' . $pid) ?>
<?php if (!$payment->checkPaymentConfiguration()): ?>
                <p><b><?php echo __('Skonfiguruj płatność') ?></b></p>
<?php endif; ?>
            </td>
            <td>
                    <?php echo input_hidden_tag('delivery[payments]['.$pid.'][cost_netto]', $dhp ? $dhp->getCost() : '0.00', array('id' => 'delivery_payments_'.$pid.'_cost_netto_hidden')) ?>
                    <?php echo input_tag('delivery[payments]['.$pid.'][cost_netto]',
                    $dhp ? $dhp->getCost() : '0.00',
                    array('size' => 6, 'disabled' => !$active, 'style' => $error_cost ? 'border-color: #FF3333' : '')) ?>
            </td>
            <td>
                    <?php echo input_hidden_tag('delivery[payments]['.$pid.'][cost_brutto]', $dhp ? $dhp->getCostBrutto() : '0.00', array('id' => 'delivery_payments_'.$pid.'_cost_brutto_hidden')) ?>
                    <?php echo input_tag('delivery[payments]['.$pid.'][cost_brutto]',
                    $dhp ? $dhp->getCostBrutto() : '0.00',
                    array('size' => 6, 'disabled' => !$active, 'style' => $error_cost ? 'border-color: #FF3333' : '')) ?>
            </td>
            <td>
                    <?php echo input_hidden_tag('delivery[payments]['.$pid.'][free_from]', $dhp ? $dhp->getFreeFrom() : '0.00', array('id' => 'delivery_payments_'.$pid.'_free_from_hidden')) ?>
                    <?php echo input_tag('delivery[payments]['.$pid.'][free_from]',
                    $dhp ? $dhp->getFreeFrom() : '0.00',
                    array('size' => 8, 'disabled' => !$active, 'style' => $error_free_from ? 'border-color: #FF3333' : '')) ?>
            </td>
            <td>
                <div id="st_delivery-payment-row-<?php echo $pid ?>-control" style="display: <?php echo $active ? 'block' : 'none' ?>">
<?php if ($form_has_errors): ?>
                        <?php echo image_tag('/images/backend/icons/asc.png') ?>
                        <?php echo image_tag('/images/backend/icons/desc.png') ?>
<?php else: ?>
                        <?php echo link_to_function(image_tag('/images/backend/icons/asc.png'), "st_insert('st_delivery-payment-row-{$pid}', 'tr.st_delivery-payment-row-enabled', 'before', 'prev')") ?>
                        <?php echo link_to_function(image_tag('/images/backend/icons/desc.png'), "st_insert('st_delivery-payment-row-{$pid}', 'tr.st_delivery-payment-row-enabled', 'after', 'next')") ?>
<?php endif; ?>
                </div>
            </td>
        </tr>
<?php endforeach ?>
    </tbody>
    <tfoot>
        <tr><th colspan="7"><?php echo st_external_link_to(__('Konfiguracja płatności'), '@stPaymentType') ?></th></tr>
    </tfoot>
</table>
<?php endif ?>

