<?php
/** 
 * SOTESHOP/stDelivery 
 * 
 * Ten plik należy do aplikacji stDelivery opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stDeliveryPlugin
 * @subpackage  actions
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: actions.class.php 312 2009-09-04 14:28:53Z marcin $
 */

/** 
 * Akcje komponentu produktu
 *
 * @author Marcin Butlak <marcin.butlak@sote.pl>
 *
 * @package     stDeliveryPlugin
 * @subpackage  actions
 */
class stDeliveryFrontendActions extends stActions 
{
    /**
     * Aktualizowanie dostawy za pomocą Ajax
     */
    public function executeAjaxDeliveryCountryUpdate()
    {
        $basket = stBasket::getInstance($this->getUser());

        $delivery = stDeliveryFrontend::getInstance($basket);

        $delivery->clearSession();

        $delivery->setDefaultDeliveryCountry($this->getRequestParameter('id'));

        $basket_params = array('basket' => $basket);

        $this->responseUpdateElement('st_basket-delivery', array('module' => 'stDeliveryFrontend','component'=> 'basketDeliveryList', 'params' => $basket_params));

        $this->responseUpdateElement('st_basket-payment', array('module' => 'stDeliveryFrontend','component'=> 'basketPaymentList', 'params' => $basket_params));

        $this->responseUpdateElement('st_basket-summary', array('module' => 'stDeliveryFrontend','component'=> 'basketSummary', 'params' => $basket_params));

        return $this->renderResponse();
    }

    /** 
     * Aktualizowanie dostawy za pomocą Ajax
     */
    public function executeAjaxDeliveryUpdate()
    {
        $basket = stBasket::getInstance($this->getUser());

        $delivery = stDeliveryFrontend::getInstance($basket);

        $delivery->clearSession();

        $delivery->setDefaultDelivery($this->getRequestParameter('id'));

        $basket_params = array('basket' => $basket);

        $this->responseUpdateElement('st_basket-payment', array('module' => 'stDeliveryFrontend','component'=> 'basketPaymentList', 'params' => $basket_params));

        $this->responseUpdateElement('st_basket-summary', array('module' => 'stDeliveryFrontend','component'=> 'basketSummary', 'params' => $basket_params));

        return $this->renderResponse();
    }

    public function executeAjaxPaymentUpdate()
    {
        $basket = stBasket::getInstance($this->getUser());

        $delivery = stDeliveryFrontend::getInstance($basket);

        $delivery->getDefaultDelivery()->setDefaultPayment($this->getRequestParameter('id'));
        
        $basket_params = array('basket' => $basket);

        $this->responseUpdateElement('st_basket-summary', array('module' => 'stDeliveryFrontend','component'=> 'basketSummary', 'params' => $basket_params));

        return $this->renderResponse();
    }    
}