<?php
st_theme_use_stylesheet('stDelivery.css');

use_javascript('stDelivery.js');

$smarty->assign('deliveries', $delivery->getDeliveries());

$smarty->assign('delivery_countries', $delivery->getDeliveryCountries());

$smarty->assign('date_time', st_get_component('stDeliveryFrontend', 'dateTime'));

if (!$delivery->hasDeliveries())
{
   $total_amount = $basket->getTotalAmount(true);

   $total_quantity = $basket->getTotalProductQuantity();

   $total_weight = $basket->getTotalProductWeight();

   $max_amount = $delivery->getMaxOrderAmount();

   $min_amount = $delivery->getMinOrderAmount();
   
   $max_quantity = $delivery->getMaxOrderQuantity();

   $min_quantity = $delivery->getMinOrderQuantity();
   
   $max_weight = $delivery->getMaxOrderWeight();

   $min_weight = $delivery->getMinOrderWeight();   

   $smarty->assign('max_order_amount_exceeded', $max_amount > 0 && $total_amount > $max_amount || $min_amount > 0 && $total_amount < $min_amount);
   
   $smarty->assign('max_order_quantity_exceeded', $max_quantity > 0 && $total_quantity > $max_quantity || $min_quantity > 0 && $total_quantity < $min_quantity);
   
   $smarty->assign('max_order_weight_exceeded', $max_weight > 0 && $total_weight > $max_weight || $min_weight > 0 && $total_weight < $min_weight);


}

$smarty->display('basket_delivery_list.html');
?>
<script type="text/javascript">
   $A($$('input.st_delivery-default')).each(function(e)
   {
      if (e.checked)
      {
         stDelivery.deliveryChecked = e.id;
      }

      e.observe('click', function()
      {

         if (stDelivery.deliveryChecked != this.id)
         {
            stDelivery.executeAjaxUpdate(this, '<?php echo url_for('stDeliveryFrontend/ajaxDeliveryUpdate') ?>');

            stDelivery.deliveryChecked = this.id;
         }
      });
   });

   $('delivery_country').observe('change', function()
   {
      stDelivery.executeAjaxUpdate(this, '<?php echo url_for('stDeliveryFrontend/ajaxDeliveryCountryUpdate') ?>');
   });
</script>