<?php

/**
 * SOTESHOP/stDepositoryPlugin 
 * 
 * Ten plik należy do aplikacji stDepositoryPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stDepositoryPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stDepositiory.class.php 617 2009-04-09 13:02:31Z michal $
 * @author      Marcin Olejniczak <marcin.olejniczak@sote.pl>
 */

/**
 * Klasa stDepository
 *
 * @author Marcin Olejniczak <marcin.olejniczak@sote.pl>
 *
 * @package     stDepositoryPlugin
 * @subpackage  libs
 */
class stDepository
{

   /**
    * Zwiększanie stanu magazynowego produktu
    *
    * @param        object      $product
    * @param       integer     $quantity
    */
   public static function increase($product, $quantity)
   {
      if (!is_object($product)) 
      {
         $product = ProductPeer::retrieveByPK($product);
      }
      
      if ($product)
      {
         $stock = $product->getStock();
         
         if (null !== $stock)
         {
            $product->setStock($stock + $quantity);
            
            $product->save();
         }
      }
   }

   /**
    * Zmniejszanie stanu magazynowego produktu
    *
    * @param        object      $product
    * @param       integer     $quantity
    */
   public static function decrease($product, $quantity)
   {
      if (!is_object($product)) 
      {
         $product = ProductPeer::retrieveByPK($product);
      }
      
      if ($product)
      {
         $stock = $product->getStock();
         
         if ($stock)
         {
            $stock -= $quantity;
            
            $product->setStock($stock > 0 ? $stock : 0);
            
            $product->save();
         }
      }
   }

   /**
    * Pobranie stanu magazynowego produktu
    *
    * @param       integer     $product_id
    * @return   integer
    */
   public static function getStock($product_id)
   {
      $product = ProductPeer::retrieveByPK($product_id);
      return $product->getStock();
   }

}