<?php

/**
 * SOTESHOP/stDepositoryPlugin 
 * 
 * Ten plik należy do aplikacji stDepositoryPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stDepositoryPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stDepositoryPluginListener.class.php 617 2009-04-09 13:02:31Z michal $
 * @author      Daniel Mendalka <daniel.mendalka@sote.pl>
 */

/**
 * Podpięcie pod generator stProduct modułu stDepositoryPlugin
 * 
 * @author Daniel Mendalka <daniel.mendalka@sote.pl>
 *
 * @package     stDepositoryPlugin
 * @subpackage  libs
 */
class stDepositoryPluginListener
{

   /**
    * Podpięcie zdarzenia dla generatora produktu
    *
    * @param       sfEvent     $event
    */
   public static function generate(sfEvent $event)
   {
      // możemy wywoływać podaną metodę wielokrotnie co powoduje dołączenie kolejnych plików
      $event->getSubject()->attachAdminGeneratorFile('stDepositoryPlugin', 'stProduct.yml');
   }

   public static function modAddItem(sfEvent $event)
   {
      $event['item']->setMaxQuantity($event['product']->getStock());
   }

   /**
    * Podpięcie się do walidacji ilości
    */
   public static function filterQuantityValidator(sfEvent $event)
   {
      $config = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
      $request = $event->getSubject()->getRequest();
      $config->load();
      if ($config->get('depository_basket') == 1)
      {
         $validator = $event['quantity_validator'];
         $id = $event['product_id'];

         if ($id)
         {
            $depository = stDepository::getStock($id);

            if ($depository !== null)
            {
               $validator->getParameterHolder()->set('max', $depository);
               $validator->getParameterHolder()->set('max_error', $event->getSubject()->getContext()->getI18N()->__('W tej chwili dostępnych jest tylko %depository% sztuk tego produktu', array("%depository%" => $depository), 'stDepositoryFrontend'));
               $event->setReturnValue($validator);
            }
         }
      }
   }

   /**
    * Zmienia wyświetlanie koszyka na disabled gdy jest włączone
    * sprawdzanie stany magazynowego, a wartość stock jest ustawiona na 0.
    *
    * @param sfEvent $event
    */
   public static function blockAddBasketButton(sfEvent $event)
   {
      $config = stConfig::getInstance(sfContext::getInstance(), array('depository_basket' => stConfig::BOOL), 'stProduct');
      $config->load();
      if ($config->get('depository_basket') == 1)
      {
         $subject = $event->getSubject();
         $depository = stDepository::getStock($subject->product->getId());
         if ($depository === 0)
         {
            $subject->enabled = 0;
         }
      }
   }

   /**
    * Sprawdza zmiany dokonane w zamówieniu i modyfikuje stany magazynowe
    * zgodnie z konfiguracją sklepu.          
    *                                         
    * Tabela do else:
    *
    * old_status      new_status      on_change       action
    * =========================================================
    * ST_CANCELED     ST_PENDING      ST_PENDING      decrease
    * ST_CANCELED     ST_COMPLETE     ST_PENDING      decrease
    * 
    * ST_PENDING      ST_CANCELED     ST_PENDING      increase
    * ST_COMPLETE     ST_CANCELED     ST_PENDING      increase    
    * 
    * ST_PENDING      ST_COMPLETE     ST_PENDING      nothing 
    * ST_COMPLETE     ST_PENDING      ST_PENDING      nothing 
    * 
    * ---------------------------------------------------------
    * 
    * ST_CANCELED     ST_COMPLETE      ST_COMPLETE      decrease
    * ST_PENDING      ST_COMPLETE      ST_COMPLETE      decrease
    * 
    * ST_COMPLETE      ST_PENDING      ST_COMPLETE      increase
    * ST_COMPLETE      ST_CANCELED     ST_COMPLETE      increase
    * 
    * ST_CANCELED     ST_PENDING      ST_COMPLETE      nothing 
    * ST_PENDING      ST_CANCELED     ST_COMPLETE      nothing
    *
    * @author Daniel Mendalka
    */
   public static function preSaveOrder(sfEvent $event)
   {
      $config = stConfig::getInstance('stProduct');

      if (!$config->get('depository_enabled', true))
      {
         return;
      }

      $order = $event->getSubject();

      if (null === $order->getChangeStockOn())
      {
         if ($config->get('get_depository') == 'order')
         {
            $order->setChangeStockOn('ST_PENDING');
         }
         elseif ($config->get('get_depository') == 'order_status')
         {
            $order->setChangeStockOn('ST_COMPLETE');
         }
      }

      if (null !== $order->getChangeStockOn() && $order->isColumnModified(OrderPeer::ORDER_STATUS_ID))
      {
         $previous_status = $order->getPreviousColumnValue(OrderPeer::ORDER_STATUS_ID) ? OrderStatusPeer::retrieveByPK($order->getPreviousColumnValue(OrderPeer::ORDER_STATUS_ID)) : null;

         switch ($order->getChangeStockOn())
         {
            case 'ST_PENDING':
               if ($order->isNew() || $previous_status && $previous_status->getType() == 'ST_CANCELED')
               {
                  self::decreaseAll($order->getOrderProducts());
               }
               elseif ($order->getOrderStatus()->getType() == 'ST_CANCELED')
               {
                  self::increaseAll($order->getOrderProducts());
               }
               break;
            case 'ST_COMPLETE':
               if ($previous_status && $previous_status->getType() == 'ST_COMPLETE' && ($order->getOrderStatus()->getType() == 'ST_CANCELED' || $order->getOrderStatus()->getType() == 'ST_PENDING'))
               {
                     self::increaseAll($order->getOrderProducts());
               }
               elseif ($order->getOrderStatus()->getType() == 'ST_COMPLETE')
               {
                  self::decreaseAll($order->getOrderProducts());
               }
               break;
         }
      }
   }

   private static function increaseAll($order_products)
   {
      foreach ($order_products as $order_product)
      {
         if ($order_product->productValidate())
         {
            stEventDispatcher::getInstance()->notify(new sfEvent(sfContext::getInstance(), 'stDepositoryPluginListener.preIncrease', array('order_product' => $order_product)));
            stDepository::increase($order_product->getProduct(), $order_product->getQuantity());
            stEventDispatcher::getInstance()->notify(new sfEvent(sfContext::getInstance(), 'stDepositoryPluginListener.postIncrease', array('order_product' => $order_product)));
         }
      }
   }

   private static function decreaseAll($order_products)
   {
      foreach ($order_products as $order_product)
      {
         if ($order_product->productValidate())
         {
            stEventDispatcher::getInstance()->notify(new sfEvent(sfContext::getInstance(), 'stDepositoryPluginListener.preDecrease', array('order_product' => $order_product)));
            stDepository::decrease($order_product->getProduct(), $order_product->getQuantity());
            stEventDispatcher::getInstance()->notify(new sfEvent(sfContext::getInstance(), 'stDepositoryPluginListener.postDecrease', array('order_product' => $order_product)));
         }
      }
   }

}

?>