<?php
/** 
 * SOTESHOP/stDepositoryPlugin 
 * 
 * Ten plik należy do aplikacji stDepositoryPlugin opartej na licencji (Professional License SOTE). 
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania. 
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać 
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 * 
 * @package     stDepositoryPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stPropelProduct.class.php 1942 2009-06-30 14:19:44Z krzysiek $
 * @author      Krzysztof Bebło <krzysztof.beblo@sote.pl> 
 */

/** 
 * stDepositoryFrontend
 *
 * @author Krzysztof Bebło <krzysztof.beblo@sote.pl> 
 * @package     stDepositoryPlugin
 * @subpackage  libs
 */
class stPropelProduct
{
    /** 
     * Pobiera stan magazynowy dla danego produktu
     *
     * @author Marcin Olejncizak <marcin.olejniczak@sote.pl>
     * @param   object      $product            obiekt produktu
     * @return  integer     stan magazynowy
     */
    public function getStock($product)
    {
        $depository = $product->getDepository();
        
        if ($depository)
        {
            return $depository->getStock();
        }        
        return '';        
    }
    
    /** 
     * Zapisuje stan magazynowy danego produktu
     *
     * @author Marcin Olejncizak <marcin.olejniczak@sote.pl>
     * @param   object      $product            obiekt produktu
     * @param                  integer     stan                magazynowy
     */
    public function setStock($product, $v)
    {   
       if (!$product->getDepository())
       {
           $product->setDepository(new Depository());
       }
       $product->getDepository()->setStock($v);
    }

    /** 
     * statyczna funkcje pobierania stanu magazynowego dla importu eksportu
     *
     * @param        object      $object
     * @return   string
     */
    public static function getProductDepository($object = null) {
        return $object->getStock();
    }

    /** 
     * statyczna funkcje pobierania stanu magazynowego dla importu eksportu
     *
     * @param        object      $object
     * @param        string      $value
     */
    public static function setProductDepository($object = null,$value = '') {       
       //celowy brak zapisu, zapis jest wykonywany w funkcji importu eksportu
       if (is_numeric($value))
       {
           $object->setStock($value);
       }
       else
       {
           $object->setStock(NULL);   
       }
       
    }    
}
?>