<?php


abstract class BaseDiscount extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $name;


	
	protected $value = 0;


	
	protected $priority = 0;


	
	protected $active = false;


	
	protected $all_products = false;


	
	protected $auto_active = false;

	
	protected $collUserHasDiscounts;

	
	protected $lastUserHasDiscountCriteria = null;

	
	protected $collDiscountHasProducts;

	
	protected $lastDiscountHasProductCriteria = null;

	
	protected $collDiscountRanges;

	
	protected $lastDiscountRangeCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getName()
    {

            return $this->name;
    }

    
    public function getValue()
    {

            return $this->value;
    }

    
    public function getPriority()
    {

            return $this->priority;
    }

    
    public function getActive()
    {

            return $this->active;
    }

    
    public function getAllProducts()
    {

            return $this->all_products;
    }

    
    public function getAutoActive()
    {

            return $this->auto_active;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = DiscountPeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = DiscountPeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = DiscountPeer::ID;
        }

	} 
	
	public function setName($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->name !== $v) {
          $this->name = $v;
          $this->modifiedColumns[] = DiscountPeer::NAME;
        }

	} 
	
	public function setValue($v)
	{

        if ($this->value !== $v || $v === 0) {
          $this->value = $v;
          $this->modifiedColumns[] = DiscountPeer::VALUE;
        }

	} 
	
	public function setPriority($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->priority !== $v || $v === 0) {
          $this->priority = $v;
          $this->modifiedColumns[] = DiscountPeer::PRIORITY;
        }

	} 
	
	public function setActive($v)
	{

        if ($this->active !== $v || $v === false) {
          $this->active = $v;
          $this->modifiedColumns[] = DiscountPeer::ACTIVE;
        }

	} 
	
	public function setAllProducts($v)
	{

        if ($this->all_products !== $v || $v === false) {
          $this->all_products = $v;
          $this->modifiedColumns[] = DiscountPeer::ALL_PRODUCTS;
        }

	} 
	
	public function setAutoActive($v)
	{

        if ($this->auto_active !== $v || $v === false) {
          $this->auto_active = $v;
          $this->modifiedColumns[] = DiscountPeer::AUTO_ACTIVE;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'Discount.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->name = $rs->getString($startcol + 3);

      $this->value = $rs->getFloat($startcol + 4);

      $this->priority = $rs->getInt($startcol + 5);

      $this->active = $rs->getBoolean($startcol + 6);

      $this->all_products = $rs->getBoolean($startcol + 7);

      $this->auto_active = $rs->getBoolean($startcol + 8);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'Discount.postHydrate', array('resultset' => $rs, 'startcol' => 9)));

            return $startcol + 9; 
    } catch (Exception $e) {
      throw new PropelException("Error populating Discount object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseDiscount:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DiscountPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			DiscountPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseDiscount:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'Discount.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseDiscount:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(DiscountPeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(DiscountPeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DiscountPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'Discount.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseDiscount:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = DiscountPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += DiscountPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collUserHasDiscounts !== null) {
				foreach($this->collUserHasDiscounts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDiscountHasProducts !== null) {
				foreach($this->collDiscountHasProducts as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collDiscountRanges !== null) {
				foreach($this->collDiscountRanges as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


			if (($retval = DiscountPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collUserHasDiscounts !== null) {
					foreach($this->collUserHasDiscounts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDiscountHasProducts !== null) {
					foreach($this->collDiscountHasProducts as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collDiscountRanges !== null) {
					foreach($this->collDiscountRanges as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DiscountPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getName();
				break;
			case 4:
				return $this->getValue();
				break;
			case 5:
				return $this->getPriority();
				break;
			case 6:
				return $this->getActive();
				break;
			case 7:
				return $this->getAllProducts();
				break;
			case 8:
				return $this->getAutoActive();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DiscountPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getName(),
			$keys[4] => $this->getValue(),
			$keys[5] => $this->getPriority(),
			$keys[6] => $this->getActive(),
			$keys[7] => $this->getAllProducts(),
			$keys[8] => $this->getAutoActive(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DiscountPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setName($value);
				break;
			case 4:
				$this->setValue($value);
				break;
			case 5:
				$this->setPriority($value);
				break;
			case 6:
				$this->setActive($value);
				break;
			case 7:
				$this->setAllProducts($value);
				break;
			case 8:
				$this->setAutoActive($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DiscountPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setName($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setValue($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setPriority($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setActive($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setAllProducts($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setAutoActive($arr[$keys[8]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(DiscountPeer::DATABASE_NAME);

		if ($this->isColumnModified(DiscountPeer::CREATED_AT)) $criteria->add(DiscountPeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(DiscountPeer::UPDATED_AT)) $criteria->add(DiscountPeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(DiscountPeer::ID)) $criteria->add(DiscountPeer::ID, $this->id);
		if ($this->isColumnModified(DiscountPeer::NAME)) $criteria->add(DiscountPeer::NAME, $this->name);
		if ($this->isColumnModified(DiscountPeer::VALUE)) $criteria->add(DiscountPeer::VALUE, $this->value);
		if ($this->isColumnModified(DiscountPeer::PRIORITY)) $criteria->add(DiscountPeer::PRIORITY, $this->priority);
		if ($this->isColumnModified(DiscountPeer::ACTIVE)) $criteria->add(DiscountPeer::ACTIVE, $this->active);
		if ($this->isColumnModified(DiscountPeer::ALL_PRODUCTS)) $criteria->add(DiscountPeer::ALL_PRODUCTS, $this->all_products);
		if ($this->isColumnModified(DiscountPeer::AUTO_ACTIVE)) $criteria->add(DiscountPeer::AUTO_ACTIVE, $this->auto_active);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(DiscountPeer::DATABASE_NAME);

		$criteria->add(DiscountPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setName($this->name);

		$copyObj->setValue($this->value);

		$copyObj->setPriority($this->priority);

		$copyObj->setActive($this->active);

		$copyObj->setAllProducts($this->all_products);

		$copyObj->setAutoActive($this->auto_active);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getUserHasDiscounts() as $relObj) {
				$copyObj->addUserHasDiscount($relObj->copy($deepCopy));
			}

			foreach($this->getDiscountHasProducts() as $relObj) {
				$copyObj->addDiscountHasProduct($relObj->copy($deepCopy));
			}

			foreach($this->getDiscountRanges() as $relObj) {
				$copyObj->addDiscountRange($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new DiscountPeer();
		}
		return self::$peer;
	}

	
	public function initUserHasDiscounts()
	{
		if ($this->collUserHasDiscounts === null) {
			$this->collUserHasDiscounts = array();
		}
	}

	
	public function getUserHasDiscounts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserHasDiscounts === null) {
			if ($this->isNew()) {
			   $this->collUserHasDiscounts = array();
			} else {

				$criteria->add(UserHasDiscountPeer::DISCOUNT_ID, $this->getId());

				UserHasDiscountPeer::addSelectColumns($criteria);
				$this->collUserHasDiscounts = UserHasDiscountPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(UserHasDiscountPeer::DISCOUNT_ID, $this->getId());

				UserHasDiscountPeer::addSelectColumns($criteria);
				if (!isset($this->lastUserHasDiscountCriteria) || !$this->lastUserHasDiscountCriteria->equals($criteria)) {
					$this->collUserHasDiscounts = UserHasDiscountPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastUserHasDiscountCriteria = $criteria;
		return $this->collUserHasDiscounts;
	}

	
	public function countUserHasDiscounts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(UserHasDiscountPeer::DISCOUNT_ID, $this->getId());

		return UserHasDiscountPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addUserHasDiscount(UserHasDiscount $l)
	{
		$this->collUserHasDiscounts[] = $l;
		$l->setDiscount($this);
	}


	
	public function getUserHasDiscountsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collUserHasDiscounts === null) {
			if ($this->isNew()) {
				$this->collUserHasDiscounts = array();
			} else {

				$criteria->add(UserHasDiscountPeer::DISCOUNT_ID, $this->getId());

				$this->collUserHasDiscounts = UserHasDiscountPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(UserHasDiscountPeer::DISCOUNT_ID, $this->getId());

			if (!isset($this->lastUserHasDiscountCriteria) || !$this->lastUserHasDiscountCriteria->equals($criteria)) {
				$this->collUserHasDiscounts = UserHasDiscountPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastUserHasDiscountCriteria = $criteria;

		return $this->collUserHasDiscounts;
	}

	
	public function initDiscountHasProducts()
	{
		if ($this->collDiscountHasProducts === null) {
			$this->collDiscountHasProducts = array();
		}
	}

	
	public function getDiscountHasProducts($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDiscountHasProducts === null) {
			if ($this->isNew()) {
			   $this->collDiscountHasProducts = array();
			} else {

				$criteria->add(DiscountHasProductPeer::DISCOUNT_ID, $this->getId());

				DiscountHasProductPeer::addSelectColumns($criteria);
				$this->collDiscountHasProducts = DiscountHasProductPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DiscountHasProductPeer::DISCOUNT_ID, $this->getId());

				DiscountHasProductPeer::addSelectColumns($criteria);
				if (!isset($this->lastDiscountHasProductCriteria) || !$this->lastDiscountHasProductCriteria->equals($criteria)) {
					$this->collDiscountHasProducts = DiscountHasProductPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDiscountHasProductCriteria = $criteria;
		return $this->collDiscountHasProducts;
	}

	
	public function countDiscountHasProducts($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DiscountHasProductPeer::DISCOUNT_ID, $this->getId());

		return DiscountHasProductPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDiscountHasProduct(DiscountHasProduct $l)
	{
		$this->collDiscountHasProducts[] = $l;
		$l->setDiscount($this);
	}


	
	public function getDiscountHasProductsJoinProduct($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDiscountHasProducts === null) {
			if ($this->isNew()) {
				$this->collDiscountHasProducts = array();
			} else {

				$criteria->add(DiscountHasProductPeer::DISCOUNT_ID, $this->getId());

				$this->collDiscountHasProducts = DiscountHasProductPeer::doSelectJoinProduct($criteria, $con);
			}
		} else {
									
			$criteria->add(DiscountHasProductPeer::DISCOUNT_ID, $this->getId());

			if (!isset($this->lastDiscountHasProductCriteria) || !$this->lastDiscountHasProductCriteria->equals($criteria)) {
				$this->collDiscountHasProducts = DiscountHasProductPeer::doSelectJoinProduct($criteria, $con);
			}
		}
		$this->lastDiscountHasProductCriteria = $criteria;

		return $this->collDiscountHasProducts;
	}

	
	public function initDiscountRanges()
	{
		if ($this->collDiscountRanges === null) {
			$this->collDiscountRanges = array();
		}
	}

	
	public function getDiscountRanges($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collDiscountRanges === null) {
			if ($this->isNew()) {
			   $this->collDiscountRanges = array();
			} else {

				$criteria->add(DiscountRangePeer::DISCOUNT_ID, $this->getId());

				DiscountRangePeer::addSelectColumns($criteria);
				$this->collDiscountRanges = DiscountRangePeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(DiscountRangePeer::DISCOUNT_ID, $this->getId());

				DiscountRangePeer::addSelectColumns($criteria);
				if (!isset($this->lastDiscountRangeCriteria) || !$this->lastDiscountRangeCriteria->equals($criteria)) {
					$this->collDiscountRanges = DiscountRangePeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastDiscountRangeCriteria = $criteria;
		return $this->collDiscountRanges;
	}

	
	public function countDiscountRanges($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(DiscountRangePeer::DISCOUNT_ID, $this->getId());

		return DiscountRangePeer::doCount($criteria, $distinct, $con);
	}

	
	public function addDiscountRange(DiscountRange $l)
	{
		$this->collDiscountRanges[] = $l;
		$l->setDiscount($this);
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'Discount.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseDiscount:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseDiscount::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 