<?php


abstract class BaseDiscountCouponCode extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $created_at;


	
	protected $updated_at;


	
	protected $id;


	
	protected $sf_guard_user_id;


	
	protected $code;


	
	protected $used = 0;


	
	protected $valid_usage = 0;


	
	protected $valid_from;


	
	protected $valid_to;


	
	protected $discount = 0;

	
	protected $asfGuardUser;

	
	protected $collBaskets;

	
	protected $lastBasketCriteria = null;

	
	protected $collOrders;

	
	protected $lastOrderCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

	
	public function getCreatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->created_at === null || $this->created_at === '') {
			return null;
		} elseif (!is_int($this->created_at)) {
						$ts = strtotime($this->created_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [created_at] as date/time value: " . var_export($this->created_at, true));
			}
		} else {
			$ts = $this->created_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getUpdatedAt($format = 'Y-m-d H:i:s')
	{

		if ($this->updated_at === null || $this->updated_at === '') {
			return null;
		} elseif (!is_int($this->updated_at)) {
						$ts = strtotime($this->updated_at);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [updated_at] as date/time value: " . var_export($this->updated_at, true));
			}
		} else {
			$ts = $this->updated_at;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getSfGuardUserId()
    {

            return $this->sf_guard_user_id;
    }

    
    public function getCode()
    {

            return $this->code;
    }

    
    public function getUsed()
    {

            return $this->used;
    }

    
    public function getValidUsage()
    {

            return $this->valid_usage;
    }

	
	public function getValidFrom($format = 'Y-m-d H:i:s')
	{

		if ($this->valid_from === null || $this->valid_from === '') {
			return null;
		} elseif (!is_int($this->valid_from)) {
						$ts = strtotime($this->valid_from);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [valid_from] as date/time value: " . var_export($this->valid_from, true));
			}
		} else {
			$ts = $this->valid_from;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

	
	public function getValidTo($format = 'Y-m-d H:i:s')
	{

		if ($this->valid_to === null || $this->valid_to === '') {
			return null;
		} elseif (!is_int($this->valid_to)) {
						$ts = strtotime($this->valid_to);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [valid_to] as date/time value: " . var_export($this->valid_to, true));
			}
		} else {
			$ts = $this->valid_to;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getDiscount()
    {

            return null !== $this->discount ? (string)$this->discount : null;
    }

	
	public function setCreatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [created_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->created_at !== $ts) {
			$this->created_at = $ts;
			$this->modifiedColumns[] = DiscountCouponCodePeer::CREATED_AT;
		}

	} 
	
	public function setUpdatedAt($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [updated_at] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->updated_at !== $ts) {
			$this->updated_at = $ts;
			$this->modifiedColumns[] = DiscountCouponCodePeer::UPDATED_AT;
		}

	} 
	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = DiscountCouponCodePeer::ID;
        }

	} 
	
	public function setSfGuardUserId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->sf_guard_user_id !== $v) {
          $this->sf_guard_user_id = $v;
          $this->modifiedColumns[] = DiscountCouponCodePeer::SF_GUARD_USER_ID;
        }

		if ($this->asfGuardUser !== null && $this->asfGuardUser->getId() !== $v) {
			$this->asfGuardUser = null;
		}

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = DiscountCouponCodePeer::CODE;
        }

	} 
	
	public function setUsed($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->used !== $v || $v === 0) {
          $this->used = $v;
          $this->modifiedColumns[] = DiscountCouponCodePeer::USED;
        }

	} 
	
	public function setValidUsage($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->valid_usage !== $v || $v === 0) {
          $this->valid_usage = $v;
          $this->modifiedColumns[] = DiscountCouponCodePeer::VALID_USAGE;
        }

	} 
	
	public function setValidFrom($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [valid_from] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->valid_from !== $ts) {
			$this->valid_from = $ts;
			$this->modifiedColumns[] = DiscountCouponCodePeer::VALID_FROM;
		}

	} 
	
	public function setValidTo($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [valid_to] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->valid_to !== $ts) {
			$this->valid_to = $ts;
			$this->modifiedColumns[] = DiscountCouponCodePeer::VALID_TO;
		}

	} 
	
	public function setDiscount($v)
	{

        if ($this->discount !== $v || $v === 0) {
          $this->discount = $v;
          $this->modifiedColumns[] = DiscountCouponCodePeer::DISCOUNT;
        }

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'DiscountCouponCode.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->created_at = $rs->getTimestamp($startcol + 0, null);

      $this->updated_at = $rs->getTimestamp($startcol + 1, null);

      $this->id = $rs->getInt($startcol + 2);

      $this->sf_guard_user_id = $rs->getInt($startcol + 3);

      $this->code = $rs->getString($startcol + 4);

      $this->used = $rs->getInt($startcol + 5);

      $this->valid_usage = $rs->getInt($startcol + 6);

      $this->valid_from = $rs->getTimestamp($startcol + 7, null);

      $this->valid_to = $rs->getTimestamp($startcol + 8, null);

      $this->discount = $rs->getString($startcol + 9, null);

      $this->discount = $rs->getFloat($startcol + 9);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'DiscountCouponCode.postHydrate', array('resultset' => $rs, 'startcol' => 10)));

            return $startcol + 10; 
    } catch (Exception $e) {
      throw new PropelException("Error populating DiscountCouponCode object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseDiscountCouponCode:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DiscountCouponCodePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			DiscountCouponCodePeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseDiscountCouponCode:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'DiscountCouponCode.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseDiscountCouponCode:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


    if ($this->isNew() && !$this->isColumnModified(DiscountCouponCodePeer::CREATED_AT))
    {
      $this->setCreatedAt(time());
    }

    if ($this->isModified() && !$this->isColumnModified(DiscountCouponCodePeer::UPDATED_AT))
    {
      $this->setUpdatedAt(time());
    }

		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(DiscountCouponCodePeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'DiscountCouponCode.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseDiscountCouponCode:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->asfGuardUser !== null) {
				if ($this->asfGuardUser->isModified()) {
					$affectedRows += $this->asfGuardUser->save($con);
				}
				$this->setsfGuardUser($this->asfGuardUser);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = DiscountCouponCodePeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += DiscountCouponCodePeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collBaskets !== null) {
				foreach($this->collBaskets as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			if ($this->collOrders !== null) {
				foreach($this->collOrders as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->asfGuardUser !== null) {
				if (!$this->asfGuardUser->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->asfGuardUser->getValidationFailures());
				}
			}


			if (($retval = DiscountCouponCodePeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collBaskets !== null) {
					foreach($this->collBaskets as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}

				if ($this->collOrders !== null) {
					foreach($this->collOrders as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DiscountCouponCodePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getCreatedAt();
				break;
			case 1:
				return $this->getUpdatedAt();
				break;
			case 2:
				return $this->getId();
				break;
			case 3:
				return $this->getSfGuardUserId();
				break;
			case 4:
				return $this->getCode();
				break;
			case 5:
				return $this->getUsed();
				break;
			case 6:
				return $this->getValidUsage();
				break;
			case 7:
				return $this->getValidFrom();
				break;
			case 8:
				return $this->getValidTo();
				break;
			case 9:
				return $this->getDiscount();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DiscountCouponCodePeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getCreatedAt(),
			$keys[1] => $this->getUpdatedAt(),
			$keys[2] => $this->getId(),
			$keys[3] => $this->getSfGuardUserId(),
			$keys[4] => $this->getCode(),
			$keys[5] => $this->getUsed(),
			$keys[6] => $this->getValidUsage(),
			$keys[7] => $this->getValidFrom(),
			$keys[8] => $this->getValidTo(),
			$keys[9] => $this->getDiscount(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = DiscountCouponCodePeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setCreatedAt($value);
				break;
			case 1:
				$this->setUpdatedAt($value);
				break;
			case 2:
				$this->setId($value);
				break;
			case 3:
				$this->setSfGuardUserId($value);
				break;
			case 4:
				$this->setCode($value);
				break;
			case 5:
				$this->setUsed($value);
				break;
			case 6:
				$this->setValidUsage($value);
				break;
			case 7:
				$this->setValidFrom($value);
				break;
			case 8:
				$this->setValidTo($value);
				break;
			case 9:
				$this->setDiscount($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = DiscountCouponCodePeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setCreatedAt($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setUpdatedAt($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setId($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setSfGuardUserId($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setCode($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setUsed($arr[$keys[5]]);
		if (array_key_exists($keys[6], $arr)) $this->setValidUsage($arr[$keys[6]]);
		if (array_key_exists($keys[7], $arr)) $this->setValidFrom($arr[$keys[7]]);
		if (array_key_exists($keys[8], $arr)) $this->setValidTo($arr[$keys[8]]);
		if (array_key_exists($keys[9], $arr)) $this->setDiscount($arr[$keys[9]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(DiscountCouponCodePeer::DATABASE_NAME);

		if ($this->isColumnModified(DiscountCouponCodePeer::CREATED_AT)) $criteria->add(DiscountCouponCodePeer::CREATED_AT, $this->created_at);
		if ($this->isColumnModified(DiscountCouponCodePeer::UPDATED_AT)) $criteria->add(DiscountCouponCodePeer::UPDATED_AT, $this->updated_at);
		if ($this->isColumnModified(DiscountCouponCodePeer::ID)) $criteria->add(DiscountCouponCodePeer::ID, $this->id);
		if ($this->isColumnModified(DiscountCouponCodePeer::SF_GUARD_USER_ID)) $criteria->add(DiscountCouponCodePeer::SF_GUARD_USER_ID, $this->sf_guard_user_id);
		if ($this->isColumnModified(DiscountCouponCodePeer::CODE)) $criteria->add(DiscountCouponCodePeer::CODE, $this->code);
		if ($this->isColumnModified(DiscountCouponCodePeer::USED)) $criteria->add(DiscountCouponCodePeer::USED, $this->used);
		if ($this->isColumnModified(DiscountCouponCodePeer::VALID_USAGE)) $criteria->add(DiscountCouponCodePeer::VALID_USAGE, $this->valid_usage);
		if ($this->isColumnModified(DiscountCouponCodePeer::VALID_FROM)) $criteria->add(DiscountCouponCodePeer::VALID_FROM, $this->valid_from);
		if ($this->isColumnModified(DiscountCouponCodePeer::VALID_TO)) $criteria->add(DiscountCouponCodePeer::VALID_TO, $this->valid_to);
		if ($this->isColumnModified(DiscountCouponCodePeer::DISCOUNT)) $criteria->add(DiscountCouponCodePeer::DISCOUNT, $this->discount);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(DiscountCouponCodePeer::DATABASE_NAME);

		$criteria->add(DiscountCouponCodePeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setCreatedAt($this->created_at);

		$copyObj->setUpdatedAt($this->updated_at);

		$copyObj->setSfGuardUserId($this->sf_guard_user_id);

		$copyObj->setCode($this->code);

		$copyObj->setUsed($this->used);

		$copyObj->setValidUsage($this->valid_usage);

		$copyObj->setValidFrom($this->valid_from);

		$copyObj->setValidTo($this->valid_to);

		$copyObj->setDiscount($this->discount);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getBaskets() as $relObj) {
				$copyObj->addBasket($relObj->copy($deepCopy));
			}

			foreach($this->getOrders() as $relObj) {
				$copyObj->addOrder($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new DiscountCouponCodePeer();
		}
		return self::$peer;
	}

	
	public function setsfGuardUser($v)
	{


		if ($v === null) {
			$this->setSfGuardUserId(NULL);
		} else {
			$this->setSfGuardUserId($v->getId());
		}


		$this->asfGuardUser = $v;
	}


	
	public function getsfGuardUser($con = null)
	{
		if ($this->asfGuardUser === null && ($this->sf_guard_user_id !== null)) {
						$this->asfGuardUser = sfGuardUserPeer::retrieveByPK($this->sf_guard_user_id, $con);

			
		}
		return $this->asfGuardUser;
	}

	
	public function initBaskets()
	{
		if ($this->collBaskets === null) {
			$this->collBaskets = array();
		}
	}

	
	public function getBaskets($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBaskets === null) {
			if ($this->isNew()) {
			   $this->collBaskets = array();
			} else {

				$criteria->add(BasketPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				BasketPeer::addSelectColumns($criteria);
				$this->collBaskets = BasketPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(BasketPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				BasketPeer::addSelectColumns($criteria);
				if (!isset($this->lastBasketCriteria) || !$this->lastBasketCriteria->equals($criteria)) {
					$this->collBaskets = BasketPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastBasketCriteria = $criteria;
		return $this->collBaskets;
	}

	
	public function countBaskets($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(BasketPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

		return BasketPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addBasket(Basket $l)
	{
		$this->collBaskets[] = $l;
		$l->setDiscountCouponCode($this);
	}


	
	public function getBasketsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collBaskets === null) {
			if ($this->isNew()) {
				$this->collBaskets = array();
			} else {

				$criteria->add(BasketPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collBaskets = BasketPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(BasketPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastBasketCriteria) || !$this->lastBasketCriteria->equals($criteria)) {
				$this->collBaskets = BasketPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastBasketCriteria = $criteria;

		return $this->collBaskets;
	}

	
	public function initOrders()
	{
		if ($this->collOrders === null) {
			$this->collOrders = array();
		}
	}

	
	public function getOrders($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
			   $this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				$this->collOrders = OrderPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				OrderPeer::addSelectColumns($criteria);
				if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
					$this->collOrders = OrderPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastOrderCriteria = $criteria;
		return $this->collOrders;
	}

	
	public function countOrders($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

		return OrderPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addOrder(Order $l)
	{
		$this->collOrders[] = $l;
		$l->setDiscountCouponCode($this);
	}


	
	public function getOrdersJoinOrderDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataDelivery($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataDelivery($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderUserDataBilling($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderUserDataBilling($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderCurrency($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderCurrency($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinOrderStatus($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinOrderStatus($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


	
	public function getOrdersJoinPartner($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collOrders === null) {
			if ($this->isNew()) {
				$this->collOrders = array();
			} else {

				$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		} else {
									
			$criteria->add(OrderPeer::DISCOUNT_COUPON_CODE_ID, $this->getId());

			if (!isset($this->lastOrderCriteria) || !$this->lastOrderCriteria->equals($criteria)) {
				$this->collOrders = OrderPeer::doSelectJoinPartner($criteria, $con);
			}
		}
		$this->lastOrderCriteria = $criteria;

		return $this->collOrders;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'DiscountCouponCode.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseDiscountCouponCode:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseDiscountCouponCode::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 