<?php
/**
 * SOTESHOP/stDiscountPlugin
 *
 * Ten plik należy do aplikacji stDiscountPlugin opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stDiscountPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stDiscount.class.php 10157 2011-01-12 09:30:11Z piotr $
 */

class stDiscount {

    /**
     * Czy uzytkownika posiada rabat
     *
     * @var boolean
     */
    protected static $userHasDiscount = false;

    /**
     *
     * @var object
     */
    protected static $user = null;

    /**
     *
     * @var double
     */
    protected static $globalDiscount = 0.0;

    /**
     * Tablica rabatow na produkty
     * @var array
     */
    protected static $productArray= array();

    /**
     * Pobiera cene po rabacie dla dane produktu
     * @param $product object
     * @param $price double
     * @return double
     */
    public static function getDiscountForProduct($product, $price) {

        $discountValue = 0.0;

        if (stDiscount::$user == null) {stDiscount::getUser(); }
         
        if (isset(stDiscount::$productArray[$product->getId()])) return stDiscount::calculateDiscountPrice($price,stDiscount::$productArray[$product->getId()]);

        // sprawdz najpierw rabat ogolny
        if (stDiscount::$globalDiscount!=0.0) {
            $discountValue = ($product->getMaxDiscount()<stDiscount::$globalDiscount && $product->getMaxDiscount()>=0)?$product->getMaxDiscount():stDiscount::$globalDiscount;
            stDiscount::$productArray[$product->getId()] = $discountValue;
            return stDiscount::calculateDiscountPrice($price, stDiscount::$productArray[$product->getId()]);
        }
         
        // jeżeli nie ma rabatu ogolnego poszukaj rabat na produkty
        if (is_array(stDiscount::$userHasDiscount)) {
            $c = new Criteria();
            $c->add(DiscountPeer::ID,stDiscount::$userHasDiscount,Criteria::IN);
            $c->addDescendingOrderByColumn(DiscountPeer::PRIORITY);
            $c->addJoin(DiscountPeer::ID,DiscountHasProductPeer::DISCOUNT_ID, Criteria::LEFT_JOIN);

            $c2 = $c->getNewCriterion(DiscountHasProductPeer::PRODUCT_ID,$product->getId());
            $c3 = $c->getNewCriterion(DiscountPeer::ALL_PRODUCTS, 0, Criteria::NOT_EQUAL);

            $c2->addOr($c3);
            $c->add($c2);
            $discount = DiscountPeer::doSelectOne($c);
            if ($discount) {
                $discountValue = ($product->getMaxDiscount()<$discount->getValue() && $product->getMaxDiscount()>=0)?$product->getMaxDiscount():$discount->getValue();
                stDiscount::$productArray[$product->getId()] = $discountValue;
                return stDiscount::calculateDiscountPrice($price,stDiscount::$productArray[$product->getId()]);
            }
        }
        stDiscount::$productArray[$product->getId()] = null;
        return $price;
    }

    /**
     * Zwraca tablice zawierajaca nazwe i wartosc rabatu, tablica zawiera:
     * - name - nazwa rabatu (jezeli nie ma rabatu to "")
     * - value - procentowa wartosc rabatu (jezeli nie ma rabatu to null)
     * - discount - objekt rabatu (jezeli nie ma rabatu lub rabat ogolny to null)
     *
     * @param $product - objekt produktu
     * @return array
     */
    public static function getDiscountInfoForProduct(Product $product) {

        $discountValue = 0.0;

        if (stDiscount::$user == null) {stDiscount::getUser(); }
         
        // sprawdz najpierw rabat ogolny
        if (stDiscount::$globalDiscount!=0.0) {
            $discountValue = ($product->getMaxDiscount()<stDiscount::$globalDiscount && $product->getMaxDiscount()>=0)?$product->getMaxDiscount():stDiscount::$globalDiscount;
            stDiscount::$productArray[$product->getId()] = $discountValue;
            return array('name'=>sfContext::getInstance()->getI18n()->__("Rabat ogólny użytkownika"), 'value'=>$discountValue, 'discount'=>null);
        }
         
        // jeżeli nie ma rabatu ogolnego poszukaj rabat na produkty
        if (is_array(stDiscount::$userHasDiscount)) {
            $c = new Criteria();
            $c->add(DiscountPeer::ID,stDiscount::$userHasDiscount,Criteria::IN);
            $c->addDescendingOrderByColumn(DiscountPeer::PRIORITY);
            $c->addJoin(DiscountPeer::ID,DiscountHasProductPeer::DISCOUNT_ID, Criteria::LEFT_JOIN);

            $c2 = $c->getNewCriterion(DiscountHasProductPeer::PRODUCT_ID,$product->getId());
            $c3 = $c->getNewCriterion(DiscountPeer::ALL_PRODUCTS, 0, Criteria::NOT_EQUAL);

            $c2->addOr($c3);
            $c->add($c2);
            $discount = DiscountPeer::doSelectOne($c);
            if ($discount) {
                $discountValue = ($product->getMaxDiscount()<$discount->getValue() && $product->getMaxDiscount()>=0)?$product->getMaxDiscount():$discount->getValue();
                stDiscount::$productArray[$product->getId()] = $discountValue;
                return array('name'=>$discount->getName(), 'value'=>$discountValue, 'discount'=>$discount);
            }
        }

        stDiscount::$productArray[$product->getId()] = null;
        return array('name'=>"", 'value'=>null, 'discount'=>null);
    }

    /**
     * Oblicza nowa cene na podstawie rabatu, w przypadku rabatu zwracana jest
     * wartosc null
     *
     * @param $price float cena produktu
     * @param $discountValue float wartosc rabatu
     * @return float
     */
    public static function calculateDiscountPrice($price, $discountValue) {
        if ($discountValue===null) return $price;
        return $price*(1.0 - $discountValue/100.0);
    }

    /**
     * Dodaje użytkownika do grupy rabatowej
     *
     * @param $user_id
     * @param $discount_id
     * @param $auto
     * @return unknown_type
     */
    public static function AddUserDiscount($user_id, $discount_id, $auto = true) {

        $c = new Criteria();
        $c->add(UserHasDiscountPeer::SF_GUARD_USER_ID,$user_id);
        $c->add(UserHasDiscountPeer::AUTO,true);

        UserHasDiscountPeer::doDelete($c);

        $c = new Criteria();
        $c->add(UserHasDiscountPeer::DISCOUNT_ID,$discount_id);
        $c->add(UserHasDiscountPeer::SF_GUARD_USER_ID,$user_id);

        $userHasDiscount = UserHasDiscountPeer::doSelectOne($c);

        if (!$userHasDiscount) {

            $userHasDiscount = new UserHasDiscount();
            $userHasDiscount->setDiscountId($discount_id);
            $userHasDiscount->setSfGuardUserId($user_id);
            $userHasDiscount->setAuto($auto);
            $userHasDiscount->save();
        }

    }

    /**
     * Pobiera aktulalnie zalogowanego użytkonika i jego grupy rabatowe
     *
     */
    protected static function getUser() {
        stDiscount::$user = sfContext::getInstance()->getUser()->getGuardUser();

        if (!stDiscount::$user) return;

        $c = new Criteria();
        $c->add(DiscountUserPeer::SF_GUARD_USER_ID,stDiscount::$user->getId());
        $discount = DiscountUserPeer::doSelectOne($c);

        if (is_object($discount)) {stDiscount::$globalDiscount = $discount->getDiscount();}

        $c = new Criteria();
        $c->add(UserHasDiscountPeer::SF_GUARD_USER_ID,stDiscount::$user->getId());
        $c->addJoin(DiscountPeer::ID,UserHasDiscountPeer::DISCOUNT_ID);
        $c->add(DiscountPeer::ACTIVE, true);
        $discounts = DiscountPeer::doSelect($c);

        if (count($discounts)) {stDiscount::$userHasDiscount = array();}
        foreach ($discounts as $discount) {
            stDiscount::$userHasDiscount[] = $discount->getId();
        }

    }

    public static function setMaxDiscount(Product $object, $value) {
        if (!is_numeric($value)) return false;
        if ($value > 100) $value = 100.0;
        if ($value < 0) $value = 0.0;
        $object->setMaxDiscount($value);
    }
    
    public static function getOrderSumForUser($order)
    {
      	$user_id = $order->getSfGuardUserId();
      	if (!empty($user_id))
      	{
	    	$sql = "SELECT 
	    			SUM(".OrderProductPeer::QUANTITY."*".OrderProductPeer::PRICE_BRUTTO.") as order_sum
	    			FROM ".OrderProductPeer::TABLE_NAME.", ".OrderPeer::TABLE_NAME.", ".OrderStatusPeer::TABLE_NAME." 
	    			WHERE ".OrderProductPeer::ORDER_ID." = ".OrderPeer::ID." 
	    			AND ".OrderPeer::ORDER_STATUS_ID." = ".OrderStatusPeer::ID." 
	    			AND ".OrderStatusPeer::TYPE." = \"ST_COMPLETE\"
	    			AND ".OrderPeer::SF_GUARD_USER_ID." = $user_id";
	        $connection = Propel::getConnection();
	        $statement = $connection->prepareStatement($sql);
	        $rs = $statement->executeQuery();
			$rs->next();
			$row = $rs->getRow();
	        return doubleval($row['order_sum']);
      	} 
      	return 0.0;
    }
}
?>