<?php

/**
 * SOTESHOP/stDiscountPlugin
 *
 * Ten plik należy do aplikacji stDiscountPlugin opartej na licencji (Professional License SOTE).
 * Nie zmieniaj tego pliku, jeśli chcesz korzystać z automatycznych aktualizacji oprogramowania.
 * Jeśli chcesz wprowadzać swoje modyfikacje do programu, zapoznaj się z dokumentacją, jak zmieniać
 * oprogramowanie bez zmiany kodu bazowego http://www.sote.pl/modifications
 *
 * @package     stDiscountPlugin
 * @subpackage  libs
 * @copyright   SOTE (www.sote.pl)
 * @license     http://www.sote.pl/license/sote (Professional License SOTE)
 * @version     $Id: stPluginDiscountBackendActions.class.php 10758 2011-02-02 11:00:18Z pawel $
 */
class stPluginDiscountBackendActions extends autostDiscountBackendActions
{

   public function executeConfig()
   {
      if ($this->getRequest()->getMethod() == sfRequest::POST && $this->hasRequestParameter('config[coupon_code]') && stLicense::isOpen())
      {
         return $this->forward('stBackendMain', 'Open');
      }

      return parent::executeConfig();
   }

   public function executeCouponCodeList()
   {

      $context = sfContext::getInstance();

      if (stLicense::isOpen())
      {
         return $this->forward('stBackendMain', 'Open');
      }

      if (!stConfig::getInstance($this->getContext(), 'stDiscountBackend')->get('coupon_code'))
      {
         $notice = $context->getI18N()->__('Aby korzystać z kodów rabatowych w sklepie musisz je włączyć w konfiguracji');
         $this->setFlash('notice', $notice);

         return $this->redirect('stDiscountBackend/config');
      }
      
      return parent::executeCouponCodeList();
   }

   public function executeCouponCodeEdit()
   {
      if (stLicense::isOpen())
      {
         return $this->forward('stBackendMain', 'Open');
      }

      return parent::executeCouponCodeEdit();
   }

   public function executeList()
   {
      parent::executeList();
      $this->fixPriority();
      if ($this->hasRequestParameter('id') && $this->hasRequestParameter('pos'))
      {
         $discount = DiscountPeer::retrieveByPk($this->getRequestParameter('id'));
         if (is_object($discount))
         {
            if ($this->getRequestParameter('pos') == 1)
               $discount->moveUp();
            if ($this->getRequestParameter('pos') == -1)
               $discount->moveDown();
            $discount->save();
         }
         return $this->redirect('stDiscountBackend/list');
      }
   }

   public function executeUserList()
   {
      parent::executeUserList();

      $c = $this->pager->getCriteria();

      $c->setDistinct(true);

      $c->add(sfGuardUserPeer::IS_SUPER_ADMIN, 0);

      $c->add(sfGuardUserPeer::ID, 1, Criteria::NOT_EQUAL);

      $this->pager->init();
   }

   public function executeUserAddGroup()
   {
      $ids = $this->getRequestParameter('sf_guard_user[selected]', array());
      $related_id = $this->getRequestParameter('forward_parameters[discount_id]');

      foreach ($ids as $id)
      {
         $c = new Criteria();
         $c->add(UserHasDiscountPeer::DISCOUNT_ID, $related_id);
         $c->add(UserHasDiscountPeer::SF_GUARD_USER_ID, $id);

         if (!UserHasDiscountPeer::doCount($c))
         {
            $user_has_discount = new UserHasDiscount();
            $user_has_discount->setDiscountId($related_id);
            $user_has_discount->setSfGuardUserId($id);
            $user_has_discount->save();
         }
      }

      $this->redirect($this->getRequest()->getReferer());
   }

   public function executeProductAddGroup()
   {
      $ids = $this->getRequestParameter('product[selected]', array());
      $related_id = $this->getRequestParameter('forward_parameters[discount_id]');

      foreach ($ids as $id)
      {
         $c = new Criteria();
         $c->add(DiscountHasProductPeer::DISCOUNT_ID, $related_id);
         $c->add(DiscountHasProductPeer::PRODUCT_ID, $id);

         if (!DiscountHasProductPeer::doCount($c))
         {
            $discount_has_product = new DiscountHasProduct();
            $discount_has_product->setDiscountId($related_id);
            $discount_has_product->setProductId($id);
            $discount_has_product->save();
         }
      }

      $this->redirect($this->getRequest()->getReferer());
   }

   public function executeProductList()
   {
      parent::executeProductList();
      $c = $this->pager->getCriteria();
      $c->setDistinct(true);
      $this->pager->setCriteria($c);
      $this->pager->init();

      $this->allProducts = false;
      $discount = DiscountPeer::retrieveByPk($this->getRequestParameter('discount_id'));
      if (is_object($discount) && $discount->getAllProducts())
      {
         $this->setFlash('notice', "Rabat jest przypisany do wszystkich produktów", false);
         $this->allProducts = true;
      }
   }

   public function executeRangeList()
   {
      parent::executeRangeList();
      $this->discountCount = DiscountPeer::doCount(new Criteria());
      if (!$this->discountCount)
      {
         $this->setFlash('notice', "Przed ustawieniem progów rabatowych, proszę utworzyć co najmniej jeden rabat.", false);
      }
   }

   public function fixPriority()
   {
      $con = Propel::getConnection();
      $query = "SELECT COUNT(`id`) as cnt FROM `st_discount` GROUP BY `priority` ORDER BY cnt DESC LIMIT 1";
      $stmt = $con->prepareStatement($query);
      $resultset = $stmt->executeQuery();
      if ($resultset->next() && $resultset->getInt('cnt') > 1)
      {
         $c = new Criteria();
         $c->addAscendingOrderByColumn(DiscountPeer::PRIORITY);
         $discounts = DiscountPeer::doSelect($c);
         $i = 1;
         foreach ($discounts as $discount)
         {
            $discount->setPriority($i);
            $discount->save();
            $i++;
         }
      }
   }
}
