<?php

class stDiscountFrontendComponents extends sfComponents
{

   public function executeCouponCode()
   {
      $config = stConfig::getInstance($this->getContext(), 'stDiscountBackend');

      if (!$config->get('coupon_code'))
      {
         return sfView::NONE;
      }
      
      $this->smarty = new stSmarty('stDiscountFrontend');

      $this->smarty->assign('form', array(
          'code' => $this->getRequestParameter('discount[coupon_code]'),
          'action' => $this->getController()->genUrl(array('module' => 'stDiscountFrontend', 'action' => 'activateCouponCode')),
          'error' => $this->getFlash('discount_coupon_code_error'),
          'return_url' => $this->return_url
      ));

      $coupon_code = stBasket::getInstance($this->getUser())->getCouponCode();

      if ($coupon_code)
      {
         $this->smarty->assign('coupon_code', array(
             'discount' => $coupon_code->getDiscount(),
             'instance' => $coupon_code,
             'remove_url' => $this->getController()->genUrl('stDiscountFrontend/deactivateCouponCode?return_url='.rawurlencode($this->return_url)),
         ));
      }
   }

}

?>
