<?php

/**
 * Subclass for representing a row from the 'st_gift_card' table.
 *
 * 
 *
 * @package plugins.stGiftCardPlugin.lib.model
 */ 
class GiftCard extends BaseGiftCard
{
   public function validateDate()
   {
      $current_time = time();

      return !$this->getValidTo() || strtotime($this->getValidTo()) >= $current_time;
   }   
   
   public function isValid()
   {
      return $this->isActive() && $this->validateDate();
   }
   
   public function isActive()
   {
      return $this->status == 'A';
   }
   
   public function isUsed()
   {
      return $this->status == 'U';
   }
   
   public function isPending()
   {  
      return $this->status == 'P';
   }
}
