<?php


abstract class BaseGiftCard extends BaseObject  implements Persistent {


              protected static $dispatcher = null;

	
	protected static $peer;


	
	protected $id;


	
	protected $status = 'A';


	
	protected $amount;


	
	protected $code;


	
	protected $valid_to;


	
	protected $currency_id;

	
	protected $aCurrency;

	
	protected $collPayments;

	
	protected $lastPaymentCriteria = null;

	
	protected $alreadyInSave = false;

	
	protected $alreadyInValidation = false;

    
    public function getId()
    {

            return $this->id;
    }

    
    public function getStatus()
    {

            return $this->status;
    }

    
    public function getAmount()
    {

            return null !== $this->amount ? (string)$this->amount : null;
    }

    
    public function getCode()
    {

            return $this->code;
    }

	
	public function getValidTo($format = 'Y-m-d')
	{

		if ($this->valid_to === null || $this->valid_to === '') {
			return null;
		} elseif (!is_int($this->valid_to)) {
						$ts = strtotime($this->valid_to);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse value of [valid_to] as date/time value: " . var_export($this->valid_to, true));
			}
		} else {
			$ts = $this->valid_to;
		}
		if ($format === null) {
			return $ts;
		} elseif (strpos($format, '%') !== false) {
			return strftime($format, $ts);
		} else {
			return date($format, $ts);
		}
	}

    
    public function getCurrencyId()
    {

            return $this->currency_id;
    }

	
	public function setId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->id !== $v) {
          $this->id = $v;
          $this->modifiedColumns[] = GiftCardPeer::ID;
        }

	} 
	
	public function setStatus($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->status !== $v || $v === 'A') {
          $this->status = $v;
          $this->modifiedColumns[] = GiftCardPeer::STATUS;
        }

	} 
	
	public function setAmount($v)
	{

        if ($this->amount !== $v) {
          $this->amount = $v;
          $this->modifiedColumns[] = GiftCardPeer::AMOUNT;
        }

	} 
	
	public function setCode($v)
	{

                        if ($v !== null && !is_string($v)) {
          $v = (string) $v;
        }

        if ($this->code !== $v) {
          $this->code = $v;
          $this->modifiedColumns[] = GiftCardPeer::CODE;
        }

	} 
	
	public function setValidTo($v)
	{

		if ($v !== null && !is_int($v)) {
			$ts = strtotime($v);
			if ($ts === -1 || $ts === false) { 				throw new PropelException("Unable to parse date/time value for [valid_to] from input: " . var_export($v, true));
			}
		} else {
			$ts = $v;
		}
		if ($this->valid_to !== $ts) {
			$this->valid_to = $ts;
			$this->modifiedColumns[] = GiftCardPeer::VALID_TO;
		}

	} 
	
	public function setCurrencyId($v)
	{

                        if ($v !== null && !is_int($v) && is_numeric($v)) {
          $v = (int) $v;
        }

        if ($this->currency_id !== $v) {
          $this->currency_id = $v;
          $this->modifiedColumns[] = GiftCardPeer::CURRENCY_ID;
        }

		if ($this->aCurrency !== null && $this->aCurrency->getId() !== $v) {
			$this->aCurrency = null;
		}

	} 
  
  public function hydrate(ResultSet $rs, $startcol = 1)
  {
    try {
      $this->getDispatcher()->notify(new sfEvent($this, 'GiftCard.preHydrate', array('resultset' => $rs, 'startcol' => 1)));

      $this->id = $rs->getInt($startcol + 0);

      $this->status = $rs->getString($startcol + 1);

      $this->amount = $rs->getString($startcol + 2, null);

      $this->amount = $rs->getFloat($startcol + 2);

      $this->code = $rs->getString($startcol + 3);

      $this->valid_to = $rs->getDate($startcol + 4, null);

      $this->currency_id = $rs->getInt($startcol + 5);

      $this->resetModified();

      $this->setNew(false);

      $this->getDispatcher()->notify(new sfEvent($this, 'GiftCard.postHydrate', array('resultset' => $rs, 'startcol' => 6)));

            return $startcol + 6; 
    } catch (Exception $e) {
      throw new PropelException("Error populating GiftCard object", $e);
    }
  }

	
	public function delete($con = null)
	{

    foreach (sfMixer::getCallables('BaseGiftCard:delete:pre') as $callable)
    {
      $ret = call_user_func($callable, $this, $con);
      if ($ret)
      {
        return;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("This object has already been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(GiftCardPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			GiftCardPeer::doDelete($this, $con);
			$this->setDeleted(true);
			$con->commit();
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	

    foreach (sfMixer::getCallables('BaseGiftCard:delete:post') as $callable)
    {
      call_user_func($callable, $this, $con);
    }

  }
	
	public function save($con = null)
	{
              $this->getDispatcher()->notify(new sfEvent($this, 'GiftCard.preSave', array('con' => $con)));


    foreach (sfMixer::getCallables('BaseGiftCard:save:pre') as $callable)
    {
      $affectedRows = call_user_func($callable, $this, $con);
      if (is_int($affectedRows))
      {
        return $affectedRows;
      }
    }


		if ($this->isDeleted()) {
			throw new PropelException("You cannot save an object that has been deleted.");
		}

		if ($con === null) {
			$con = Propel::getConnection(GiftCardPeer::DATABASE_NAME);
		}

		try {
			$con->begin();
			$affectedRows = $this->doSave($con);
			$con->commit();
              $this->getDispatcher()->notify(new sfEvent($this, 'GiftCard.postSave', array('con' => $con)));

    foreach (sfMixer::getCallables('BaseGiftCard:save:post') as $callable)
    {
      call_user_func($callable, $this, $con, $affectedRows);
    }

			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected function doSave($con)
	{
		$affectedRows = 0; 		if (!$this->alreadyInSave) {
			$this->alreadyInSave = true;


												
			if ($this->aCurrency !== null) {
				if ($this->aCurrency->isModified() || $this->aCurrency->getCurrentCurrencyI18n()->isModified()) {
					$affectedRows += $this->aCurrency->save($con);
				}
				$this->setCurrency($this->aCurrency);
			}


						if ($this->isModified()) {
				if ($this->isNew()) {
					$pk = GiftCardPeer::doInsert($this, $con);
					$affectedRows += 1; 										 										 
					$this->setId($pk);  
					$this->setNew(false);
				} else {
					$affectedRows += GiftCardPeer::doUpdate($this, $con);
				}
				$this->resetModified(); 			}

			if ($this->collPayments !== null) {
				foreach($this->collPayments as $referrerFK) {
					if (!$referrerFK->isDeleted()) {
						$affectedRows += $referrerFK->save($con);
					}
				}
			}

			$this->alreadyInSave = false;
		}
		return $affectedRows;
	} 
	
	protected $validationFailures = array();

	
	public function getValidationFailures()
	{
		return $this->validationFailures;
	}

	
	public function validate($columns = null)
	{
		$res = $this->doValidate($columns);
		if ($res === true) {
			$this->validationFailures = array();
			return true;
		} else {
			$this->validationFailures = $res;
			return false;
		}
	}

	
	protected function doValidate($columns = null)
	{
		if (!$this->alreadyInValidation) {
			$this->alreadyInValidation = true;
			$retval = null;

			$failureMap = array();


												
			if ($this->aCurrency !== null) {
				if (!$this->aCurrency->validate($columns)) {
					$failureMap = array_merge($failureMap, $this->aCurrency->getValidationFailures());
				}
			}


			if (($retval = GiftCardPeer::doValidate($this, $columns)) !== true) {
				$failureMap = array_merge($failureMap, $retval);
			}


				if ($this->collPayments !== null) {
					foreach($this->collPayments as $referrerFK) {
						if (!$referrerFK->validate($columns)) {
							$failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
						}
					}
				}


			$this->alreadyInValidation = false;
		}

		return (!empty($failureMap) ? $failureMap : true);
	}

	
	public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = GiftCardPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->getByPosition($pos);
	}

	
	public function getByPosition($pos)
	{
		switch($pos) {
			case 0:
				return $this->getId();
				break;
			case 1:
				return $this->getStatus();
				break;
			case 2:
				return $this->getAmount();
				break;
			case 3:
				return $this->getCode();
				break;
			case 4:
				return $this->getValidTo();
				break;
			case 5:
				return $this->getCurrencyId();
				break;
			default:
				return null;
				break;
		} 	}

	
	public function toArray($keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = GiftCardPeer::getFieldNames($keyType);
		$result = array(
			$keys[0] => $this->getId(),
			$keys[1] => $this->getStatus(),
			$keys[2] => $this->getAmount(),
			$keys[3] => $this->getCode(),
			$keys[4] => $this->getValidTo(),
			$keys[5] => $this->getCurrencyId(),
		);
		return $result;
	}

	
	public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
	{
		$pos = GiftCardPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
		return $this->setByPosition($pos, $value);
	}

	
	public function setByPosition($pos, $value)
	{
		switch($pos) {
			case 0:
				$this->setId($value);
				break;
			case 1:
				$this->setStatus($value);
				break;
			case 2:
				$this->setAmount($value);
				break;
			case 3:
				$this->setCode($value);
				break;
			case 4:
				$this->setValidTo($value);
				break;
			case 5:
				$this->setCurrencyId($value);
				break;
		} 	}

	
	public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
	{
		$keys = GiftCardPeer::getFieldNames($keyType);

		if (array_key_exists($keys[0], $arr)) $this->setId($arr[$keys[0]]);
		if (array_key_exists($keys[1], $arr)) $this->setStatus($arr[$keys[1]]);
		if (array_key_exists($keys[2], $arr)) $this->setAmount($arr[$keys[2]]);
		if (array_key_exists($keys[3], $arr)) $this->setCode($arr[$keys[3]]);
		if (array_key_exists($keys[4], $arr)) $this->setValidTo($arr[$keys[4]]);
		if (array_key_exists($keys[5], $arr)) $this->setCurrencyId($arr[$keys[5]]);
	}

	
	public function buildCriteria()
	{
		$criteria = new Criteria(GiftCardPeer::DATABASE_NAME);

		if ($this->isColumnModified(GiftCardPeer::ID)) $criteria->add(GiftCardPeer::ID, $this->id);
		if ($this->isColumnModified(GiftCardPeer::STATUS)) $criteria->add(GiftCardPeer::STATUS, $this->status);
		if ($this->isColumnModified(GiftCardPeer::AMOUNT)) $criteria->add(GiftCardPeer::AMOUNT, $this->amount);
		if ($this->isColumnModified(GiftCardPeer::CODE)) $criteria->add(GiftCardPeer::CODE, $this->code);
		if ($this->isColumnModified(GiftCardPeer::VALID_TO)) $criteria->add(GiftCardPeer::VALID_TO, $this->valid_to);
		if ($this->isColumnModified(GiftCardPeer::CURRENCY_ID)) $criteria->add(GiftCardPeer::CURRENCY_ID, $this->currency_id);

		return $criteria;
	}

	
	public function buildPkeyCriteria()
	{
		$criteria = new Criteria(GiftCardPeer::DATABASE_NAME);

		$criteria->add(GiftCardPeer::ID, $this->id);

		return $criteria;
	}

	
	public function getPrimaryKey()
	{
		return $this->getId();
	}

	
	public function setPrimaryKey($key)
	{
		$this->setId($key);
	}

	
	public function copyInto($copyObj, $deepCopy = false)
	{

		$copyObj->setStatus($this->status);

		$copyObj->setAmount($this->amount);

		$copyObj->setCode($this->code);

		$copyObj->setValidTo($this->valid_to);

		$copyObj->setCurrencyId($this->currency_id);


		if ($deepCopy) {
									$copyObj->setNew(false);

			foreach($this->getPayments() as $relObj) {
				$copyObj->addPayment($relObj->copy($deepCopy));
			}

		} 

		$copyObj->setNew(true);

		$copyObj->setId(NULL); 
	}

	
	public function copy($deepCopy = false)
	{
				$clazz = get_class($this);
		$copyObj = new $clazz();
		$this->copyInto($copyObj, $deepCopy);
		return $copyObj;
	}

	
	public function getPeer()
	{
		if (self::$peer === null) {
			self::$peer = new GiftCardPeer();
		}
		return self::$peer;
	}

	
	public function setCurrency($v)
	{


		if ($v === null) {
			$this->setCurrencyId(NULL);
		} else {
			$this->setCurrencyId($v->getId());
		}


		$this->aCurrency = $v;
	}


	
	public function getCurrency($con = null)
	{
		if ($this->aCurrency === null && ($this->currency_id !== null)) {
						$this->aCurrency = CurrencyPeer::retrieveByPK($this->currency_id, $con);

			
		}
		return $this->aCurrency;
	}

	
	public function initPayments()
	{
		if ($this->collPayments === null) {
			$this->collPayments = array();
		}
	}

	
	public function getPayments($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
			   $this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::GIFT_CARD_ID, $this->getId());

				PaymentPeer::addSelectColumns($criteria);
				$this->collPayments = PaymentPeer::doSelect($criteria, $con);
			}
		} else {
						if (!$this->isNew()) {
												

				$criteria->add(PaymentPeer::GIFT_CARD_ID, $this->getId());

				PaymentPeer::addSelectColumns($criteria);
				if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
					$this->collPayments = PaymentPeer::doSelect($criteria, $con);
				}
			}
		}
		$this->lastPaymentCriteria = $criteria;
		return $this->collPayments;
	}

	
	public function countPayments($criteria = null, $distinct = false, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		$criteria->add(PaymentPeer::GIFT_CARD_ID, $this->getId());

		return PaymentPeer::doCount($criteria, $distinct, $con);
	}

	
	public function addPayment(Payment $l)
	{
		$this->collPayments[] = $l;
		$l->setGiftCard($this);
	}


	
	public function getPaymentsJoinsfGuardUser($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::GIFT_CARD_ID, $this->getId());

				$this->collPayments = PaymentPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		} else {
									
			$criteria->add(PaymentPeer::GIFT_CARD_ID, $this->getId());

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinsfGuardUser($criteria, $con);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}


	
	public function getPaymentsJoinPaymentType($criteria = null, $con = null)
	{
				if ($criteria === null) {
			$criteria = new Criteria();
		}
		elseif ($criteria instanceof Criteria)
		{
			$criteria = clone $criteria;
		}

		if ($this->collPayments === null) {
			if ($this->isNew()) {
				$this->collPayments = array();
			} else {

				$criteria->add(PaymentPeer::GIFT_CARD_ID, $this->getId());

				$this->collPayments = PaymentPeer::doSelectJoinPaymentType($criteria, $con);
			}
		} else {
									
			$criteria->add(PaymentPeer::GIFT_CARD_ID, $this->getId());

			if (!isset($this->lastPaymentCriteria) || !$this->lastPaymentCriteria->equals($criteria)) {
				$this->collPayments = PaymentPeer::doSelectJoinPaymentType($criteria, $con);
			}
		}
		$this->lastPaymentCriteria = $criteria;

		return $this->collPayments;
	}


  public function getDispatcher()
  {
      if (null === self::$dispatcher)
      {
          self::$dispatcher = stEventDispatcher::getInstance();
      }

      return self::$dispatcher;
  }
        
  public function __call($method, $arguments)
  {
      $event = $this->getDispatcher()->notifyUntil(new sfEvent($this, 'GiftCard.' . $method, array('arguments' => $arguments, 'method' => $method)));

      if ($event->isProcessed())
      {
          return $event->getReturnValue();
      }

      if (!$callable = sfMixer::getCallable('BaseGiftCard:'.$method))
      {
        throw new sfException(sprintf('Call to undefined method BaseGiftCard::%s', $method));
      }

      array_unshift($arguments, $this);

      return call_user_func_array($callable, $arguments);
  }

} 