<?php


abstract class BaseGiftCardPeer {

	
	const DATABASE_NAME = 'propel';

	
	const TABLE_NAME = 'st_gift_card';

	
	const CLASS_DEFAULT = 'plugins.stGiftCardPlugin.lib.model.GiftCard';

	
	const NUM_COLUMNS = 6;

	
	const NUM_LAZY_LOAD_COLUMNS = 0;


	
	const ID = 'st_gift_card.ID';

	
	const STATUS = 'st_gift_card.STATUS';

	
	const AMOUNT = 'st_gift_card.AMOUNT';

	
	const CODE = 'st_gift_card.CODE';

	
	const VALID_TO = 'st_gift_card.VALID_TO';

	
	const CURRENCY_ID = 'st_gift_card.CURRENCY_ID';

	
	private static $phpNameMap = null;


	
	private static $fieldNames = array (
		BasePeer::TYPE_PHPNAME => array ('Id', 'Status', 'Amount', 'Code', 'ValidTo', 'CurrencyId', ),
		BasePeer::TYPE_COLNAME => array (GiftCardPeer::ID, GiftCardPeer::STATUS, GiftCardPeer::AMOUNT, GiftCardPeer::CODE, GiftCardPeer::VALID_TO, GiftCardPeer::CURRENCY_ID, ),
		BasePeer::TYPE_FIELDNAME => array ('id', 'status', 'amount', 'code', 'valid_to', 'currency_id', ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, )
	);

	
	private static $fieldKeys = array (
		BasePeer::TYPE_PHPNAME => array ('Id' => 0, 'Status' => 1, 'Amount' => 2, 'Code' => 3, 'ValidTo' => 4, 'CurrencyId' => 5, ),
		BasePeer::TYPE_COLNAME => array (GiftCardPeer::ID => 0, GiftCardPeer::STATUS => 1, GiftCardPeer::AMOUNT => 2, GiftCardPeer::CODE => 3, GiftCardPeer::VALID_TO => 4, GiftCardPeer::CURRENCY_ID => 5, ),
		BasePeer::TYPE_FIELDNAME => array ('id' => 0, 'status' => 1, 'amount' => 2, 'code' => 3, 'valid_to' => 4, 'currency_id' => 5, ),
		BasePeer::TYPE_NUM => array (0, 1, 2, 3, 4, 5, )
	);

         protected static $hydrateMethod = null;

         protected static $postHydrateMethod = null;

         public static function setHydrateMethod($callback)
         {
            self::$hydrateMethod = $callback;
         }

         public static function setPostHydrateMethod($callback)
         {
            self::$postHydrateMethod = $callback;
         }

	
	public static function getMapBuilder()
	{
		return BasePeer::getMapBuilder('plugins.stGiftCardPlugin.lib.model.map.GiftCardMapBuilder');
	}
	
	public static function getPhpNameMap()
	{
		if (self::$phpNameMap === null) {
			$map = GiftCardPeer::getTableMap();
			$columns = $map->getColumns();
			$nameMap = array();
			foreach ($columns as $column) {
				$nameMap[$column->getPhpName()] = $column->getColumnName();
			}
			self::$phpNameMap = $nameMap;
		}
		return self::$phpNameMap;
	}
	
	static public function translateFieldName($name, $fromType, $toType)
	{
		$toNames = self::getFieldNames($toType);
		$key = isset(self::$fieldKeys[$fromType][$name]) ? self::$fieldKeys[$fromType][$name] : null;
		if ($key === null) {
			throw new PropelException("'$name' could not be found in the field names of type '$fromType'. These are: " . print_r(self::$fieldKeys[$fromType], true));
		}
		return $toNames[$key];
	}

	

	static public function getFieldNames($type = BasePeer::TYPE_PHPNAME)
	{
		if (!array_key_exists($type, self::$fieldNames)) {
			throw new PropelException('Method getFieldNames() expects the parameter $type to be one of the class constants TYPE_PHPNAME, TYPE_COLNAME, TYPE_FIELDNAME, TYPE_NUM. ' . $type . ' was given.');
		}
		return self::$fieldNames[$type];
	}

	
	public static function alias($alias, $column)
	{
		return str_replace(GiftCardPeer::TABLE_NAME.'.', $alias.'.', $column);
	}

	
	public static function addSelectColumns(Criteria $criteria)
	{

		$criteria->addSelectColumn(GiftCardPeer::ID);

		$criteria->addSelectColumn(GiftCardPeer::STATUS);

		$criteria->addSelectColumn(GiftCardPeer::AMOUNT);

		$criteria->addSelectColumn(GiftCardPeer::CODE);

		$criteria->addSelectColumn(GiftCardPeer::VALID_TO);

		$criteria->addSelectColumn(GiftCardPeer::CURRENCY_ID);

	}

	const COUNT = 'COUNT(st_gift_card.ID)';
	const COUNT_DISTINCT = 'COUNT(DISTINCT st_gift_card.ID)';

	
	public static function doCount(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(GiftCardPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(GiftCardPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$rs = GiftCardPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}
	
	public static function doSelectOne(Criteria $criteria, $con = null)
	{
		$critcopy = clone $criteria;
		$critcopy->setLimit(1);
		$objects = GiftCardPeer::doSelect($critcopy, $con);
		if ($objects) {
			return $objects[0];
		}
		return null;
	}
	
	public static function doSelect(Criteria $criteria, $con = null)
	{
		return GiftCardPeer::populateObjects(GiftCardPeer::doSelectRS($criteria, $con));
	}
	
	public static function doSelectRS(Criteria $criteria, $con = null)
	{

    foreach (sfMixer::getCallables('BaseGiftCardPeer:addDoSelectRS:addDoSelectRS') as $callable)
    {
      call_user_func($callable, 'BaseGiftCardPeer', $criteria, $con);
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if (!$criteria->getSelectColumns()) {
			$criteria = clone $criteria;
			GiftCardPeer::addSelectColumns($criteria);
		}

				$criteria->setDbName(self::DATABASE_NAME);

						return BasePeer::doSelect($criteria, $con);
	}
	
	public static function populateObjects(ResultSet $rs)
	{
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();
	
				$cls = GiftCardPeer::getOMClass();
		$cls = Propel::import($cls);
				while($rs->next()) {
		
			$obj = new $cls();
			$obj->hydrate($rs);
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj) : $obj;
			
		}
		return $results;
	}

	
	public static function doCountJoinCurrency(Criteria $criteria, $distinct = false, $con = null)
	{
				$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(GiftCardPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(GiftCardPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(GiftCardPeer::CURRENCY_ID, CurrencyPeer::ID);

		$rs = GiftCardPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinCurrency(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		GiftCardPeer::addSelectColumns($c);
		$startcol = (GiftCardPeer::NUM_COLUMNS - GiftCardPeer::NUM_LAZY_LOAD_COLUMNS) + 1;
		CurrencyPeer::addSelectColumns($c);

		$c->addJoin(GiftCardPeer::CURRENCY_ID, CurrencyPeer::ID);
		$rs = BasePeer::doSelect($c, $con);
                   
                if (self::$hydrateMethod)
                {
                   return call_user_func(self::$hydrateMethod, $rs);
                }                   

		$results = array();

		while($rs->next()) {

			$omClass = GiftCardPeer::getOMClass();

			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);
                        if ($obj1->getCurrencyId())
                        {

			   $omClass = CurrencyPeer::getOMClass();

			   $cls = Propel::import($omClass);
			   $obj2 = new $cls();
			   $obj2->hydrate($rs, $startcol);
                           $obj2->addGiftCard($obj1);
                        }
			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;;
		}
		return $results;
	}


	
	public static function doCountJoinAll(Criteria $criteria, $distinct = false, $con = null)
	{
		$criteria = clone $criteria;

				$criteria->clearSelectColumns()->clearOrderByColumns();
		if ($distinct || in_array(Criteria::DISTINCT, $criteria->getSelectModifiers())) {
			$criteria->addSelectColumn(GiftCardPeer::COUNT_DISTINCT);
		} else {
			$criteria->addSelectColumn(GiftCardPeer::COUNT);
		}

				foreach($criteria->getGroupByColumns() as $column)
		{
			$criteria->addSelectColumn($column);
		}

		$criteria->addJoin(GiftCardPeer::CURRENCY_ID, CurrencyPeer::ID);

		$rs = GiftCardPeer::doSelectRS($criteria, $con);
		if ($rs->next()) {
			return $rs->getInt(1);
		} else {
						return 0;
		}
	}


	
	public static function doSelectJoinAll(Criteria $c, $con = null)
	{
		$c = clone $c;

				if ($c->getDbName() == Propel::getDefaultDB()) {
			$c->setDbName(self::DATABASE_NAME);
		}

		GiftCardPeer::addSelectColumns($c);
		$startcol2 = (GiftCardPeer::NUM_COLUMNS - GiftCardPeer::NUM_LAZY_LOAD_COLUMNS) + 1;

		CurrencyPeer::addSelectColumns($c);
		$startcol3 = $startcol2 + CurrencyPeer::NUM_COLUMNS;

		$c->addJoin(GiftCardPeer::CURRENCY_ID, CurrencyPeer::ID);

		$rs = BasePeer::doSelect($c, $con);
		
            if (self::$hydrateMethod)
            {
               return call_user_func(self::$hydrateMethod, $rs);
            }
            $results = array();

		while($rs->next()) {

			$omClass = GiftCardPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj1 = new $cls();
			$obj1->hydrate($rs);


					
			$omClass = CurrencyPeer::getOMClass();


			$cls = Propel::import($omClass);
			$obj2 = new $cls();
			$obj2->hydrate($rs, $startcol2);

			$newObject = true;
			for ($j=0, $resCount=count($results); $j < $resCount; $j++) {
				$temp_obj1 = $results[$j];
				$temp_obj2 = $temp_obj1->getCurrency(); 				if ($temp_obj2->getPrimaryKey() === $obj2->getPrimaryKey()) {
					$newObject = false;
					$temp_obj2->addGiftCard($obj1); 					break;
				}
			}

			if ($newObject) {
				$obj2->initGiftCards();
				$obj2->addGiftCard($obj1);
			}

			$results[] = self::$postHydrateMethod ? call_use_func(self::$postHydrateMethod, $obj1) : $obj1;
		}
		return $results;
	}

	
	public static function getTableMap()
	{
		return Propel::getDatabaseMap(self::DATABASE_NAME)->getTable(self::TABLE_NAME);
	}

	
	public static function getOMClass()
	{
		return GiftCardPeer::CLASS_DEFAULT;
	}

	
	public static function doInsert($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseGiftCardPeer:doInsert:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseGiftCardPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} else {
			$criteria = $values->buildCriteria(); 		}

		$criteria->remove(GiftCardPeer::ID); 

				$criteria->setDbName(self::DATABASE_NAME);

		try {
									$con->begin();
			$pk = BasePeer::doInsert($criteria, $con);
			$con->commit();
		} catch(PropelException $e) {
			$con->rollback();
			throw $e;
		}

		
    foreach (sfMixer::getCallables('BaseGiftCardPeer:doInsert:post') as $callable)
    {
      call_user_func($callable, 'BaseGiftCardPeer', $values, $con, $pk);
    }

    return $pk;
	}

	
	public static function doUpdate($values, $con = null)
	{

    foreach (sfMixer::getCallables('BaseGiftCardPeer:doUpdate:pre') as $callable)
    {
      $ret = call_user_func($callable, 'BaseGiftCardPeer', $values, $con);
      if (false !== $ret)
      {
        return $ret;
      }
    }


		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$selectCriteria = new Criteria(self::DATABASE_NAME);

		if ($values instanceof Criteria) {
			$criteria = clone $values; 
			$comparison = $criteria->getComparison(GiftCardPeer::ID);
			$selectCriteria->add(GiftCardPeer::ID, $criteria->remove(GiftCardPeer::ID), $comparison);

		} else { 			$criteria = $values->buildCriteria(); 			$selectCriteria = $values->buildPkeyCriteria(); 		}

				$criteria->setDbName(self::DATABASE_NAME);

		$ret = BasePeer::doUpdate($selectCriteria, $criteria, $con);
	

    foreach (sfMixer::getCallables('BaseGiftCardPeer:doUpdate:post') as $callable)
    {
      call_user_func($callable, 'BaseGiftCardPeer', $values, $con, $ret);
    }

    return $ret;
  }

	
	public static function doDeleteAll($con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}
		$affectedRows = 0; 		try {
									$con->begin();
			GiftCardPeer::doOnDeleteSetNull(new Criteria(), $con);
			$affectedRows += BasePeer::doDeleteAll(GiftCardPeer::TABLE_NAME, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	 public static function doDelete($values, $con = null)
	 {
		if ($con === null) {
			$con = Propel::getConnection(GiftCardPeer::DATABASE_NAME);
		}

		if ($values instanceof Criteria) {
			$criteria = clone $values; 		} elseif ($values instanceof GiftCard) {

			$criteria = $values->buildPkeyCriteria();
		} else {
						$criteria = new Criteria(self::DATABASE_NAME);
			$criteria->add(GiftCardPeer::ID, (array) $values, Criteria::IN);
		}

				$criteria->setDbName(self::DATABASE_NAME);

		$affectedRows = 0; 
		try {
									$con->begin();
			GiftCardPeer::doOnDeleteSetNull($criteria, $con);
			$affectedRows += BasePeer::doDelete($criteria, $con);
			$con->commit();
			return $affectedRows;
		} catch (PropelException $e) {
			$con->rollback();
			throw $e;
		}
	}

	
	protected static function doOnDeleteSetNull(Criteria $criteria, Connection $con)
	{

				$objects = GiftCardPeer::doSelect($criteria, $con);
		foreach($objects as $obj) {

						$selectCriteria = new Criteria(GiftCardPeer::DATABASE_NAME);
			$updateValues = new Criteria(GiftCardPeer::DATABASE_NAME);
			$selectCriteria->add(PaymentPeer::GIFT_CARD_ID, $obj->getId());
			$updateValues->add(PaymentPeer::GIFT_CARD_ID, null);

			BasePeer::doUpdate($selectCriteria, $updateValues, $con); 
		}
	}

	
	public static function doValidate(GiftCard $obj, $cols = null)
	{
		$columns = array();

		if ($cols) {
			$dbMap = Propel::getDatabaseMap(GiftCardPeer::DATABASE_NAME);
			$tableMap = $dbMap->getTable(GiftCardPeer::TABLE_NAME);

			if (! is_array($cols)) {
				$cols = array($cols);
			}

			foreach($cols as $colName) {
				if ($tableMap->containsColumn($colName)) {
					$get = 'get' . $tableMap->getColumn($colName)->getPhpName();
					$columns[$colName] = $obj->$get();
				}
			}
		} else {

		}

		$res =  BasePeer::doValidate(GiftCardPeer::DATABASE_NAME, GiftCardPeer::TABLE_NAME, $columns);
    if ($res !== true) {
        $request = sfContext::getInstance()->getRequest();
        foreach ($res as $failed) {
            $col = GiftCardPeer::translateFieldname($failed->getColumn(), BasePeer::TYPE_COLNAME, BasePeer::TYPE_PHPNAME);
            $request->setError($col, $failed->getMessage());
        }
    }

    return $res;
	}

	
	public static function retrieveByPK($pk, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$criteria = new Criteria(GiftCardPeer::DATABASE_NAME);

		$criteria->add(GiftCardPeer::ID, $pk);


		$v = GiftCardPeer::doSelect($criteria, $con);

		return !empty($v) > 0 ? $v[0] : null;
	}

	
	public static function retrieveByPKs($pks, $con = null)
	{
		if ($con === null) {
			$con = Propel::getConnection(self::DATABASE_NAME);
		}

		$objs = null;
		if (empty($pks)) {
			$objs = array();
		} else {
			$criteria = new Criteria();
			$criteria->add(GiftCardPeer::ID, $pks, Criteria::IN);
			$objs = GiftCardPeer::doSelect($criteria, $con);
		}
		return $objs;
	}

} 
if (Propel::isInit()) {
			try {
		BaseGiftCardPeer::getMapBuilder();
	} catch (Exception $e) {
		Propel::log('Could not initialize Peer: ' . $e->getMessage(), Propel::LOG_ERR);
	}
} else {
			Propel::registerMapBuilder('plugins.stGiftCardPlugin.lib.model.map.GiftCardMapBuilder');
}
