<?php

class stGiftCardPlugin
{
   const SESSION_NAMESPACE = 'soteshop/stGiftCardPlugin';

   protected static $objectPool = array();

   public static function calculateAmountLeft($amount, $gift_cards = array())
   {
      $amount -= self::getTotalAmountPaid($gift_cards);
      
      return $amount >= 0 ? $amount : 0;
   }
   
   public static function getTotalAmountPaid($gift_cards = array())
   {
      $total = 0;
      
      if (!$gift_cards)
      {
         $gift_cards = self::get();
      }
      
      foreach ($gift_cards as $gift_card)
      {
         $total += $gift_card->getAmount();
      }   
      
      return $total;
   }
   
   public static function isActive()
   {
      $gift_cards = sfContext::getInstance()->getUser()->getAttribute('active', array(), self::SESSION_NAMESPACE);
      
      return !empty($gift_cards);
   }
   
   public static function get()
   {
      if (!self::$objectPool)
      {
         $gift_cards = sfContext::getInstance()->getUser()->getAttribute('active', array(), self::SESSION_NAMESPACE);

         $currency_id = stCurrency::getInstance(sfContext::getInstance())->get()->getId();
 
         $c = new Criteria();
         
         $c->add(GiftCardPeer::CURRENCY_ID, $currency_id);
         
         $c->add(GiftCardPeer::ID, $gift_cards, Criteria::IN);
         
         self::$objectPool = GiftCardPeer::doSelect($c);
      }

      return self::$objectPool;
   }

   public static function has(GiftCard $gift_card = null)
   {
      $gift_cards = sfContext::getInstance()->getUser()->getAttribute('active', array(), self::SESSION_NAMESPACE);

      return isset($gift_cards[$gift_card->getCode()]);
   }

   public static function add(GiftCard $gift_card)
   {
      $user = sfContext::getInstance()->getUser();

      $gift_cards = $user->getAttribute('active', array(), self::SESSION_NAMESPACE);

      $gift_cards[$gift_card->getCode()] = $gift_card->getId();

      $user->setAttribute('active', $gift_cards, self::SESSION_NAMESPACE);

      self::$objectPool = array();
   }

   public static function remove(GiftCard $gift_card)
   {
      $user = sfContext::getInstance()->getUser();

      $gift_cards = $user->getAttribute('active', array(), self::SESSION_NAMESPACE);

      unset($gift_cards[$gift_card->getCode()]);

      $user->setAttribute('active', $gift_cards, self::SESSION_NAMESPACE);

      self::$objectPool = array();
   }
   
   public static function clear()
   {
      sfContext::getInstance()->getUser()->setAttribute('active', array(), self::SESSION_NAMESPACE);
   }
}